/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RequestOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class ConnectionTest {

    public static class DialectDetectionTest
    extends AbstractMockServerTest {
        @Override
        protected String getBaseUrl() {
            return super.getBaseUrl() + ";minSessions=1";
        }

        @After
        public void reset() {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.GOOGLE_STANDARD_SQL));
            mockSpanner.reset();
            mockSpanner.removeAllExecutionTimes();
            SpannerPool.closeSpannerPool();
        }

        @Test
        public void testDefaultGetDialect() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)connection.getDialect());
            }
        }

        @Test
        public void testPostgreSQLGetDialect() {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.POSTGRESQL));
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                Assert.assertEquals((Object)Dialect.POSTGRESQL, (Object)connection.getDialect());
            }
        }

        @Test
        public void testGetDialect_DatabaseNotFound() throws Exception {
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.stickyDatabaseNotFoundException("invalid-database"));
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((Connection)connection).getDialect());
                Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)exception.getErrorCode());
                Assert.assertTrue((boolean)exception.getMessage().contains("Database with id invalid-database not found"));
            }
        }
    }

    public static class ConnectionRPCPriorityTest
    extends AbstractMockServerTest {
        @AfterClass
        public static void reset() {
            mockSpanner.reset();
        }

        @Override
        protected String getBaseUrl() {
            return super.getBaseUrl() + ";rpcPriority=MEDIUM";
        }

        @Test
        public void testQuery_RPCPriority() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                for (boolean autocommit : new boolean[]{true, false}) {
                    connection.setAutocommit(autocommit);
                    ResultSet rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                    if (rs != null) {
                        rs.close();
                    }
                    Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                    Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getPriority());
                    mockSpanner.clearRequests();
                }
            }
        }

        @Test
        public void testUpdate_RPCPriority() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                for (boolean autocommit : new boolean[]{true, false}) {
                    connection.setAutocommit(autocommit);
                    connection.executeUpdate(INSERT_STATEMENT);
                    Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                    Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getPriority());
                    mockSpanner.clearRequests();
                }
            }
        }

        @Test
        public void testPartitionedUpdate_RPCPriority() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setAutocommit(true);
                connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
                connection.executeUpdate(INSERT_STATEMENT);
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getPriority());
                mockSpanner.clearRequests();
            }
        }

        @Test
        public void testBatchUpdate_RPCPriority() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.executeBatchUpdate(Collections.singleton(INSERT_STATEMENT));
                connection.commit();
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getPriority());
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
                Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getPriority());
                mockSpanner.clearRequests();
            }
        }

        @Test
        public void testDmlBatch_RPCPriority() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                for (boolean autocommit : new boolean[]{true, false}) {
                    connection.setAutocommit(autocommit);
                    connection.startBatchDml();
                    connection.execute(INSERT_STATEMENT);
                    connection.execute(INSERT_STATEMENT);
                    connection.runBatch();
                    Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                    Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getPriority());
                    mockSpanner.clearRequests();
                }
            }
        }

        @Test
        public void testRunBatch_RPCPriority() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.startBatchDml();
                connection.execute(INSERT_STATEMENT);
                connection.execute(INSERT_STATEMENT);
                connection.runBatch();
                connection.commit();
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getPriority());
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
                Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getPriority());
                mockSpanner.clearRequests();
            }
        }

        @Test
        public void testShowSetRPCPriority() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setRPCPriority(null);
                try (ResultSet rs = connection.execute(Statement.of((String)"SHOW VARIABLE RPC_PRIORITY")).getResultSet();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"PRIORITY_UNSPECIFIED", (Object)rs.getString("RPC_PRIORITY"));
                    Assert.assertFalse((boolean)rs.next());
                }
                connection.execute(Statement.of((String)"SET RPC_PRIORITY='LOW'"));
                rs = connection.execute(Statement.of((String)"SHOW VARIABLE RPC_PRIORITY")).getResultSet();
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"LOW", (Object)rs.getString("RPC_PRIORITY"));
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                connection.execute(Statement.of((String)"SET RPC_PRIORITY='HIGH'"));
                rs = connection.execute(Statement.of((String)"SHOW VARIABLE RPC_PRIORITY")).getResultSet();
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"HIGH", (Object)rs.getString("RPC_PRIORITY"));
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
    }

    public static class ConnectionMaxSessionsTest
    extends AbstractMockServerTest {
        @AfterClass
        public static void reset() {
            mockSpanner.reset();
        }

        @Override
        protected String getBaseUrl() {
            return super.getBaseUrl() + ";maxSessions=1";
        }

        @Test
        public void testMaxSessions() throws InterruptedException, TimeoutException, ExecutionException {
            try (ITAbstractSpannerTest.ITConnection connection1 = this.createConnection();
                 ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection1.beginTransactionAsync();
                connection2.beginTransactionAsync();
                ApiFuture count1 = connection1.executeUpdateAsync(INSERT_STATEMENT);
                ApiFuture count2 = connection2.executeUpdateAsync(INSERT_STATEMENT);
                ApiFuture commit1 = connection1.commitAsync();
                ApiFuture commit2 = connection2.commitAsync();
                Truth.assertThat((Boolean)(count1.isDone() && count2.isDone() ? 1 : 0)).isFalse();
                Truth.assertThat((Boolean)(commit1.isDone() && commit2.isDone() ? 1 : 0)).isFalse();
                ApiFutures.allAsList(Arrays.asList(commit1, commit2)).get(5L, TimeUnit.SECONDS);
                Truth.assertThat((Boolean)count1.isDone()).isTrue();
                Truth.assertThat((Boolean)count2.isDone()).isTrue();
                if (this.isMultiplexedSessionsEnabled(connection1.getSpanner())) {
                    Truth.assertThat((Integer)mockSpanner.numSessionsCreated()).isAtLeast((Comparable)Integer.valueOf(1));
                    Truth.assertThat((Integer)mockSpanner.numSessionsCreated()).isAtMost((Comparable)Integer.valueOf(2));
                } else {
                    Truth.assertThat((Integer)mockSpanner.numSessionsCreated()).isEqualTo((Object)1);
                }
            }
        }
    }

    public static class ConnectionMinSessionsTest
    extends AbstractMockServerTest {
        @AfterClass
        public static void reset() {
            mockSpanner.reset();
        }

        @Override
        protected String getBaseUrl() {
            return super.getBaseUrl() + ";minSessions=1";
        }

        @Test
        public void testMinSessions() throws InterruptedException, TimeoutException {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                mockSpanner.waitForRequestsToContain((Predicate<? super AbstractMessage>)((Predicate)input -> input instanceof BatchCreateSessionsRequest && ((BatchCreateSessionsRequest)input).getSessionCount() == 1), 5000L);
            }
        }
    }

    public static class DefaultConnectionOptionsTest
    extends AbstractMockServerTest {
        @Test
        public void testDefaultOptimizerVersion() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
                 ResultSet rs = connection.executeQuery(Statement.of((String)"SHOW VARIABLE OPTIMIZER_VERSION"), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((String)rs.getString("OPTIMIZER_VERSION")).isEqualTo((Object)"");
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
        }

        @Test
        public void testDefaultOptimizerStatisticsPackage() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
                 ResultSet rs = connection.executeQuery(Statement.of((String)"SHOW VARIABLE OPTIMIZER_STATISTICS_PACKAGE"), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((String)rs.getString("OPTIMIZER_STATISTICS_PACKAGE")).isEqualTo((Object)"");
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
        }

        @Test
        public void testExecuteInvalidBatchUpdate() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                try {
                    connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)SELECT_RANDOM_STATEMENT));
                    Assert.fail((String)"Missing expected exception");
                }
                catch (SpannerException e) {
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                }
            }
        }

        @Test
        public void testQueryAborted() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setRetryAbortsInternally(false);
                Boolean[] booleanArray = new Boolean[]{true, false};
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean abort = booleanArray[i];
                    try {
                        if (abort) {
                            mockSpanner.abortNextStatement();
                        }
                        connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                        Truth.assertThat((Boolean)abort).isFalse();
                        connection.commit();
                        continue;
                    }
                    catch (AbortedException e) {
                        Truth.assertThat((Boolean)abort).isTrue();
                        connection.rollback();
                    }
                }
            }
        }

        @Test
        public void testUpdateAborted() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setRetryAbortsInternally(false);
                Boolean[] booleanArray = new Boolean[]{true, false};
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean abort = booleanArray[i];
                    try {
                        if (abort) {
                            mockSpanner.abortNextStatement();
                        }
                        connection.executeUpdate(INSERT_STATEMENT);
                        Truth.assertThat((Boolean)abort).isFalse();
                        connection.commit();
                        continue;
                    }
                    catch (AbortedException e) {
                        Truth.assertThat((Boolean)abort).isTrue();
                        connection.rollback();
                    }
                }
            }
        }

        @Test
        public void testBatchUpdateAborted() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setRetryAbortsInternally(false);
                Boolean[] booleanArray = new Boolean[]{true, false};
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean abort = booleanArray[i];
                    try {
                        if (abort) {
                            mockSpanner.abortNextStatement();
                        }
                        connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
                        Truth.assertThat((Boolean)abort).isFalse();
                        connection.commit();
                        continue;
                    }
                    catch (AbortedException e) {
                        Truth.assertThat((Boolean)abort).isTrue();
                        connection.rollback();
                    }
                }
            }
        }
    }

    public static class EnvironmentConnectionOptionsTest
    extends AbstractMockServerTest {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testUseOptimizerVersionAndStatisticsPackageFromEnvironment() {
            try {
                SpannerOptions.useEnvironment((SpannerOptions.SpannerEnvironment)new SpannerOptions.SpannerEnvironment(){

                    @Nonnull
                    public String getOptimizerVersion() {
                        return "20";
                    }

                    @Nonnull
                    public String getOptimizerStatisticsPackage() {
                        return "env-package";
                    }
                });
                try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                    ExecuteSqlRequest request;
                    try (ResultSet rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);){
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)0L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        request = this.getLastExecuteSqlRequest();
                        Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"20");
                        Truth.assertThat((String)request.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"env-package");
                    }
                    connection.execute(Statement.of((String)"SET OPTIMIZER_VERSION='30'"));
                    connection.execute(Statement.of((String)"SET OPTIMIZER_STATISTICS_PACKAGE='custom-package'"));
                    rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                    try {
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)0L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        request = this.getLastExecuteSqlRequest();
                        Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"30");
                        Truth.assertThat((String)request.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"custom-package");
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    rs = connection.executeQuery(Statement.newBuilder((String)SELECT_COUNT_STATEMENT.getSql()).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("user-defined-version").setOptimizerStatisticsPackage("user-defined-statistics-package").build()).build(), new Options.QueryOption[0]);
                    try {
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)0L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        request = this.getLastExecuteSqlRequest();
                        Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"user-defined-version");
                        Truth.assertThat((String)request.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"user-defined-statistics-package");
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
            }
            finally {
                SpannerOptions.useDefaultEnvironment();
            }
        }
    }
}

