/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.Repeat;
import com.google.spanner.v1.ExecuteSqlRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QueryOptionsTest
extends AbstractMockServerTest {
    @Test
    public void testUseOptimizerVersionFromConnectionUrl() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection("?optimizerVersion=10");){
            Repeat.twice(() -> {
                this.executeSelect1AndConsumeResults(connection);
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
                Assert.assertEquals((Object)"10", (Object)request.getQueryOptions().getOptimizerVersion());
                mockSpanner.clearRequests();
            });
        }
    }

    @Test
    public void testUseOptimizerVersionFromStatement() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)"set optimizer_version='7'"));
            Repeat.twice(() -> {
                this.executeSelect1AndConsumeResults(connection);
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
                Assert.assertEquals((Object)"7", (Object)request.getQueryOptions().getOptimizerVersion());
                mockSpanner.clearRequests();
            });
        }
    }

    private void executeSelect1AndConsumeResults(Connection connection) {
        try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
    }
}

