/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.AbstractMultiUseTransaction;
import com.google.cloud.spanner.connection.ReadOnlyTransaction;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SavepointTest {
    @Test
    public void testCreateSavepoint_GoogleSql() {
        Dialect dialect = Dialect.GOOGLE_STANDARD_SQL;
        TestTransaction transaction = new TestTransaction();
        transaction.savepoint("s1", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.savepoint("s2", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        Assert.assertThrows(SpannerException.class, () -> transaction.savepoint("s1", dialect));
        Assert.assertThrows(SpannerException.class, () -> transaction.savepoint("s2", dialect));
    }

    @Test
    public void testCreateSavepoint_PostgreSQL() {
        Dialect dialect = Dialect.POSTGRESQL;
        TestTransaction transaction = new TestTransaction();
        transaction.savepoint("s1", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.savepoint("s2", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.savepoint("s2", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.savepoint("s1", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
    }

    @Test
    public void testReleaseSavepoint_GoogleSql() {
        Dialect dialect = Dialect.GOOGLE_STANDARD_SQL;
        TestTransaction transaction = new TestTransaction();
        transaction.savepoint("s1", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.releaseSavepoint("s1");
        Assert.assertEquals((Object)ImmutableList.of(), (Object)transaction.getSavepoints());
        transaction.savepoint("s1", dialect);
        transaction.savepoint("s2", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.releaseSavepoint("s2");
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.savepoint("s2", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.releaseSavepoint("s1");
        Assert.assertEquals((Object)ImmutableList.of(), (Object)transaction.getSavepoints());
        Assert.assertThrows(SpannerException.class, () -> transaction.releaseSavepoint("s1"));
        transaction.savepoint("s1", dialect);
        Assert.assertThrows(SpannerException.class, () -> transaction.releaseSavepoint("s2"));
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
    }

    @Test
    public void testReleaseSavepoint_PostgreSQL() {
        Dialect dialect = Dialect.POSTGRESQL;
        TestTransaction transaction = new TestTransaction();
        transaction.savepoint("s1", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.releaseSavepoint("s1");
        Assert.assertEquals((Object)ImmutableList.of(), (Object)transaction.getSavepoints());
        transaction.savepoint("s1", dialect);
        transaction.savepoint("s2", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.releaseSavepoint("s2");
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.savepoint("s2", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.releaseSavepoint("s1");
        Assert.assertEquals((Object)ImmutableList.of(), (Object)transaction.getSavepoints());
        Assert.assertThrows(SpannerException.class, () -> transaction.releaseSavepoint("s1"));
        transaction.savepoint("s1", dialect);
        Assert.assertThrows(SpannerException.class, () -> transaction.releaseSavepoint("s2"));
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.savepoint("s2", dialect);
        transaction.savepoint("s1", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.releaseSavepoint("s1");
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
    }

    @Test
    public void testRollbackToSavepoint_GoogleSql() {
        Dialect dialect = Dialect.GOOGLE_STANDARD_SQL;
        TestTransaction transaction = new TestTransaction();
        transaction.savepoint("s1", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.rollbackToSavepoint("s1", SavepointSupport.ENABLED);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.savepoint("s2", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.rollbackToSavepoint("s2", SavepointSupport.ENABLED);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.rollbackToSavepoint("s1", SavepointSupport.ENABLED);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        Assert.assertThrows(SpannerException.class, () -> transaction.rollbackToSavepoint("s2", SavepointSupport.ENABLED));
    }

    @Test
    public void testRollbackToSavepoint_PostgreSQL() {
        Dialect dialect = Dialect.POSTGRESQL;
        TestTransaction transaction = new TestTransaction();
        transaction.savepoint("s1", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.rollbackToSavepoint("s1", SavepointSupport.ENABLED);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.savepoint("s2", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.rollbackToSavepoint("s2", SavepointSupport.ENABLED);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2")), (Object)transaction.getSavepoints());
        transaction.rollbackToSavepoint("s1", SavepointSupport.ENABLED);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        Assert.assertThrows(SpannerException.class, () -> transaction.rollbackToSavepoint("s2", SavepointSupport.ENABLED));
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.savepoint("s2", dialect);
        transaction.savepoint("s1", dialect);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
        transaction.rollbackToSavepoint("s1", SavepointSupport.ENABLED);
        Assert.assertEquals((Object)ImmutableList.of((Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s2"), (Object)AbstractMultiUseTransaction.Savepoint.of((String)"s1")), (Object)transaction.getSavepoints());
    }

    static class TestTransaction
    extends ReadOnlyTransaction {
        TestTransaction() {
            super((ReadOnlyTransaction.Builder)ReadOnlyTransaction.newBuilder().withStatementExecutor((StatementExecutor)Mockito.mock(StatementExecutor.class)));
        }
    }
}

