/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.StatementParserTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerStatementParserTest {
    static String skip(String sql) {
        return SpannerStatementParserTest.skip(sql, 0);
    }

    static String skip(String sql, int currentIndex) {
        int position = AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).skip(sql, currentIndex, null);
        return sql.substring(currentIndex, position);
    }

    @Test
    public void testSkip() {
        Assert.assertEquals((Object)"", (Object)SpannerStatementParserTest.skip(""));
        Assert.assertEquals((Object)"1", (Object)SpannerStatementParserTest.skip("1 "));
        Assert.assertEquals((Object)"1", (Object)SpannerStatementParserTest.skip("12 "));
        Assert.assertEquals((Object)"2", (Object)SpannerStatementParserTest.skip("12 ", 1));
        Assert.assertEquals((Object)"", (Object)SpannerStatementParserTest.skip("12", 2));
        Assert.assertEquals((Object)"'foo'", (Object)SpannerStatementParserTest.skip("'foo'  ", 0));
        Assert.assertEquals((Object)"'foo'", (Object)SpannerStatementParserTest.skip("'foo''bar'  ", 0));
        Assert.assertEquals((Object)"'foo'", (Object)SpannerStatementParserTest.skip("'foo'  'bar'  ", 0));
        Assert.assertEquals((Object)"'bar'", (Object)SpannerStatementParserTest.skip("'foo''bar'  ", 5));
        Assert.assertEquals((Object)"'foo\"bar\"'", (Object)SpannerStatementParserTest.skip("'foo\"bar\"'  ", 0));
        Assert.assertEquals((Object)"\"foo'bar'\"", (Object)SpannerStatementParserTest.skip("\"foo'bar'\"  ", 0));
        Assert.assertEquals((Object)"`foo'bar'`", (Object)SpannerStatementParserTest.skip("`foo'bar'`  ", 0));
        Assert.assertEquals((Object)"'''foo'bar'''", (Object)SpannerStatementParserTest.skip("'''foo'bar'''  ", 0));
        Assert.assertEquals((Object)"'''foo\\'bar'''", (Object)SpannerStatementParserTest.skip("'''foo\\'bar'''  ", 0));
        Assert.assertEquals((Object)"'''foo\\'\\'bar'''", (Object)SpannerStatementParserTest.skip("'''foo\\'\\'bar'''  ", 0));
        Assert.assertEquals((Object)"'''foo\\'\\'\\'bar'''", (Object)SpannerStatementParserTest.skip("'''foo\\'\\'\\'bar'''  ", 0));
        Assert.assertEquals((Object)"\"\"\"foo'bar\"\"\"", (Object)SpannerStatementParserTest.skip("\"\"\"foo'bar\"\"\"", 0));
        Assert.assertEquals((Object)"```foo'bar```", (Object)SpannerStatementParserTest.skip("```foo'bar```", 0));
        Assert.assertEquals((Object)"-- comment\n", (Object)SpannerStatementParserTest.skip("-- comment\nselect * from foo", 0));
        Assert.assertEquals((Object)"# comment\n", (Object)SpannerStatementParserTest.skip("# comment\nselect * from foo", 0));
        Assert.assertEquals((Object)"/* comment */", (Object)SpannerStatementParserTest.skip("/* comment */ select * from foo", 0));
        Assert.assertEquals((Object)"/* comment /* GoogleSQL does not support nested comments */", (Object)SpannerStatementParserTest.skip("/* comment /* GoogleSQL does not support nested comments */ select * from foo", 0));
        Assert.assertEquals((Object)"$", (Object)SpannerStatementParserTest.skip("$tag$not a string$tag$ select * from foo", 0));
        Assert.assertEquals((Object)"/* 'test' */", (Object)SpannerStatementParserTest.skip("/* 'test' */ foo"));
        Assert.assertEquals((Object)"-- 'test' \n", (Object)SpannerStatementParserTest.skip("-- 'test' \n foo"));
        Assert.assertEquals((Object)"'/* test */'", (Object)SpannerStatementParserTest.skip("'/* test */' foo"));
        Assert.assertEquals((Object)"'foo\\''", (Object)SpannerStatementParserTest.skip("'foo\\''  ", 0));
        Assert.assertEquals((Object)"'foo\\''", (Object)SpannerStatementParserTest.skip("r'foo\\''  ", 1));
        Assert.assertEquals((Object)"'''foo\\'\\'\\'bar'''", (Object)SpannerStatementParserTest.skip("'''foo\\'\\'\\'bar'''  ", 0));
    }

    @Test
    public void testConvertPositionalParametersToNamedParameters() {
        AbstractStatementParser parser = AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL);
        for (String comment : new String[]{"-- test comment\n", "/* another test comment */", "/* comment\nwith\nmultiple\nlines\n */", "/* comment /* with nested */ comment */"}) {
            for (StatementParserTest.CommentInjector injector : StatementParserTest.CommentInjector.values()) {
                Assert.assertEquals((Object)injector.inject("select * %sfrom foo where name=@p1", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"select * %sfrom foo where name=?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1%s'?test?\"?test?\"?'@p2", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?%s'?test?\"?test?\"?'?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1'?it\\'?s'%s@p2", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?'?it\\'?s'%s?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1'?it\\\"?s'%s@p2", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?'?it\\\"?s'%s?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1\"?it\\\"?s\"%s@p2", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?\"?it\\\"?s\"%s?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1%s'''?it\\''?s'''@p2", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?%s'''?it\\''?s'''?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1\"\"\"?it\\\"\"?s\"\"\"%s@p2", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?\"\"\"?it\\\"\"?s\"\"\"%s?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1$$@p2it$@p3s$$%s@p4", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?$$?it$?s$$%s?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1$tag$@p2it$$@p3s$tag$%s@p4", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?$tag$?it$$?s$tag$%s?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1%s$$@p2it\\'?s \t ?it\\'?s'$$@p3", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?%s$$?it\\'?s \t ?it\\'?s'$$?", (String)comment)).sqlWithNamedParameters);
                StatementParserTest.assertUnclosedLiteral(parser, injector.inject("?'?it\\''?s \n ?it\\''?s'%s?", comment));
                Assert.assertEquals((Object)"@p1'?it\\''@p2s \n @p3it\\''@p4s@p5", (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)"?'?it\\''?s \n ?it\\''?s?").sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("@p1%s'''?it\\''?s \n ?it\\''?s'''@p2", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"?%s'''?it\\''?s \n ?it\\''?s'''?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("select 1, @p1, 'test?test', \"test?test\", %sfoo.* from `foo` where col1=@p2 and col2='test' and col3=@p3 and col4='?' and col5=\"?\" and col6='?''?''?'", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"select 1, ?, 'test?test', \"test?test\", %sfoo.* from `foo` where col1=? and col2='test' and col3=? and col4='?' and col5=\"?\" and col6='?''?''?'", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("select * %sfrom foo where name=@p1 and col2 like @p2 and col3 > @p3", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"select * %sfrom foo where name=? and col2 like ? and col3 > ?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("select * from foo where id between @p1%s and @p2", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"select * from foo where id between ?%s and ?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("select * from foo limit @p1 %s offset @p2", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"select * from foo limit ? %s offset ?", (String)comment)).sqlWithNamedParameters);
                Assert.assertEquals((Object)injector.inject("select * from foo where col1=@p1 and col2 like @p2  %s and col3 > @p3 and col4 < @p4 and col5 != @p5 and col6 not in (@p6, @p7, @p8) and col7 in (@p9, @p10, @p11) and col8 between @p12 and @p13", comment), (Object)parser.convertPositionalParametersToNamedParameters((char)'?', (String)injector.inject((String)"select * from foo where col1=? and col2 like ?  %s and col3 > ? and col4 < ? and col5 != ? and col6 not in (?, ?, ?) and col7 in (?, ?, ?) and col8 between ? and ?", (String)comment)).sqlWithNamedParameters);
            }
        }
    }
}

