/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public final class ITDMLTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static DatabaseClient googleStandardSQLClient;
    private static DatabaseClient postgreSQLClient;
    private static int seq;
    private static int id;
    private static final String INSERT_DML = "INSERT INTO T (k, v) VALUES ('%d-boo1', 1), ('%d-boo2', 2), ('%d-boo3', 3), ('%d-boo4', 4);";
    private static final String UPDATE_DML = "UPDATE T SET V = 100 WHERE K LIKE '%d-boo%%';";
    private static final String DELETE_DML = "DELETE FROM T WHERE K like '%d-boo%%';";
    private static final long DML_COUNT = 4L;
    private static boolean throwAbortOnce;
    @Parameterized.Parameter(value=0)
    public DialectTestParameter dialect;

    @BeforeClass
    public static void setUpDatabase() {
        Database googleStandardSQLDatabase = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T (  K    STRING(MAX) NOT NULL,  V    INT64,) PRIMARY KEY (K)"});
        googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSQLDatabase);
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Arrays.asList("CREATE TABLE T (  K    VARCHAR PRIMARY KEY,  V    BIGINT)"));
            postgreSQLClient = env.getTestHelper().getDatabaseClient(postgreSQLDatabase);
        }
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    @Before
    public void increaseTestIdAndDeleteTestData() {
        if (this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL) {
            googleStandardSQLClient.writeAtLeastOnce(Collections.singletonList(Mutation.delete((String)"T", (KeySet)KeySet.all())));
        } else {
            postgreSQLClient.writeAtLeastOnce(Collections.singletonList(Mutation.delete((String)"T", (KeySet)KeySet.all())));
        }
        ++id;
    }

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        }
        return params;
    }

    private static String uniqueKey() {
        return "k" + seq++;
    }

    private String insertDml() {
        return String.format(INSERT_DML, id, id, id, id);
    }

    private String updateDml() {
        return String.format(UPDATE_DML, id);
    }

    private String deleteDml() {
        return String.format(DELETE_DML, id);
    }

    private void executeUpdate(long expectedCount, String ... stmts) {
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = 0L;
            for (String stmt : stmts) {
                if (throwAbortOnce) {
                    throwAbortOnce = false;
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"Abort in test");
                }
                rowCount += transaction.executeUpdate(Statement.of((String)stmt), new Options.UpdateOption[0]);
            }
            return rowCount;
        };
        TransactionRunner runner = this.getClient(this.dialect.dialect).readWriteTransaction(new Options.TransactionOption[0]);
        Long rowCount = (Long)runner.run(callable);
        Truth.assertThat((Long)rowCount).isEqualTo((Object)expectedCount);
    }

    private DatabaseClient getClient(Dialect dialect) {
        if (dialect == Dialect.POSTGRESQL) {
            return postgreSQLClient;
        }
        return googleStandardSQLClient;
    }

    @Test
    public void abortOnceShouldSucceedAfterRetry() {
        try {
            throwAbortOnce = true;
            this.executeUpdate(4L, this.insertDml());
            Truth.assertThat((Boolean)throwAbortOnce).isFalse();
        }
        catch (AbortedException e) {
            Assert.fail((String)"Abort Exception not caught and retried");
        }
    }

    @Test
    public void partitionedDML() {
        this.executeUpdate(4L, this.insertDml());
        Truth.assertThat((Long)this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)1);
        long rowCount = this.getClient(this.dialect.dialect).executePartitionedUpdate(Statement.of((String)this.updateDml()), new Options.UpdateOption[0]);
        Truth.assertThat((Long)rowCount).isEqualTo((Object)4L);
        Truth.assertThat((Long)this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)100);
        rowCount = this.getClient(this.dialect.dialect).executePartitionedUpdate(Statement.of((String)this.deleteDml()), new Options.UpdateOption[0]);
        Truth.assertThat((Long)rowCount).isEqualTo((Object)4L);
        Truth.assertThat((Object)this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V"))).isNull();
    }

    @Test
    public void standardDML() {
        this.executeUpdate(4L, this.insertDml());
        Truth.assertThat((Long)this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)1);
        this.executeUpdate(4L, this.updateDml());
        Truth.assertThat((Long)this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)100);
        this.executeUpdate(4L, this.deleteDml());
        Truth.assertThat((Object)this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V"))).isNull();
    }

    @Test
    public void standardDMLWithError() {
        try {
            this.executeUpdate(0L, "SELECT * FROM T;");
            Assert.fail((String)"Expected illegal argument exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"DML response missing stats possibly due to non-DML statement as input");
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void standardDMLWithDuplicates() {
        this.executeUpdate(4L, this.insertDml());
        this.executeUpdate(4L, String.format("UPDATE T SET v = 200 WHERE k = '%d-boo1';", id), String.format("UPDATE T SET v = 300 WHERE k = '%d-boo1';", id), String.format("UPDATE T SET v = 400 WHERE k = '%d-boo1';", id), String.format("UPDATE T SET v = 500 WHERE k = '%d-boo1';", id));
        Truth.assertThat((Long)this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)500);
        this.executeUpdate(4L, this.deleteDml(), this.deleteDml());
    }

    @Test
    public void standardDMLReadYourWrites() {
        this.executeUpdate(4L, this.insertDml());
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = transaction.executeUpdate(Statement.of((String)String.format("UPDATE T SET v = v * 2 WHERE k = '%d-boo2';", id)), new Options.UpdateOption[0]);
            Truth.assertThat((Long)rowCount).isEqualTo((Object)1);
            Truth.assertThat((Long)transaction.readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo2", id)}), Collections.singletonList("v")).getLong(0)).isEqualTo((Object)4);
            return null;
        };
        TransactionRunner runner = this.getClient(this.dialect.dialect).readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(callable);
        this.executeUpdate(4L, this.deleteDml());
    }

    @Test
    public void standardDMLRollback() {
        class UserException
        extends Exception {
            UserException(String message) {
                super(message);
            }
        }
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = transaction.executeUpdate(Statement.of((String)this.insertDml()), new Options.UpdateOption[0]);
            Truth.assertThat((Long)rowCount).isEqualTo((Object)4L);
            throw new UserException("failing to commit");
        };
        try {
            TransactionRunner runner = this.getClient(this.dialect.dialect).readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(callable);
            Assert.fail((String)"Expected user exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"failing to commit");
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(UserException.class);
        }
        ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).read("T", KeySet.range((KeyRange)KeyRange.prefix((Key)Key.of((Object[])new Object[]{String.format("%d-boo", id)}))), Collections.singletonList("K"), new Options.ReadOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
    }

    @Test
    public void standardDMLAndMutations() {
        String key1 = ITDMLTest.uniqueKey();
        String key2 = ITDMLTest.uniqueKey();
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = transaction.executeUpdate(Statement.of((String)("INSERT INTO T (k, v) VALUES ('" + key1 + "', 1)")), new Options.UpdateOption[0]);
            Truth.assertThat((Long)rowCount).isEqualTo((Object)1);
            transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(key2)).set("V").to(2L)).build());
            return null;
        };
        TransactionRunner runner = this.getClient(this.dialect.dialect).readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(callable);
        KeySet.Builder keys = KeySet.newBuilder();
        keys.addKey(Key.of((Object[])new Object[]{key1})).addKey(Key.of((Object[])new Object[]{key2}));
        ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).read("T", keys.build(), Collections.singletonList("K"), new Options.ReadOption[0]);
        int rowCount = 0;
        while (resultSet.next()) {
            ++rowCount;
        }
        Truth.assertThat((Integer)rowCount).isEqualTo((Object)2);
    }

    private void executeQuery(long expectedCount, String ... stmts) {
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = 0L;
            for (String stmt : stmts) {
                ResultSet resultSet = transaction.executeQuery(Statement.of((String)stmt), new Options.QueryOption[0]);
                Truth.assertThat((Boolean)resultSet.next()).isFalse();
                Truth.assertThat((Object)resultSet.getStats()).isNotNull();
                rowCount += resultSet.getStats().getRowCountExact();
            }
            return rowCount;
        };
        TransactionRunner runner = this.getClient(this.dialect.dialect).readWriteTransaction(new Options.TransactionOption[0]);
        Long rowCount = (Long)runner.run(callable);
        Truth.assertThat((Long)rowCount).isEqualTo((Object)expectedCount);
    }

    @Test
    public void standardDMLWithExecuteSQL() {
        this.executeQuery(4L, this.insertDml());
        this.executeQuery(8L, this.updateDml(), this.deleteDml());
    }

    @Test
    public void testUntypedNullValues() {
        Assume.assumeFalse((String)"Spanner PostgreSQL does not yet support untyped null values", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        DatabaseClient client = this.getClient(this.dialect.dialect);
        String sql = this.dialect.dialect == Dialect.POSTGRESQL ? "INSERT INTO T (K, V) VALUES ($1, $2)" : "INSERT INTO T (K, V) VALUES (@p1, @p2)";
        Long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)sql).bind("p1").to("k1")).bind("p2").to((Value)null)).build(), new Options.UpdateOption[0]));
        Assert.assertNotNull((Object)updateCount);
        Assert.assertEquals((long)1L, (long)updateCount);
        try (ResultSet resultSet = client.singleUse().executeQuery(Statement.of((String)"SELECT V FROM T"), new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((boolean)resultSet.isNull(0));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    static {
        throwAbortOnce = false;
    }
}

