/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.spi.v1.GapicSpannerRpc;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ListValue;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Value;
import com.google.rpc.ErrorInfo;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SpannerGrpc;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.threeten.bp.Duration;

@RunWith(value=Parameterized.class)
public class GapicSpannerRpcTest {
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static final Statement UPDATE_FOO_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    private static final String STATIC_OAUTH_TOKEN = "STATIC_TEST_OAUTH_TOKEN";
    private static final String VARIABLE_OAUTH_TOKEN = "VARIABLE_TEST_OAUTH_TOKEN";
    private static final OAuth2Credentials STATIC_CREDENTIALS = OAuth2Credentials.create((AccessToken)new AccessToken("STATIC_TEST_OAUTH_TOKEN", new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS))));
    private static final OAuth2Credentials VARIABLE_CREDENTIALS = OAuth2Credentials.create((AccessToken)new AccessToken("VARIABLE_TEST_OAUTH_TOKEN", new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS))));
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static InetSocketAddress address;
    private static final Map<SpannerRpc.Option, Object> optionsMap;
    private static Metadata lastSeenHeaders;
    private static String defaultUserAgent;
    private static Spanner spanner;
    private static boolean isRouteToLeader;
    @Parameterized.Parameter
    public Dialect dialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    @Before
    public void startServer() throws IOException {
        Assume.assumeTrue((String)"Skip tests when emulator is enabled as this test interferes with the check whether the emulator is running", (System.getenv("SPANNER_EMULATOR_HOST") == null ? 1 : 0) != 0);
        defaultUserAgent = "spanner-java/" + GaxProperties.getLibraryVersion(GapicSpannerRpc.class);
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_FOO_STATEMENT, 1L));
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).intercept(new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                lastSeenHeaders = headers;
                String auth = (String)headers.get(Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                Truth.assertThat((String)auth).isEqualTo((Object)"Bearer VARIABLE_TEST_OAUTH_TOKEN");
                String clientLibToken = (String)headers.get(Metadata.Key.of((String)"x-goog-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                Assert.assertNotNull((Object)clientLibToken);
                Assert.assertTrue((boolean)clientLibToken.contains(ServiceOptions.getGoogApiClientLibName() + "/"));
                if (call.getMethodDescriptor().equals(SpannerGrpc.getExecuteStreamingSqlMethod()) || call.getMethodDescriptor().equals(SpannerGrpc.getExecuteSqlMethod())) {
                    String routeToLeaderHeader = (String)headers.get(Metadata.Key.of((String)"x-goog-spanner-route-to-leader", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                    isRouteToLeader = routeToLeaderHeader != null && routeToLeaderHeader.equals("true");
                }
                return Contexts.interceptCall((Context)Context.current(), call, (Metadata)headers, next);
            }
        })).build().start();
        optionsMap.put(SpannerRpc.Option.CHANNEL_HINT, 1L);
        spanner = (Spanner)this.createSpannerOptions().getService();
    }

    @After
    public void reset() throws InterruptedException {
        if (mockSpanner != null) {
            mockSpanner.reset();
        }
        if (spanner != null) {
            spanner.close();
        }
        if (server != null) {
            server.shutdown();
            server.awaitTermination();
        }
        isRouteToLeader = false;
    }

    @Test
    public void testCallCredentialsProviderPreferenceAboveCredentials() {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)STATIC_CREDENTIALS)).setCallCredentialsProvider(() -> MoreCallCredentials.from((Credentials)VARIABLE_CREDENTIALS)).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        Assert.assertNotNull((Object)rpc.newCallContext(optionsMap, "/some/resource", (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()).getCallOptions().getCredentials());
        rpc.shutdown();
    }

    @Test
    public void testCallCredentialsProviderReturnsNull() {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)STATIC_CREDENTIALS)).setCallCredentialsProvider(() -> null).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        Assert.assertNull((Object)rpc.newCallContext(optionsMap, "/some/resource", (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()).getCallOptions().getCredentials());
        rpc.shutdown();
    }

    @Test
    public void testNoCallCredentials() {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)STATIC_CREDENTIALS)).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        Assert.assertNull((Object)rpc.newCallContext(optionsMap, "/some/resource", (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()).getCallOptions().getCredentials());
        rpc.shutdown();
    }

    @Test
    public void testClientCompressorGzip() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCompressorName("gzip").build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        Assert.assertEquals((Object)"gzip", (Object)rpc.newCallContext(optionsMap, "/some/resource", (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()).getCallOptions().getCompressor());
        rpc.shutdown();
    }

    @Test
    public void testClientCompressorIdentity() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCompressorName("identity").build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        Assert.assertEquals((Object)"identity", (Object)rpc.newCallContext(optionsMap, "/some/resource", (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()).getCallOptions().getCompressor());
        rpc.shutdown();
    }

    @Test
    public void testClientCompressorDefault() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        Assert.assertNull((Object)rpc.newCallContext(optionsMap, "/some/resource", (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()).getCallOptions().getCompressor());
        rpc.shutdown();
    }

    @Test
    public void testCallContextTimeout() {
        final TimeoutHolder timeoutHolder = new TimeoutHolder();
        SpannerOptions.CallContextConfigurator configurator = new SpannerOptions.CallContextConfigurator(){

            public <ReqT, RespT> ApiCallContext configure(ApiCallContext context, ReqT request, MethodDescriptor<ReqT, RespT> method) {
                ExecuteSqlRequest sqlRequest;
                if (request instanceof ExecuteSqlRequest && method.equals((Object)SpannerGrpc.getExecuteSqlMethod()) && (sqlRequest = (ExecuteSqlRequest)request).getSeqno() > 0L) {
                    return context.withTimeout(timeoutHolder.timeout);
                }
                return null;
            }
        };
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        Context context = Context.current().withValue(SpannerOptions.CALL_CONTEXT_CONFIGURATOR_KEY, (Object)configurator);
        context.run(() -> {
            timeoutHolder.timeout = Duration.ofNanos((long)1L);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0])));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            timeoutHolder.timeout = Duration.ofMinutes((long)1L);
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
            Assert.assertEquals((long)1L, (long)updateCount);
        });
    }

    @Test
    public void testNewCallContextWithNullRequestAndNullMethod() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        Assert.assertNotNull((Object)rpc.newCallContext(optionsMap, "/some/resource", null, null));
        rpc.shutdown();
    }

    @Test
    public void testNewCallContextWithRouteToLeaderHeader() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).enableLeaderAwareRouting().build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        GrpcCallContext callContext = rpc.newCallContext(optionsMap, "/some/resource", (Object)ExecuteSqlRequest.getDefaultInstance(), SpannerGrpc.getExecuteSqlMethod(), true);
        Assert.assertNotNull((Object)callContext);
        Assert.assertEquals((Object)ImmutableList.of((Object)"true"), callContext.getExtraHeaders().get("x-goog-spanner-route-to-leader"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"projects/some-project"), callContext.getExtraHeaders().get(ApiClientHeaderProvider.getDefaultResourceHeaderKey()));
        rpc.shutdown();
    }

    @Test
    public void testNewCallContextWithoutRouteToLeaderHeader() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().enableLeaderAwareRouting().setProjectId("some-project")).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        GrpcCallContext callContext = rpc.newCallContext(optionsMap, "/some/resource", (Object)ExecuteSqlRequest.getDefaultInstance(), SpannerGrpc.getExecuteSqlMethod(), false);
        Assert.assertNotNull((Object)callContext);
        Assert.assertNull(callContext.getExtraHeaders().get("x-goog-spanner-route-to-leader"));
        rpc.shutdown();
    }

    @Test
    public void testNewCallContextWithRouteToLeaderHeaderAndLarDisabled() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).disableLeaderAwareRouting().build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        GrpcCallContext callContext = rpc.newCallContext(optionsMap, "/some/resource", (Object)ExecuteSqlRequest.getDefaultInstance(), SpannerGrpc.getExecuteSqlMethod(), true);
        Assert.assertNotNull((Object)callContext);
        Assert.assertNull(callContext.getExtraHeaders().get("x-goog-spanner-route-to-leader"));
        rpc.shutdown();
    }

    @Test
    public void testAdminRequestsLimitExceededRetryAlgorithm() {
        GapicSpannerRpc.AdminRequestsLimitExceededRetryAlgorithm alg = new GapicSpannerRpc.AdminRequestsLimitExceededRetryAlgorithm();
        Truth.assertThat((Boolean)alg.shouldRetry(null, (Object)1L)).isFalse();
        ErrorInfo info = ErrorInfo.newBuilder().putMetadata("quota_limit", "AdminMethodQuotaPerMinutePerProject").build();
        Metadata.Key key = Metadata.Key.of((String)(info.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)info));
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)info);
        SpannerException adminRateExceeded = SpannerExceptionFactory.newSpannerException((Throwable)Status.RESOURCE_EXHAUSTED.withDescription("foo").asRuntimeException(trailers));
        Truth.assertThat((Boolean)alg.shouldRetry((Throwable)adminRateExceeded, null)).isTrue();
        SpannerException numDatabasesExceeded = SpannerExceptionFactory.newSpannerException((Throwable)Status.RESOURCE_EXHAUSTED.withDescription("Too many databases on instance").asRuntimeException());
        Truth.assertThat((Boolean)alg.shouldRetry((Throwable)numDatabasesExceeded, null)).isFalse();
        Truth.assertThat((Boolean)alg.shouldRetry((Throwable)new Exception("random exception"), null)).isFalse();
    }

    @Test
    public void testDefaultUserAgent() {
        DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        try (ResultSet rs = databaseClient.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            rs.next();
        }
        Truth.assertThat((String)((String)lastSeenHeaders.get(Metadata.Key.of((String)"user-agent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)))).contains((CharSequence)defaultUserAgent);
    }

    @Test
    public void testCustomUserAgent() {
        for (String headerId : new String[]{"user-agent", "User-Agent", "USER-AGENT"}) {
            HeaderProvider userAgentHeaderProvider = () -> {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put(headerId, "test-agent");
                return headers;
            };
            SpannerOptions options = ((SpannerOptions.Builder)this.createSpannerOptions().toBuilder().setHeaderProvider(userAgentHeaderProvider)).build();
            try (Spanner spanner = (Spanner)options.getService();){
                DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
                try (ResultSet rs = databaseClient.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                    rs.next();
                }
                Truth.assertThat((String)((String)lastSeenHeaders.get(Metadata.Key.of((String)"user-agent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)))).contains((CharSequence)("test-agent " + defaultUserAgent));
            }
        }
    }

    @Test
    public void testRouteToLeaderHeaderForReadOnly() {
        SpannerOptions options = this.createSpannerOptions().toBuilder().enableLeaderAwareRouting().build();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (ResultSet rs = databaseClient.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                rs.next();
            }
            Assert.assertFalse((boolean)isRouteToLeader);
        }
    }

    @Test
    public void testRouteToLeaderHeaderForReadWrite() {
        SpannerOptions options = this.createSpannerOptions().toBuilder().enableLeaderAwareRouting().build();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            TransactionRunner runner = databaseClient.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> {
                transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]);
                return null;
            });
        }
        Assert.assertTrue((boolean)isRouteToLeader);
    }

    @Test
    public void testRouteToLeaderHeaderWithLeaderAwareRoutingDisabled() {
        SpannerOptions options = this.createSpannerOptions().toBuilder().disableLeaderAwareRouting().build();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            TransactionRunner runner = databaseClient.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> {
                transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]);
                return null;
            });
        }
        Assert.assertFalse((boolean)isRouteToLeader);
    }

    @Test
    public void testClientLibToken() {
        SpannerOptions options = this.createSpannerOptions();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            TransactionRunner runner = databaseClient.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
        }
        Metadata.Key key = Metadata.Key.of((String)"x-goog-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Assert.assertTrue((boolean)lastSeenHeaders.containsKey(key));
        Assert.assertTrue((String)((String)lastSeenHeaders.get(key)), (boolean)Objects.requireNonNull((String)lastSeenHeaders.get(key)).contains(ServiceOptions.getGoogApiClientLibName() + "/"));
        Assert.assertEquals((String)((String)lastSeenHeaders.get(key)), (long)2L, (long)Objects.requireNonNull((String)lastSeenHeaders.get(key)).split(ServiceOptions.getGoogApiClientLibName()).length);
        Assert.assertTrue((String)((String)lastSeenHeaders.get(key)), (boolean)Objects.requireNonNull((String)lastSeenHeaders.get(key)).contains("gl-java/"));
    }

    @Test
    public void testCustomClientLibToken_alsoContainsDefaultToken() {
        SpannerOptions options = this.createSpannerOptions().toBuilder().setClientLibToken("pg-adapter").build();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            TransactionRunner runner = databaseClient.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
        }
        Metadata.Key key = Metadata.Key.of((String)"x-goog-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Assert.assertTrue((boolean)lastSeenHeaders.containsKey(key));
        Assert.assertTrue((String)((String)lastSeenHeaders.get(key)), (boolean)Objects.requireNonNull((String)lastSeenHeaders.get(key)).contains("pg-adapter"));
        Assert.assertTrue((String)((String)lastSeenHeaders.get(key)), (boolean)Objects.requireNonNull((String)lastSeenHeaders.get(key)).contains(ServiceOptions.getGoogApiClientLibName() + "/"));
        Assert.assertTrue((String)((String)lastSeenHeaders.get(key)), (boolean)Objects.requireNonNull((String)lastSeenHeaders.get(key)).contains("gl-java/"));
    }

    @Test
    public void testGetDatabaseAdminStubSettings_whenStubInitialized_assertNonNullClientSetting() {
        SpannerOptions options = this.createSpannerOptions();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, true);
        Assert.assertNotNull((Object)rpc.getDatabaseAdminStubSettings());
        rpc.shutdown();
    }

    @Test
    public void testGetInstanceAdminStubSettings_whenStubInitialized_assertNonNullClientSetting() {
        SpannerOptions options = this.createSpannerOptions();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, true);
        Assert.assertNotNull((Object)rpc.getInstanceAdminStubSettings());
        rpc.shutdown();
    }

    @Test
    public void testAdminStubSettings_whenStubNotInitialized_assertNullClientSetting() {
        SpannerOptions options = this.createSpannerOptions();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, false);
        Assert.assertNull((Object)rpc.getDatabaseAdminStubSettings());
        Assert.assertNull((Object)rpc.getInstanceAdminStubSettings());
        rpc.shutdown();
    }

    @Test
    public void testCreateSession_assertSessionProto() {
        SpannerOptions options = this.createSpannerOptions();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, true);
        Session session = rpc.createSession("DATABASE_NAME", null, null, null);
        Assert.assertNotNull((Object)session);
        Assert.assertNotNull((Object)session.getCreateTime());
        Assert.assertEquals((Object)false, (Object)session.getMultiplexed());
        rpc.shutdown();
    }

    @Test
    public void testCreateSession_whenMultiplexedSessionIsTrue_assertSessionProto() {
        SpannerOptions options = this.createSpannerOptions();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, true);
        Session session = rpc.createSession("DATABASE_NAME", null, null, null, true);
        Assert.assertNotNull((Object)session);
        Assert.assertNotNull((Object)session.getCreateTime());
        Assert.assertEquals((Object)true, (Object)session.getMultiplexed());
        rpc.shutdown();
    }

    @Test
    public void testCreateSession_whenMultiplexedSessionIsFalse_assertSessionProto() {
        SpannerOptions options = this.createSpannerOptions();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options, true);
        Session session = rpc.createSession("DATABASE_NAME", null, null, null, false);
        Assert.assertNotNull((Object)session);
        Assert.assertNotNull((Object)session.getCreateTime());
        Assert.assertEquals((Object)false, (Object)session.getMultiplexed());
        rpc.shutdown();
    }

    private SpannerOptions createSpannerOptions() {
        String endpoint = address.getHostString() + ":" + server.getPort();
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).disableDirectPath().setHost("http://" + endpoint).setCredentials((Credentials)STATIC_CREDENTIALS)).setCallCredentialsProvider(() -> MoreCallCredentials.from((Credentials)VARIABLE_CREDENTIALS)).build();
    }

    static {
        optionsMap = new HashMap<SpannerRpc.Option, Object>();
    }

    private static final class TimeoutHolder {
        private Duration timeout;

        private TimeoutHolder() {
        }
    }
}

