/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AsyncStatementResult;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.DdlInTransactionMode;
import com.google.cloud.spanner.connection.PartitionedQueryResultSet;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.ResultSetStats;
import java.time.Duration;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@InternalApi
public interface Connection
extends AutoCloseable {
    @Override
    public void close();

    public ApiFuture<Void> closeAsync();

    public boolean isClosed();

    public void setAutocommit(boolean var1);

    public boolean isAutocommit();

    public void setReadOnly(boolean var1);

    public boolean isReadOnly();

    public void setStatementTimeout(long var1, TimeUnit var3);

    public void clearStatementTimeout();

    public long getStatementTimeout(TimeUnit var1);

    public boolean hasStatementTimeout();

    public void cancel();

    public void beginTransaction();

    public ApiFuture<Void> beginTransactionAsync();

    public void setTransactionMode(TransactionMode var1);

    public TransactionMode getTransactionMode();

    default public void setTransactionTag(String tag) {
        throw new UnsupportedOperationException();
    }

    default public String getTransactionTag() {
        throw new UnsupportedOperationException();
    }

    default public void setStatementTag(String tag) {
        throw new UnsupportedOperationException();
    }

    default public String getStatementTag() {
        throw new UnsupportedOperationException();
    }

    public boolean isRetryAbortsInternally();

    public void setRetryAbortsInternally(boolean var1);

    public void addTransactionRetryListener(TransactionRetryListener var1);

    public boolean removeTransactionRetryListener(TransactionRetryListener var1);

    public Iterator<TransactionRetryListener> getTransactionRetryListeners();

    public void setAutocommitDmlMode(AutocommitDmlMode var1);

    public AutocommitDmlMode getAutocommitDmlMode();

    public void setReadOnlyStaleness(TimestampBound var1);

    public TimestampBound getReadOnlyStaleness();

    default public void setDirectedRead(DirectedReadOptions directedReadOptions) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public DirectedReadOptions getDirectedRead() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    public void setOptimizerVersion(String var1);

    public String getOptimizerVersion();

    default public void setOptimizerStatisticsPackage(String optimizerStatisticsPackage) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public String getOptimizerStatisticsPackage() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    public void setReturnCommitStats(boolean var1);

    public boolean isReturnCommitStats();

    default public void setMaxCommitDelay(Duration maxCommitDelay) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public Duration getMaxCommitDelay() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public void setRPCPriority(Options.RpcPriority rpcPriority) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public Options.RpcPriority getRPCPriority() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public void setDelayTransactionStartUntilFirstWrite(boolean delayTransactionStartUntilFirstWrite) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public boolean isDelayTransactionStartUntilFirstWrite() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    public void commit();

    public ApiFuture<Void> commitAsync();

    public void rollback();

    public ApiFuture<Void> rollbackAsync();

    public SavepointSupport getSavepointSupport();

    public void setSavepointSupport(SavepointSupport var1);

    public DdlInTransactionMode getDdlInTransactionMode();

    public void setDdlInTransactionMode(DdlInTransactionMode var1);

    public void savepoint(String var1);

    public void releaseSavepoint(String var1);

    public void rollbackToSavepoint(String var1);

    public boolean isInTransaction();

    public boolean isTransactionStarted();

    public Timestamp getReadTimestamp();

    public Timestamp getCommitTimestamp();

    public CommitResponse getCommitResponse();

    public void startBatchDdl();

    public void startBatchDml();

    public long[] runBatch();

    public ApiFuture<long[]> runBatchAsync();

    public void abortBatch();

    public boolean isDdlBatchActive();

    public boolean isDmlBatchActive();

    public StatementResult execute(Statement var1);

    default public StatementResult execute(Statement statement, Set<StatementResult.ResultType> allowedResultTypes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public AsyncStatementResult executeAsync(Statement var1);

    public ResultSet executeQuery(Statement var1, Options.QueryOption ... var2);

    public AsyncResultSet executeQueryAsync(Statement var1, Options.QueryOption ... var2);

    public ResultSet analyzeQuery(Statement var1, ReadContext.QueryAnalyzeMode var2);

    public void setDataBoostEnabled(boolean var1);

    public boolean isDataBoostEnabled();

    public void setAutoPartitionMode(boolean var1);

    public boolean isAutoPartitionMode();

    public void setMaxPartitions(int var1);

    public int getMaxPartitions();

    public ResultSet partitionQuery(Statement var1, PartitionOptions var2, Options.QueryOption ... var3);

    public ResultSet runPartition(String var1);

    public void setMaxPartitionedParallelism(int var1);

    public int getMaxPartitionedParallelism();

    public PartitionedQueryResultSet runPartitionedQuery(Statement var1, PartitionOptions var2, Options.QueryOption ... var3);

    public long executeUpdate(Statement var1);

    @Deprecated
    default public ResultSetStats analyzeUpdate(Statement update, ReadContext.QueryAnalyzeMode analyzeMode) {
        throw new UnsupportedOperationException("Not implemented");
    }

    default public ResultSet analyzeUpdateStatement(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ApiFuture<Long> executeUpdateAsync(Statement var1);

    public long[] executeBatchUpdate(Iterable<Statement> var1);

    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<Statement> var1);

    public void write(Mutation var1);

    public ApiFuture<Void> writeAsync(Mutation var1);

    public void write(Iterable<Mutation> var1);

    public ApiFuture<Void> writeAsync(Iterable<Mutation> var1);

    public void bufferedWrite(Mutation var1);

    public void bufferedWrite(Iterable<Mutation> var1);

    default public Dialect getDialect() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @InternalApi
    default public DatabaseClient getDatabaseClient() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @InternalApi
    default public Spanner getSpanner() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @InternalApi
    public static final class InternalMetadataQuery
    implements Options.QueryOption {
        @InternalApi
        public static final InternalMetadataQuery INSTANCE = new InternalMetadataQuery();

        private InternalMetadataQuery() {
        }
    }
}

