/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.AbstractMultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.DelayedReadContext;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.MultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.SessionReference;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;

class DelayedMultiplexedSessionTransaction
extends AbstractMultiplexedSessionDatabaseClient {
    private final MultiplexedSessionDatabaseClient client;
    private final ISpan span;
    private final ApiFuture<SessionReference> sessionFuture;

    DelayedMultiplexedSessionTransaction(MultiplexedSessionDatabaseClient client, ISpan span, ApiFuture<SessionReference> sessionFuture) {
        this.client = client;
        this.span = span;
        this.sessionFuture = sessionFuture;
    }

    @Override
    public ReadContext singleUse() {
        return new DelayedReadContext(ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, true).singleUse(), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        return new DelayedReadContext(ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, true).singleUse(bound), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        return new DelayedReadContext.DelayedReadOnlyTransaction((ApiFuture<ReadOnlyTransaction>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, true).singleUseReadOnlyTransaction(), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        return new DelayedReadContext.DelayedReadOnlyTransaction((ApiFuture<ReadOnlyTransaction>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, true).singleUseReadOnlyTransaction(bound), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        return new DelayedReadContext.DelayedReadOnlyTransaction((ApiFuture<ReadOnlyTransaction>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, false).readOnlyTransaction(), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        return new DelayedReadContext.DelayedReadOnlyTransaction((ApiFuture<ReadOnlyTransaction>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, false).readOnlyTransaction(bound), (Executor)MoreExecutors.directExecutor()));
    }
}

