/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingAsyncResultSet;
import com.google.cloud.spanner.IScope;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.NoRowsResultSet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerRetryHelper;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class TransactionRunnerImpl
implements SessionImpl.SessionTransaction,
TransactionRunner {
    private static final Logger txnLogger = Logger.getLogger(TransactionRunner.class.getName());
    private static final String TRANSACTION_CANCELLED_MESSAGE = "invalidated by a later transaction";
    private static final String TRANSACTION_ALREADY_COMMITTED_MESSAGE = "Transaction has already committed";
    private static final String DML_INVALID_EXCLUDE_CHANGE_STREAMS_OPTION_MESSAGE = "Options.excludeTxnFromChangeStreams() cannot be specified for individual DML requests. This option should be set at the transaction level.";
    private boolean blockNestedTxn = true;
    private final SessionImpl session;
    private final Options options;
    private ISpan span;
    private TraceWrapper tracer;
    private TransactionContextImpl txn;
    private volatile boolean isValid = true;

    @Override
    public TransactionRunner allowNestedTransaction() {
        this.blockNestedTxn = false;
        return this;
    }

    TransactionRunnerImpl(SessionImpl session, Options.TransactionOption ... options) {
        this.session = session;
        this.options = Options.fromTransactionOptions(options);
        this.txn = session.newTransaction(this.options);
        this.tracer = session.getTracer();
    }

    @Override
    public void setSpan(ISpan span) {
        this.span = span;
    }

    @Override
    @Nullable
    public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
        try {
            T t;
            block12: {
                IScope s = this.tracer.withSpan(this.span);
                try {
                    if (this.blockNestedTxn) {
                        SessionImpl.hasPendingTransaction.set(Boolean.TRUE);
                    }
                    t = this.runInternal(callable);
                    if (s == null) break block12;
                    s.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        this.span.setStatus(e);
                        throw e;
                    }
                }
            }
            return t;
        }
        finally {
            SessionImpl.hasPendingTransaction.remove();
            this.span.end();
        }
    }

    private <T> T runInternal(TransactionRunner.TransactionCallable<T> txCallable) {
        AtomicInteger attempt = new AtomicInteger();
        Callable<Object> retryCallable = () -> {
            Object result;
            boolean useInlinedBegin = true;
            if (attempt.get() > 0) {
                useInlinedBegin = this.txn.transactionId != null;
                this.txn = this.session.newTransaction(this.options);
            }
            Preconditions.checkState((boolean)this.isValid, (Object)"TransactionRunner has been invalidated by a new operation on the session");
            attempt.incrementAndGet();
            this.span.addAnnotation("Starting Transaction Attempt", "Attempt", attempt.longValue());
            if (!useInlinedBegin) {
                this.txn.ensureTxn();
            }
            boolean shouldRollback = true;
            try {
                result = txCallable.run(this.txn);
                shouldRollback = false;
            }
            catch (Exception e) {
                txnLogger.log(Level.FINE, "User-provided TransactionCallable raised exception", e);
                if (this.txn.isAborted() || e instanceof AbortedException) {
                    this.span.addAnnotation("Transaction Attempt Aborted in user operation. Retrying", "Attempt", attempt.longValue());
                    shouldRollback = false;
                    if (e instanceof AbortedException) {
                        throw e;
                    }
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, e.getMessage(), e);
                }
                SpannerException toThrow = e instanceof SpannerException ? (SpannerException)((Object)((Object)e)) : SpannerExceptionFactory.newSpannerException(ErrorCode.UNKNOWN, e.getMessage(), e);
                this.span.addAnnotation("Transaction Attempt Failed in user operation", (Map<String, Object>)ImmutableMap.of((Object)"Attempt", (Object)attempt.longValue(), (Object)"Status", (Object)toThrow.getErrorCode().toString()));
                throw toThrow;
            }
            finally {
                if (shouldRollback) {
                    this.txn.rollback();
                }
            }
            try {
                this.txn.commit();
                this.span.addAnnotation("Transaction Attempt Succeeded", "Attempt", attempt.longValue());
                return result;
            }
            catch (AbortedException e) {
                txnLogger.log(Level.FINE, "Commit aborted", (Throwable)((Object)e));
                this.span.addAnnotation("Transaction Attempt Aborted in Commit. Retrying", "Attempt", attempt.longValue());
                throw e;
            }
            catch (SpannerException e) {
                this.span.addAnnotation("Transaction Attempt Failed in Commit", (Map<String, Object>)ImmutableMap.of((Object)"Attempt", (Object)attempt.longValue(), (Object)"Status", (Object)e.getErrorCode().toString()));
                throw e;
            }
        };
        return (T)SpannerRetryHelper.runTxWithRetriesOnAborted(retryCallable);
    }

    @Override
    public Timestamp getCommitTimestamp() {
        Preconditions.checkState((this.txn != null ? 1 : 0) != 0, (Object)"run() has not yet returned normally");
        return this.txn.getCommitResponse().getCommitTimestamp();
    }

    @Override
    public CommitResponse getCommitResponse() {
        Preconditions.checkState((this.txn != null ? 1 : 0) != 0, (Object)"run() has not yet returned normally");
        return this.txn.getCommitResponse();
    }

    @Override
    public void invalidate() {
        this.isValid = false;
    }

    @Override
    public void close() {
    }

    @VisibleForTesting
    static class TransactionContextImpl
    extends AbstractReadContext
    implements TransactionContext {
        private final Object committingLock = new Object();
        @GuardedBy(value="committingLock")
        private volatile boolean committing;
        @GuardedBy(value="lock")
        private volatile SettableApiFuture<Void> finishedAsyncOperations = SettableApiFuture.create();
        @GuardedBy(value="lock")
        private volatile int runningAsyncOperations;
        private final Queue<Mutation> mutations = new ConcurrentLinkedQueue<Mutation>();
        @GuardedBy(value="lock")
        private boolean aborted;
        private final Options options;
        @GuardedBy(value="lock")
        private long retryDelayInMillis = -1L;
        @VisibleForTesting
        volatile SettableApiFuture<ByteString> transactionIdFuture = null;
        @VisibleForTesting
        long waitForTransactionTimeoutMillis = 60000L;
        private final boolean trackTransactionStarter;
        private Exception transactionStarter;
        volatile ByteString transactionId;
        private CommitResponse commitResponse;
        private final Clock clock;
        private final Map<SpannerRpc.Option, ?> channelHint;
        volatile ApiFuture<CommitResponse> commitFuture;

        static Builder newBuilder() {
            return new Builder();
        }

        private TransactionContextImpl(Builder builder) {
            super(builder);
            this.transactionId = builder.transactionId;
            this.trackTransactionStarter = builder.trackTransactionStarter;
            this.options = builder.options;
            this.finishedAsyncOperations.set(null);
            this.clock = builder.clock;
            this.channelHint = this.getChannelHintOptions(this.session.getOptions(), ThreadLocalRandom.current().nextLong(Long.MAX_VALUE));
        }

        @Override
        protected boolean isReadOnly() {
            return false;
        }

        @Override
        protected boolean isRouteToLeader() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void increaseAsyncOperations() {
            Object object = this.lock;
            synchronized (object) {
                if (this.runningAsyncOperations == 0) {
                    this.finishedAsyncOperations = SettableApiFuture.create();
                }
                ++this.runningAsyncOperations;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decreaseAsyncOperations() {
            Object object = this.lock;
            synchronized (object) {
                --this.runningAsyncOperations;
                if (this.runningAsyncOperations == 0) {
                    this.finishedAsyncOperations.set(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.isClosed = true;
            }
        }

        void ensureTxn() {
            try {
                this.ensureTxnAsync().get();
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause());
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        }

        ApiFuture<Void> ensureTxnAsync() {
            SettableApiFuture res = SettableApiFuture.create();
            if (this.transactionId == null || this.isAborted()) {
                this.createTxnAsync((SettableApiFuture<Void>)res);
            } else {
                this.span.addAnnotation("Transaction Initialized", "Id", this.transactionId.toStringUtf8());
                txnLogger.log(Level.FINER, "Using prepared transaction {0}", txnLogger.isLoggable(Level.FINER) ? this.transactionId.asReadOnlyByteBuffer() : null);
                res.set(null);
            }
            return res;
        }

        private void createTxnAsync(SettableApiFuture<Void> res) {
            this.span.addAnnotation("Creating Transaction");
            ApiFuture<ByteString> fut = this.session.beginTransactionAsync(this.options, this.isRouteToLeader());
            fut.addListener(() -> {
                try {
                    this.transactionId = (ByteString)fut.get();
                    this.span.addAnnotation("Transaction Creation Done", "Id", this.transactionId.toStringUtf8());
                    txnLogger.log(Level.FINER, "Started transaction {0}", txnLogger.isLoggable(Level.FINER) ? this.transactionId.asReadOnlyByteBuffer() : null);
                    res.set(null);
                }
                catch (ExecutionException e) {
                    this.span.addAnnotation("Transaction Creation Failed", e.getCause() == null ? e : e.getCause());
                    res.setException(e.getCause() == null ? e : e.getCause());
                }
                catch (InterruptedException e) {
                    res.setException((Throwable)((Object)SpannerExceptionFactory.propagateInterrupt(e)));
                }
            }, MoreExecutors.directExecutor());
        }

        void commit() {
            try {
                this.commitResponse = (CommitResponse)this.commitAsync().get();
            }
            catch (InterruptedException e) {
                if (this.commitFuture != null) {
                    this.commitFuture.cancel(true);
                }
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ApiFuture<CommitResponse> commitAsync() {
            SettableApiFuture finishOps;
            this.close();
            ArrayList<com.google.spanner.v1.Mutation> mutationsProto = new ArrayList<com.google.spanner.v1.Mutation>();
            Object object = this.committingLock;
            synchronized (object) {
                if (this.committing) {
                    throw new IllegalStateException(TransactionRunnerImpl.TRANSACTION_ALREADY_COMMITTED_MESSAGE);
                }
                this.committing = true;
                if (!this.mutations.isEmpty()) {
                    Mutation.toProto(this.mutations, mutationsProto);
                }
            }
            SettableApiFuture res = SettableApiFuture.create();
            CommitRequest.Builder builder = CommitRequest.newBuilder().setSession(this.session.getName()).setReturnCommitStats(this.options.withCommitStats());
            if (this.options.hasPriority() || this.getTransactionTag() != null) {
                RequestOptions.Builder requestOptionsBuilder = RequestOptions.newBuilder();
                if (this.options.hasPriority()) {
                    requestOptionsBuilder.setPriority(this.options.priority());
                }
                if (this.getTransactionTag() != null) {
                    requestOptionsBuilder.setTransactionTag(this.getTransactionTag());
                }
                builder.setRequestOptions(requestOptionsBuilder.build());
            }
            if (this.options.hasMaxCommitDelay()) {
                builder.setMaxCommitDelay(Duration.newBuilder().setSeconds(this.options.maxCommitDelay().getSeconds()).setNanos(this.options.maxCommitDelay().getNano()).build());
            }
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.transactionIdFuture == null && this.transactionId == null && this.runningAsyncOperations == 0) {
                    finishOps = SettableApiFuture.create();
                    this.createTxnAsync((SettableApiFuture<Void>)finishOps);
                } else {
                    finishOps = this.finishedAsyncOperations;
                }
            }
            builder.addAllMutations(mutationsProto);
            finishOps.addListener((Runnable)new CommitRunnable((SettableApiFuture<CommitResponse>)res, (ApiFuture<Void>)finishOps, builder), MoreExecutors.directExecutor());
            return res;
        }

        CommitResponse getCommitResponse() {
            Preconditions.checkState((this.commitResponse != null ? 1 : 0) != 0, (Object)"run() has not yet returned normally");
            return this.commitResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAborted() {
            Object object = this.lock;
            synchronized (object) {
                return this.aborted;
            }
        }

        void rollback() {
            try {
                this.rollbackAsync().get();
            }
            catch (ExecutionException e) {
                txnLogger.log(Level.FINE, "Exception during rollback", e);
                this.span.addAnnotation("Rollback Failed", e);
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        }

        ApiFuture<Empty> rollbackAsync() {
            this.close();
            if (this.transactionId != null) {
                this.span.addAnnotation("Starting Rollback");
                ApiFuture<Empty> apiFuture = this.rpc.rollbackAsync(RollbackRequest.newBuilder().setSession(this.session.getName()).setTransactionId(this.transactionId).build(), this.session.getOptions());
                this.session.markUsed(this.clock.instant());
                return apiFuture;
            }
            return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            if (this.transactionId == null) {
                try {
                    SettableApiFuture<ByteString> tx = null;
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.transactionIdFuture == null) {
                            this.transactionIdFuture = SettableApiFuture.create();
                            if (this.trackTransactionStarter) {
                                this.transactionStarter = new Exception("Requesting new transaction");
                            }
                        } else {
                            tx = this.transactionIdFuture;
                        }
                    }
                    if (tx == null) {
                        return TransactionSelector.newBuilder().setBegin(SessionImpl.createReadWriteTransactionOptions(this.options)).build();
                    }
                    return TransactionSelector.newBuilder().setId((ByteString)tx.get(this.waitForTransactionTimeoutMillis, TimeUnit.MILLISECONDS)).build();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof AbortedException) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.aborted = true;
                        }
                    }
                    throw SpannerExceptionFactory.newSpannerException(e.getCause());
                }
                catch (TimeoutException e) {
                    SpannerException se = SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "Timeout while waiting for a transaction to be returned by another statement." + (this.trackTransactionStarter ? " See the suppressed exception for the stacktrace of the caller that should return a transaction" : ""), e);
                    if (this.transactionStarter != null) {
                        se.addSuppressed(this.transactionStarter);
                    }
                    throw se;
                }
                catch (InterruptedException e) {
                    throw SpannerExceptionFactory.newSpannerExceptionForCancellation(null, e);
                }
            }
            return TransactionSelector.newBuilder().setId(this.transactionId).build();
        }

        @Override
        Map<SpannerRpc.Option, ?> getTransactionChannelHint() {
            return this.channelHint;
        }

        @Override
        public void onTransactionMetadata(Transaction transaction, boolean shouldIncludeId) {
            Preconditions.checkNotNull((Object)transaction);
            if (transaction.getId() != ByteString.EMPTY) {
                if (!(this.transactionIdFuture != null && this.transactionIdFuture.isDone() || this.transactionId != null)) {
                    this.transactionId = transaction.getId();
                    this.transactionIdFuture.set((Object)transaction.getId());
                }
            } else if (shouldIncludeId) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "The statement did not return a transaction even though one was requested");
            }
        }

        @Override
        @Nullable
        String getTransactionTag() {
            if (this.options.hasTag()) {
                return this.options.tag();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SpannerException onError(SpannerException e, boolean withBeginTransaction) {
            SpannerException exceptionToThrow;
            e = super.onError(e, withBeginTransaction);
            if (withBeginTransaction) {
                this.transactionIdFuture.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "Aborted due to failed initial statement", (Throwable)SpannerExceptionFactory.createAbortedExceptionWithRetryDelay("Aborted due to failed initial statement", (Throwable)((Object)e), 0L, 1))));
            }
            if ((exceptionToThrow = withBeginTransaction && e.getErrorCode() == ErrorCode.CANCELLED && e.getMessage().contains(TransactionRunnerImpl.TRANSACTION_CANCELLED_MESSAGE) ? SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, e.getMessage(), (Throwable)SpannerExceptionFactory.createAbortedExceptionWithRetryDelay("Aborted due to failed initial statement", (Throwable)((Object)e), 0L, 1)) : e).getErrorCode() == ErrorCode.ABORTED) {
                long delay = -1L;
                if (exceptionToThrow instanceof AbortedException) {
                    delay = exceptionToThrow.getRetryDelayInMillis();
                }
                if (delay == -1L) {
                    txnLogger.log(Level.FINE, "Retry duration is missing from the exception.", (Throwable)((Object)exceptionToThrow));
                }
                Object object = this.lock;
                synchronized (object) {
                    this.retryDelayInMillis = delay;
                    this.aborted = true;
                }
            }
            return exceptionToThrow;
        }

        @Override
        public void onDone(boolean withBeginTransaction) {
            if (withBeginTransaction && this.transactionIdFuture != null && !this.transactionIdFuture.isDone()) {
                this.transactionIdFuture.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "ResultSet was closed before a transaction id was returned")));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buffer(Mutation mutation) {
            Object object = this.committingLock;
            synchronized (object) {
                if (this.committing) {
                    throw new IllegalStateException(TransactionRunnerImpl.TRANSACTION_ALREADY_COMMITTED_MESSAGE);
                }
                this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
            }
        }

        @Override
        public ApiFuture<Void> bufferAsync(Mutation mutation) {
            this.buffer(mutation);
            return ApiFutures.immediateFuture(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buffer(Iterable<Mutation> mutations) {
            Object object = this.committingLock;
            synchronized (object) {
                if (this.committing) {
                    throw new IllegalStateException(TransactionRunnerImpl.TRANSACTION_ALREADY_COMMITTED_MESSAGE);
                }
                for (Mutation mutation : mutations) {
                    this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
                }
            }
        }

        @Override
        public ApiFuture<Void> bufferAsync(Iterable<Mutation> mutations) {
            this.buffer(mutations);
            return ApiFutures.immediateFuture(null);
        }

        @Override
        public ResultSetStats analyzeUpdate(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.UpdateOption ... options) {
            return this.internalAnalyzeStatement(statement, analyzeMode, options).getStats();
        }

        @Override
        public ResultSet analyzeUpdateStatement(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.UpdateOption ... options) {
            return new NoRowsResultSet(this.internalAnalyzeStatement(statement, analyzeMode, options));
        }

        private com.google.spanner.v1.ResultSet internalAnalyzeStatement(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.UpdateOption ... updateOptions) {
            ExecuteSqlRequest.QueryMode queryMode;
            Preconditions.checkNotNull((Object)((Object)analyzeMode));
            switch (analyzeMode) {
                case PLAN: {
                    queryMode = ExecuteSqlRequest.QueryMode.PLAN;
                    break;
                }
                case PROFILE: {
                    queryMode = ExecuteSqlRequest.QueryMode.PROFILE;
                    break;
                }
                default: {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown analyze mode: " + (Object)((Object)analyzeMode));
                }
            }
            Options options = Options.fromUpdateOptions(updateOptions);
            return this.internalExecuteUpdate(statement, queryMode, options);
        }

        @Override
        public long executeUpdate(Statement statement, Options.UpdateOption ... updateOptions) {
            Options options = Options.fromUpdateOptions(updateOptions);
            ISpan span = this.tracer.spanBuilderWithExplicitParent("CloudSpannerOperation.ExecuteUpdate", this.span, this.tracer.createStatementAttributes(statement, options));
            try {
                IScope ignore = this.tracer.withSpan(span);
                try {
                    com.google.spanner.v1.ResultSet resultSet = this.internalExecuteUpdate(statement, ExecuteSqlRequest.QueryMode.NORMAL, options);
                    long l = resultSet.getStats().getRowCountExact();
                    if (ignore != null) {
                        ignore.close();
                    }
                    return l;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                span.end();
            }
        }

        private com.google.spanner.v1.ResultSet internalExecuteUpdate(Statement statement, ExecuteSqlRequest.QueryMode queryMode, Options options) {
            this.beforeReadOrQuery();
            if (options.withExcludeTxnFromChangeStreams() != null) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, TransactionRunnerImpl.DML_INVALID_EXCLUDE_CHANGE_STREAMS_OPTION_MESSAGE);
            }
            ExecuteSqlRequest.Builder builder = this.getExecuteSqlRequestBuilder(statement, queryMode, options, true);
            try {
                com.google.spanner.v1.ResultSet resultSet = this.rpc.executeQuery(builder.build(), this.session.getOptions(), this.isRouteToLeader());
                this.session.markUsed(this.clock.instant());
                if (resultSet.getMetadata().hasTransaction()) {
                    this.onTransactionMetadata(resultSet.getMetadata().getTransaction(), builder.getTransaction().hasBegin());
                }
                if (!resultSet.hasStats()) {
                    throw new IllegalArgumentException("DML response missing stats possibly due to non-DML statement as input");
                }
                return resultSet;
            }
            catch (Throwable t) {
                throw this.onError(SpannerExceptionFactory.asSpannerException(t), builder.getTransaction().hasBegin());
            }
        }

        @Override
        public ApiFuture<Long> executeUpdateAsync(Statement statement, Options.UpdateOption ... updateOptions) {
            Options options = Options.fromUpdateOptions(updateOptions);
            ISpan span = this.tracer.spanBuilderWithExplicitParent("CloudSpannerOperation.ExecuteUpdate", this.span, this.tracer.createStatementAttributes(statement, options));
            try (IScope ignore = this.tracer.withSpan(span);){
                ApiFuture<com.google.spanner.v1.ResultSet> resultSet;
                this.beforeReadOrQuery();
                if (options.withExcludeTxnFromChangeStreams() != null) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, TransactionRunnerImpl.DML_INVALID_EXCLUDE_CHANGE_STREAMS_OPTION_MESSAGE);
                }
                ExecuteSqlRequest.Builder builder = this.getExecuteSqlRequestBuilder(statement, ExecuteSqlRequest.QueryMode.NORMAL, options, true);
                try {
                    this.increaseAsyncOperations();
                    resultSet = this.rpc.executeQueryAsync(builder.build(), this.session.getOptions(), this.isRouteToLeader());
                    this.session.markUsed(this.clock.instant());
                }
                catch (Throwable t) {
                    this.decreaseAsyncOperations();
                    throw t;
                }
                ApiFuture updateCount = ApiFutures.transform(resultSet, input -> {
                    if (!input.hasStats()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "DML response missing stats possibly due to non-DML statement as input");
                    }
                    if (builder.getTransaction().hasBegin() && (!input.getMetadata().hasTransaction() || input.getMetadata().getTransaction().getId() == ByteString.EMPTY)) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "The statement did not return a transaction even though one was requested");
                    }
                    return input.getStats().getRowCountExact();
                }, (Executor)MoreExecutors.directExecutor());
                updateCount = ApiFutures.catching((ApiFuture)updateCount, Throwable.class, input -> {
                    SpannerException e = SpannerExceptionFactory.asSpannerException(input);
                    SpannerException exceptionToThrow = this.onError(e, builder.getTransaction().hasBegin());
                    span.setStatus((Throwable)((Object)exceptionToThrow));
                    throw exceptionToThrow;
                }, (Executor)MoreExecutors.directExecutor());
                updateCount.addListener(() -> {
                    try {
                        if (((com.google.spanner.v1.ResultSet)resultSet.get()).getMetadata().hasTransaction()) {
                            this.onTransactionMetadata(((com.google.spanner.v1.ResultSet)resultSet.get()).getMetadata().getTransaction(), builder.getTransaction().hasBegin());
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    span.end();
                    this.decreaseAsyncOperations();
                }, MoreExecutors.directExecutor());
                ApiFuture apiFuture = updateCount;
                return apiFuture;
            }
        }

        private SpannerException createAbortedExceptionForBatchDml(ExecuteBatchDmlResponse response) {
            return SpannerExceptionFactory.newSpannerException(ErrorCode.fromRpcStatus(response.getStatus()), response.getStatus().getMessage(), (Throwable)SpannerExceptionFactory.createAbortedExceptionWithRetryDelay(response.getStatus().getMessage(), null, 0L, (int)TimeUnit.MILLISECONDS.toNanos(10L)));
        }

        /*
         * Exception decompiling
         */
        @Override
        public long[] batchUpdate(Iterable<Statement> statements, Options.UpdateOption ... updateOptions) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public ApiFuture<long[]> batchUpdateAsync(Iterable<Statement> statements, Options.UpdateOption ... updateOptions) {
            Options options = Options.fromUpdateOptions(updateOptions);
            ISpan span = this.tracer.spanBuilderWithExplicitParent("CloudSpannerOperation.BatchUpdate", this.span, this.tracer.createStatementBatchAttributes(statements, options));
            try (IScope ignore = this.tracer.withSpan(span);){
                ApiFuture<ExecuteBatchDmlResponse> response;
                this.beforeReadOrQuery();
                if (options.withExcludeTxnFromChangeStreams() != null) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, TransactionRunnerImpl.DML_INVALID_EXCLUDE_CHANGE_STREAMS_OPTION_MESSAGE);
                }
                ExecuteBatchDmlRequest.Builder builder = this.getExecuteBatchDmlRequestBuilder(statements, options);
                try {
                    this.increaseAsyncOperations();
                    response = this.rpc.executeBatchDmlAsync(builder.build(), this.session.getOptions());
                    this.session.markUsed(this.clock.instant());
                }
                catch (Throwable t) {
                    this.decreaseAsyncOperations();
                    throw t;
                }
                ApiFuture updateCounts = ApiFutures.transform(response, batchDmlResponse -> {
                    long[] results = new long[batchDmlResponse.getResultSetsCount()];
                    for (int i = 0; i < batchDmlResponse.getResultSetsCount(); ++i) {
                        results[i] = batchDmlResponse.getResultSets(i).getStats().getRowCountExact();
                        if (!batchDmlResponse.getResultSets(i).getMetadata().hasTransaction()) continue;
                        this.onTransactionMetadata(batchDmlResponse.getResultSets(i).getMetadata().getTransaction(), builder.getTransaction().hasBegin());
                    }
                    if (batchDmlResponse.getStatus().getCode() == 10) {
                        throw this.createAbortedExceptionForBatchDml((ExecuteBatchDmlResponse)batchDmlResponse);
                    }
                    if (batchDmlResponse.getStatus().getCode() != 0) {
                        throw SpannerExceptionFactory.newSpannerBatchUpdateException(ErrorCode.fromRpcStatus(batchDmlResponse.getStatus()), batchDmlResponse.getStatus().getMessage(), results);
                    }
                    return results;
                }, (Executor)MoreExecutors.directExecutor());
                updateCounts = ApiFutures.catching((ApiFuture)updateCounts, Throwable.class, input -> {
                    SpannerException e = SpannerExceptionFactory.asSpannerException(input);
                    SpannerException exceptionToThrow = this.onError(e, builder.getTransaction().hasBegin());
                    span.setStatus((Throwable)((Object)exceptionToThrow));
                    throw exceptionToThrow;
                }, (Executor)MoreExecutors.directExecutor());
                updateCounts.addListener(() -> {
                    span.end();
                    this.decreaseAsyncOperations();
                }, MoreExecutors.directExecutor());
                ApiFuture apiFuture = updateCounts;
                return apiFuture;
            }
        }

        private AbstractReadContext.ListenableAsyncResultSet wrap(AbstractReadContext.ListenableAsyncResultSet delegate) {
            return new TransactionContextAsyncResultSetImpl(delegate);
        }

        @Override
        public AbstractReadContext.ListenableAsyncResultSet readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.wrap((AbstractReadContext.ListenableAsyncResultSet)super.readAsync(table, keys, (Iterable)columns, options));
        }

        @Override
        public AbstractReadContext.ListenableAsyncResultSet readUsingIndexAsync(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.wrap((AbstractReadContext.ListenableAsyncResultSet)super.readUsingIndexAsync(table, index, keys, (Iterable)columns, options));
        }

        @Override
        public AbstractReadContext.ListenableAsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... options) {
            return this.wrap(super.executeQueryAsync(statement, options));
        }

        static class Builder
        extends AbstractReadContext.Builder<Builder, TransactionContextImpl> {
            private Clock clock = new Clock();
            private ByteString transactionId;
            private Options options;
            private boolean trackTransactionStarter;

            private Builder() {
            }

            @Override
            Builder setClock(Clock clock) {
                this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
                return (Builder)this.self();
            }

            Builder setTransactionId(ByteString transactionId) {
                this.transactionId = transactionId;
                return (Builder)this.self();
            }

            Builder setOptions(Options options) {
                this.options = (Options)Preconditions.checkNotNull((Object)options);
                return (Builder)this.self();
            }

            Builder setTrackTransactionStarter(boolean trackTransactionStarter) {
                this.trackTransactionStarter = trackTransactionStarter;
                return (Builder)this.self();
            }

            @Override
            TransactionContextImpl build() {
                Preconditions.checkState((this.options != null ? 1 : 0) != 0, (Object)"Options must be set");
                return new TransactionContextImpl(this);
            }
        }

        private final class CommitRunnable
        implements Runnable {
            private final SettableApiFuture<CommitResponse> res;
            private final ApiFuture<Void> prev;
            private final CommitRequest.Builder requestBuilder;

            CommitRunnable(SettableApiFuture<CommitResponse> res, ApiFuture<Void> prev, CommitRequest.Builder requestBuilder) {
                this.res = res;
                this.prev = prev;
                this.requestBuilder = requestBuilder;
            }

            @Override
            public void run() {
                try {
                    this.prev.get();
                    if (TransactionContextImpl.this.transactionId == null && TransactionContextImpl.this.transactionIdFuture == null) {
                        this.requestBuilder.setSingleUseTransaction(TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance()).setExcludeTxnFromChangeStreams(TransactionContextImpl.this.options.withExcludeTxnFromChangeStreams() == Boolean.TRUE));
                    } else {
                        this.requestBuilder.setTransactionId(TransactionContextImpl.this.transactionId == null ? (ByteString)TransactionContextImpl.this.transactionIdFuture.get(TransactionContextImpl.this.waitForTransactionTimeoutMillis, TimeUnit.MILLISECONDS) : TransactionContextImpl.this.transactionId);
                    }
                    if (TransactionContextImpl.this.options.hasPriority() || TransactionContextImpl.this.getTransactionTag() != null) {
                        RequestOptions.Builder requestOptionsBuilder = RequestOptions.newBuilder();
                        if (TransactionContextImpl.this.options.hasPriority()) {
                            requestOptionsBuilder.setPriority(TransactionContextImpl.this.options.priority());
                        }
                        if (TransactionContextImpl.this.getTransactionTag() != null) {
                            requestOptionsBuilder.setTransactionTag(TransactionContextImpl.this.getTransactionTag());
                        }
                        this.requestBuilder.setRequestOptions(requestOptionsBuilder.build());
                    }
                    CommitRequest commitRequest = this.requestBuilder.build();
                    TransactionContextImpl.this.span.addAnnotation("Starting Commit");
                    ISpan opSpan = TransactionContextImpl.this.tracer.spanBuilderWithExplicitParent("CloudSpannerOperation.Commit", TransactionContextImpl.this.span);
                    ApiFuture<com.google.spanner.v1.CommitResponse> commitFuture = TransactionContextImpl.this.rpc.commitAsync(commitRequest, TransactionContextImpl.this.session.getOptions());
                    TransactionContextImpl.this.session.markUsed(TransactionContextImpl.this.clock.instant());
                    commitFuture.addListener(() -> {
                        try (IScope s = TransactionContextImpl.this.tracer.withSpan(opSpan);){
                            com.google.spanner.v1.CommitResponse proto = (com.google.spanner.v1.CommitResponse)commitFuture.get();
                            if (!proto.hasCommitTimestamp()) {
                                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing commitTimestamp:\n" + TransactionContextImpl.this.session.getName());
                            }
                            TransactionContextImpl.this.span.addAnnotation("Commit Done");
                            opSpan.end();
                            this.res.set((Object)new CommitResponse(proto));
                        }
                        catch (Throwable e2) {
                            SpannerException e2 = e2 instanceof ExecutionException ? SpannerExceptionFactory.newSpannerException(e2.getCause() == null ? e2 : e2.getCause()) : (e2 instanceof InterruptedException ? SpannerExceptionFactory.propagateInterrupt((InterruptedException)e2) : SpannerExceptionFactory.newSpannerException(e2));
                            TransactionContextImpl.this.span.addAnnotation("Commit Failed", (Throwable)((Object)e2));
                            opSpan.setStatus((Throwable)((Object)e2));
                            opSpan.end();
                            this.res.setException((Throwable)((Object)TransactionContextImpl.this.onError(e2, false)));
                        }
                    }, MoreExecutors.directExecutor());
                }
                catch (InterruptedException e) {
                    this.res.setException((Throwable)((Object)SpannerExceptionFactory.propagateInterrupt(e)));
                }
                catch (TimeoutException e) {
                    this.res.setException((Throwable)((Object)SpannerExceptionFactory.propagateTimeout(e)));
                }
                catch (ExecutionException e) {
                    this.res.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause())));
                }
                catch (Throwable e) {
                    this.res.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause())));
                }
            }
        }

        private class TransactionContextAsyncResultSetImpl
        extends ForwardingAsyncResultSet
        implements AbstractReadContext.ListenableAsyncResultSet {
            private TransactionContextAsyncResultSetImpl(AbstractReadContext.ListenableAsyncResultSet delegate) {
                super(delegate);
            }

            @Override
            public ApiFuture<Void> setCallback(Executor exec, AsyncResultSet.ReadyCallback cb) {
                Runnable listener = () -> TransactionContextImpl.this.decreaseAsyncOperations();
                try {
                    TransactionContextImpl.this.increaseAsyncOperations();
                    this.addListener(listener);
                    return super.setCallback(exec, cb);
                }
                catch (Throwable t) {
                    this.removeListener(listener);
                    TransactionContextImpl.this.decreaseAsyncOperations();
                    throw t;
                }
            }

            @Override
            public void addListener(Runnable listener) {
                ((AbstractReadContext.ListenableAsyncResultSet)this.getDelegate()).addListener(listener);
            }

            @Override
            public void removeListener(Runnable listener) {
                ((AbstractReadContext.ListenableAsyncResultSet)this.getDelegate()).removeListener(listener);
            }
        }
    }
}

