/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverter;
import com.google.cloud.spanner.connection.DirectedReadOptionsUtil;
import com.google.cloud.spanner.connection.PgTransactionMode;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.RequestOptions;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ClientSideStatementValueConverters {
    ClientSideStatementValueConverters() {
    }

    static class ProtoDescriptorsFileConverter
    implements ClientSideStatementValueConverter<String> {
        public ProtoDescriptorsFileConverter(String allowedValues) {
        }

        @Override
        public Class<String> getParameterClass() {
            return String.class;
        }

        @Override
        public String convert(String filePath) {
            if (Strings.isNullOrEmpty((String)filePath)) {
                return null;
            }
            return filePath;
        }
    }

    static class ProtoDescriptorsConverter
    implements ClientSideStatementValueConverter<byte[]> {
        public ProtoDescriptorsConverter(String allowedValues) {
        }

        @Override
        public Class<byte[]> getParameterClass() {
            return byte[].class;
        }

        @Override
        public byte[] convert(String value) {
            if (value == null || value.length() == 0 || value.equalsIgnoreCase("null")) {
                return null;
            }
            try {
                return Base64.getDecoder().decode(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    static class ExplainCommandConverter
    implements ClientSideStatementValueConverter<String> {
        ExplainCommandConverter() {
        }

        @Override
        public Class<String> getParameterClass() {
            return String.class;
        }

        @Override
        public String convert(String value) {
            if (value.length() <= 7) {
                return null;
            }
            return value.substring(7).trim();
        }
    }

    static class SavepointSupportConverter
    implements ClientSideStatementValueConverter<SavepointSupport> {
        private final CaseInsensitiveEnumMap<SavepointSupport> values = new CaseInsensitiveEnumMap(SavepointSupport.class);

        public SavepointSupportConverter(String allowedValues) {
        }

        @Override
        public Class<SavepointSupport> getParameterClass() {
            return SavepointSupport.class;
        }

        @Override
        public SavepointSupport convert(String value) {
            return (SavepointSupport)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class RpcPriorityConverter
    implements ClientSideStatementValueConverter<RequestOptions.Priority> {
        private final CaseInsensitiveEnumMap<RequestOptions.Priority> values = new CaseInsensitiveEnumMap(RequestOptions.Priority.class);
        private final Pattern allowedValues;

        public RpcPriorityConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<RequestOptions.Priority> getParameterClass() {
            return RequestOptions.Priority.class;
        }

        @Override
        public RequestOptions.Priority convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find() && matcher.group(0).equalsIgnoreCase("null")) {
                return RequestOptions.Priority.PRIORITY_UNSPECIFIED;
            }
            return (RequestOptions.Priority)((CaseInsensitiveEnumMap)this.values).get("PRIORITY_" + value);
        }
    }

    static class PgTransactionModeConverter
    implements ClientSideStatementValueConverter<PgTransactionMode> {
        PgTransactionModeConverter() {
        }

        public PgTransactionModeConverter(String allowedValues) {
        }

        @Override
        public Class<PgTransactionMode> getParameterClass() {
            return PgTransactionMode.class;
        }

        @Override
        public PgTransactionMode convert(String value) {
            PgTransactionMode mode = new PgTransactionMode();
            String valueWithoutDeferrable = value.replaceAll("(?i)(not\\s+deferrable)", " ");
            String valueWithSingleSpaces = valueWithoutDeferrable.replaceAll("\\s+", " ").toLowerCase(Locale.ENGLISH).trim();
            int currentIndex = 0;
            while (currentIndex < valueWithSingleSpaces.length()) {
                if (valueWithSingleSpaces.substring(currentIndex).startsWith("read only")) {
                    currentIndex += "read only".length();
                    mode.setAccessMode(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION);
                } else if (valueWithSingleSpaces.substring(currentIndex).startsWith("read write")) {
                    currentIndex += "read write".length();
                    mode.setAccessMode(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION);
                } else if (valueWithSingleSpaces.substring(currentIndex).startsWith("isolation level serializable")) {
                    currentIndex += "isolation level serializable".length();
                    mode.setIsolationLevel(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE);
                } else if (valueWithSingleSpaces.substring(currentIndex).startsWith("isolation level default")) {
                    currentIndex += "isolation level default".length();
                    mode.setIsolationLevel(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT);
                } else {
                    return null;
                }
                if (currentIndex < valueWithSingleSpaces.length() && valueWithSingleSpaces.charAt(currentIndex) == ' ') {
                    ++currentIndex;
                }
                if (currentIndex < valueWithSingleSpaces.length() && valueWithSingleSpaces.charAt(currentIndex) == ',') {
                    ++currentIndex;
                }
                if (currentIndex >= valueWithSingleSpaces.length() || valueWithSingleSpaces.charAt(currentIndex) != ' ') continue;
                ++currentIndex;
            }
            return mode;
        }
    }

    static class PgTransactionIsolationConverter
    implements ClientSideStatementValueConverter<PgTransactionMode.IsolationLevel> {
        private final CaseInsensitiveEnumMap<PgTransactionMode.IsolationLevel> values = new CaseInsensitiveEnumMap(PgTransactionMode.IsolationLevel.class, PgTransactionMode.IsolationLevel::getShortStatementString);

        public PgTransactionIsolationConverter(String allowedValues) {
        }

        @Override
        public Class<PgTransactionMode.IsolationLevel> getParameterClass() {
            return PgTransactionMode.IsolationLevel.class;
        }

        @Override
        public PgTransactionMode.IsolationLevel convert(String value) {
            String valueWithSingleSpaces = value.replaceAll("\\s+", " ");
            if (valueWithSingleSpaces.length() > 1 && (valueWithSingleSpaces.startsWith("'") && valueWithSingleSpaces.endsWith("'") || valueWithSingleSpaces.startsWith("\"") && valueWithSingleSpaces.endsWith("\""))) {
                valueWithSingleSpaces = valueWithSingleSpaces.substring(1, valueWithSingleSpaces.length() - 1);
            }
            return (PgTransactionMode.IsolationLevel)((CaseInsensitiveEnumMap)this.values).get(valueWithSingleSpaces);
        }
    }

    static class TransactionModeConverter
    implements ClientSideStatementValueConverter<TransactionMode> {
        private final CaseInsensitiveEnumMap<TransactionMode> values = new CaseInsensitiveEnumMap(TransactionMode.class, TransactionMode::getStatementString);

        public TransactionModeConverter(String allowedValues) {
        }

        @Override
        public Class<TransactionMode> getParameterClass() {
            return TransactionMode.class;
        }

        @Override
        public TransactionMode convert(String value) {
            String valueWithSingleSpaces = value.replaceAll("\\s+", " ");
            return (TransactionMode)((CaseInsensitiveEnumMap)this.values).get(valueWithSingleSpaces);
        }
    }

    static class StringValueConverter
    implements ClientSideStatementValueConverter<String> {
        public StringValueConverter(String allowedValues) {
        }

        @Override
        public Class<String> getParameterClass() {
            return String.class;
        }

        @Override
        public String convert(String value) {
            return value;
        }
    }

    static class AutocommitDmlModeConverter
    implements ClientSideStatementValueConverter<AutocommitDmlMode> {
        private final CaseInsensitiveEnumMap<AutocommitDmlMode> values = new CaseInsensitiveEnumMap(AutocommitDmlMode.class);

        public AutocommitDmlModeConverter(String allowedValues) {
        }

        @Override
        public Class<AutocommitDmlMode> getParameterClass() {
            return AutocommitDmlMode.class;
        }

        @Override
        public AutocommitDmlMode convert(String value) {
            return (AutocommitDmlMode)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class DirectedReadOptionsConverter
    implements ClientSideStatementValueConverter<DirectedReadOptions> {
        private final Pattern allowedValues;

        public DirectedReadOptionsConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<DirectedReadOptions> getParameterClass() {
            return DirectedReadOptions.class;
        }

        @Override
        public DirectedReadOptions convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find()) {
                try {
                    return DirectedReadOptionsUtil.parse(value);
                }
                catch (SpannerException spannerException) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Failed to parse '%s' as a valid value for DIRECTED_READ.\nThe value should be a JSON string like this: '%s'.\nYou can generate a valid JSON string from a DirectedReadOptions instance by calling %s.%s", value, "{\"includeReplicas\":{\"replicaSelections\":[{\"location\":\"eu-west1\",\"type\":\"READ_ONLY\"}]}}", DirectedReadOptionsUtil.class.getName(), "toString(DirectedReadOptions directedReadOptions)"), (Throwable)((Object)spannerException));
                }
            }
            return null;
        }
    }

    static class ReadOnlyStalenessConverter
    implements ClientSideStatementValueConverter<TimestampBound> {
        private final Pattern allowedValues;
        private final CaseInsensitiveEnumMap<TimestampBound.Mode> values = new CaseInsensitiveEnumMap(TimestampBound.Mode.class);

        public ReadOnlyStalenessConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<TimestampBound> getParameterClass() {
            return TimestampBound.class;
        }

        @Override
        public TimestampBound convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find() && matcher.groupCount() >= 1) {
                Enum mode = null;
                int groupIndex = 0;
                for (int group = 1; group <= matcher.groupCount(); ++group) {
                    if (matcher.group(group) == null || (mode = (TimestampBound.Mode)((CaseInsensitiveEnumMap)this.values).get(matcher.group(group))) == null) continue;
                    groupIndex = group;
                    break;
                }
                switch (1.$SwitchMap$com$google$cloud$spanner$TimestampBound$Mode[mode.ordinal()]) {
                    case 1: {
                        return TimestampBound.strong();
                    }
                    case 2: {
                        return TimestampBound.ofReadTimestamp(ReadOnlyStalenessUtil.parseRfc3339(matcher.group(groupIndex + 1)));
                    }
                    case 3: {
                        return TimestampBound.ofMinReadTimestamp(ReadOnlyStalenessUtil.parseRfc3339(matcher.group(groupIndex + 1)));
                    }
                    case 4: {
                        try {
                            return TimestampBound.ofExactStaleness(Long.parseLong(matcher.group(groupIndex + 2)), ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(groupIndex + 3)));
                        }
                        catch (IllegalArgumentException e) {
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, e.getMessage());
                        }
                    }
                    case 5: {
                        try {
                            return TimestampBound.ofMaxStaleness(Long.parseLong(matcher.group(groupIndex + 2)), ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(groupIndex + 3)));
                        }
                        catch (IllegalArgumentException e) {
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, e.getMessage());
                        }
                    }
                }
            }
            return null;
        }
    }

    static class PgDurationConverter
    implements ClientSideStatementValueConverter<Duration> {
        private final Pattern allowedValues;

        public PgDurationConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<Duration> getParameterClass() {
            return Duration.class;
        }

        @Override
        public Duration convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find()) {
                if (matcher.group(0).equalsIgnoreCase("default")) {
                    return Durations.fromNanos((long)0L);
                }
                Duration duration = matcher.group(2) == null ? ReadOnlyStalenessUtil.createDuration(Long.parseLong(matcher.group(0)), TimeUnit.MILLISECONDS) : ReadOnlyStalenessUtil.createDuration(Long.parseLong(matcher.group(1)), ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(2)));
                if (duration.getSeconds() == 0L && duration.getNanos() == 0) {
                    return null;
                }
                return duration;
            }
            return null;
        }
    }

    static class DurationConverter
    implements ClientSideStatementValueConverter<Duration> {
        private final Pattern allowedValues;

        public DurationConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<Duration> getParameterClass() {
            return Duration.class;
        }

        @Override
        public Duration convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find()) {
                if (matcher.group(0).equalsIgnoreCase("null")) {
                    return Durations.fromNanos((long)0L);
                }
                Duration duration = ReadOnlyStalenessUtil.createDuration(Long.parseLong(matcher.group(1)), ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(2)));
                if (duration.getSeconds() == 0L && duration.getNanos() == 0) {
                    return null;
                }
                return duration;
            }
            return null;
        }
    }

    static class NonNegativeIntegerConverter
    implements ClientSideStatementValueConverter<Integer> {
        public NonNegativeIntegerConverter(String allowedValues) {
        }

        @Override
        public Class<Integer> getParameterClass() {
            return Integer.class;
        }

        @Override
        public Integer convert(String value) {
            try {
                int res = Integer.parseInt(value);
                if (res < 0) {
                    return null;
                }
                return res;
            }
            catch (Exception ignore) {
                return null;
            }
        }
    }

    static class PgBooleanConverter
    implements ClientSideStatementValueConverter<Boolean> {
        public PgBooleanConverter(String allowedValues) {
        }

        @Override
        public Class<Boolean> getParameterClass() {
            return Boolean.class;
        }

        @Override
        public Boolean convert(String value) {
            if (value == null) {
                return null;
            }
            if (value.length() > 1 && (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\""))) {
                value = value.substring(1, value.length() - 1);
            }
            if ("true".equalsIgnoreCase(value) || "tru".equalsIgnoreCase(value) || "tr".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "ye".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value) || "fals".equalsIgnoreCase(value) || "fal".equalsIgnoreCase(value) || "fa".equalsIgnoreCase(value) || "f".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value) || "of".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "n".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    static class BooleanConverter
    implements ClientSideStatementValueConverter<Boolean> {
        public BooleanConverter(String allowedValues) {
        }

        @Override
        public Class<Boolean> getParameterClass() {
            return Boolean.class;
        }

        @Override
        public Boolean convert(String value) {
            if ("true".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private static final class CaseInsensitiveEnumMap<E extends Enum<E>> {
        private final Map<String, E> map = new HashMap<String, E>();

        private CaseInsensitiveEnumMap(Class<E> elementType) {
            this(elementType, Enum::name);
        }

        private CaseInsensitiveEnumMap(Class<E> elementType, Function<E, String> keyFunction) {
            Preconditions.checkNotNull(elementType);
            Preconditions.checkNotNull(keyFunction);
            EnumSet<Enum> set = EnumSet.allOf(elementType);
            for (Enum e : set) {
                if (this.map.put(((String)keyFunction.apply((Object)e)).toUpperCase(), e) == null) continue;
                throw new IllegalArgumentException("Enum contains multiple elements with the same case-insensitive key");
            }
        }

        private E get(String value) {
            Preconditions.checkNotNull((Object)value);
            return (E)((Enum)this.map.get(value.toUpperCase()));
        }
    }
}

