/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.spanner.v1.CommitResponse;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CommitResponseTest {
    @Test
    public void testConstructWithTimestamp() {
        Timestamp timestamp = Timestamp.ofTimeSecondsAndNanos((long)100L, (int)100);
        CommitResponse response = new CommitResponse(timestamp);
        Assert.assertEquals((Object)timestamp, (Object)response.getCommitTimestamp());
    }

    @Test
    public void testFromProto() {
        long mutationCount = 5L;
        com.google.protobuf.Timestamp timestamp = com.google.protobuf.Timestamp.newBuilder().setSeconds(123L).setNanos(456).build();
        com.google.spanner.v1.CommitResponse proto = com.google.spanner.v1.CommitResponse.newBuilder().setCommitStats(CommitResponse.CommitStats.newBuilder().setMutationCount(mutationCount).build()).setCommitTimestamp(timestamp).build();
        CommitResponse response = new CommitResponse(proto);
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)123L, (int)456), (Object)response.getCommitTimestamp());
        Assert.assertEquals((long)mutationCount, (long)response.getCommitStats().getMutationCount());
    }

    @Test
    public void testEqualsAndHashCode() {
        com.google.spanner.v1.CommitResponse proto1 = com.google.spanner.v1.CommitResponse.newBuilder().setCommitTimestamp(com.google.protobuf.Timestamp.newBuilder().setSeconds(1L).build()).build();
        com.google.spanner.v1.CommitResponse proto2 = com.google.spanner.v1.CommitResponse.newBuilder().setCommitTimestamp(com.google.protobuf.Timestamp.newBuilder().setSeconds(2L).build()).build();
        com.google.spanner.v1.CommitResponse proto3 = com.google.spanner.v1.CommitResponse.newBuilder().setCommitTimestamp(com.google.protobuf.Timestamp.newBuilder().setSeconds(1L).build()).build();
        CommitResponse response1 = new CommitResponse(proto1);
        CommitResponse response2 = new CommitResponse(proto2);
        CommitResponse response3 = new CommitResponse(proto3);
        Assert.assertEquals((Object)response3, (Object)response1);
        Assert.assertNotEquals((Object)response2, (Object)response1);
        Assert.assertNotEquals((Object)response3, (Object)response2);
        Assert.assertNotEquals((Object)response1, null);
        Assert.assertNotEquals((Object)response1, (Object)new Object());
        Assert.assertEquals((long)response3.hashCode(), (long)response1.hashCode());
        Assert.assertNotEquals((long)response2.hashCode(), (long)response1.hashCode());
        Assert.assertNotEquals((long)response3.hashCode(), (long)response2.hashCode());
    }

    @Test
    public void testHasCommitStats() {
        com.google.spanner.v1.CommitResponse protoWithoutCommitStats = com.google.spanner.v1.CommitResponse.getDefaultInstance();
        CommitResponse responseWithoutCommitStats = new CommitResponse(protoWithoutCommitStats);
        Assert.assertFalse((boolean)responseWithoutCommitStats.hasCommitStats());
        com.google.spanner.v1.CommitResponse protoWithCommitStats = com.google.spanner.v1.CommitResponse.newBuilder().setCommitStats(CommitResponse.CommitStats.getDefaultInstance()).build();
        CommitResponse responseWithCommitStats = new CommitResponse(protoWithCommitStats);
        Assert.assertTrue((boolean)responseWithCommitStats.hasCommitStats());
    }
}

