/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.LazySpannerInitializer;
import com.google.cloud.spanner.Spanner;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class LazySpannerInitializerTest {
    @Test
    public void testGet_shouldReturnSameInstance() throws Throwable {
        LazySpannerInitializer initializer = new LazySpannerInitializer(){

            public Spanner initialize() {
                return (Spanner)Mockito.mock(Spanner.class);
            }
        };
        Spanner s1 = (Spanner)initializer.get();
        Spanner s2 = (Spanner)initializer.get();
        Truth.assertThat((Object)s1).isSameInstanceAs((Object)s2);
    }

    @Test
    public void testGet_shouldThrowErrorFromInitializeMethod() {
        LazySpannerInitializer initializer = new LazySpannerInitializer(){

            public Spanner initialize() throws IOException {
                throw new IOException("Could not find credentials file");
            }
        };
        Throwable t1 = Assert.assertThrows(Throwable.class, () -> initializer.get());
        Throwable t2 = Assert.assertThrows(Throwable.class, () -> initializer.get());
        Truth.assertThat((Throwable)t1).isSameInstanceAs((Object)t2);
    }

    @Test
    public void testGet_shouldInvokeInitializeOnlyOnce() throws InterruptedException, ExecutionException {
        int i;
        final AtomicInteger count = new AtomicInteger();
        LazySpannerInitializer initializer = new LazySpannerInitializer(){

            public Spanner initialize() {
                count.incrementAndGet();
                return (Spanner)Mockito.mock(Spanner.class);
            }
        };
        int threads = 16;
        CountDownLatch latch = new CountDownLatch(16);
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(16));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(16);
        for (i = 0; i < 16; ++i) {
            futures.add(executor.submit(() -> {
                latch.countDown();
                latch.await(10L, TimeUnit.SECONDS);
                return (Spanner)initializer.get();
            }));
        }
        Truth.assertThat((Iterable)((Iterable)Futures.allAsList(futures).get())).hasSize(16);
        for (i = 0; i < 15; ++i) {
            Truth.assertThat((Object)((ListenableFuture)futures.get(i)).get()).isSameInstanceAs(((ListenableFuture)futures.get(i + 1)).get());
        }
        Truth.assertThat((Integer)count.get()).isEqualTo((Object)1);
        executor.shutdown();
    }
}

