/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BaseSessionPoolTest;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.FakeClock;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SessionReference;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TraceWrapper;
import io.opencensus.trace.Tracing;
import io.opentelemetry.api.OpenTelemetry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

@RunWith(value=JUnit4.class)
public class MultiplexedSessionMaintainerTest
extends BaseSessionPoolTest {
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    @Mock
    private SpannerImpl client;
    @Mock
    private SessionClient sessionClient;
    @Mock
    private SpannerOptions spannerOptions;
    private DatabaseId db = DatabaseId.of((String)"projects/p/instances/i/databases/unused");
    private SessionPoolOptions options;
    private FakeClock clock = new FakeClock();
    private List<SessionReference> multiplexedSessionsRemoved = new ArrayList<SessionReference>();

    @BeforeClass
    public static void checkUsesMultiplexedSessionPool() {
        Assume.assumeTrue((String)"Only run if the maintainer in the session pool is used", (boolean)false);
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)((SpannerOptions)this.client.getOptions())).thenReturn((Object)this.spannerOptions);
        Mockito.when((Object)this.client.getSessionClient(this.db)).thenReturn((Object)this.sessionClient);
        Mockito.when((Object)this.sessionClient.getSpanner()).thenReturn((Object)this.client);
        Mockito.when((Object)this.spannerOptions.getNumChannels()).thenReturn((Object)4);
        Mockito.when((Object)this.spannerOptions.getDatabaseRole()).thenReturn((Object)"role");
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxIdleSessions(1).setMaxSessions(5).setIncStep(1).setKeepAliveIntervalMinutes(2).setUseMultiplexedSession(true).setPoolMaintainerClock((Clock)this.clock).build();
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)this.options);
        Assume.assumeTrue((boolean)this.options.getUseMultiplexedSession());
        this.multiplexedSessionsRemoved.clear();
    }

    @Test
    public void testMaintainMultiplexedSession_whenNewSessionCreated_assertThatStaleSessionIsRemoved() throws Exception {
        ((SessionClient)Mockito.doAnswer(invocation -> {
            SessionPool.MultiplexedSessionInitializationConsumer consumer = (SessionPool.MultiplexedSessionInitializationConsumer)invocation.getArgument(0, SessionPool.MultiplexedSessionInitializationConsumer.class);
            ReadContext mockContext = (ReadContext)Mockito.mock(ReadContext.class);
            Timestamp timestamp = Timestamp.ofTimeSecondsAndNanos((long)Instant.ofEpochMilli((long)this.clock.currentTimeMillis.get()).getEpochSecond(), (int)0);
            consumer.onSessionReady(this.setupMockSession(this.buildMockMultiplexedSession(this.client, mockContext, timestamp.toProto()), mockContext));
            return null;
        }).when((Object)this.sessionClient)).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionInitializationConsumer.class));
        ((SessionClient)Mockito.doAnswer(invocation -> {
            SessionPool.MultiplexedSessionMaintainerConsumer consumer = (SessionPool.MultiplexedSessionMaintainerConsumer)invocation.getArgument(0, SessionPool.MultiplexedSessionMaintainerConsumer.class);
            ReadContext mockContext = (ReadContext)Mockito.mock(ReadContext.class);
            Timestamp timestamp = Timestamp.ofTimeSecondsAndNanos((long)Instant.ofEpochMilli((long)this.clock.currentTimeMillis.get()).getEpochSecond(), (int)0);
            consumer.onSessionReady(this.setupMockSession(this.buildMockMultiplexedSession(this.client, mockContext, timestamp.toProto()), mockContext));
            return null;
        }).when((Object)this.sessionClient)).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionMaintainerConsumer.class));
        SessionPool pool = this.createPool();
        SessionPool.CachedSession session1 = pool.getMultiplexedSessionWithFallback().get().get();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Assert.assertTrue((boolean)this.multiplexedSessionsRemoved.isEmpty());
        this.clock.currentTimeMillis.addAndGet(Duration.ofDays((long)8L).toMillis());
        this.runMaintenanceLoop(this.clock, pool, 1L);
        SessionPool.CachedSession session2 = pool.getMultiplexedSessionWithFallback().get().get();
        Assert.assertNotEquals((Object)session1.getName(), (Object)session2.getName());
        Assert.assertEquals((long)1L, (long)this.multiplexedSessionsRemoved.size());
        Assert.assertTrue((boolean)this.getNameOfSessionRemoved().contains(session1.getName()));
        this.clock.currentTimeMillis.addAndGet(Duration.ofDays((long)8L).toMillis());
        this.runMaintenanceLoop(this.clock, pool, 1L);
        SessionPool.CachedSession session3 = pool.getMultiplexedSessionWithFallback().get().get();
        Assert.assertNotEquals((Object)session2.getName(), (Object)session3.getName());
        Assert.assertEquals((long)2L, (long)this.multiplexedSessionsRemoved.size());
        Assert.assertTrue((boolean)this.getNameOfSessionRemoved().contains(session2.getName()));
    }

    @Test
    public void testMaintainMultiplexedSession_whenMultiplexedSessionNotStale_assertThatSessionIsNotRemoved() {
        ((SessionClient)Mockito.doAnswer(invocation -> {
            SessionPool.MultiplexedSessionInitializationConsumer consumer = (SessionPool.MultiplexedSessionInitializationConsumer)invocation.getArgument(0, SessionPool.MultiplexedSessionInitializationConsumer.class);
            ReadContext mockContext = (ReadContext)Mockito.mock(ReadContext.class);
            Timestamp timestamp = Timestamp.ofTimeSecondsAndNanos((long)Instant.ofEpochMilli((long)this.clock.currentTimeMillis.get()).getEpochSecond(), (int)0);
            consumer.onSessionReady(this.setupMockSession(this.buildMockMultiplexedSession(this.client, mockContext, timestamp.toProto()), mockContext));
            return null;
        }).when((Object)this.sessionClient)).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionInitializationConsumer.class));
        SessionPool pool = this.createPool();
        SessionPool.SessionFutureWrapper session1 = pool.getMultiplexedSessionWithFallback();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Assert.assertTrue((boolean)this.multiplexedSessionsRemoved.isEmpty());
        this.clock.currentTimeMillis.addAndGet(Duration.ofDays((long)4L).toMillis());
        this.runMaintenanceLoop(this.clock, pool, 1L);
        SessionPool.SessionFutureWrapper session2 = pool.getMultiplexedSessionWithFallback();
        Assert.assertTrue((boolean)this.multiplexedSessionsRemoved.isEmpty());
        Assert.assertEquals((Object)session1.get().getName(), (Object)session2.get().getName());
    }

    @Test
    public void testMaintainMultiplexedSession_whenMultiplexedSessionCreationFailed_testRetryAfterDelay() {
        ((SessionClient)Mockito.doAnswer(invocation -> {
            SessionPool.MultiplexedSessionInitializationConsumer consumer = (SessionPool.MultiplexedSessionInitializationConsumer)invocation.getArgument(0, SessionPool.MultiplexedSessionInitializationConsumer.class);
            ReadContext mockContext = (ReadContext)Mockito.mock(ReadContext.class);
            Timestamp timestamp = Timestamp.ofTimeSecondsAndNanos((long)Instant.ofEpochMilli((long)this.clock.currentTimeMillis.get()).getEpochSecond(), (int)0);
            consumer.onSessionReady(this.setupMockSession(this.buildMockMultiplexedSession(this.client, mockContext, timestamp.toProto()), mockContext));
            return null;
        }).when((Object)this.sessionClient)).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionInitializationConsumer.class));
        ((SessionClient)Mockito.doAnswer(invocation -> {
            SessionPool.MultiplexedSessionMaintainerConsumer consumer = (SessionPool.MultiplexedSessionMaintainerConsumer)invocation.getArgument(0, SessionPool.MultiplexedSessionMaintainerConsumer.class);
            consumer.onSessionCreateFailure((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)""), 1);
            return null;
        }).when((Object)this.sessionClient)).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionMaintainerConsumer.class));
        SessionPool pool = this.createPool();
        this.clock.currentTimeMillis.addAndGet(Duration.ofDays((long)8L).toMillis());
        SessionPool.SessionFutureWrapper session1 = pool.getMultiplexedSessionWithFallback();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Assert.assertTrue((boolean)this.multiplexedSessionsRemoved.isEmpty());
        ((SessionClient)Mockito.verify((Object)this.sessionClient, (VerificationMode)Mockito.times((int)1))).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionMaintainerConsumer.class));
        this.clock.currentTimeMillis.addAndGet(Duration.ofSeconds((long)10L).toMillis());
        ((SessionClient)Mockito.doAnswer(invocation -> {
            SessionPool.MultiplexedSessionMaintainerConsumer consumer = (SessionPool.MultiplexedSessionMaintainerConsumer)invocation.getArgument(0, SessionPool.MultiplexedSessionMaintainerConsumer.class);
            ReadContext mockContext = (ReadContext)Mockito.mock(ReadContext.class);
            Timestamp timestamp = Timestamp.ofTimeSecondsAndNanos((long)Instant.ofEpochMilli((long)this.clock.currentTimeMillis.get()).getEpochSecond(), (int)0);
            consumer.onSessionReady(this.setupMockSession(this.buildMockMultiplexedSession(this.client, mockContext, timestamp.toProto()), mockContext));
            return null;
        }).when((Object)this.sessionClient)).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionMaintainerConsumer.class));
        this.runMaintenanceLoop(this.clock, pool, 1L);
        SessionPool.SessionFutureWrapper session2 = pool.getMultiplexedSessionWithFallback();
        Assert.assertTrue((boolean)this.multiplexedSessionsRemoved.isEmpty());
        Assert.assertEquals((Object)session1.get().getName(), (Object)session2.get().getName());
        ((SessionClient)Mockito.verify((Object)this.sessionClient, (VerificationMode)Mockito.times((int)1))).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionMaintainerConsumer.class));
        this.clock.currentTimeMillis.addAndGet(Duration.ofMinutes((long)15L).toMillis());
        this.runMaintenanceLoop(this.clock, pool, 1L);
        SessionPool.SessionFutureWrapper session3 = pool.getMultiplexedSessionWithFallback();
        Assert.assertTrue((boolean)this.getNameOfSessionRemoved().contains(session1.get().get().getName()));
        Assert.assertNotEquals((Object)session1.get().getName(), (Object)session3.get().getName());
        ((SessionClient)Mockito.verify((Object)this.sessionClient, (VerificationMode)Mockito.times((int)2))).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionPool.MultiplexedSessionMaintainerConsumer.class));
    }

    private SessionImpl setupMockSession(SessionImpl session, ReadContext mockContext) {
        ResultSet mockResult = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockContext.executeQuery((Statement)ArgumentMatchers.any(Statement.class), new Options.QueryOption[0])).thenAnswer(invocation -> mockResult);
        Mockito.when((Object)mockResult.next()).thenReturn((Object)true);
        return session;
    }

    private SessionPool createPool() {
        SessionPool pool = SessionPool.createPool((SessionPoolOptions)this.options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(this), (SessionClient)this.client.getSessionClient(this.db), (Clock)this.clock, (SessionPool.Position)SessionPool.Position.FIRST, (TraceWrapper)new TraceWrapper(Tracing.getTracer(), OpenTelemetry.noop().getTracer(""), false), (OpenTelemetry)OpenTelemetry.noop());
        pool.multiplexedSessionRemovedListener = input -> {
            this.multiplexedSessionsRemoved.add((SessionReference)input);
            return null;
        };
        return pool;
    }

    Set<String> getNameOfSessionRemoved() {
        return this.multiplexedSessionsRemoved.stream().map(session -> session.getName()).collect(Collectors.toSet());
    }
}

