/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.BatchWriteRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MutationGroupTest {
    private final Random random = new Random();

    private Mutation getRandomMutation() {
        return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)String.valueOf(this.random.nextInt())).set("ID").to((long)this.random.nextInt())).set("NAME").to(String.valueOf(this.random.nextInt()))).build();
    }

    private BatchWriteRequest.MutationGroup getMutationGroupProto(ImmutableList<Mutation> mutations) {
        ArrayList mutationsProto = new ArrayList();
        Mutation.toProto(mutations, mutationsProto);
        return BatchWriteRequest.MutationGroup.newBuilder().addAllMutations(mutationsProto).build();
    }

    @Test
    public void ofVarargTest() {
        Object[] mutations = new Mutation[]{this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation()};
        MutationGroup mutationGroup = MutationGroup.of((Mutation[])mutations);
        Assert.assertArrayEquals((Object[])mutations, (Object[])mutationGroup.getMutations().toArray());
        Assert.assertEquals((Object)MutationGroup.toProto((MutationGroup)mutationGroup), (Object)this.getMutationGroupProto((ImmutableList<Mutation>)ImmutableList.copyOf((Object[])mutations)));
    }

    @Test
    public void ofIterableTest() {
        ImmutableList mutations = ImmutableList.of((Object)this.getRandomMutation(), (Object)this.getRandomMutation(), (Object)this.getRandomMutation(), (Object)this.getRandomMutation());
        MutationGroup mutationGroup = MutationGroup.of((Iterable)mutations);
        Assert.assertEquals((Object)mutations, (Object)mutationGroup.getMutations());
        Assert.assertEquals((Object)MutationGroup.toProto((MutationGroup)mutationGroup), (Object)this.getMutationGroupProto((ImmutableList<Mutation>)mutations));
    }

    @Test
    public void toProtoTest() {
        Object[] mutations = new Mutation[]{this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation()};
        MutationGroup mutationGroup = MutationGroup.of((Mutation[])mutations);
        Assert.assertEquals((Object)MutationGroup.toProto((MutationGroup)mutationGroup), (Object)this.getMutationGroupProto((ImmutableList<Mutation>)ImmutableList.copyOf((Object[])mutations)));
    }

    @Test
    public void toListProtoTest() {
        Object[] mutations1 = new Mutation[]{this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation()};
        Object[] mutations2 = new Mutation[]{this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation()};
        Object[] mutations3 = new Mutation[]{this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation(), this.getRandomMutation()};
        ImmutableList mutationGroups = ImmutableList.of((Object)MutationGroup.of((Mutation[])mutations1), (Object)MutationGroup.of((Mutation[])mutations2), (Object)MutationGroup.of((Mutation[])mutations3));
        List mutationGroupsProto = MutationGroup.toListProto((Iterable)mutationGroups);
        Assert.assertEquals(mutationGroupsProto.get(0), (Object)this.getMutationGroupProto((ImmutableList<Mutation>)ImmutableList.copyOf((Object[])mutations1)));
        Assert.assertEquals(mutationGroupsProto.get(1), (Object)this.getMutationGroupProto((ImmutableList<Mutation>)ImmutableList.copyOf((Object[])mutations2)));
        Assert.assertEquals(mutationGroupsProto.get(2), (Object)this.getMutationGroupProto((ImmutableList<Mutation>)ImmutableList.copyOf((Object[])mutations3)));
    }
}

