/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.SpannerGrpc;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.Attributes;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TransactionChannelHintTest {
    private static final Statement SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
    private static final ResultSetMetadata SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static InetSocketAddress address;
    private static final Set<InetSocketAddress> executeSqlLocalIps;
    private static final Set<InetSocketAddress> beginTransactionLocalIps;
    private static final Set<InetSocketAddress> streamingReadLocalIps;
    private static Level originalLogLevel;

    @BeforeClass
    public static void startServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_ONE_KEY_VALUE_STATEMENT, MockSpannerTestUtil.READ_ONE_KEY_VALUE_RESULTSET));
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).intercept(new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                Attributes attributes = call.getAttributes();
                Attributes.Key key = attributes.keys().stream().filter(k -> k.equals(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).findFirst().orElse(null);
                if (key != null) {
                    if (call.getMethodDescriptor().equals(SpannerGrpc.getExecuteStreamingSqlMethod())) {
                        executeSqlLocalIps.add((InetSocketAddress)attributes.get(key));
                    }
                    if (call.getMethodDescriptor().equals(SpannerGrpc.getStreamingReadMethod())) {
                        streamingReadLocalIps.add((InetSocketAddress)attributes.get(key));
                    }
                    if (call.getMethodDescriptor().equals(SpannerGrpc.getBeginTransactionMethod())) {
                        beginTransactionLocalIps.add((InetSocketAddress)attributes.get(key));
                    }
                }
                return Contexts.interceptCall((Context)Context.current(), call, (Metadata)headers, next);
            }
        })).build().start();
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @BeforeClass
    public static void disableLogging() {
        Logger logger = Logger.getLogger("");
        originalLogLevel = logger.getLevel();
        logger.setLevel(Level.OFF);
    }

    @AfterClass
    public static void resetLogging() {
        Logger logger = Logger.getLogger("");
        logger.setLevel(originalLogLevel);
    }

    @After
    public void reset() {
        mockSpanner.reset();
        executeSqlLocalIps.clear();
        streamingReadLocalIps.clear();
        beginTransactionLocalIps.clear();
    }

    private SpannerOptions createSpannerOptions() {
        String endpoint = address.getHostString() + ":" + server.getPort();
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator(input -> {
            input.usePlaintext();
            return input;
        }).setCompressorName("gzip").setHost("http://" + endpoint).setCredentials((Credentials)NoCredentials.getInstance())).build();
    }

    @Test
    public void testSingleUseReadOnlyTransaction_usesSingleChannel() {
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (ResultSet resultSet = client.singleUseReadOnlyTransaction().executeQuery(SELECT1, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
        }
        Assert.assertEquals((long)1L, (long)executeSqlLocalIps.size());
    }

    @Test
    public void testSingleUseReadOnlyTransaction_withTimestampBound_usesSingleChannel() {
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (ResultSet resultSet = client.singleUseReadOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQuery(SELECT1, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
        }
        Assert.assertEquals((long)1L, (long)executeSqlLocalIps.size());
    }

    @Test
    public void testReadOnlyTransaction_usesSingleChannel() {
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (ReadOnlyTransaction transaction = client.readOnlyTransaction();){
                try (ResultSet resultSet = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                    while (resultSet.next()) {
                    }
                }
                resultSet = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);
                try {
                    while (resultSet.next()) {
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        Assert.assertEquals((long)1L, (long)executeSqlLocalIps.size());
        Assert.assertEquals((long)1L, (long)beginTransactionLocalIps.size());
        Assert.assertEquals(executeSqlLocalIps, beginTransactionLocalIps);
    }

    @Test
    public void testReadOnlyTransaction_withTimestampBound_usesSingleChannel() {
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (ReadOnlyTransaction transaction = client.readOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS));){
                try (ResultSet resultSet = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                    while (resultSet.next()) {
                    }
                }
                resultSet = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);
                try {
                    while (resultSet.next()) {
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        Assert.assertEquals((long)1L, (long)executeSqlLocalIps.size());
        Assert.assertEquals((long)1L, (long)beginTransactionLocalIps.size());
        Assert.assertEquals(executeSqlLocalIps, beginTransactionLocalIps);
    }

    @Test
    public void testTransactionManager_usesSingleChannel() {
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        try (ResultSet resultSet = transaction.analyzeQuery(SELECT1, ReadContext.QueryAnalyzeMode.PROFILE);){
                            while (resultSet.next()) {
                            }
                        }
                        resultSet = transaction.analyzeQuery(SELECT1, ReadContext.QueryAnalyzeMode.PROFILE);
                        try {
                            while (resultSet.next()) {
                            }
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
        }
        Assert.assertEquals((long)1L, (long)executeSqlLocalIps.size());
    }

    @Test
    public void testTransactionRunner_usesSingleChannel() {
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> {
                try (ResultSet resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
                    while (resultSet.next()) {
                    }
                }
                resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
                try {
                    while (resultSet.next()) {
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                return null;
            });
        }
        Assert.assertEquals((long)1L, (long)streamingReadLocalIps.size());
    }

    static {
        executeSqlLocalIps = ConcurrentHashMap.newKeySet();
        beginTransactionLocalIps = ConcurrentHashMap.newKeySet();
        streamingReadLocalIps = ConcurrentHashMap.newKeySet();
    }
}

