/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConnectionAsyncApiAbortedTest
extends AbstractMockServerTest {
    private static final ExecutorService singleThreadedExecutor = Executors.newSingleThreadExecutor();
    private static final ExecutorService multiThreadedExecutor = Executors.newFixedThreadPool(8);
    public static final int RANDOM_RESULT_SET_ROW_COUNT_2 = 50;
    public static final Statement SELECT_RANDOM_STATEMENT_2 = Statement.of((String)"SELECT * FROM RANDOM2");
    public static final ResultSet RANDOM_RESULT_SET_2 = new RandomResultSetGenerator(50).generate();

    @BeforeClass
    public static void setupAdditionalResults() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_RANDOM_STATEMENT_2, RANDOM_RESULT_SET_2));
    }

    @AfterClass
    public static void stopExecutor() {
        singleThreadedExecutor.shutdown();
        multiThreadedExecutor.shutdown();
    }

    @Before
    public void setup() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.getDialect();
        }
    }

    @After
    public void reset() {
        mockSpanner.removeAllExecutionTimes();
    }

    ITAbstractSpannerTest.ITConnection createConnection(TransactionRetryListener listener) {
        ITAbstractSpannerTest.ITConnection connection = super.createConnection((List<StatementExecutionInterceptor>)ImmutableList.of(), (List<TransactionRetryListener>)ImmutableList.of((Object)listener));
        connection.setAutocommit(false);
        return connection;
    }

    @Test
    public void testSingleQueryAborted() {
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)0);
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test"))));
            QueryResult res = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT);
            Truth.assertThat((Object)SpannerApiFutures.get(res.finished)).isNull();
            Truth.assertThat((Integer)res.rowCount.get()).isEqualTo((Object)100);
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
        }
    }

    @Test
    public void testTwoQueriesSecondAborted() {
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)0);
            QueryResult res1 = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT);
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test"))));
            QueryResult res2 = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT_2);
            Truth.assertThat((Object)SpannerApiFutures.get(res1.finished)).isNull();
            Truth.assertThat((Integer)res1.rowCount.get()).isEqualTo((Object)100);
            Truth.assertThat((Object)SpannerApiFutures.get(res2.finished)).isNull();
            Truth.assertThat((Integer)res2.rowCount.get()).isEqualTo((Object)50);
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
        }
    }

    @Test
    public void testTwoQueriesBothAborted() throws InterruptedException {
        RetryCounter counter = new RetryCounter(1);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)0);
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test"))));
            QueryResult res1 = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT);
            Truth.assertThat((Boolean)counter.latch.await(10L, TimeUnit.SECONDS)).isTrue();
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test"))));
            QueryResult res2 = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT_2);
            Truth.assertThat((Object)SpannerApiFutures.get(res1.finished)).isNull();
            Truth.assertThat((Integer)res1.rowCount.get()).isEqualTo((Object)100);
            Truth.assertThat((Object)SpannerApiFutures.get(res2.finished)).isNull();
            Truth.assertThat((Integer)res2.rowCount.get()).isEqualTo((Object)50);
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)2);
        }
    }

    @Test
    public void testSingleQueryAbortedMidway() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")), 50L));
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)0);
            QueryResult res = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT);
            Truth.assertThat((Object)SpannerApiFutures.get(res.finished)).isNull();
            Truth.assertThat((Integer)res.rowCount.get()).isEqualTo((Object)100);
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
        }
    }

    @Test
    public void testTwoQueriesSecondAbortedMidway() {
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)0);
            QueryResult res1 = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT);
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")), 25L));
            QueryResult res2 = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT_2);
            Truth.assertThat((Object)SpannerApiFutures.get(res1.finished)).isNull();
            Truth.assertThat((Integer)res1.rowCount.get()).isEqualTo((Object)100);
            Truth.assertThat((Object)SpannerApiFutures.get(res2.finished)).isNull();
            Truth.assertThat((Integer)res2.rowCount.get()).isEqualTo((Object)50);
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
        }
    }

    @Test
    public void testTwoQueriesOneAbortedMidway() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")), Math.min(50, 25)));
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)0);
            QueryResult res1 = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT, multiThreadedExecutor);
            QueryResult res2 = this.executeQueryAsync(connection, SELECT_RANDOM_STATEMENT_2, multiThreadedExecutor);
            Truth.assertThat((Object)SpannerApiFutures.get(res1.finished)).isNull();
            Truth.assertThat((Integer)res1.rowCount.get()).isEqualTo((Object)100);
            Truth.assertThat((Object)SpannerApiFutures.get(res2.finished)).isNull();
            Truth.assertThat((Integer)res2.rowCount.get()).isEqualTo((Object)50);
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
        }
    }

    @Test
    public void testUpdateAndQueryAbortedMidway() throws InterruptedException {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")), 50L));
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            ApiFuture finished;
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)0);
            final SettableApiFuture rowCount = SettableApiFuture.create();
            final CountDownLatch updateLatch = new CountDownLatch(1);
            final CountDownLatch queryLatch = new CountDownLatch(1);
            try (AsyncResultSet rs = connection.executeQueryAsync(SELECT_RANDOM_STATEMENT, new Options.QueryOption[]{Options.bufferRows((int)49)});){
                finished = rs.setCallback((Executor)singleThreadedExecutor, new AsyncResultSet.ReadyCallback(){
                    long count;

                    public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                        queryLatch.countDown();
                        try {
                            updateLatch.await(10L, TimeUnit.SECONDS);
                            while (true) {
                                switch (resultSet.tryNext()) {
                                    case OK: {
                                        ++this.count;
                                        break;
                                    }
                                    case DONE: {
                                        rowCount.set((Object)this.count);
                                        return AsyncResultSet.CallbackResponse.DONE;
                                    }
                                    case NOT_READY: {
                                        return AsyncResultSet.CallbackResponse.CONTINUE;
                                    }
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
                        }
                    }
                });
            }
            queryLatch.await(10L, TimeUnit.SECONDS);
            ApiFuture updateCount = connection.executeUpdateAsync(INSERT_STATEMENT);
            updateCount.addListener(updateLatch::countDown, MoreExecutors.directExecutor());
            Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)finished)).isNull();
            ApiFuture commit = connection.commitAsync();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)rowCount))).isEqualTo((Object)100);
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)updateCount))).isEqualTo((Object)1L);
            Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)commit)).isNull();
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
            ArrayList requests = Lists.newArrayList((Iterable)Collections2.filter(mockSpanner.getRequests(), input -> input instanceof ExecuteSqlRequest));
            Truth.assertThat((Iterable)requests).hasSize(4);
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(0)).getSeqno()).isEqualTo((Object)1L);
            Truth.assertThat((String)((ExecuteSqlRequest)requests.get(0)).getSql()).isEqualTo((Object)SELECT_RANDOM_STATEMENT.getSql());
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(1)).getSeqno()).isEqualTo((Object)2L);
            Truth.assertThat((String)((ExecuteSqlRequest)requests.get(1)).getSql()).isEqualTo((Object)INSERT_STATEMENT.getSql());
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(2)).getSeqno()).isEqualTo((Object)1L);
            Truth.assertThat((String)((ExecuteSqlRequest)requests.get(2)).getSql()).isEqualTo((Object)SELECT_RANDOM_STATEMENT.getSql());
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(3)).getSeqno()).isEqualTo((Object)2L);
            Truth.assertThat((String)((ExecuteSqlRequest)requests.get(3)).getSql()).isEqualTo((Object)INSERT_STATEMENT.getSql());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateAndQueryAbortedMidway_UpdateCountChanged() throws InterruptedException {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")), 50L));
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            ApiFuture finished;
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)0);
            CountDownLatch updateLatch = new CountDownLatch(1);
            CountDownLatch queryLatch = new CountDownLatch(1);
            try (AsyncResultSet rs = connection.executeQueryAsync(SELECT_RANDOM_STATEMENT, new Options.QueryOption[]{Options.bufferRows((int)49)});){
                finished = rs.setCallback((Executor)singleThreadedExecutor, resultSet -> {
                    queryLatch.countDown();
                    try {
                        updateLatch.await(10L, TimeUnit.SECONDS);
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case OK: {
                                    break;
                                }
                                case DONE: {
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
                    }
                });
            }
            queryLatch.await(10L, TimeUnit.SECONDS);
            SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(INSERT_STATEMENT));
            try {
                mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 2L));
                updateLatch.countDown();
                SpannerApiFutures.get((ApiFuture)finished);
                Assert.fail((String)"Missing expected exception");
            }
            catch (AbortedDueToConcurrentModificationException e) {
                Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
            }
            finally {
                mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 1L));
            }
            ArrayList requests = Lists.newArrayList((Iterable)Collections2.filter(mockSpanner.getRequests(), input -> input instanceof ExecuteSqlRequest));
            Truth.assertThat((Iterable)requests).hasSize(4);
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(0)).getSeqno()).isEqualTo((Object)1L);
            Truth.assertThat((String)((ExecuteSqlRequest)requests.get(0)).getSql()).isEqualTo((Object)SELECT_RANDOM_STATEMENT.getSql());
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(1)).getSeqno()).isEqualTo((Object)2L);
            Truth.assertThat((String)((ExecuteSqlRequest)requests.get(1)).getSql()).isEqualTo((Object)INSERT_STATEMENT.getSql());
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(2)).getSeqno()).isEqualTo((Object)1L);
            Truth.assertThat((String)((ExecuteSqlRequest)requests.get(2)).getSql()).isEqualTo((Object)SELECT_RANDOM_STATEMENT.getSql());
            Truth.assertThat((Long)((ExecuteSqlRequest)requests.get(3)).getSeqno()).isEqualTo((Object)2L);
            Truth.assertThat((String)((ExecuteSqlRequest)requests.get(3)).getSql()).isEqualTo((Object)INSERT_STATEMENT.getSql());
        }
    }

    @Test
    public void testQueriesAbortedMidway_ResultsChanged() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")), 99L));
        final Statement statement = Statement.of((String)"SELECT * FROM TEST_TABLE");
        final RandomResultSetGenerator generator = new RandomResultSetGenerator(90);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        final CountDownLatch latch = new CountDownLatch(1);
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            ApiFuture res1;
            try (AsyncResultSet rs = connection.executeQueryAsync(SELECT_RANDOM_STATEMENT, new Options.QueryOption[]{Options.bufferRows((int)5)});){
                res1 = rs.setCallback((Executor)multiThreadedExecutor, resultSet -> {
                    try {
                        latch.await(10L, TimeUnit.SECONDS);
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case OK: {
                                    break;
                                }
                                case DONE: {
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        throw SpannerExceptionFactory.asSpannerException((Throwable)t);
                    }
                });
            }
            rs = connection.executeQueryAsync(statement, new Options.QueryOption[]{Options.bufferRows((int)5)});
            try {
                rs.setCallback((Executor)multiThreadedExecutor, new AsyncResultSet.ReadyCallback(){
                    boolean replaced;

                    public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                        if (!this.replaced) {
                            AbstractMockServerTest.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
                            this.replaced = true;
                        }
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case OK: {
                                    break;
                                }
                                case DONE: {
                                    latch.countDown();
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                            }
                        }
                    }
                });
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            try {
                SpannerApiFutures.get((ApiFuture)res1);
                Assert.fail((String)"Missing expected exception");
            }
            catch (AbortedDueToConcurrentModificationException e) {
                Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
            }
        }
    }

    @Test
    public void testBlindUpdateAborted() {
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            mockSpanner.abortNextStatement();
            ApiFuture updateCount = connection.executeUpdateAsync(INSERT_STATEMENT);
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)updateCount))).isEqualTo((Object)1L);
            Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
        }
    }

    @Test
    public void testBlindUpdateAborted_WithConcurrentModification() {
        Statement update1 = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=100");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(update1, 100L));
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(update1));
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(update1, 200L));
            mockSpanner.abortNextStatement();
            connection.executeUpdateAsync(INSERT_STATEMENT);
            try {
                SpannerApiFutures.get((ApiFuture)connection.commitAsync());
                Assert.fail((String)"Missing expected exception");
            }
            catch (AbortedDueToConcurrentModificationException e) {
                Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
            }
        }
    }

    @Test
    public void testMultipleBlindUpdatesAborted_WithConcurrentModification() {
        Statement update1 = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=100");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(update1, 100L));
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(update1));
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(update1, 200L));
            mockSpanner.abortNextStatement();
            ArrayList<ApiFuture> futures = new ArrayList<ApiFuture>();
            for (int i = 0; i < 3; ++i) {
                futures.add(connection.executeUpdateAsync(INSERT_STATEMENT));
            }
            for (ApiFuture fut : futures) {
                try {
                    SpannerApiFutures.get((ApiFuture)fut);
                    Assert.fail((String)"Missing expected exception");
                }
                catch (AbortedDueToConcurrentModificationException e) {
                    Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
                }
            }
        }
    }

    @Test
    public void testBlindUpdateAborted_ThenAsyncQuery_WithConcurrentModification() {
        Statement update1 = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=100");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(update1, 100L));
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            ApiFuture fut;
            SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(update1));
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(update1, 200L));
            mockSpanner.abortNextStatement();
            connection.executeUpdateAsync(INSERT_STATEMENT);
            try (AsyncResultSet rs = connection.executeQueryAsync(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                fut = rs.setCallback((Executor)singleThreadedExecutor, resultSet -> {
                    resultSet.tryNext();
                    return AsyncResultSet.CallbackResponse.DONE;
                });
                try {
                    Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)fut)).isNull();
                    Assert.fail((String)"Missing expected exception");
                }
                catch (AbortedDueToConcurrentModificationException e) {
                    Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
                }
            }
            connection.rollbackAsync();
            rs = connection.executeQueryAsync(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
            try {
                fut = rs.setCallback((Executor)singleThreadedExecutor, resultSet -> {
                    resultSet.tryNext();
                    return AsyncResultSet.CallbackResponse.DONE;
                });
                Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)fut)).isNull();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
        }
    }

    @Test
    public void testBlindUpdateAborted_SelectResults() {
        Statement update1 = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=100");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(update1, 100L));
        RetryCounter counter = new RetryCounter();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(counter);){
            connection.executeUpdate(update1);
            mockSpanner.abortNextStatement();
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(update1, 200L));
            connection.executeUpdateAsync(INSERT_STATEMENT);
            ApiFuture commit = connection.commitAsync();
            try (AsyncResultSet rs = connection.executeQueryAsync(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
            try {
                SpannerApiFutures.get((ApiFuture)commit);
                Assert.fail((String)"Missing expected exception");
            }
            catch (AbortedDueToConcurrentModificationException e) {
                Truth.assertThat((Integer)counter.retryCount).isEqualTo((Object)1);
            }
        }
    }

    private QueryResult executeQueryAsync(Connection connection, Statement statement) {
        return this.executeQueryAsync(connection, statement, singleThreadedExecutor);
    }

    private QueryResult executeQueryAsync(Connection connection, Statement statement, Executor executor) {
        AtomicInteger rowCount = new AtomicInteger();
        try (AsyncResultSet rs = connection.executeQueryAsync(statement, new Options.QueryOption[]{Options.bufferRows((int)5)});){
            ApiFuture res = rs.setCallback(executor, resultSet -> {
                while (true) {
                    switch (resultSet.tryNext()) {
                        case OK: {
                            rowCount.incrementAndGet();
                            break;
                        }
                        case DONE: {
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                    }
                }
            });
            QueryResult queryResult = new QueryResult((ApiFuture<Void>)res, rowCount);
            return queryResult;
        }
    }

    private static final class RetryCounter
    implements TransactionRetryListener {
        final CountDownLatch latch;
        int retryCount = 0;

        RetryCounter() {
            this(0);
        }

        RetryCounter(int countDown) {
            this.latch = new CountDownLatch(countDown);
        }

        public void retryStarting(Timestamp transactionStarted, long transactionId, int retryAttempt) {
            ++this.retryCount;
            this.latch.countDown();
        }

        public void retryFinished(Timestamp transactionStarted, long transactionId, int retryAttempt, TransactionRetryListener.RetryResult result) {
        }
    }

    private static final class QueryResult {
        final ApiFuture<Void> finished;
        final AtomicInteger rowCount;

        QueryResult(ApiFuture<Void> finished, AtomicInteger rowCount) {
            this.finished = finished;
            this.rowCount = rowCount;
        }
    }
}

