/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.DecodeMode;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DecodeModeTest
extends AbstractMockServerTest {
    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testAllDecodeModes() {
        int numRows = 10;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
        String sql = "select * from random";
        Statement statement = Statement.of((String)sql);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean readonly : new boolean[]{true, false}) {
                for (boolean autocommit : new boolean[]{true, false}) {
                    connection.setReadOnly(readonly);
                    connection.setAutocommit(autocommit);
                    int receivedRows = 0;
                    try (ResultSet direct = connection.executeQuery(statement, new Options.QueryOption[]{!readonly && !autocommit ? Options.decodeMode((DecodeMode)DecodeMode.LAZY_PER_ROW) : Options.decodeMode((DecodeMode)DecodeMode.DIRECT)});
                         ResultSet lazyPerRow = connection.executeQuery(statement, new Options.QueryOption[]{Options.decodeMode((DecodeMode)DecodeMode.LAZY_PER_ROW)});
                         ResultSet lazyPerCol = connection.executeQuery(statement, new Options.QueryOption[]{Options.decodeMode((DecodeMode)DecodeMode.LAZY_PER_COL)});){
                        while (direct.next() && lazyPerRow.next() && lazyPerCol.next()) {
                            Assert.assertEquals((long)direct.getColumnCount(), (long)lazyPerRow.getColumnCount());
                            Assert.assertEquals((long)direct.getColumnCount(), (long)lazyPerCol.getColumnCount());
                            for (int col = 0; col < direct.getColumnCount(); ++col) {
                                if (col % 2 == 0) {
                                    Assert.assertEquals((Object)direct.getCurrentRowAsStruct(), (Object)lazyPerRow.getCurrentRowAsStruct());
                                    Assert.assertEquals((Object)direct.getCurrentRowAsStruct(), (Object)lazyPerCol.getCurrentRowAsStruct());
                                }
                                Assert.assertEquals((Object)direct.isNull(col), (Object)lazyPerRow.isNull(col));
                                Assert.assertEquals((Object)direct.isNull(col), (Object)lazyPerCol.isNull(col));
                                Assert.assertEquals((Object)direct.getValue(col), (Object)lazyPerRow.getValue(col));
                                Assert.assertEquals((Object)direct.getValue(col), (Object)lazyPerCol.getValue(col));
                                if (col % 2 != 1) continue;
                                Assert.assertEquals((Object)direct.getCurrentRowAsStruct(), (Object)lazyPerRow.getCurrentRowAsStruct());
                                Assert.assertEquals((Object)direct.getCurrentRowAsStruct(), (Object)lazyPerCol.getCurrentRowAsStruct());
                            }
                            ++receivedRows;
                        }
                        Assert.assertEquals((long)numRows, (long)receivedRows);
                    }
                    if (autocommit) continue;
                    connection.commit();
                }
            }
        }
    }

    @Test
    public void testDecodeModeDirect_failsInReadWriteTransaction() {
        int numRows = 1;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
        String sql = "select * from random";
        Statement statement = Statement.of((String)sql);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            try (ResultSet resultSet = connection.executeQuery(statement, new Options.QueryOption[]{Options.decodeMode((DecodeMode)DecodeMode.DIRECT)});){
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)resultSet).next());
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
                Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Executing queries with DecodeMode#DIRECT is not supported in read/write transactions."));
            }
        }
    }
}

