/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.protobuf.ByteString;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartitionQueryRequest;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InternalMetadataQueryMockServerTest
extends AbstractMockServerTest {
    private static final Statement STATEMENT = Statement.of((String)"SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");
    @Parameterized.Parameter
    public Dialect dialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    @BeforeClass
    public static void setupInternalMetadataQueryResults() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(STATEMENT, SELECT_COUNT_RESULTSET_BEFORE_INSERT));
    }

    @Before
    public void setupDialect() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(this.dialect));
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testInternalMetadataQueryInAutocommit() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            this.verifyInternalMetadataQuery(connection);
        }
    }

    @Test
    public void testInternalMetadataQueryWithStaleness() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnlyStaleness(TimestampBound.ofMaxStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
            this.verifyInternalMetadataQuery(connection);
        }
    }

    @Test
    public void testInternalMetadataQueryReadOnlyTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(true);
            this.verifyInternalMetadataQuery(connection);
        }
    }

    @Test
    public void testInternalMetadataQueryReadOnlyTransactionWithStaleness() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(true);
            connection.setReadOnlyStaleness(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
            this.verifyInternalMetadataQuery(connection);
        }
    }

    @Test
    public void testInternalMetadataQueryReadWriteTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(false);
            this.verifyInternalMetadataQuery(connection);
        }
    }

    @Test
    public void testInternalMetadataQueryInDmlBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.startBatchDml();
            this.verifyInternalMetadataQuery(connection);
            connection.runBatch();
        }
    }

    @Test
    public void testInternalMetadataQueryInDdlBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.startBatchDdl();
            this.verifyInternalMetadataQuery(connection);
            connection.runBatch();
        }
    }

    @Test
    public void testInternalMetadataQueryInAutoPartitionMode() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutoPartitionMode(true);
            this.verifyInternalMetadataQuery(connection);
        }
    }

    private void verifyInternalMetadataQuery(Connection connection) {
        try (ResultSet resultSet = connection.executeQuery(STATEMENT, new Options.QueryOption[]{Connection.InternalMetadataQuery.INSTANCE});){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)0L, (long)resultSet.getLong(0));
            Assert.assertFalse((boolean)resultSet.next());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasTransaction());
        Assert.assertTrue((boolean)request.getTransaction().hasSingleUse());
        Assert.assertTrue((boolean)request.getTransaction().getSingleUse().hasReadOnly());
        Assert.assertTrue((boolean)request.getTransaction().getSingleUse().getReadOnly().hasStrong());
        Assert.assertEquals((Object)ByteString.EMPTY, (Object)request.getPartitionToken());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }
}

