/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.SpannerOptionsTestHelper;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.Repeat;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.common.collect.ImmutableList;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OpenTelemetryTracingTest
extends AbstractMockServerTest {
    private static InMemorySpanExporter spanExporter;
    private static OpenTelemetrySdk openTelemetry;

    @BeforeClass
    public static void setupOpenTelemetry() {
        SpannerOptionsTestHelper.resetActiveTracingFramework();
        SpannerOptions.enableOpenTelemetryTraces();
        GlobalOpenTelemetry.resetForTest();
        spanExporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)).build();
        openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(tracerProvider).buildAndRegisterGlobal();
    }

    @AfterClass
    public static void closeOpenTelemetry() {
        SpannerPool.closeSpannerPool();
        if (openTelemetry != null) {
            openTelemetry.close();
        }
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
        spanExporter.reset();
    }

    Connection createTestConnection() {
        return this.createTestConnection(this.getBaseUrl() + ";enableExtendedTracing=true");
    }

    Connection createTestConnection(String url) {
        return ConnectionOptions.newBuilder().setTracingPrefix("CloudSpannerJdbc").setUri(url).build().getConnection();
    }

    @Test
    public void testSingleUseQuery_withoutSqlStatement() {
        try (Connection connection = this.createTestConnection(this.getBaseUrl());){
            connection.setAutocommit(true);
            try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        Assert.assertEquals((long)2L, (long)spans.stream().filter(span -> span.getName().equals("CloudSpannerOperation.ExecuteStreamingQuery")).count());
        Assert.assertEquals((long)2L, (long)spans.stream().filter(span -> span.getName().equals("CloudSpannerOperation.ExecuteStreamingQuery") && span.getAttributes().get(AttributeKey.stringKey((String)"db.statement")) == null).count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleUseQuery_withoutSqlStatement_usingEnvVar() {
        SpannerPool.closeSpannerPool();
        SpannerOptions.useEnvironment((SpannerOptions.SpannerEnvironment)new SpannerOptions.SpannerEnvironment(){

            public boolean isEnableExtendedTracing() {
                return true;
            }
        });
        try (Connection connection = this.createTestConnection(this.getBaseUrl());){
            connection.setAutocommit(true);
            try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
        finally {
            SpannerOptions.useDefaultEnvironment();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.SingleUseTransaction", spans);
        this.assertContains("CloudSpanner.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)SELECT1_STATEMENT.getSql()), spans);
        this.assertParent("CloudSpannerJdbc.SingleUseTransaction", "CloudSpanner.ReadOnlyTransaction", spans);
        this.assertParent("CloudSpanner.ReadOnlyTransaction", "CloudSpannerOperation.ExecuteStreamingQuery", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)SELECT1_STATEMENT.getSql()), spans);
    }

    @Test
    public void testSingleUseQuery() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(true);
            try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.SingleUseTransaction", spans);
        this.assertContains("CloudSpanner.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)SELECT1_STATEMENT.getSql()), spans);
        this.assertParent("CloudSpannerJdbc.SingleUseTransaction", "CloudSpanner.ReadOnlyTransaction", spans);
        this.assertParent("CloudSpanner.ReadOnlyTransaction", "CloudSpannerOperation.ExecuteStreamingQuery", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)SELECT1_STATEMENT.getSql()), spans);
    }

    @Test
    public void testSingleUseUpdate() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(true);
            connection.executeUpdate(INSERT_STATEMENT);
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.SingleUseTransaction", spans);
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteUpdate", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)INSERT_STATEMENT.getSql()), spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertParent("CloudSpannerJdbc.SingleUseTransaction", "CloudSpanner.ReadWriteTransaction", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.ExecuteUpdate", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)INSERT_STATEMENT.getSql()), spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.Commit", spans);
    }

    @Test
    public void testSingleUseBatchUpdate() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(true);
            connection.startBatchDml();
            connection.executeUpdate(INSERT_STATEMENT);
            connection.executeUpdate(INSERT_STATEMENT);
            connection.runBatch();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.SingleUseTransaction", spans);
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.BatchUpdate", Attributes.of((AttributeKey)AttributeKey.stringArrayKey((String)"db.statement"), (Object)ImmutableList.of((Object)INSERT_STATEMENT.getSql(), (Object)INSERT_STATEMENT.getSql())), spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertParent("CloudSpannerJdbc.SingleUseTransaction", "CloudSpanner.ReadWriteTransaction", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.BatchUpdate", Attributes.of((AttributeKey)AttributeKey.stringArrayKey((String)"db.statement"), (Object)ImmutableList.of((Object)INSERT_STATEMENT.getSql(), (Object)INSERT_STATEMENT.getSql())), spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.Commit", spans);
    }

    @Test
    public void testSingleUseDdl() {
        String ddl = "CREATE TABLE foo (id int64) PRIMARY KEY (id)";
        this.addUpdateDdlResponse();
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(true);
            connection.execute(Statement.of((String)ddl));
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.DdlStatement", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)ddl), spans);
    }

    @Test
    public void testSingleUseDdlBatch() {
        String ddl1 = "CREATE TABLE foo (id int64, value string(max)) PRIMARY KEY (id)";
        String ddl2 = "CREATE INDEX idx_foo ON foo (value)";
        this.addUpdateDdlResponse();
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(true);
            connection.startBatchDdl();
            connection.execute(Statement.of((String)ddl1));
            connection.execute(Statement.of((String)ddl2));
            connection.runBatch();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.DdlBatch", Attributes.of((AttributeKey)AttributeKey.stringArrayKey((String)"db.statement"), (Object)ImmutableList.of((Object)ddl1, (Object)ddl2)), spans);
    }

    @Test
    public void testMultiUseReadOnlyQueries() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(true);
            Repeat.twice(() -> {
                try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertFalse((boolean)resultSet.next());
                }
            });
            connection.commit();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpanner.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", 2, Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)SELECT1_STATEMENT.getSql()), spans);
        this.assertParent("CloudSpannerJdbc.ReadOnlyTransaction", "CloudSpanner.ReadOnlyTransaction", spans);
        this.assertParent("CloudSpanner.ReadOnlyTransaction", "CloudSpannerOperation.ExecuteStreamingQuery", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)SELECT1_STATEMENT.getSql()), spans);
    }

    @Test
    public void testMultiUseReadWriteQueries() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(false);
            Repeat.twice(() -> {
                try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertFalse((boolean)resultSet.next());
                }
            });
            connection.commit();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.ReadWriteTransaction", spans);
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", 2, Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)SELECT1_STATEMENT.getSql()), spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertParent("CloudSpannerJdbc.ReadWriteTransaction", "CloudSpanner.ReadWriteTransaction", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.ExecuteStreamingQuery", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)SELECT1_STATEMENT.getSql()), spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.Commit", spans);
    }

    @Test
    public void testMultiUseReadWriteUpdates() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(false);
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.ReadWriteTransaction", spans);
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteUpdate", 2, Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)INSERT_STATEMENT.getSql()), spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertParent("CloudSpannerJdbc.ReadWriteTransaction", "CloudSpanner.ReadWriteTransaction", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.ExecuteUpdate", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)INSERT_STATEMENT.getSql()), spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.Commit", spans);
    }

    @Test
    public void testMultiUseReadWriteBatchUpdates() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(false);
            Repeat.twice(() -> {
                connection.startBatchDml();
                connection.executeUpdate(INSERT_STATEMENT);
                connection.executeUpdate(INSERT_STATEMENT);
                connection.runBatch();
            });
            connection.commit();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.ReadWriteTransaction", spans);
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.BatchUpdate", 2, Attributes.of((AttributeKey)AttributeKey.stringArrayKey((String)"db.statement"), (Object)ImmutableList.of((Object)INSERT_STATEMENT.getSql(), (Object)INSERT_STATEMENT.getSql())), spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertParent("CloudSpannerJdbc.ReadWriteTransaction", "CloudSpanner.ReadWriteTransaction", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.BatchUpdate", Attributes.of((AttributeKey)AttributeKey.stringArrayKey((String)"db.statement"), (Object)ImmutableList.of((Object)INSERT_STATEMENT.getSql(), (Object)INSERT_STATEMENT.getSql())), spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.Commit", spans);
    }

    @Test
    public void testMultiUseReadWriteAborted() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(false);
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.ReadWriteTransaction", spans);
        this.assertContains("CloudSpanner.ReadWriteTransaction", 1, Attributes.empty(), spans);
        SpanData transactionSpan = spans.stream().filter(span -> span.getName().equals("CloudSpannerJdbc.ReadWriteTransaction")).findFirst().orElseThrow(IllegalStateException::new);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)transactionSpan.getAttributes().get(AttributeKey.booleanKey((String)"transaction.retried")));
        Assert.assertEquals((long)1L, (long)transactionSpan.getTotalRecordedEvents());
        EventData event = (EventData)transactionSpan.getEvents().get(0);
        Assert.assertEquals((Object)"Transaction aborted. Backing off for 0 milliseconds and retrying.", (Object)event.getName());
        this.assertContains("CloudSpannerOperation.ExecuteUpdate", 2, Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)INSERT_STATEMENT.getSql()), spans);
        this.assertContains("CloudSpannerOperation.Commit", 2, Attributes.empty(), spans);
        this.assertParent("CloudSpannerJdbc.ReadWriteTransaction", "CloudSpanner.ReadWriteTransaction", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.ExecuteUpdate", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)INSERT_STATEMENT.getSql()), spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.Commit", spans);
    }

    @Test
    public void testSavepoint() {
        Statement statement1 = Statement.of((String)"insert into foo (id) values (1)");
        Statement statement2 = Statement.of((String)"insert into foo (id) values (2)");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement1, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement2, 1L));
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(false);
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(statement1));
            connection.savepoint("test");
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(statement2));
            connection.rollbackToSavepoint("test");
            connection.commit();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerJdbc.ReadWriteTransaction", spans);
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteUpdate", 2, Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)statement1.getSql()), spans);
        this.assertContains("CloudSpannerOperation.ExecuteUpdate", 1, Attributes.of((AttributeKey)AttributeKey.stringKey((String)"db.statement"), (Object)statement2.getSql()), spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        List<SpanData> transactionSpans = this.getSpans("CloudSpanner.ReadWriteTransaction", Attributes.empty(), spans);
        Assert.assertEquals((long)2L, (long)transactionSpans.size());
        Assert.assertEquals((Object)transactionSpans.get(0).getParentSpanId(), (Object)transactionSpans.get(1).getParentSpanId());
        List<SpanData> jdbcTransactionSpans = this.getSpans("CloudSpannerJdbc.ReadWriteTransaction", Attributes.empty(), spans);
        Assert.assertEquals((long)1L, (long)jdbcTransactionSpans.size());
        Assert.assertEquals((Object)jdbcTransactionSpans.get(0).getSpanId(), (Object)transactionSpans.get(0).getParentSpanId());
        List<SpanData> commitSpans = this.getSpans("CloudSpannerOperation.Commit", Attributes.empty(), spans);
        Assert.assertEquals((long)1L, (long)commitSpans.size());
        Assert.assertEquals((Object)transactionSpans.get(1).getSpanId(), (Object)commitSpans.get(0).getParentSpanId());
    }

    @Test
    public void testTransactionTag() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(false);
            connection.setTransactionTag("my_tag");
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpanner.ReadWriteTransaction", 1, Attributes.of((AttributeKey)AttributeKey.stringKey((String)"transaction.tag"), (Object)"my_tag"), spans);
    }

    @Test
    public void testStatementTag() {
        try (Connection connection = this.createTestConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(false);
            connection.setStatementTag("my_tag");
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpannerOperation.ExecuteUpdate", 1, Attributes.of((AttributeKey)AttributeKey.stringKey((String)"statement.tag"), (Object)"my_tag"), spans);
    }

    void assertContains(String expected, List<SpanData> spans) {
        Assert.assertTrue((String)("Expected " + this.spansToString(spans) + " to contain " + expected), (boolean)spans.stream().anyMatch(span -> span.getName().equals(expected)));
    }

    void assertContains(String expected, Attributes attributes, List<SpanData> spans) {
        this.assertContains(expected, 1, attributes, spans);
    }

    void assertContains(String expected, int count, Attributes attributes, List<SpanData> spans) {
        Assert.assertEquals((String)("Expected " + this.spansToString(spans) + " to contain " + expected), (long)count, (long)spans.stream().filter(span -> this.equalsSpan((SpanData)span, expected, attributes)).count());
    }

    boolean equalsSpan(SpanData span, String name, Attributes attributes) {
        if (!span.getName().equals(name)) {
            return false;
        }
        for (Map.Entry entry : attributes.asMap().entrySet()) {
            if (!span.getAttributes().asMap().containsKey(entry.getKey())) {
                return false;
            }
            if (Objects.equals(entry.getValue(), span.getAttributes().get((AttributeKey)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    void assertParent(String expectedParent, String child, List<SpanData> spans) {
        SpanData parentSpan = this.getSpan(expectedParent, spans);
        SpanData childSpan = this.getSpan(child, spans);
        Assert.assertEquals((Object)parentSpan.getSpanId(), (Object)childSpan.getParentSpanId());
    }

    void assertParent(String expectedParent, String child, Attributes attributes, List<SpanData> spans) {
        SpanData parentSpan = this.getSpan(expectedParent, spans);
        List<SpanData> childSpans = this.getSpans(child, attributes, spans);
        for (SpanData childSpan : childSpans) {
            Assert.assertEquals((Object)parentSpan.getSpanId(), (Object)childSpan.getParentSpanId());
        }
    }

    SpanData getSpan(String name, List<SpanData> spans) {
        return spans.stream().filter(span -> span.getName().equals(name)).findAny().orElseThrow(() -> new IllegalArgumentException("Span " + name + " not found"));
    }

    SpanData getSpan(String name, Attributes attributes, List<SpanData> spans) {
        return spans.stream().filter(span -> this.equalsSpan((SpanData)span, name, attributes)).findAny().orElseThrow(() -> new IllegalArgumentException("Span " + name + " not found"));
    }

    List<SpanData> getSpans(String name, Attributes attributes, List<SpanData> spans) {
        return spans.stream().filter(span -> this.equalsSpan((SpanData)span, name, attributes)).collect(Collectors.toList());
    }

    private String spansToString(List<SpanData> spans) {
        return spans.stream().map(SpanData::getName).collect(Collectors.joining("\n", "\n", "\n"));
    }

    private void addUpdateDdlResponse() {
        mockDatabaseAdmin.addResponse((AbstractMessage)Operation.newBuilder().setMetadata(Any.pack((Message)UpdateDatabaseDdlMetadata.newBuilder().setDatabase("projects/proj/instances/inst/databases/db").build())).setName("projects/proj/instances/inst/databases/db/operations/1").setDone(true).setResponse(Any.pack((Message)Empty.getDefaultInstance())).build());
    }
}

