/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.SimpleParser;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SimpleParserTest {
    @Parameterized.Parameter
    public Dialect dialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    SimpleParser parserFor(String sql) {
        return new SimpleParser(this.dialect, sql);
    }

    @Test
    public void testResultHashCode() {
        Assert.assertEquals((long)0L, (long)SimpleParser.Result.NOT_FOUND.hashCode());
        Assert.assertEquals((long)SimpleParser.Result.found((String)"foo").hashCode(), (long)SimpleParser.Result.found((String)"foo").hashCode());
        Assert.assertNotEquals((long)SimpleParser.Result.found((String)"foo").hashCode(), (long)SimpleParser.Result.found((String)"bar").hashCode());
        Assert.assertNotEquals((long)SimpleParser.Result.NOT_FOUND.hashCode(), (long)SimpleParser.Result.found((String)"bar").hashCode());
    }

    @Test
    public void testResultEquals() {
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)SimpleParser.Result.found((String)"foo"));
        Assert.assertNotEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)SimpleParser.Result.found((String)"bar"));
        Assert.assertNotEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)SimpleParser.Result.found((String)"bar"));
        Assert.assertNotEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)new Object());
        Assert.assertNotEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)new Object());
    }

    @Test
    public void testResultToString() {
        Assert.assertEquals((Object)"foo", (Object)SimpleParser.Result.found((String)"foo").toString());
        Assert.assertEquals((Object)"NOT FOUND", (Object)SimpleParser.Result.NOT_FOUND.toString());
    }

    @Test
    public void testResultGetValue() {
        Assert.assertEquals((Object)"foo", (Object)SimpleParser.Result.found((String)"foo").getValue());
        Assert.assertNull((Object)SimpleParser.Result.NOT_FOUND.getValue());
    }

    @Test
    public void testEatToken() {
        Assert.assertTrue((boolean)this.parserFor("(foo").eatToken('('));
        Assert.assertTrue((boolean)this.parserFor("(").eatToken('('));
        Assert.assertTrue((boolean)this.parserFor("( ").eatToken('('));
        Assert.assertTrue((boolean)this.parserFor("\t(   foo").eatToken('('));
        Assert.assertFalse((boolean)this.parserFor("foo(").eatToken('('));
        Assert.assertFalse((boolean)this.parserFor("").eatToken('('));
    }

    @Test
    public void testEatTokenAdvancesPosition() {
        SimpleParser parser = this.parserFor("@{test=value}");
        Assert.assertEquals((long)0L, (long)parser.getPos());
        Assert.assertTrue((boolean)parser.eatToken('@'));
        Assert.assertEquals((long)1L, (long)parser.getPos());
        Assert.assertFalse((boolean)parser.eatToken('('));
        Assert.assertEquals((long)1L, (long)parser.getPos());
        Assert.assertTrue((boolean)parser.eatToken('{'));
        Assert.assertEquals((long)2L, (long)parser.getPos());
    }

    @Test
    public void testEatTokensAdvancesPosition() {
        SimpleParser parser = this.parserFor("@{test=value}");
        Assert.assertEquals((long)0L, (long)parser.getPos());
        Assert.assertTrue((boolean)parser.eatTokens(new char[]{'@', '{'}));
        Assert.assertEquals((long)2L, (long)parser.getPos());
        Assert.assertFalse((boolean)parser.eatTokens(new char[]{'@', '{'}));
        Assert.assertEquals((long)2L, (long)parser.getPos());
        parser = this.parserFor("@ /* comment */ { test=value}");
        Assert.assertEquals((long)0L, (long)parser.getPos());
        Assert.assertTrue((boolean)parser.eatTokens(new char[]{'@', '{'}));
        Assert.assertEquals((long)"@ /* comment */ {".length(), (long)parser.getPos());
    }

    @Test
    public void testPeekTokenKeepsPosition() {
        SimpleParser parser = this.parserFor("@{test=value}");
        Assert.assertEquals((long)0L, (long)parser.getPos());
        Assert.assertTrue((boolean)parser.peekToken('@'));
        Assert.assertEquals((long)0L, (long)parser.getPos());
        Assert.assertFalse((boolean)parser.peekToken('{'));
        Assert.assertEquals((long)0L, (long)parser.getPos());
    }

    @Test
    public void testPeekTokensKeepsPosition() {
        SimpleParser parser = this.parserFor("@{test=value}");
        Assert.assertEquals((long)0L, (long)parser.getPos());
        Assert.assertTrue((boolean)parser.peekTokens(new char[]{'@', '{'}));
        Assert.assertEquals((long)0L, (long)parser.getPos());
    }

    @Test
    public void testEatIdentifier() {
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("foo").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("foo(id)").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("foo bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor(" foo bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("\tfoo").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"bar"), (Object)this.parserFor("\n bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("    foo").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("foo\"bar\"").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("foo.bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("foo) bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("foo- bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo"), (Object)this.parserFor("foo/ bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"foo$"), (Object)this.parserFor("foo$ bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"f$oo"), (Object)this.parserFor("f$oo bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"_foo"), (Object)this.parserFor("_foo bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"\u00f8foo"), (Object)this.parserFor("\u00f8foo bar").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("\"foo").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("\\foo").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("1foo").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("-foo").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("$foo").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("   ").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("\n").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("/* comment */").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("-- comment").eatIdentifier());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("/* comment").eatIdentifier());
        String nestedCommentFollowedByIdentifier = "/* comment /* nested comment */ still a comment if nested comments are supported, and otherwise the start of an identifier. */ test";
        if (AbstractStatementParser.getInstance((Dialect)this.dialect).supportsNestedComments()) {
            Assert.assertEquals((Object)SimpleParser.Result.found((String)"test"), (Object)this.parserFor(nestedCommentFollowedByIdentifier).eatIdentifier());
        } else {
            Assert.assertEquals((Object)SimpleParser.Result.found((String)"still"), (Object)this.parserFor(nestedCommentFollowedByIdentifier).eatIdentifier());
        }
        if (AbstractStatementParser.getInstance((Dialect)this.dialect).supportsHashSingleLineComments()) {
            Assert.assertEquals((Object)SimpleParser.Result.found((String)"test"), (Object)this.parserFor("# comment\ntest").eatIdentifier());
        } else {
            Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("# not a comment\ntest").eatIdentifier());
        }
    }

    @Test
    public void testEatSingleQuotedString() {
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test"), (Object)this.parserFor("'test'").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test"), (Object)this.parserFor("  'test'   ").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test"), (Object)this.parserFor("\n'test'").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test"), (Object)this.parserFor("\t'test'").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test test"), (Object)this.parserFor("  'test test'   ").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test\t"), (Object)this.parserFor("'test\t'").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test"), (Object)this.parserFor("/* comment */'test'/*comment*/").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test"), (Object)this.parserFor("-- comment\n'test'--comment\n").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test /* not a comment */"), (Object)this.parserFor("'test /* not a comment */'").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("test").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("'test").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("test'").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("\"test\"").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("'test\n'").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("'\ntest'").eatSingleQuotedString());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)this.parserFor("'te\nst'").eatSingleQuotedString());
    }

    @Test
    public void testEatSingleQuotedStringAdvancesPosition() {
        SimpleParser parser = this.parserFor("'test 1'  'test 2'  ");
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test 1"), (Object)parser.eatSingleQuotedString());
        Assert.assertEquals((long)"'test 1'".length(), (long)parser.getPos());
        Assert.assertEquals((Object)SimpleParser.Result.found((String)"test 2"), (Object)parser.eatSingleQuotedString());
        Assert.assertEquals((long)"'test 1'  'test 2'".length(), (long)parser.getPos());
        Assert.assertEquals((Object)SimpleParser.Result.NOT_FOUND, (Object)parser.eatSingleQuotedString());
        Assert.assertEquals((long)parser.getSql().length(), (long)parser.getPos());
    }
}

