/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import io.grpc.BindableService;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractAsyncTransactionTest {
    static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static InetSocketAddress address;
    static ExecutorService executor;
    Spanner spanner;
    Spanner spannerWithEmptySessionPool;

    @BeforeClass
    public static void setup() throws Exception {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_ONE_EMPTY_KEY_VALUE_STATEMENT, MockSpannerTestUtil.EMPTY_KEY_VALUE_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_ONE_KEY_VALUE_STATEMENT, MockSpannerTestUtil.READ_ONE_KEY_VALUE_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_MULTIPLE_KEY_VALUE_STATEMENT, MockSpannerTestUtil.READ_MULTIPLE_KEY_VALUE_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(MockSpannerTestUtil.UPDATE_ABORTED_STATEMENT, Status.ABORTED.withDescription("Transaction was aborted").asRuntimeException()));
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).build().start();
        executor = Executors.newSingleThreadExecutor();
    }

    @AfterClass
    public static void teardown() throws Exception {
        server.shutdown();
        server.awaitTermination();
        executor.shutdown();
    }

    @Before
    public void before() {
        String endpoint = address.getHostString() + ":" + server.getPort();
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("my-project")).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).setHost("http://" + endpoint).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setFailOnSessionLeak().build()).build().getService();
        this.spannerWithEmptySessionPool = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setFailOnSessionLeak().setMinSessions(0).setIncStep(1).build()).build().getService();
    }

    @After
    public void after() {
        this.spanner.close();
        this.spannerWithEmptySessionPool.close();
        mockSpanner.removeAllExecutionTimes();
        mockSpanner.reset();
    }

    DatabaseClient client() {
        return this.spanner.getDatabaseClient(DatabaseId.of((String)"my-project", (String)"my-instance", (String)"my-database"));
    }

    DatabaseClient clientWithEmptySessionPool() {
        return this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)"my-project", (String)"my-instance", (String)"my-database"));
    }
}

