/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.common.base.Stopwatch;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BatchCreateSessionsTest {
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final ResultSet SELECT1_RESULTSET = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).directExecutor()).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
    }

    private Spanner createSpanner(int minSessions, int maxSessions) {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(minSessions).setMaxSessions(maxSessions).build();
        return (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(sessionPoolOptions).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();
    }

    @Test
    public void testCreatedMinSessions() throws InterruptedException {
        int minSessions = 1000;
        int maxSessions = 4000;
        try (Spanner spanner = this.createSpanner(minSessions, maxSessions);){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            Stopwatch watch = Stopwatch.createStarted();
            while (client.pool.totalSessions() < minSessions && watch.elapsed(TimeUnit.SECONDS) < 10L) {
                Thread.sleep(10L);
            }
            MatcherAssert.assertThat((Object)client.pool.totalSessions(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)minSessions)));
        }
    }

    @Test
    public void testClosePoolWhileInitializing() throws InterruptedException {
        DatabaseClientImpl client;
        int minSessions = 10000;
        int maxSessions = 10000;
        mockSpanner.freeze();
        try (Spanner spanner = this.createSpanner(minSessions, maxSessions);){
            client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
            mockSpanner.unfreeze();
            Stopwatch watch = Stopwatch.createStarted();
            while (client.pool.totalSessions() == 0 && watch.elapsed(TimeUnit.SECONDS) < 10L) {
                Thread.sleep(1L);
            }
        }
        MatcherAssert.assertThat((Object)client.pool.totalSessions(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }

    @Test
    public void testSpannerReturnsAllAvailableSessionsAndThenNoSessions() throws InterruptedException {
        DatabaseClientImpl client;
        int minSessions = 1000;
        int maxSessions = 1000;
        int maxServerSessions = 550;
        mockSpanner.setMaxTotalSessions(maxServerSessions);
        try (Spanner spanner = this.createSpanner(minSessions, maxSessions);){
            client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            Stopwatch watch = Stopwatch.createStarted();
            while (client.pool.totalSessions() < maxServerSessions && watch.elapsed(TimeUnit.SECONDS) < 10L) {
                Thread.sleep(10L);
            }
            MatcherAssert.assertThat((Object)client.pool.totalSessions(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)maxServerSessions)));
            watch = watch.reset();
            watch.start();
            while (client.pool.getNumberOfSessionsBeingCreated() > 0 && watch.elapsed(TimeUnit.SECONDS) < 10L) {
                Thread.sleep(10L);
            }
            mockSpanner.setMaxTotalSessions(Integer.MAX_VALUE);
            Thread.sleep(20L);
            MatcherAssert.assertThat((Object)client.pool.totalSessions(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)maxServerSessions)));
        }
        MatcherAssert.assertThat((Object)client.pool.totalSessions(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }

    @Test
    public void testSpannerReturnsResourceExhausted() throws InterruptedException {
        DatabaseClientImpl client;
        int minSessions = 100;
        int maxSessions = 1000;
        mockSpanner.addException((Exception)Status.RESOURCE_EXHAUSTED.asRuntimeException());
        try (Spanner spanner = this.createSpanner(minSessions, maxSessions);){
            client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            int expectedSessions = minSessions - minSessions / ((SpannerOptions)spanner.getOptions()).getNumChannels();
            Stopwatch watch = Stopwatch.createStarted();
            while (client.pool.totalSessions() < expectedSessions && watch.elapsed(TimeUnit.SECONDS) < 10L) {
                Thread.sleep(10L);
            }
            Thread.sleep(20L);
        }
        MatcherAssert.assertThat((Object)client.pool.totalSessions(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }
}

