/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStubSettings;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.base.Strings;
import com.google.common.truth.Truth;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.ListSessionsRequest;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.SpannerGrpc;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class SpannerOptionsTest {
    private static Level originalLogLevel;

    @BeforeClass
    public static void disableLogging() {
        Logger logger = Logger.getLogger("");
        originalLogLevel = logger.getLevel();
        logger.setLevel(Level.OFF);
    }

    @AfterClass
    public static void resetLogging() {
        Logger logger = Logger.getLogger("");
        logger.setLevel(originalLogLevel);
    }

    @Test
    public void defaultBuilder() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        if (Strings.isNullOrEmpty((String)System.getenv("SPANNER_EMULATOR_HOST"))) {
            Truth.assertThat((String)options.getHost()).isEqualTo((Object)"https://spanner.googleapis.com");
        } else {
            Truth.assertThat((String)options.getHost()).isEqualTo((Object)("http://" + System.getenv("SPANNER_EMULATOR_HOST")));
        }
        Truth.assertThat((Integer)options.getPrefetchChunks()).isEqualTo((Object)4);
        Assert.assertNull((Object)options.getSessionLabels());
    }

    @Test
    public void builder() {
        String host = "http://localhost:8000/";
        String projectId = "test-project";
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("env", "dev");
        InMemoryMetricReader inMemoryMetricReader = InMemoryMetricReader.create();
        SdkMeterProvider sdkMeterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)inMemoryMetricReader).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProvider).build();
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setHost(host).setProjectId(projectId)).setPrefetchChunks(2).setSessionLabels(labels).setOpenTelemetry((OpenTelemetry)openTelemetry).build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)host);
        Truth.assertThat((String)options.getProjectId()).isEqualTo((Object)projectId);
        Truth.assertThat((Integer)options.getPrefetchChunks()).isEqualTo((Object)2);
        Truth.assertThat((Map)options.getSessionLabels()).containsExactlyEntriesIn(labels);
        Truth.assertThat((Object)options.getOpenTelemetry()).isEqualTo((Object)openTelemetry);
    }

    @Test
    public void testSpannerDefaultRetrySettings() {
        RetrySettings witRetryPolicy1 = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
        RetrySettings witRetryPolicy2 = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
        RetrySettings witRetryPolicy3 = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
        RetrySettings noRetry1 = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        SpannerStubSettings stubSettings = options.getSpannerStubSettings();
        List<UnaryCallSettings> callsWithRetry1 = Arrays.asList(stubSettings.listSessionsSettings(), stubSettings.commitSettings());
        List<UnaryCallSettings> callsWithRetry2 = Collections.singletonList(stubSettings.batchCreateSessionsSettings());
        List<UnaryCallSettings> callsWithRetry3 = Arrays.asList(stubSettings.createSessionSettings(), stubSettings.getSessionSettings(), stubSettings.deleteSessionSettings(), stubSettings.executeSqlSettings(), stubSettings.executeBatchDmlSettings(), stubSettings.readSettings(), stubSettings.beginTransactionSettings(), stubSettings.rollbackSettings(), stubSettings.partitionQuerySettings(), stubSettings.partitionReadSettings());
        List<ServerStreamingCallSettings> callsWithNoRetry1 = Arrays.asList(stubSettings.executeStreamingSqlSettings(), stubSettings.streamingReadSettings());
        for (UnaryCallSettings unaryCallSettings : callsWithRetry1) {
            Truth.assertThat((Object)unaryCallSettings.getRetrySettings()).isEqualTo((Object)witRetryPolicy1);
        }
        for (UnaryCallSettings unaryCallSettings : callsWithRetry2) {
            Truth.assertThat((Object)unaryCallSettings.getRetrySettings()).isEqualTo((Object)witRetryPolicy2);
        }
        for (UnaryCallSettings unaryCallSettings : callsWithRetry3) {
            Truth.assertThat((Object)unaryCallSettings.getRetrySettings()).isEqualTo((Object)witRetryPolicy3);
        }
        for (ServerStreamingCallSettings serverStreamingCallSettings : callsWithNoRetry1) {
            Truth.assertThat((Object)serverStreamingCallSettings.getRetrySettings()).isEqualTo((Object)noRetry1);
        }
    }

    @Test
    public void testSpannerCustomRetrySettings() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)9999L)).setRetryDelayMultiplier(9999.99).setMaxRetryDelay(Duration.ofSeconds((long)9999L)).setInitialRpcTimeout(Duration.ofSeconds((long)9999L)).setRpcTimeoutMultiplier(9999.99).setMaxRpcTimeout(Duration.ofSeconds((long)9999L)).setTotalTimeout(Duration.ofSeconds((long)9999L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project");
        SpannerStubSettings.Builder stubSettingsBuilder = builder.getSpannerStubSettingsBuilder();
        List<UnaryCallSettings.Builder> unaryCallSettingsBuilders = Arrays.asList(stubSettingsBuilder.beginTransactionSettings(), stubSettingsBuilder.createSessionSettings(), stubSettingsBuilder.deleteSessionSettings(), stubSettingsBuilder.executeBatchDmlSettings(), stubSettingsBuilder.executeSqlSettings(), stubSettingsBuilder.getSessionSettings(), stubSettingsBuilder.listSessionsSettings(), stubSettingsBuilder.partitionQuerySettings(), stubSettingsBuilder.partitionReadSettings(), stubSettingsBuilder.readSettings(), stubSettingsBuilder.rollbackSettings(), stubSettingsBuilder.commitSettings());
        for (UnaryCallSettings.Builder builder2 : unaryCallSettingsBuilders) {
            builder2.setRetrySettings(retrySettings);
        }
        List<ServerStreamingCallSettings.Builder> streamingCallSettingsBuilders = Arrays.asList(stubSettingsBuilder.executeStreamingSqlSettings(), stubSettingsBuilder.streamingReadSettings());
        for (ServerStreamingCallSettings.Builder callSettingsBuilder : streamingCallSettingsBuilders) {
            callSettingsBuilder.setRetrySettings(retrySettings);
        }
        SpannerOptions spannerOptions = builder.build();
        SpannerStubSettings stubSettings = spannerOptions.getSpannerStubSettings();
        List<UnaryCallSettings> callsWithDefaultSettings = Arrays.asList(stubSettings.beginTransactionSettings(), stubSettings.createSessionSettings(), stubSettings.deleteSessionSettings(), stubSettings.executeBatchDmlSettings(), stubSettings.executeSqlSettings(), stubSettings.getSessionSettings(), stubSettings.listSessionsSettings(), stubSettings.partitionQuerySettings(), stubSettings.partitionReadSettings(), stubSettings.readSettings(), stubSettings.rollbackSettings(), stubSettings.commitSettings());
        List<ServerStreamingCallSettings> callsWithStreamingSettings = Arrays.asList(stubSettings.executeStreamingSqlSettings(), stubSettings.streamingReadSettings());
        for (UnaryCallSettings unaryCallSettings : callsWithDefaultSettings) {
            Truth.assertThat((Object)unaryCallSettings.getRetrySettings()).isEqualTo((Object)retrySettings);
        }
        for (ServerStreamingCallSettings serverStreamingCallSettings : callsWithStreamingSettings) {
            Truth.assertThat((Object)serverStreamingCallSettings.getRetrySettings()).isEqualTo((Object)retrySettings);
        }
    }

    @Test
    public void testDatabaseAdminDefaultRetrySettings() {
        RetrySettings withRetryPolicy1 = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
        RetrySettings withRetryPolicy2 = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
        RetrySettings noRetryPolicy2 = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        DatabaseAdminStubSettings stubSettings = options.getDatabaseAdminStubSettings();
        List<UnaryCallSettings> callsWithRetryPolicy1 = Arrays.asList(stubSettings.dropDatabaseSettings(), stubSettings.getDatabaseSettings(), stubSettings.getDatabaseDdlSettings());
        List<UnaryCallSettings> callsWithRetryPolicy2 = Collections.singletonList(stubSettings.getIamPolicySettings());
        List<UnaryCallSettings> callsWithNoRetry2 = Arrays.asList(stubSettings.setIamPolicySettings(), stubSettings.testIamPermissionsSettings());
        for (UnaryCallSettings callSettings : callsWithRetryPolicy1) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)withRetryPolicy1);
        }
        for (UnaryCallSettings callSettings : callsWithRetryPolicy2) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)withRetryPolicy2);
        }
        for (UnaryCallSettings callSettings : callsWithNoRetry2) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)noRetryPolicy2);
        }
    }

    @Test
    public void testDatabaseAdminCustomRetrySettings() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)9999L)).setRetryDelayMultiplier(9999.99).setMaxRetryDelay(Duration.ofSeconds((long)9999L)).setInitialRpcTimeout(Duration.ofSeconds((long)9999L)).setRpcTimeoutMultiplier(9999.99).setMaxRpcTimeout(Duration.ofSeconds((long)9999L)).setTotalTimeout(Duration.ofSeconds((long)9999L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project");
        DatabaseAdminStubSettings.Builder stubSettingsBuilder = builder.getDatabaseAdminStubSettingsBuilder();
        List<UnaryCallSettings.Builder> unaryCallSettingsBuilders = Arrays.asList(stubSettingsBuilder.dropDatabaseSettings(), stubSettingsBuilder.getDatabaseDdlSettings(), stubSettingsBuilder.getDatabaseSettings());
        for (UnaryCallSettings.Builder callSettingsBuilder : unaryCallSettingsBuilders) {
            callSettingsBuilder.setRetrySettings(retrySettings);
        }
        SpannerOptions options = builder.build();
        DatabaseAdminStubSettings stubSettings = options.getDatabaseAdminStubSettings();
        List<UnaryCallSettings> callsWithDefaultSettings = Arrays.asList(stubSettings.dropDatabaseSettings(), stubSettings.getDatabaseDdlSettings(), stubSettings.getDatabaseSettings());
        for (UnaryCallSettings callSettings : callsWithDefaultSettings) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)retrySettings);
        }
    }

    @Test
    public void testInstanceAdminDefaultRetrySettings() {
        RetrySettings withRetryPolicy1 = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
        RetrySettings withRetryPolicy2 = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
        RetrySettings noRetryPolicy1 = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
        RetrySettings noRetryPolicy2 = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        InstanceAdminStubSettings stubSettings = options.getInstanceAdminStubSettings();
        List<UnaryCallSettings> callsWithRetryPolicy1 = Arrays.asList(stubSettings.getInstanceConfigSettings(), stubSettings.listInstanceConfigsSettings(), stubSettings.deleteInstanceSettings(), stubSettings.getInstanceSettings(), stubSettings.listInstancesSettings());
        List<UnaryCallSettings> callsWithRetryPolicy2 = Collections.singletonList(stubSettings.getIamPolicySettings());
        List<UnaryCallSettings> callsWithNoRetryPolicy1 = Arrays.asList(stubSettings.createInstanceSettings(), stubSettings.updateInstanceSettings());
        List<UnaryCallSettings> callsWithNoRetryPolicy2 = Arrays.asList(stubSettings.setIamPolicySettings(), stubSettings.testIamPermissionsSettings());
        for (UnaryCallSettings callSettings : callsWithRetryPolicy1) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)withRetryPolicy1);
        }
        for (UnaryCallSettings callSettings : callsWithRetryPolicy2) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)withRetryPolicy2);
        }
        for (UnaryCallSettings callSettings : callsWithNoRetryPolicy1) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)noRetryPolicy1);
        }
        for (UnaryCallSettings callSettings : callsWithNoRetryPolicy2) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)noRetryPolicy2);
        }
    }

    @Test
    public void testInstanceAdminCustomRetrySettings() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)9999L)).setRetryDelayMultiplier(9999.99).setMaxRetryDelay(Duration.ofSeconds((long)9999L)).setInitialRpcTimeout(Duration.ofSeconds((long)9999L)).setRpcTimeoutMultiplier(9999.99).setMaxRpcTimeout(Duration.ofSeconds((long)9999L)).setTotalTimeout(Duration.ofSeconds((long)9999L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project");
        InstanceAdminStubSettings.Builder stubSettingsBuilder = builder.getInstanceAdminStubSettingsBuilder();
        List<UnaryCallSettings.Builder> unaryCallSettingsBuilders = Arrays.asList(stubSettingsBuilder.deleteInstanceSettings(), stubSettingsBuilder.getInstanceConfigSettings(), stubSettingsBuilder.getInstanceSettings(), stubSettingsBuilder.listInstanceConfigsSettings(), stubSettingsBuilder.listInstancesSettings());
        for (UnaryCallSettings.Builder callSettingsBuilder : unaryCallSettingsBuilders) {
            callSettingsBuilder.setRetrySettings(retrySettings);
        }
        SpannerOptions options = builder.build();
        InstanceAdminStubSettings stubSettings = options.getInstanceAdminStubSettings();
        List<UnaryCallSettings> callsWithDefaultSettings = Arrays.asList(stubSettings.getInstanceConfigSettings(), stubSettings.listInstanceConfigsSettings(), stubSettings.deleteInstanceSettings(), stubSettings.getInstanceSettings(), stubSettings.listInstancesSettings());
        for (UnaryCallSettings callSettings : callsWithDefaultSettings) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)retrySettings);
        }
    }

    @Test
    public void testInvalidTransport() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> SpannerOptions.newBuilder().setTransportOptions((TransportOptions)Mockito.mock(TransportOptions.class)));
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void testInvalidSessionLabels() {
        HashMap<String, Object> labels = new HashMap<String, Object>();
        labels.put("env", null);
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> SpannerOptions.newBuilder().setSessionLabels(labels));
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void testNullSessionLabels() {
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> SpannerOptions.newBuilder().setSessionLabels(null));
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void testDoNotCacheClosedSpannerInstance() {
        Spanner service2;
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setCredentials((Credentials)NoCredentials.getInstance())).build();
        Spanner service1 = (Spanner)options.getService();
        MatcherAssert.assertThat((Object)(service1 == (service2 = (Spanner)options.getService()) ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        Truth.assertThat((Boolean)service1.isClosed()).isFalse();
        service1.close();
        Spanner service3 = (Spanner)options.getService();
        MatcherAssert.assertThat((Object)(service3 == service1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)false));
        Truth.assertThat((Boolean)service1.isClosed()).isTrue();
        Truth.assertThat((Boolean)service3.isClosed()).isFalse();
        Spanner service4 = (Spanner)options.getService();
        MatcherAssert.assertThat((Object)(service3 == service4 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        Truth.assertThat((Boolean)service3.isClosed()).isFalse();
        service3.close();
    }

    @Test
    public void testSetClientLibToken() {
        String jdbcToken = "sp-jdbc";
        String hibernateToken = "sp-hib";
        String pgAdapterToken = "pg-adapter";
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)NoCredentials.getInstance())).setClientLibToken("sp-jdbc").build();
        Assert.assertEquals((Object)"sp-jdbc gccl", (Object)options.getClientLibToken());
        options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)NoCredentials.getInstance())).setClientLibToken("sp-hib").build();
        Assert.assertEquals((Object)"sp-hib gccl", (Object)options.getClientLibToken());
        options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)NoCredentials.getInstance())).setClientLibToken("pg-adapter").build();
        Assert.assertEquals((Object)"pg-adapter gccl", (Object)options.getClientLibToken());
        options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)NoCredentials.getInstance())).build();
        Assert.assertEquals((Object)options.getClientLibToken(), (Object)ServiceOptions.getGoogApiClientLibName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetInvalidClientLibToken() {
        ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)NoCredentials.getInstance())).setClientLibToken("foo");
    }

    @Test
    public void testSetEmulatorHostWithoutProtocol() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setEmulatorHost("localhost:1234").build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)"http://localhost:1234");
        Truth.assertThat((String)options.getEndpoint()).isEqualTo((Object)"localhost:1234");
    }

    @Test
    public void testSetEmulatorHostWithProtocol() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setEmulatorHost("http://localhost:1234").build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)"http://localhost:1234");
        Truth.assertThat((String)options.getEndpoint()).isEqualTo((Object)"localhost:1234");
    }

    @Test
    public void testDefaultQueryOptions() {
        SpannerOptions.useEnvironment((SpannerOptions.SpannerEnvironment)new SpannerOptions.SpannerEnvironment(){

            public String getOptimizerVersion() {
                return "";
            }

            @Nonnull
            public String getOptimizerStatisticsPackage() {
                return "";
            }
        });
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setDefaultQueryOptions(DatabaseId.of((String)"p", (String)"i", (String)"d"), ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).setProjectId("p")).setCredentials((Credentials)NoCredentials.getInstance())).build();
        Truth.assertThat((Object)options.getDefaultQueryOptions(DatabaseId.of((String)"p", (String)"i", (String)"d"))).isEqualTo((Object)ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build());
        Truth.assertThat((Object)options.getDefaultQueryOptions(DatabaseId.of((String)"p", (String)"i", (String)"o"))).isEqualTo((Object)ExecuteSqlRequest.QueryOptions.getDefaultInstance());
        SpannerOptions.useEnvironment((SpannerOptions.SpannerEnvironment)new SpannerOptions.SpannerEnvironment(){

            public String getOptimizerVersion() {
                return "2";
            }

            @Nonnull
            public String getOptimizerStatisticsPackage() {
                return "env-package";
            }
        });
        options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setDefaultQueryOptions(DatabaseId.of((String)"p", (String)"i", (String)"d"), ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).setProjectId("p")).setCredentials((Credentials)NoCredentials.getInstance())).build();
        Truth.assertThat((Object)options.getDefaultQueryOptions(DatabaseId.of((String)"p", (String)"i", (String)"d"))).isEqualTo((Object)ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("2").setOptimizerStatisticsPackage("env-package").build());
        Truth.assertThat((Object)options.getDefaultQueryOptions(DatabaseId.of((String)"p", (String)"i", (String)"o"))).isEqualTo((Object)ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("2").setOptimizerStatisticsPackage("env-package").build());
    }

    @Test
    public void testCompressorName() {
        Truth.assertThat((String)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).setCompressorName("gzip").build().getCompressorName()).isEqualTo((Object)"gzip");
        Truth.assertThat((String)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).setCompressorName("identity").build().getCompressorName()).isEqualTo((Object)"identity");
        Assert.assertNull((Object)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).setCompressorName(null).build().getCompressorName());
        Assert.assertThrows(IllegalArgumentException.class, () -> SpannerOptions.newBuilder().setCompressorName("foo"));
    }

    @Test
    public void testLeaderAwareRoutingEnablement() {
        Assert.assertTrue((boolean)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).build().isLeaderAwareRoutingEnabled());
        Assert.assertTrue((boolean)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).enableLeaderAwareRouting().build().isLeaderAwareRoutingEnabled());
        Assert.assertFalse((boolean)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).disableLeaderAwareRouting().build().isLeaderAwareRoutingEnabled());
    }

    @Test
    public void testSetDirectedReadOptions() {
        DirectedReadOptions directedReadOptions = DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setLocation("us-west1").build()).build()).build();
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setDirectedReadOptions(directedReadOptions).build();
        Assert.assertEquals((Object)options.getDirectedReadOptions(), (Object)directedReadOptions);
        Assert.assertThrows(NullPointerException.class, () -> SpannerOptions.newBuilder().setDirectedReadOptions(null).build());
    }

    @Test
    public void testSpannerCallContextTimeoutConfigurator_NullValues() {
        SpannerOptions.SpannerCallContextTimeoutConfigurator configurator = SpannerOptions.SpannerCallContextTimeoutConfigurator.create();
        GrpcCallContext inputCallContext = GrpcCallContext.createDefault();
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)BatchCreateSessionsRequest.getDefaultInstance(), SpannerGrpc.getBatchCreateSessionsMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)CreateSessionRequest.getDefaultInstance(), SpannerGrpc.getCreateSessionMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)DeleteSessionRequest.getDefaultInstance(), SpannerGrpc.getDeleteSessionMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)DeleteSessionRequest.getDefaultInstance(), SpannerGrpc.getDeleteSessionMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)ListSessionsRequest.getDefaultInstance(), SpannerGrpc.getListSessionsMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)BeginTransactionRequest.getDefaultInstance(), SpannerGrpc.getBeginTransactionMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)CommitRequest.getDefaultInstance(), SpannerGrpc.getCommitMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)RollbackRequest.getDefaultInstance(), SpannerGrpc.getRollbackMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)ExecuteSqlRequest.getDefaultInstance(), SpannerGrpc.getExecuteSqlMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)ExecuteSqlRequest.getDefaultInstance(), SpannerGrpc.getExecuteStreamingSqlMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)ExecuteBatchDmlRequest.getDefaultInstance(), SpannerGrpc.getExecuteBatchDmlMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)ReadRequest.getDefaultInstance(), SpannerGrpc.getReadMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)ReadRequest.getDefaultInstance(), SpannerGrpc.getStreamingReadMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)PartitionQueryRequest.getDefaultInstance(), SpannerGrpc.getPartitionQueryMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)PartitionReadRequest.getDefaultInstance(), SpannerGrpc.getPartitionReadMethod()));
    }

    @Test
    public void testSpannerCallContextTimeoutConfigurator_WithTimeouts() {
        SpannerOptions.SpannerCallContextTimeoutConfigurator configurator = SpannerOptions.SpannerCallContextTimeoutConfigurator.create();
        configurator.withBatchUpdateTimeout(Duration.ofSeconds((long)1L));
        configurator.withCommitTimeout(Duration.ofSeconds((long)2L));
        configurator.withExecuteQueryTimeout(Duration.ofSeconds((long)3L));
        configurator.withExecuteUpdateTimeout(Duration.ofSeconds((long)4L));
        configurator.withPartitionQueryTimeout(Duration.ofSeconds((long)5L));
        configurator.withPartitionReadTimeout(Duration.ofSeconds((long)6L));
        configurator.withReadTimeout(Duration.ofSeconds((long)7L));
        configurator.withRollbackTimeout(Duration.ofSeconds((long)8L));
        GrpcCallContext inputCallContext = GrpcCallContext.createDefault();
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)BatchCreateSessionsRequest.getDefaultInstance(), SpannerGrpc.getBatchCreateSessionsMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)CreateSessionRequest.getDefaultInstance(), SpannerGrpc.getCreateSessionMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)DeleteSessionRequest.getDefaultInstance(), SpannerGrpc.getDeleteSessionMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)DeleteSessionRequest.getDefaultInstance(), SpannerGrpc.getDeleteSessionMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)ListSessionsRequest.getDefaultInstance(), SpannerGrpc.getListSessionsMethod()));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)BeginTransactionRequest.getDefaultInstance(), SpannerGrpc.getBeginTransactionMethod()));
        Truth.assertThat((Comparable)configurator.configure((ApiCallContext)inputCallContext, (Object)CommitRequest.getDefaultInstance(), SpannerGrpc.getCommitMethod()).getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)2L));
        Truth.assertThat((Comparable)configurator.configure((ApiCallContext)inputCallContext, (Object)RollbackRequest.getDefaultInstance(), SpannerGrpc.getRollbackMethod()).getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)8L));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)ExecuteSqlRequest.getDefaultInstance(), SpannerGrpc.getExecuteSqlMethod()));
        Truth.assertThat((Comparable)configurator.configure((ApiCallContext)inputCallContext, (Object)ExecuteSqlRequest.getDefaultInstance(), SpannerGrpc.getExecuteStreamingSqlMethod()).getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)3L));
        Truth.assertThat((Comparable)configurator.configure((ApiCallContext)inputCallContext, (Object)ExecuteBatchDmlRequest.getDefaultInstance(), SpannerGrpc.getExecuteBatchDmlMethod()).getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)1L));
        Assert.assertNull((Object)configurator.configure((ApiCallContext)inputCallContext, (Object)ReadRequest.getDefaultInstance(), SpannerGrpc.getReadMethod()));
        Truth.assertThat((Comparable)configurator.configure((ApiCallContext)inputCallContext, (Object)ReadRequest.getDefaultInstance(), SpannerGrpc.getStreamingReadMethod()).getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)7L));
        Truth.assertThat((Comparable)configurator.configure((ApiCallContext)inputCallContext, (Object)PartitionQueryRequest.getDefaultInstance(), SpannerGrpc.getPartitionQueryMethod()).getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)5L));
        Truth.assertThat((Comparable)configurator.configure((ApiCallContext)inputCallContext, (Object)PartitionReadRequest.getDefaultInstance(), SpannerGrpc.getPartitionReadMethod()).getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)6L));
    }

    @Test
    public void testCustomAsyncExecutorProvider() {
        ScheduledExecutorService service = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setCredentials((Credentials)NoCredentials.getInstance())).setAsyncExecutorProvider((SpannerOptions.CloseableExecutorProvider)SpannerOptions.FixedCloseableExecutorProvider.create((ScheduledExecutorService)service)).build();
        Assert.assertSame((Object)service, (Object)options.getAsyncExecutorProvider().getExecutor());
    }

    @Test
    public void testAsyncExecutorProviderCoreThreadCount() throws Exception {
        Assert.assertEquals((long)8L, (long)SpannerOptions.getDefaultAsyncExecutorProviderCoreThreadCount());
        String propertyName = "com.google.cloud.spanner.async_num_core_threads";
        Assert.assertEquals((Object)8, (Object)SpannerOptionsTest.runWithSystemProperty(propertyName, null, SpannerOptions::getDefaultAsyncExecutorProviderCoreThreadCount));
        Assert.assertEquals((Object)16, (Object)SpannerOptionsTest.runWithSystemProperty(propertyName, "16", SpannerOptions::getDefaultAsyncExecutorProviderCoreThreadCount));
        Assert.assertEquals((Object)1, (Object)SpannerOptionsTest.runWithSystemProperty(propertyName, "1", SpannerOptions::getDefaultAsyncExecutorProviderCoreThreadCount));
        Assert.assertThrows(SpannerException.class, () -> SpannerOptionsTest.runWithSystemProperty(propertyName, "foo", SpannerOptions::getDefaultAsyncExecutorProviderCoreThreadCount));
        Assert.assertThrows(SpannerException.class, () -> SpannerOptionsTest.runWithSystemProperty(propertyName, "-1", SpannerOptions::getDefaultAsyncExecutorProviderCoreThreadCount));
        Assert.assertThrows(SpannerException.class, () -> SpannerOptionsTest.runWithSystemProperty(propertyName, "", SpannerOptions::getDefaultAsyncExecutorProviderCoreThreadCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <V> V runWithSystemProperty(String propertyName, String propertyValue, Callable<V> callable) throws Exception {
        String currentValue = System.getProperty(propertyName);
        if (propertyValue == null) {
            System.clearProperty(propertyName);
        } else {
            System.setProperty(propertyName, propertyValue);
        }
        try {
            V v = callable.call();
            return v;
        }
        finally {
            if (currentValue == null) {
                System.clearProperty(propertyName);
            } else {
                System.setProperty(propertyName, currentValue);
            }
        }
    }

    @Test
    public void testDefaultNumChannelsWithGrpcGcpExtensionEnabled() {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setCredentials((Credentials)NoCredentials.getInstance())).enableGrpcGcpExtension().build();
        Assert.assertEquals((long)8L, (long)options.getNumChannels());
    }

    @Test
    public void testDefaultNumChannelsWithGrpcGcpExtensionDisabled() {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setCredentials((Credentials)NoCredentials.getInstance())).build();
        Assert.assertEquals((long)4L, (long)options.getNumChannels());
    }

    @Test
    public void testNumChannelsWithGrpcGcpExtensionEnabled() {
        int numChannels = 5;
        SpannerOptions options1 = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setCredentials((Credentials)NoCredentials.getInstance())).setNumChannels(numChannels).enableGrpcGcpExtension().build();
        Assert.assertEquals((long)numChannels, (long)options1.getNumChannels());
        SpannerOptions options2 = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setCredentials((Credentials)NoCredentials.getInstance())).enableGrpcGcpExtension().setNumChannels(numChannels).build();
        Assert.assertEquals((long)numChannels, (long)options2.getNumChannels());
    }

    @Test
    public void checkCreatedInstanceWhenGrpcGcpExtensionDisabled() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        SpannerOptions options1 = options.toBuilder().build();
        Assert.assertEquals((Object)false, (Object)options.isGrpcGcpExtensionEnabled());
        Assert.assertEquals((Object)options.isGrpcGcpExtensionEnabled(), (Object)options1.isGrpcGcpExtensionEnabled());
        Spanner spanner1 = (Spanner)options.getService();
        Spanner spanner2 = (Spanner)options1.getService();
        Assert.assertNotSame((Object)spanner1, (Object)spanner2);
        spanner1.close();
        spanner2.close();
    }

    @Test
    public void checkCreatedInstanceWhenGrpcGcpExtensionEnabled() {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setCredentials((Credentials)NoCredentials.getInstance())).enableGrpcGcpExtension().build();
        SpannerOptions options1 = options.toBuilder().build();
        Assert.assertEquals((Object)true, (Object)options.isGrpcGcpExtensionEnabled());
        Assert.assertEquals((Object)options.isGrpcGcpExtensionEnabled(), (Object)options1.isGrpcGcpExtensionEnabled());
        Spanner spanner1 = (Spanner)options.getService();
        Spanner spanner2 = (Spanner)options1.getService();
        Assert.assertNotSame((Object)spanner1, (Object)spanner2);
        spanner1.close();
        spanner2.close();
    }

    @Test
    public void checkGlobalOpenTelemetryWhenNotInjected() {
        GlobalOpenTelemetry.resetForTest();
        InMemoryMetricReader inMemoryMetricReader = InMemoryMetricReader.create();
        SdkMeterProvider sdkMeterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)inMemoryMetricReader).build();
        OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProvider).buildAndRegisterGlobal();
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setCredentials((Credentials)NoCredentials.getInstance())).build();
        Assert.assertEquals((Object)GlobalOpenTelemetry.get(), (Object)options.getOpenTelemetry());
    }
}

