/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ForceCloseSpannerFunction;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.admin.database.v1.MockDatabaseAdminImpl;
import com.google.cloud.spanner.admin.instance.v1.MockInstanceAdminImpl;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.ITConnectionImpl;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsGrpc;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.Value;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class AbstractMockServerTest {
    public static final long COUNT_BEFORE_INSERT = 0L;
    public static final long COUNT_AFTER_INSERT = 1L;
    public static final Statement SELECT_COUNT_STATEMENT = Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1");
    protected static final Statement SELECT1_STATEMENT = Statement.of((String)"SELECT 1");
    private static final ResultSetMetadata SINGLE_COL_INT64_RESULTSET_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("C").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    public static final ResultSet SELECT_COUNT_RESULTSET_BEFORE_INSERT = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue(String.valueOf(0L)).build()).build()).setMetadata(SINGLE_COL_INT64_RESULTSET_METADATA).build();
    public static final ResultSet SELECT_COUNT_RESULTSET_AFTER_INSERT = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue(String.valueOf(1L)).build()).build()).setMetadata(SINGLE_COL_INT64_RESULTSET_METADATA).build();
    public static final ResultSet UPDATE_RETURNING_RESULTSET = ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L)).setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("col").setType(Type.newBuilder().setCodeValue(2)).build()))).build();
    protected static final ResultSet SELECT1_RESULTSET = ResultSet.newBuilder().setMetadata(SINGLE_COL_INT64_RESULTSET_METADATA).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).build();
    public static final Statement INSERT_STATEMENT = Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')");
    public static final Statement INSERT_RETURNING_STATEMENT = Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted') THEN RETURN *");
    public static final Statement PG_INSERT_RETURNING_STATEMENT = Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted') RETURNING *");
    public static final long UPDATE_COUNT = 1L;
    public static final int RANDOM_RESULT_SET_ROW_COUNT = 100;
    public static final Statement SELECT_RANDOM_STATEMENT = Statement.of((String)"SELECT * FROM RANDOM");
    public static final ResultSet RANDOM_RESULT_SET = new RandomResultSetGenerator(100).generate();
    public static MockSpannerServiceImpl mockSpanner;
    public static MockInstanceAdminImpl mockInstanceAdmin;
    public static MockDatabaseAdminImpl mockDatabaseAdmin;
    public static OperationsGrpc.OperationsImplBase mockOperations;
    private static Server server;
    private static InetSocketAddress address;
    private static boolean futureParentHandlers;
    private static boolean exceptionRunnableParentHandlers;
    private static boolean nettyServerParentHandlers;
    private static boolean clientStreamParentHandlers;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockInstanceAdmin = new MockInstanceAdminImpl();
        mockDatabaseAdmin = new MockDatabaseAdminImpl();
        mockOperations = new OperationsGrpc.OperationsImplBase(){

            public void getOperation(GetOperationRequest request, StreamObserver<Operation> responseObserver) {
                responseObserver.onNext((Object)Operation.newBuilder().setDone(false).setName(request.getName()).setMetadata(Any.pack((Message)Empty.getDefaultInstance())).build());
                responseObserver.onCompleted();
            }
        };
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).addService((BindableService)mockInstanceAdmin)).addService((BindableService)mockDatabaseAdmin)).addService((BindableService)mockOperations)).build().start();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_BEFORE_INSERT));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.updateReturning(INSERT_RETURNING_STATEMENT, UPDATE_RETURNING_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.updateReturning(PG_INSERT_RETURNING_STATEMENT, UPDATE_RETURNING_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_RANDOM_STATEMENT, RANDOM_RESULT_SET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1_STATEMENT, SELECT1_RESULTSET));
        futureParentHandlers = Logger.getLogger(AbstractFuture.class.getName()).getUseParentHandlers();
        exceptionRunnableParentHandlers = Logger.getLogger(LogExceptionRunnable.class.getName()).getUseParentHandlers();
        nettyServerParentHandlers = Logger.getLogger("io.grpc.netty.shaded.io.grpc.netty.NettyServerHandler").getUseParentHandlers();
        clientStreamParentHandlers = Logger.getLogger("io.grpc.netty.shaded.io.grpc.netty.NettyServerHandler").getUseParentHandlers();
        Logger.getLogger(AbstractFuture.class.getName()).setUseParentHandlers(false);
        Logger.getLogger(LogExceptionRunnable.class.getName()).setUseParentHandlers(false);
        Logger.getLogger("io.grpc.netty.shaded.io.grpc.netty.NettyServerHandler").setUseParentHandlers(false);
        Logger.getLogger("io.grpc.internal.AbstractClientStream").setUseParentHandlers(false);
    }

    @AfterClass
    public static void stopServer() {
        try {
            SpannerPool.INSTANCE.checkAndCloseSpanners(SpannerPool.CheckAndCloseSpannersMode.ERROR, (Function)new ForceCloseSpannerFunction(500L, TimeUnit.MILLISECONDS));
        }
        finally {
            Logger.getLogger(AbstractFuture.class.getName()).setUseParentHandlers(futureParentHandlers);
            Logger.getLogger(LogExceptionRunnable.class.getName()).setUseParentHandlers(exceptionRunnableParentHandlers);
            Logger.getLogger("io.grpc.netty.shaded.io.grpc.netty.NettyServerHandler").setUseParentHandlers(nettyServerParentHandlers);
            Logger.getLogger("io.grpc.internal.AbstractClientStream").setUseParentHandlers(clientStreamParentHandlers);
        }
        server.shutdown();
    }

    @Before
    public void setupResults() {
        mockSpanner.clearRequests();
        mockDatabaseAdmin.getRequests().clear();
        mockInstanceAdmin.getRequests().clear();
    }

    protected Connection createJdbcConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:" + this.getBaseUrl());
    }

    ITAbstractSpannerTest.ITConnection createConnection() {
        return this.createConnection(Collections.emptyList(), Collections.emptyList());
    }

    ITAbstractSpannerTest.ITConnection createConnection(String additionalUrlOptions) {
        return this.createConnection(Collections.emptyList(), Collections.emptyList(), additionalUrlOptions);
    }

    ITAbstractSpannerTest.ITConnection createConnection(ITAbstractSpannerTest.AbortInterceptor interceptor, TransactionRetryListener transactionRetryListener) {
        return this.createConnection(Collections.singletonList(interceptor), Collections.singletonList(transactionRetryListener));
    }

    ITAbstractSpannerTest.ITConnection createConnection(List<StatementExecutionInterceptor> interceptors, List<TransactionRetryListener> transactionRetryListeners) {
        return this.createConnection(interceptors, transactionRetryListeners, "");
    }

    ITAbstractSpannerTest.ITConnection createConnection(List<StatementExecutionInterceptor> interceptors, List<TransactionRetryListener> transactionRetryListeners, String additionalUrlOptions) {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder().setUri(this.getBaseUrl() + additionalUrlOptions).setStatementExecutionInterceptors(interceptors);
        ConnectionOptions options = builder.build();
        ITAbstractSpannerTest.ITConnection connection = this.createITConnection(options);
        for (TransactionRetryListener listener : transactionRetryListeners) {
            connection.addTransactionRetryListener(listener);
        }
        return connection;
    }

    protected String getBaseUrl() {
        return String.format("cloudspanner://localhost:%d/projects/proj/instances/inst/databases/db?usePlainText=true;autocommit=false;retryAbortsInternally=true", server.getPort());
    }

    protected int getPort() {
        return server.getPort();
    }

    protected ExecuteSqlRequest getLastExecuteSqlRequest() {
        List<AbstractMessage> requests = mockSpanner.getRequests();
        for (int i = requests.size() - 1; i >= 0; --i) {
            if (!(requests.get(i) instanceof ExecuteSqlRequest)) continue;
            return (ExecuteSqlRequest)requests.get(i);
        }
        throw new IllegalStateException("No ExecuteSqlRequest found in requests");
    }

    ITAbstractSpannerTest.ITConnection createITConnection(ConnectionOptions options) {
        return new ITConnectionImpl(options);
    }

    boolean isMultiplexedSessionsEnabled(Spanner spanner) {
        if (spanner.getOptions() == null || ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions() == null) {
            return false;
        }
        return ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession();
    }
}

