/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.connection.StatementHintParser;
import com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StatementHintParserTest {
    @Parameterized.Parameter
    public Dialect dialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    StatementHintParser parserFor(String sql) {
        return new StatementHintParser(this.dialect, sql);
    }

    String getStartHint() {
        return this.dialect == Dialect.POSTGRESQL ? "/*@" : "@{";
    }

    String getEndHint() {
        return this.dialect == Dialect.POSTGRESQL ? "*/" : "}";
    }

    String encloseInHint(String sql) {
        return this.getStartHint() + sql + this.getEndHint();
    }

    @Test
    public void testNoHints() {
        Assert.assertFalse((boolean)this.parserFor("select foo from bar").hasStatementHints());
        Assert.assertFalse((boolean)this.parserFor("/* comment */ select foo from bar").hasStatementHints());
        Assert.assertFalse((boolean)this.parserFor("select foo from bar").hasStatementHints());
        Assert.assertFalse((boolean)this.parserFor("select foo from bar").hasStatementHints());
    }

    @Test
    public void testExtractHints() {
        StatementHintParser parser = this.parserFor(this.encloseInHint("statement_tag=tag1") + " select 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"statement_tag", (Object)"tag1"), (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)" select 1", (Object)parser.getSqlWithoutClientSideHints());
        parser = this.parserFor(this.encloseInHint("statement_tag=tag1, other_hint=value") + " select 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"statement_tag", (Object)"tag1"), (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)(this.encloseInHint(" other_hint=value") + " select 1"), (Object)parser.getSqlWithoutClientSideHints());
        parser = this.parserFor(this.encloseInHint("other_hint=value") + " select 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)StatementHintParser.NO_HINTS, (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)(this.encloseInHint("other_hint=value") + " select 1"), (Object)parser.getSqlWithoutClientSideHints());
        parser = this.parserFor(this.encloseInHint("statement_tag=tag1, rpc_priority=high") + " select 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"statement_tag", (Object)"tag1", (Object)"rpc_priority", (Object)"high"), (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)" select 1", (Object)parser.getSqlWithoutClientSideHints());
        parser = this.parserFor(this.encloseInHint("rpc_priority=medium, statement_tag='value 2'") + " select 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"rpc_priority", (Object)"medium", (Object)"statement_tag", (Object)"value 2"), (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)" select 1", (Object)parser.getSqlWithoutClientSideHints());
        parser = this.parserFor("/* comment */ " + this.encloseInHint("/*comment*/statement_tag--comment\n=--comment\nvalue1\n,rpc_priority=Low/*comment*/") + " /* yet another comment */ select 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"statement_tag", (Object)"value1", (Object)"rpc_priority", (Object)"Low"), (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)" /* yet another comment */ select 1", (Object)parser.getSqlWithoutClientSideHints());
        parser = this.parserFor("/* comment */ " + this.encloseInHint("/*comment*/statement_tag--comment\n=--comment\nvalue1\n,/* other hint comment */ other_hint='some value',\nrpc_priority=Low/*comment*/") + " /* yet another comment */ select 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"statement_tag", (Object)"value1", (Object)"rpc_priority", (Object)"Low"), (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)("/* comment */ " + this.encloseInHint("/*comment*//* other hint comment */ other_hint='some value',\n/*comment*/") + " /* yet another comment */ select 1"), (Object)parser.getSqlWithoutClientSideHints());
        parser = this.parserFor(this.encloseInHint("statement_tag=tag1,\nother_hint1='some value',\nrpc_priority=low,\nother_hint2=value") + "\nselect 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"statement_tag", (Object)"tag1", (Object)"rpc_priority", (Object)"low"), (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)(this.encloseInHint("\nother_hint1='some value',\n\nother_hint2=value") + "\nselect 1"), (Object)parser.getSqlWithoutClientSideHints());
        parser = this.parserFor(this.encloseInHint("hint1=value1,\nother_hint1='some value',\nrpc_priority=low,\nother_hint2=value") + "\nselect 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"rpc_priority", (Object)"low"), (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)(this.encloseInHint("hint1=value1,\nother_hint1='some value',\n\nother_hint2=value") + "\nselect 1"), (Object)parser.getSqlWithoutClientSideHints());
        parser = this.parserFor(this.encloseInHint("hint1=value1,\nhint2=value2,\nrpc_priority=low,\nstatement_tag=tag") + "\nselect 1");
        Assert.assertTrue((boolean)parser.hasStatementHints());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"rpc_priority", (Object)"low", (Object)"statement_tag", (Object)"tag"), (Object)parser.getClientSideStatementHints());
        Assert.assertEquals((Object)(this.encloseInHint("hint1=value1,\nhint2=value2,\n\n") + "\nselect 1"), (Object)parser.getSqlWithoutClientSideHints());
    }

    @Test
    public void testExtractInvalidHints() {
        this.assertInvalidHints("@{statement_tag=value value}");
        this.assertInvalidHints("@statement_tag=value");
        this.assertInvalidHints("{statement_tag=value}");
        this.assertInvalidHints("@{statement_tag=value");
        this.assertInvalidHints("@{statement_tag=value,");
        this.assertInvalidHints("@{statement_tag=value,}");
        this.assertInvalidHints("@statement_tag=value}");
        this.assertInvalidHints("@{statement_tag=}");
        this.assertInvalidHints("@{=value}");
        this.assertInvalidHints("@{}");
        this.assertInvalidHints("@{statement_tag=value,}");
        this.assertInvalidHints("@{statement_tag=value1,hint2=value2,}");
        this.assertInvalidHints("@{@statement_tag=value1}");
        this.assertInvalidHints("@{statement_tag=@value1}");
        this.assertInvalidHints("@{statement_tag value1}");
        this.assertInvalidHints("@{statement_tag='value1}");
        this.assertInvalidHints("@{statement_tag=value1'}");
    }

    private void assertInvalidHints(String sql) {
        StatementHintParser parser = this.parserFor(sql);
        Assert.assertEquals((Object)StatementHintParser.NO_HINTS, (Object)parser.getClientSideStatementHints());
        Assert.assertSame((Object)sql, (Object)parser.getSqlWithoutClientSideHints());
    }
}

