/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class SpanExceptionTest
extends AbstractMockServerTest {
    @Test
    public void testReadOnlyTransaction() throws InterruptedException, ExecutionException {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("my-project")).setHost(String.format("http://localhost:%d", this.getPort())).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMaxSessions(10).setAcquireSessionTimeout(Duration.ofMillis((long)10L)).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            int numThreads = 25;
            ExecutorService service = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(numThreads);
            try (ReadOnlyTransaction readOnlyTransaction = client.readOnlyTransaction();){
                for (int i = 0; i < numThreads; ++i) {
                    futures.add(service.submit(() -> this.executeRandom(readOnlyTransaction)));
                }
                service.shutdown();
                Assert.assertTrue((boolean)service.awaitTermination(60L, TimeUnit.SECONDS));
                for (Future future : futures) {
                    Assert.assertNull(future.get());
                }
            }
        }
    }

    private Void executeRandom(ReadOnlyTransaction readOnlyTransaction) {
        try (ResultSet resultSet = readOnlyTransaction.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
        catch (SpannerException spannerException) {
            if (spannerException.getErrorCode() == ErrorCode.RESOURCE_EXHAUSTED) {
                return null;
            }
            throw spannerException;
        }
        return null;
    }
}

