/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.connection.DirectedReadOptionsUtil;
import com.google.spanner.v1.DirectedReadOptions;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DirectedReadOptionsUtilTest {
    @Test
    public void testToString() {
        this.assertRoundTrip("", DirectedReadOptions.newBuilder().build());
        this.assertRoundTrip("{\"includeReplicas\":{}}", DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().build()).build());
        this.assertRoundTrip("{\"includeReplicas\":{\"replicaSelections\":[{\"location\":\"eu-west1\",\"type\":\"READ_ONLY\"}]}}", DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setType(DirectedReadOptions.ReplicaSelection.Type.READ_ONLY).setLocation("eu-west1").build()).build()).build());
        this.assertRoundTrip("{\"excludeReplicas\":{\"replicaSelections\":[{\"location\":\"eu-west1\",\"type\":\"READ_ONLY\"}]}}", DirectedReadOptions.newBuilder().setExcludeReplicas(DirectedReadOptions.ExcludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setType(DirectedReadOptions.ReplicaSelection.Type.READ_ONLY).setLocation("eu-west1").build()).build()).build());
    }

    private void assertRoundTrip(String json, DirectedReadOptions options) {
        TestCase.assertEquals((String)json, (String)DirectedReadOptionsUtil.toString((DirectedReadOptions)options));
        TestCase.assertEquals((Object)options, (Object)DirectedReadOptionsUtil.parse((String)json));
    }
}

