/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ReadOnlyStalenessConverterTest;
import com.google.protobuf.Duration;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DurationConverterTest {
    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        String allowedValues = ReadOnlyStalenessConverterTest.getAllowedValues(ClientSideStatementValueConverters.DurationConverter.class, Dialect.GOOGLE_STANDARD_SQL);
        MatcherAssert.assertThat((Object)allowedValues, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ClientSideStatementValueConverters.DurationConverter converter = new ClientSideStatementValueConverters.DurationConverter(allowedValues);
        MatcherAssert.assertThat((Object)converter.convert("'100ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.newBuilder().setNanos((int)TimeUnit.MILLISECONDS.toNanos(100L)).build())));
        MatcherAssert.assertThat((Object)converter.convert("'0ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'-100ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'315576000000000ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.newBuilder().setSeconds(315576000000L).build())));
        MatcherAssert.assertThat((Object)converter.convert("'1000ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.newBuilder().setSeconds(1L).build())));
        MatcherAssert.assertThat((Object)converter.convert("'1001ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.newBuilder().setSeconds(1L).setNanos((int)TimeUnit.MILLISECONDS.toNanos(1L)).build())));
        MatcherAssert.assertThat((Object)converter.convert("'1ns'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.newBuilder().setNanos(1).build())));
        MatcherAssert.assertThat((Object)converter.convert("'1us'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.newBuilder().setNanos(1000).build())));
        MatcherAssert.assertThat((Object)converter.convert("'1ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.newBuilder().setNanos(1000000).build())));
        MatcherAssert.assertThat((Object)converter.convert("'999999999ns'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.newBuilder().setNanos(999999999).build())));
        MatcherAssert.assertThat((Object)converter.convert("'1s'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.newBuilder().setSeconds(1L).build())));
        MatcherAssert.assertThat((Object)converter.convert("''"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("' '"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'random string'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("null"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.getDefaultInstance())));
        MatcherAssert.assertThat((Object)converter.convert("NULL"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.getDefaultInstance())));
        MatcherAssert.assertThat((Object)converter.convert("Null"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.getDefaultInstance())));
        MatcherAssert.assertThat((Object)converter.convert("'null'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'NULL'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'Null'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

