/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExcludeTxnFromChangeStreamsMockServerTest
extends AbstractMockServerTest {
    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testAutoCommit_includedByDefault() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.executeUpdate(INSERT_STATEMENT);
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasTransaction());
        Assert.assertTrue((boolean)request.getTransaction().hasBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertFalse((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testAutoCommitUpdate() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setExcludeTxnFromChangeStreams(true);
            connection.executeUpdate(INSERT_STATEMENT);
            Assert.assertFalse((boolean)connection.isExcludeTxnFromChangeStreams());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasTransaction());
        Assert.assertTrue((boolean)request.getTransaction().hasBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testAutoCommitBatchDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setExcludeTxnFromChangeStreams(true);
            connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
            Assert.assertFalse((boolean)connection.isExcludeTxnFromChangeStreams());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasTransaction());
        Assert.assertTrue((boolean)request.getTransaction().hasBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testAutoCommitUpdateReturning() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setExcludeTxnFromChangeStreams(true);
            connection.executeQuery(INSERT_RETURNING_STATEMENT, new Options.QueryOption[0]);
            Assert.assertFalse((boolean)connection.isExcludeTxnFromChangeStreams());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasTransaction());
        Assert.assertTrue((boolean)request.getTransaction().hasBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testPartitionedDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            connection.setExcludeTxnFromChangeStreams(true);
            connection.executeUpdate(INSERT_STATEMENT);
            Assert.assertFalse((boolean)connection.isExcludeTxnFromChangeStreams());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        BeginTransactionRequest request = mockSpanner.getRequestsOfType(BeginTransactionRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasOptions());
        Assert.assertTrue((boolean)request.getOptions().hasPartitionedDml());
        Assert.assertTrue((boolean)request.getOptions().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testTransaction_includedByDefault() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasTransaction());
        Assert.assertTrue((boolean)request.getTransaction().hasBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertFalse((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testTransactionUpdate() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setExcludeTxnFromChangeStreams(true);
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
            Assert.assertFalse((boolean)connection.isExcludeTxnFromChangeStreams());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasTransaction());
        Assert.assertTrue((boolean)request.getTransaction().hasBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testTransactionBatchDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setExcludeTxnFromChangeStreams(true);
            connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
            connection.commit();
            Assert.assertFalse((boolean)connection.isExcludeTxnFromChangeStreams());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasTransaction());
        Assert.assertTrue((boolean)request.getTransaction().hasBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testTransactionUpdateReturning() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setExcludeTxnFromChangeStreams(true);
            connection.executeQuery(INSERT_RETURNING_STATEMENT, new Options.QueryOption[0]);
            connection.commit();
            Assert.assertFalse((boolean)connection.isExcludeTxnFromChangeStreams());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertTrue((boolean)request.hasTransaction());
        Assert.assertTrue((boolean)request.getTransaction().hasBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testSqlStatements() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.execute(Statement.of((String)"set exclude_txn_from_change_streams = true"));
            Assert.assertTrue((boolean)connection.isExcludeTxnFromChangeStreams());
            try (ResultSet resultSet = connection.execute(Statement.of((String)"show variable exclude_txn_from_change_streams")).getResultSet();){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertTrue((boolean)resultSet.getBoolean("EXCLUDE_TXN_FROM_CHANGE_STREAMS"));
                Assert.assertFalse((boolean)resultSet.next());
            }
            connection.setAutocommit(false);
            connection.execute(Statement.of((String)"set exclude_txn_from_change_streams = true"));
            Assert.assertTrue((boolean)connection.isExcludeTxnFromChangeStreams());
            connection.execute(INSERT_STATEMENT);
            Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)"set exclude_txn_from_change_streams=false")));
        }
    }
}

