/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.Repeat;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Duration;
import com.google.spanner.v1.CommitRequest;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MaxCommitDelayTest
extends AbstractMockServerTest {
    @Parameterized.Parameter
    public Dialect dialect;
    private Dialect currentDialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Collection<Object[]> data() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Dialect dialect : Dialect.values()) {
            builder.add((Object)new Object[]{dialect});
        }
        return builder.build();
    }

    @Before
    public void setupDialect() {
        if (this.currentDialect != this.dialect) {
            SpannerPool.closeSpannerPool();
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(this.dialect));
            this.currentDialect = this.dialect;
        }
    }

    private Mutation createMutation() {
        return ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).build();
    }

    private String getVariablePrefix() {
        return this.dialect == Dialect.POSTGRESQL ? "spanner." : "";
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testNoMaxCommitDelayByDefault() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                this.executeCommit(connection);
                this.assertMaxCommitDelay(Duration.getDefaultInstance());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testMaxCommitDelayInConnectionString() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(";maxCommitDelay=1000");){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                this.executeCommit(connection);
                this.assertMaxCommitDelay(Duration.newBuilder().setSeconds(1L).build());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testSetMaxCommitDelay() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                for (boolean useSql : new boolean[]{true, false}) {
                    connection.setAutocommit(autocommit);
                    if (useSql) {
                        connection.execute(Statement.of((String)String.format("set %smax_commit_delay='40ms'", this.getVariablePrefix())));
                    } else {
                        connection.setMaxCommitDelay(java.time.Duration.of(40000L, ChronoUnit.MICROS));
                    }
                    Repeat.twice(() -> {
                        this.executeCommit(connection);
                        this.assertMaxCommitDelay(Duration.newBuilder().setNanos((int)TimeUnit.MILLISECONDS.toNanos(40L)).build());
                        mockSpanner.clearRequests();
                    });
                    if (useSql) {
                        connection.execute(Statement.of((String)String.format("set %smax_commit_delay=null", this.getVariablePrefix())));
                    } else {
                        connection.setMaxCommitDelay(null);
                    }
                    this.executeCommit(connection);
                    this.assertMaxCommitDelay(Duration.getDefaultInstance());
                    mockSpanner.clearRequests();
                }
            }
        }
    }

    void executeCommit(Connection connection) {
        if (connection.isAutocommit()) {
            connection.write(this.createMutation());
        } else {
            connection.bufferedWrite(this.createMutation());
            connection.commit();
        }
    }

    private void assertMaxCommitDelay(Duration expected) {
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        TestCase.assertEquals((int)1, (int)requests.size());
        CommitRequest request = requests.get(0);
        TestCase.assertEquals((Object)expected, (Object)request.getMaxCommitDelay());
    }
}

