/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.PartitionId;
import com.google.cloud.spanner.connection.PartitionedQueryResultSet;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartitionQueryRequest;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PartitionedQueryMockServerTest
extends AbstractMockServerTest {
    @Parameterized.Parameter
    public Dialect dialect;
    private Dialect currentDialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    @Before
    public void setupDialect() {
        if (this.currentDialect != this.dialect) {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(this.dialect));
            SpannerPool.closeSpannerPool();
            this.currentDialect = this.dialect;
        }
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testPartitionQuery() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            for (int i = 0; i < 2; ++i) {
                try (ResultSet resultSet = connection.partitionQuery(((Statement.Builder)Statement.newBuilder((String)"select * from my_table where id=@id").bind("p1").to(1L)).build(), PartitionOptions.newBuilder().build(), new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((long)1L, (long)resultSet.getColumnCount());
                    PartitionId partitionId = PartitionId.decodeFromString((String)resultSet.getString("PARTITION"));
                    Assert.assertNotNull((Object)partitionId);
                    Assert.assertFalse((boolean)resultSet.next());
                    continue;
                }
            }
            if (this.isMultiplexedSessionsEnabled(connection.getSpanner())) {
                Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            } else {
                Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            }
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testPartitionQueryInReadOnlyTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(true);
            for (int i = 0; i < 2; ++i) {
                try (ResultSet resultSet = connection.partitionQuery(((Statement.Builder)Statement.newBuilder((String)"select * from my_table where id=@id").bind("p1").to(1L)).build(), PartitionOptions.newBuilder().build(), new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertFalse((boolean)resultSet.next());
                    continue;
                }
            }
            if (this.isMultiplexedSessionsEnabled(connection.getSpanner())) {
                Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            } else {
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testMixNormalAndPartitionQueryInReadOnlyTransaction() {
        ArrayList<Timestamp> readTimestamps = new ArrayList<Timestamp>();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(true);
            for (int i = 0; i < 2; ++i) {
                try (ResultSet resultSet = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((long)0L, (long)resultSet.getLong(0));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                resultSet = connection.partitionQuery(((Statement.Builder)Statement.newBuilder((String)"select * from my_table where id=@id").bind("p1").to(1L)).build(), PartitionOptions.newBuilder().build(), new Options.QueryOption[0]);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                readTimestamps.add(connection.getReadTimestamp());
                connection.commit();
            }
            if (this.isMultiplexedSessionsEnabled(connection.getSpanner())) {
                Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            } else {
                Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            }
        }
        Assert.assertEquals((long)4L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
        List<BeginTransactionRequest> beginRequests = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Assert.assertTrue((boolean)beginRequests.get(0).getOptions().getReadOnly().hasStrong());
        Assert.assertTrue((boolean)beginRequests.get(1).getOptions().getReadOnly().hasReadTimestamp());
        Assert.assertTrue((boolean)beginRequests.get(2).getOptions().getReadOnly().hasStrong());
        Assert.assertTrue((boolean)beginRequests.get(3).getOptions().getReadOnly().hasReadTimestamp());
        Assert.assertEquals(readTimestamps.get(0), (Object)Timestamp.fromProto((com.google.protobuf.Timestamp)beginRequests.get(1).getOptions().getReadOnly().getReadTimestamp()));
        Assert.assertEquals(readTimestamps.get(1), (Object)Timestamp.fromProto((com.google.protobuf.Timestamp)beginRequests.get(3).getOptions().getReadOnly().getReadTimestamp()));
    }

    @Test
    public void testRunPartition() {
        int generatedRowCount = 20;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        Statement statement = Statement.of((String)"select * from random_table");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        int maxPartitions = 5;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            boolean isMultiplexedSessionCreated = false;
            for (boolean dataBoostEnabled : new boolean[]{false, true}) {
                connection.setDataBoostEnabled(dataBoostEnabled);
                Assert.assertEquals((Object)dataBoostEnabled, (Object)connection.isDataBoostEnabled());
                int rowCount = 0;
                try (ResultSet partitions = connection.partitionQuery(statement, PartitionOptions.newBuilder().setMaxPartitions((long)maxPartitions).build(), new Options.QueryOption[0]);){
                    int partitionCount = 0;
                    while (partitions.next()) {
                        try (ResultSet resultSet = connection.runPartition(partitions.getString("PARTITION"));){
                            while (resultSet.next()) {
                                ++rowCount;
                            }
                        }
                        ++partitionCount;
                    }
                    Assert.assertEquals((long)maxPartitions, (long)partitionCount);
                    Assert.assertEquals((long)(generatedRowCount * maxPartitions), (long)rowCount);
                }
                int createSessionRequestCounts = mockSpanner.countRequestsOfType(CreateSessionRequest.class);
                int expectedCreateSessionsRPC = 1;
                if (this.isMultiplexedSessionsEnabled(connection.getSpanner()) && !isMultiplexedSessionCreated) {
                    Assert.assertTrue((createSessionRequestCounts >= expectedCreateSessionsRPC && createSessionRequestCounts <= expectedCreateSessionsRPC + 1 ? 1 : 0) != 0);
                    if (createSessionRequestCounts == expectedCreateSessionsRPC + 1) {
                        isMultiplexedSessionCreated = true;
                    }
                } else {
                    Assert.assertEquals((long)expectedCreateSessionsRPC, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
                }
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
                Assert.assertEquals((long)maxPartitions, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertFalse((boolean)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().anyMatch(request -> request.getPartitionToken().isEmpty()));
                Assert.assertFalse((boolean)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().anyMatch(request -> request.getDataBoostEnabled() != dataBoostEnabled));
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testRunPartitionUsingSql() {
        int generatedRowCount = 20;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        String paramName = this.dialect == Dialect.POSTGRESQL ? "$1" : "@p1";
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)String.format("select * from random_table where active=%s", paramName)).bind("p1").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        String prefix = this.dialect == Dialect.POSTGRESQL ? "spanner." : "";
        int maxPartitions = 5;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)"set autocommit=true"));
            Assert.assertTrue((boolean)connection.isAutocommit());
            for (boolean dataBoostEnabled : new boolean[]{false, true}) {
                connection.execute(Statement.of((String)String.format("set %sdata_boost_enabled=%s", prefix, dataBoostEnabled)));
                try (ResultSet resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %sdata_boost_enabled", prefix)), new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((Object)dataBoostEnabled, (Object)resultSet.getBoolean(0));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                connection.execute(Statement.of((String)String.format("set %smax_partitions=%d", prefix, maxPartitions)));
                resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %smax_partitions", prefix)), new Options.QueryOption[0]);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((long)maxPartitions, (long)resultSet.getLong(0));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                boolean isMultiplexedSessionCreated = false;
                for (boolean useLiteral : new boolean[]{true, false}) {
                    try (ResultSet partitions = connection.executeQuery(((Statement.Builder)Statement.newBuilder((String)("partition " + statement.getSql())).bind("p1").to(true)).build(), new Options.QueryOption[0]);){
                        int rowCount = 0;
                        int partitionCount = 0;
                        while (partitions.next()) {
                            try (ResultSet resultSet = connection.executeQuery(useLiteral ? Statement.of((String)("RUN\tPARTITION\n '" + partitions.getString("PARTITION") + "'")) : ((Statement.Builder)Statement.newBuilder((String)"RUN PARTITION").bind("PARTITION").to(partitions.getString("PARTITION"))).build(), new Options.QueryOption[0]);){
                                while (resultSet.next()) {
                                    ++rowCount;
                                }
                            }
                            ++partitionCount;
                        }
                        Assert.assertEquals((long)maxPartitions, (long)partitionCount);
                        Assert.assertEquals((long)(generatedRowCount * maxPartitions), (long)rowCount);
                    }
                    int createSessionRequestCounts = mockSpanner.countRequestsOfType(CreateSessionRequest.class);
                    int expectedCreateSessionsRPC = 1;
                    if (this.isMultiplexedSessionsEnabled(connection.getSpanner()) && !isMultiplexedSessionCreated) {
                        Assert.assertTrue((createSessionRequestCounts >= expectedCreateSessionsRPC && createSessionRequestCounts <= expectedCreateSessionsRPC + 1 ? 1 : 0) != 0);
                        if (createSessionRequestCounts == expectedCreateSessionsRPC + 1) {
                            isMultiplexedSessionCreated = true;
                        }
                    } else {
                        Assert.assertEquals((long)expectedCreateSessionsRPC, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
                    }
                    Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
                    Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
                    Assert.assertEquals((long)maxPartitions, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                    Assert.assertFalse((boolean)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().anyMatch(request -> request.getPartitionToken().isEmpty()));
                    Assert.assertFalse((boolean)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().anyMatch(request -> request.getDataBoostEnabled() != dataBoostEnabled));
                    mockSpanner.clearRequests();
                }
            }
        }
    }

    @Test
    public void testRunPartitionedQuery() {
        int generatedRowCount = 20;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select * from random_table where active=@active").bind("active").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        int maxPartitions = 5;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            try (PartitionedQueryResultSet resultSet = connection.runPartitionedQuery(statement, PartitionOptions.newBuilder().setMaxPartitions((long)maxPartitions).build(), new Options.QueryOption[0]);){
                int rowCount = 0;
                while (resultSet.next()) {
                    ++rowCount;
                }
                Assert.assertEquals((long)(maxPartitions * generatedRowCount), (long)rowCount);
            }
            if (this.isMultiplexedSessionsEnabled(connection.getSpanner())) {
                Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            } else {
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testRunEmptyPartitionedQuery() {
        int generatedRowCount = 0;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select * from random_table where active=@active").bind("active").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        int maxPartitions = 5;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            try (PartitionedQueryResultSet resultSet = connection.runPartitionedQuery(statement, PartitionOptions.newBuilder().setMaxPartitions((long)maxPartitions).build(), new Options.QueryOption[0]);){
                Assert.assertFalse((boolean)resultSet.next());
                Assert.assertNotNull((Object)resultSet.getMetadata());
                Assert.assertEquals((long)24L, (long)resultSet.getMetadata().getRowType().getFieldsCount());
                Assert.assertNotNull((Object)resultSet.getType());
                Assert.assertEquals((long)24L, (long)resultSet.getType().getStructFields().size());
            }
            if (this.isMultiplexedSessionsEnabled(connection.getSpanner())) {
                Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            } else {
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testGetMetadataWithoutNextCall() {
        int generatedRowCount = 1;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select * from random_table where active=@active").bind("active").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        int maxPartitions = 1;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            try (PartitionedQueryResultSet resultSet = connection.runPartitionedQuery(statement, PartitionOptions.newBuilder().setMaxPartitions((long)maxPartitions).build(), new Options.QueryOption[0]);){
                Assert.assertNotNull((Object)resultSet.getMetadata());
                Assert.assertEquals((long)24L, (long)resultSet.getMetadata().getRowType().getFieldsCount());
                Assert.assertNotNull((Object)resultSet.getType());
                Assert.assertEquals((long)24L, (long)resultSet.getType().getStructFields().size());
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertNotNull((Object)resultSet.getMetadata());
                Assert.assertEquals((long)24L, (long)resultSet.getMetadata().getRowType().getFieldsCount());
                Assert.assertNotNull((Object)resultSet.getType());
                Assert.assertEquals((long)24L, (long)resultSet.getType().getStructFields().size());
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testGetMetadataWithoutNextCallOnEmptyResultSet() {
        int generatedRowCount = 0;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select * from random_table where active=@active").bind("active").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        int maxPartitions = 1;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            try (PartitionedQueryResultSet resultSet = connection.runPartitionedQuery(statement, PartitionOptions.newBuilder().setMaxPartitions((long)maxPartitions).build(), new Options.QueryOption[0]);){
                Assert.assertNotNull((Object)resultSet.getMetadata());
                Assert.assertEquals((long)24L, (long)resultSet.getMetadata().getRowType().getFieldsCount());
                Assert.assertNotNull((Object)resultSet.getType());
                Assert.assertEquals((long)24L, (long)resultSet.getType().getStructFields().size());
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testGetMetadataWithoutNextCallOnResultSetWithError() {
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select * from random_table where active=@active").bind("active").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(statement, Status.NOT_FOUND.asRuntimeException()));
        int maxPartitions = 1;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            try (PartitionedQueryResultSet resultSet = connection.runPartitionedQuery(statement, PartitionOptions.newBuilder().setMaxPartitions((long)maxPartitions).build(), new Options.QueryOption[0]);){
                Assert.assertThrows(SpannerException.class, () -> ((PartitionedQueryResultSet)resultSet).getMetadata());
                Assert.assertThrows(SpannerException.class, () -> ((PartitionedQueryResultSet)resultSet).getType());
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testRunPartitionedQueryUsingSql() {
        int generatedRowCount = 20;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select * from random_table where active=@active").bind("active").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        String prefix = this.dialect == Dialect.POSTGRESQL ? "spanner." : "";
        int maxPartitions = 5;
        int maxParallelism = 4;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)"set autocommit=true"));
            Assert.assertTrue((boolean)connection.isAutocommit());
            for (boolean dataBoostEnabled : new boolean[]{false, true}) {
                connection.execute(Statement.of((String)String.format("set %sdata_boost_enabled=%s", prefix, dataBoostEnabled)));
                try (ResultSet resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %sdata_boost_enabled", prefix)), new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((Object)dataBoostEnabled, (Object)resultSet.getBoolean(0));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                connection.execute(Statement.of((String)String.format("set %smax_partitions=%d", prefix, maxPartitions)));
                resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %smax_partitions", prefix)), new Options.QueryOption[0]);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((long)maxPartitions, (long)resultSet.getLong(0));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                connection.execute(Statement.of((String)String.format("set %smax_partitioned_parallelism=%d", prefix, maxParallelism)));
                resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %smax_partitioned_parallelism", prefix)), new Options.QueryOption[0]);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((long)maxParallelism, (long)resultSet.getLong(0));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = connection.executeQuery(((Statement.Builder)Statement.newBuilder((String)"run\tpartitioned   query\n select * from random_table where active=@active").bind("active").to(true)).build(), new Options.QueryOption[0]);
                try {
                    int rowCount = 0;
                    while (resultSet.next()) {
                        ++rowCount;
                    }
                    Assert.assertEquals((long)(maxPartitions * generatedRowCount), (long)rowCount);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            if (this.isMultiplexedSessionsEnabled(connection.getSpanner())) {
                Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            } else {
                Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            }
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testRunPartitionedQueryWithError() {
        int generatedRowCount = 20;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select * from random_table where active=@active").bind("active").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        int maxPartitions = 5;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((Object)this.dialect, (Object)connection.getDialect());
            int errorIndex = new Random().nextInt(generatedRowCount);
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)((Object)Status.RESOURCE_EXHAUSTED.withDescription("test error").asRuntimeException()), errorIndex));
            connection.setAutocommit(true);
            int rowCount = 0;
            try (PartitionedQueryResultSet resultSet = connection.runPartitionedQuery(statement, PartitionOptions.newBuilder().setMaxPartitions((long)maxPartitions).build(), new Options.QueryOption[0]);){
                while (resultSet.next()) {
                    ++rowCount;
                }
                Assert.fail((String)("missing expected exception for error index " + errorIndex + ". Got row count " + rowCount));
            }
            catch (SpannerException exception) {
                Assert.assertEquals((Object)ErrorCode.RESOURCE_EXHAUSTED, (Object)exception.getErrorCode());
                Assert.assertTrue((boolean)exception.getMessage().contains("test error"));
                Assert.assertTrue((String)String.format("rowCount (%d) should be <= maxPartitions (%d) * generatedRowCount (%d) - (generatedRowCount (%d) - errorIndex (%d))", rowCount, maxPartitions, generatedRowCount, generatedRowCount, errorIndex), (rowCount <= maxPartitions * generatedRowCount - (generatedRowCount - errorIndex) ? 1 : 0) != 0);
            }
            if (this.isMultiplexedSessionsEnabled(connection.getSpanner())) {
                Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            } else {
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testRunPartitionedQueryWithMaxParallelism() {
        int generatedRowCount = 20;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select * from random_table where active=@active").bind("active").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        int maxPartitions = 15;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            for (int maxParallelism : new int[]{0, 1, 2, 5, 20}) {
                connection.setMaxPartitionedParallelism(maxParallelism);
                try (PartitionedQueryResultSet resultSet = connection.runPartitionedQuery(statement, PartitionOptions.newBuilder().setMaxPartitions((long)maxPartitions).build(), new Options.QueryOption[0]);){
                    int expectedParallelism = maxParallelism == 0 ? Math.min(maxPartitions, Runtime.getRuntime().availableProcessors()) : Math.min(maxParallelism, maxPartitions);
                    Assert.assertEquals((long)expectedParallelism, (long)resultSet.getParallelism());
                    int rowCount = 0;
                    while (resultSet.next()) {
                        ++rowCount;
                    }
                    Assert.assertEquals((long)(maxPartitions * generatedRowCount), (long)rowCount);
                }
            }
            if (this.isMultiplexedSessionsEnabled(connection.getSpanner())) {
                Assert.assertEquals((long)6L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            } else {
                Assert.assertEquals((long)5L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            }
        }
        Assert.assertEquals((long)5L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)5L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }

    @Test
    public void testAutoPartitionMode() {
        int generatedRowCount = 5;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(generatedRowCount);
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select * from random_table where active=@active").bind("active").to(true)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        String prefix = this.dialect == Dialect.POSTGRESQL ? "spanner." : "";
        int maxPartitions = 4;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            int rowCount;
            connection.setAutocommit(true);
            connection.setMaxPartitions(maxPartitions);
            connection.execute(Statement.of((String)String.format("set %sauto_partition_mode=true", prefix)));
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %sauto_partition_mode", prefix)), new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertTrue((boolean)resultSet.getBoolean(0));
                Assert.assertFalse((boolean)resultSet.next());
            }
            resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);
            try {
                rowCount = 0;
                while (resultSet.next()) {
                    ++rowCount;
                }
                Assert.assertEquals((long)(maxPartitions * generatedRowCount), (long)rowCount);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = connection.execute(statement).getResultSet();
            try {
                rowCount = 0;
                while (resultSet.next()) {
                    ++rowCount;
                }
                Assert.assertEquals((long)(maxPartitions * generatedRowCount), (long)rowCount);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQueryAsync(statement, new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Partitioned queries cannot be executed asynchronously"));
            exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeAsync(statement));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Partitioned queries cannot be executed asynchronously"));
            connection.setAutocommit(false);
            exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(statement, new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Partition query is not supported for read/write transaction"));
            exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(statement));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Partition query is not supported for read/write transaction"));
            if (this.isMultiplexedSessionsEnabled(connection.getSpanner())) {
                Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            } else {
                Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
            }
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(PartitionQueryRequest.class));
    }
}

