/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SqlScriptVerifier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDdlTest
extends ITAbstractSpannerTest {
    @Test
    public void testSqlScript() throws Exception {
        SqlScriptVerifier verifier = new SqlScriptVerifier(new ITAbstractSpannerTest.ITConnectionProvider(this));
        verifier.verifyStatementsInFile("ITDdlTest.sql", SqlScriptVerifier.class, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateDatabase() {
        DatabaseAdminClient client = ITDdlTest.getTestEnv().getTestHelper().getClient().getDatabaseAdminClient();
        String instance = ITDdlTest.getTestEnv().getTestHelper().getInstanceId().getInstance();
        String name = ITDdlTest.getTestEnv().getTestHelper().getUniqueDatabaseId();
        Assert.assertThrows(DatabaseNotFoundException.class, () -> client.getDatabase(instance, name));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)String.format("CREATE DATABASE `%s`", name)));
            Assert.assertNotNull((Object)client.getDatabase(instance, name));
        }
        finally {
            client.dropDatabase(instance, name);
        }
    }
}

