/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITAsyncAPITest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final String TABLE_NAME = "TestTable";
    private static final String INDEX_NAME = "TestTableByValue";
    private static final List<String> ALL_COLUMNS = Arrays.asList("Key", "StringValue");
    private static final Type TABLE_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"Key", (Type)Type.string()), Type.StructField.of((String)"StringValue", (Type)Type.string())});
    private static Database db;
    private static DatabaseClient client;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TestTable (  Key                STRING(MAX) NOT NULL,  StringValue        STRING(MAX),) PRIMARY KEY (Key)", "CREATE INDEX TestTableByValue ON TestTable(StringValue)", "CREATE INDEX TestTableByValueDesc ON TestTable(StringValue DESC)"});
        client = env.getTestHelper().getDatabaseClient(db);
        executor = Executors.newSingleThreadExecutor();
    }

    @AfterClass
    public static void cleanup() {
        executor.shutdown();
    }

    @Before
    public void setupData() {
        client.write(Collections.singletonList(Mutation.delete((String)TABLE_NAME, (KeySet)KeySet.all())));
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int i = 0; i < 15; ++i) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to("k" + i)).set("StringValue").to("v" + i)).build());
        }
        client.write(mutations);
    }

    @Test
    public void emptyReadAsync() throws Exception {
        SettableFuture result = SettableFuture.create();
        AsyncResultSet resultSet = client.singleUse(TimestampBound.strong()).readAsync(TABLE_NAME, KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"k99"}), (Key)Key.of((Object[])new Object[]{"z"}))), ALL_COLUMNS, new Options.ReadOption[0]);
        resultSet.setCallback((Executor)executor, rs -> {
            try {
                while (true) {
                    switch (rs.tryNext()) {
                        case OK: {
                            Assert.fail((String)"received unexpected data");
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                        case DONE: {
                            Truth.assertThat((Object)rs.getType()).isEqualTo((Object)TABLE_TYPE);
                            result.set((Object)true);
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                    }
                }
            }
            catch (Throwable t) {
                result.setException(t);
                return AsyncResultSet.CallbackResponse.DONE;
            }
        });
        Truth.assertThat((Boolean)((Boolean)result.get())).isTrue();
    }

    @Test
    public void indexEmptyReadAsync() throws Exception {
        SettableFuture result = SettableFuture.create();
        AsyncResultSet resultSet = client.singleUse(TimestampBound.strong()).readUsingIndexAsync(TABLE_NAME, INDEX_NAME, KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"v99"}), (Key)Key.of((Object[])new Object[]{"z"}))), ALL_COLUMNS, new Options.ReadOption[0]);
        resultSet.setCallback((Executor)executor, rs -> {
            try {
                while (true) {
                    switch (rs.tryNext()) {
                        case OK: {
                            Assert.fail((String)"received unexpected data");
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                        case DONE: {
                            Truth.assertThat((Object)rs.getType()).isEqualTo((Object)TABLE_TYPE);
                            result.set((Object)true);
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                    }
                }
            }
            catch (Throwable t) {
                result.setException(t);
                return AsyncResultSet.CallbackResponse.DONE;
            }
        });
        Truth.assertThat((Boolean)((Boolean)result.get())).isTrue();
    }

    @Test
    public void pointReadAsync() throws Exception {
        ApiFuture row = client.singleUse(TimestampBound.strong()).readRowAsync(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS);
        Truth.assertThat((Object)row.get()).isNotNull();
        Truth.assertThat((String)((Struct)row.get()).getString(0)).isEqualTo((Object)"k1");
        Truth.assertThat((String)((Struct)row.get()).getString(1)).isEqualTo((Object)"v1");
        Truth.assertThat((Object)row.get()).isEqualTo((Object)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("Key").to("k1")).set("StringValue").to("v1")).build());
    }

    @Test
    public void indexPointReadAsync() throws Exception {
        ApiFuture row = client.singleUse(TimestampBound.strong()).readRowUsingIndexAsync(TABLE_NAME, INDEX_NAME, Key.of((Object[])new Object[]{"v1"}), ALL_COLUMNS);
        Truth.assertThat((Object)row.get()).isNotNull();
        Truth.assertThat((String)((Struct)row.get()).getString(0)).isEqualTo((Object)"k1");
        Truth.assertThat((String)((Struct)row.get()).getString(1)).isEqualTo((Object)"v1");
    }

    @Test
    public void pointReadNotFound() throws Exception {
        ApiFuture row = client.singleUse(TimestampBound.strong()).readRowAsync(TABLE_NAME, Key.of((Object[])new Object[]{"k999"}), ALL_COLUMNS);
        Truth.assertThat((Object)row.get()).isNull();
    }

    @Test
    public void indexPointReadNotFound() throws Exception {
        ApiFuture row = client.singleUse(TimestampBound.strong()).readRowUsingIndexAsync(TABLE_NAME, INDEX_NAME, Key.of((Object[])new Object[]{"v999"}), ALL_COLUMNS);
        Truth.assertThat((Object)row.get()).isNull();
    }

    @Test
    public void invalidDatabase() throws Exception {
        RemoteSpannerHelper helper = env.getTestHelper();
        DatabaseClient invalidClient = helper.getClient().getDatabaseClient(DatabaseId.of((InstanceId)helper.getInstanceId(), (String)"invalid"));
        ApiFuture row = invalidClient.singleUse(TimestampBound.strong()).readRowAsync(TABLE_NAME, Key.of((Object[])new Object[]{"k99"}), ALL_COLUMNS);
        try {
            row.get();
            Assert.fail((String)"missing expected exception");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
            SpannerException se = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
        }
    }

    @Test
    public void tableNotFound() throws Exception {
        ApiFuture row = client.singleUse(TimestampBound.strong()).readRowAsync("BadTableName", Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS);
        try {
            row.get();
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
            SpannerException se = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            Truth.assertThat((String)se.getMessage()).contains((CharSequence)"BadTableName");
        }
    }

    @Test
    public void columnNotFound() throws Exception {
        ApiFuture row = client.singleUse(TimestampBound.strong()).readRowAsync(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), Arrays.asList("Key", "BadColumnName"));
        try {
            row.get();
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
            SpannerException se = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            Truth.assertThat((String)se.getMessage()).contains((CharSequence)"BadColumnName");
        }
    }

    @Test
    public void asyncRunnerFireAndForgetInvalidUpdate() throws Exception {
        try {
            Truth.assertThat((Object)client.singleUse().readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k999"}), ALL_COLUMNS)).isNull();
            AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
            ApiFuture res = runner.runAsync(txn -> {
                txn.executeUpdateAsync(Statement.of((String)"UPDATE BadTableName SET FOO=1 WHERE ID=2"), new Options.UpdateOption[0]);
                return txn.executeUpdateAsync(Statement.of((String)"INSERT INTO TestTable (Key, StringValue) VALUES ('k999', 'v999')"), new Options.UpdateOption[0]);
            }, (Executor)executor);
            Truth.assertThat((Long)((Long)res.get())).isEqualTo((Object)1L);
            Truth.assertThat((Object)client.singleUse().readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k999"}), ALL_COLUMNS)).isNotNull();
        }
        catch (Throwable throwable) {
            client.writeAtLeastOnce(Collections.singletonList(Mutation.delete((String)TABLE_NAME, (Key)Key.of((Object[])new Object[]{"k999"}))));
            Truth.assertThat((Object)client.singleUse().readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k999"}), ALL_COLUMNS)).isNull();
            throw throwable;
        }
        client.writeAtLeastOnce(Collections.singletonList(Mutation.delete((String)TABLE_NAME, (Key)Key.of((Object[])new Object[]{"k999"}))));
        Truth.assertThat((Object)client.singleUse().readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k999"}), ALL_COLUMNS)).isNull();
    }

    @Test
    public void testAsyncRunnerReturnsCommitStats() {
        Assume.assumeFalse((String)"Emulator does not return commit statistics", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[]{Options.commitStats()});
        runner.runAsync(transaction -> {
            transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to("k_commit_stats")).set("StringValue").to("Should return commit stats")).build());
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor);
        Assert.assertNotNull((Object)((CommitResponse)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse())).getCommitStats());
        Assert.assertEquals((long)4L, (long)((CommitResponse)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse())).getCommitStats().getMutationCount());
    }

    @Test
    public void testAsyncTransactionManagerReturnsCommitStats() throws InterruptedException {
        Assume.assumeFalse((String)"Emulator does not return commit statistics", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[]{Options.commitStats()});){
            AsyncTransactionManager.TransactionContextFuture context = manager.beginAsync();
            while (true) {
                try {
                    SpannerApiFutures.get((ApiFuture)context.then((transaction, ignored) -> {
                        transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to("k_commit_stats")).set("StringValue").to("Should return commit stats")).build());
                        return ApiFutures.immediateFuture(null);
                    }, (Executor)executor).commitAsync());
                    Assert.assertNotNull((Object)((CommitResponse)SpannerApiFutures.get((ApiFuture)manager.getCommitResponse())).getCommitStats());
                    Assert.assertEquals((long)4L, (long)((CommitResponse)SpannerApiFutures.get((ApiFuture)manager.getCommitResponse())).getCommitStats().getMutationCount());
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    context = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }
}

