/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.Policy;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SerialIntegrationTest;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.base.Strings;
import com.google.common.truth.Truth;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.OperationsSettings;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={SerialIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITVPCNegativeTest {
    private static final Logger logger = Logger.getLogger(ITVPCNegativeTest.class.getName());
    private static final String IN_VPCSC_TEST = System.getenv("GOOGLE_CLOUD_TESTS_IN_VPCSC");
    private static final String OUTSIDE_VPC_PROJECT = System.getenv("GOOGLE_CLOUD_TESTS_VPCSC_OUTSIDE_PERIMETER_PROJECT");
    private Spanner spanner;
    private InstanceAdminClient instanceAdminClient;
    private DatabaseAdminClient databaseAdminClient;
    private DatabaseClient databaseClient;
    private InstanceId instanceId;
    private BackupId backupId;

    @BeforeClass
    public static void setUpClass() {
        Assume.assumeTrue((String)"To run tests, GOOGLE_CLOUD_TESTS_IN_VPCSC environment variable needs to be set to True", (IN_VPCSC_TEST != null && IN_VPCSC_TEST.equalsIgnoreCase("true") ? 1 : 0) != 0);
        Assert.assertFalse((String)"GOOGLE_CLOUD_TESTS_VPCSC_OUTSIDE_PERIMETER_PROJECT environment variable needs to be set to a GCP project that is outside the VPC perimeter", (boolean)Strings.isNullOrEmpty((String)OUTSIDE_VPC_PROJECT));
        Assume.assumeTrue((boolean)Strings.isNullOrEmpty((String)System.getenv("SPANNER_EMULATOR_HOST")));
    }

    @Before
    public void setUp() {
        this.instanceId = InstanceId.of((String)OUTSIDE_VPC_PROJECT, (String)"nonexistent-instance");
        this.backupId = BackupId.of((String)OUTSIDE_VPC_PROJECT, (String)"nonexistent-instance", (String)"nonexistent-backup");
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(this.instanceId.getProject())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).setFailIfPoolExhausted().build()).build();
        this.spanner = (Spanner)options.getService();
        this.instanceAdminClient = this.spanner.getInstanceAdminClient();
        this.databaseAdminClient = this.spanner.getDatabaseAdminClient();
        this.databaseClient = this.spanner.getDatabaseClient(DatabaseId.of((String)OUTSIDE_VPC_PROJECT, (String)"nonexistent-instance", (String)"nonexistent-database"));
    }

    @After
    public void tearDown() {
        this.spanner.close();
    }

    private void checkExceptionForVPCError(SpannerException e) {
        Assert.assertEquals((Object)ErrorCode.PERMISSION_DENIED, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Request is prohibited by organization's policy");
    }

    @Test
    public void deniedListInstanceConfigs() {
        try {
            this.instanceAdminClient.listInstanceConfigs(new Options.ListOption[0]);
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedGetInstanceConfig() {
        try {
            this.instanceAdminClient.getInstanceConfig("nonexistent-configs");
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedListInstances() {
        try {
            this.instanceAdminClient.listInstances(new Options.ListOption[0]);
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedGetInstance() {
        try {
            this.instanceAdminClient.getInstance("non-existent");
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedListDatabases() {
        try {
            this.databaseAdminClient.listDatabases("nonexistent-instance", new Options.ListOption[]{Options.pageSize((int)1)});
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedGetDatabase() {
        try {
            this.databaseAdminClient.getDatabase("nonexistent-instance", "nonexistent-database");
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedRead() {
        ResultSet rs = this.databaseClient.singleUse().read("nonexistent-table", KeySet.all(), Collections.singletonList("nonexistent-col"), new Options.ReadOption[0]);
        try {
            rs.next();
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedCreateBackup() throws InterruptedException {
        try {
            this.databaseAdminClient.createBackup(this.instanceId.getInstance(), "newbackup-id", "nonexistent-db", Timestamp.now()).get();
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (ExecutionException e) {
            Throwable thrown = e.getCause();
            this.checkExceptionForVPCError((SpannerException)thrown);
        }
    }

    @Test
    public void deniedGetBackup() {
        try {
            this.databaseAdminClient.getBackup(this.instanceId.getInstance(), this.backupId.getBackup());
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedUpdateBackup() {
        try {
            this.databaseAdminClient.updateBackup(this.instanceId.getInstance(), this.backupId.getBackup(), Timestamp.now());
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedListBackup() {
        try {
            this.databaseAdminClient.listBackups(this.instanceId.getInstance(), new Options.ListOption[0]);
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedDeleteBackup() {
        try {
            this.databaseAdminClient.deleteBackup(this.instanceId.getInstance(), this.backupId.getBackup());
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedRestoreDatabase() throws InterruptedException {
        try {
            this.databaseAdminClient.restoreDatabase(this.instanceId.getInstance(), "nonexistent-backup", this.instanceId.getInstance(), "newdb-id").get();
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (ExecutionException e) {
            Throwable thrown = e.getCause();
            this.checkExceptionForVPCError((SpannerException)thrown);
        }
    }

    @Test
    public void deniedListBackupOperationsInInstance() {
        try {
            this.databaseAdminClient.listBackupOperations(this.instanceId.getInstance(), new Options.ListOption[0]);
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedListDatabaseOperationsInInstance() {
        try {
            this.databaseAdminClient.listDatabaseOperations(this.instanceId.getInstance(), new Options.ListOption[0]);
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedGetBackupIamPolicy() {
        try {
            this.databaseAdminClient.getBackupIAMPolicy(this.instanceId.getInstance(), this.backupId.getBackup());
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedSetBackupIamPolicy() {
        try {
            Policy policy = Policy.newBuilder().build();
            this.databaseAdminClient.setBackupIAMPolicy(this.backupId.getInstanceId().getInstance(), this.backupId.getBackup(), policy);
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedTestBackupIamPermissions() {
        try {
            ArrayList permissions = new ArrayList();
            this.databaseAdminClient.testBackupIAMPermissions(this.backupId.getInstanceId().getInstance(), this.backupId.getBackup(), permissions);
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedCancelBackupOperation() {
        try {
            this.databaseAdminClient.cancelOperation(this.backupId.getName() + "/operations/nonexistentop");
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedGetBackupOperation() {
        try {
            this.databaseAdminClient.getOperation(this.backupId.getName() + "/operations/nonexistentop");
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedListBackupOperations() throws IOException {
        try (OperationsClient client = OperationsClient.create((OperationsSettings)((OperationsSettings.Builder)((OperationsSettings.Builder)((OperationsSettings.Builder)OperationsSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().build())).setEndpoint("spanner.googleapis.com:443")).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)new FileInputStream(System.getenv("GOOGLE_APPLICATION_CREDENTIALS")))))).build());){
            client.listOperations(this.backupId.getName() + "/operations", "");
            Assert.fail((String)"Expected PermissionDeniedException");
        }
        catch (PermissionDeniedException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Request is prohibited by organization's policy");
        }
    }
}

