/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.Tuple;
import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ProtobufResultSet;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.ThreadFactoryUtil;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractMultiUseTransaction;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.ChecksumResultSet;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.FailedBatchUpdate;
import com.google.cloud.spanner.connection.FailedQuery;
import com.google.cloud.spanner.connection.FailedUpdate;
import com.google.cloud.spanner.connection.RetriableBatchUpdate;
import com.google.cloud.spanner.connection.RetriableUpdate;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.SpannerGrpc;
import io.grpc.MethodDescriptor;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.Scope;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReadWriteTransaction
extends AbstractMultiUseTransaction {
    private static final AttributeKey<Boolean> TRANSACTION_RETRIED = AttributeKey.booleanKey((String)"transaction.retried");
    private static final Logger logger = Logger.getLogger(ReadWriteTransaction.class.getName());
    private static final ThreadFactory KEEP_ALIVE_THREAD_FACTORY = ThreadFactoryUtil.createVirtualOrPlatformDaemonThreadFactory("read-write-transaction-keep-alive", true);
    private static final ScheduledExecutorService KEEP_ALIVE_SERVICE = Executors.newSingleThreadScheduledExecutor(KEEP_ALIVE_THREAD_FACTORY);
    private static final AbstractStatementParser.ParsedStatement SELECT1_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("SELECT 1"));
    private static final long DEFAULT_KEEP_ALIVE_INTERVAL_MILLIS = 8000L;
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private static final String MAX_INTERNAL_RETRIES_EXCEEDED = "Internal transaction retry maximum exceeded";
    private static final int DEFAULT_MAX_INTERNAL_RETRIES = 50;
    private static final ThreadLocal<ReadWriteTransaction> CURRENT_ACTIVE_TRANSACTION = new ThreadLocal();
    private static final String AUTO_SAVEPOINT_NAME = "_auto_savepoint";
    private final boolean useAutoSavepointsForEmulator;
    private AbstractMultiUseTransaction.Savepoint autoSavepoint;
    private final int maxInternalRetries;
    private final ReentrantLock abortedLock = new ReentrantLock();
    private final long transactionId;
    private final DatabaseClient dbClient;
    private final Options.TransactionOption[] transactionOptions;
    private TransactionManager txManager;
    private final boolean retryAbortsInternally;
    private final boolean delayTransactionStartUntilFirstWrite;
    private final boolean keepTransactionAlive;
    private final long keepAliveIntervalMillis;
    private final ReentrantLock keepAliveLock;
    private final SavepointSupport savepointSupport;
    private int transactionRetryAttempts;
    private int successfulRetries;
    private final List<TransactionRetryListener> transactionRetryListeners;
    private volatile ApiFuture<TransactionContext> txContextFuture;
    private boolean canUseSingleUseRead;
    private volatile SettableApiFuture<CommitResponse> commitResponseFuture;
    private volatile UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;
    private volatile AbortedException abortedException;
    private AbortedException rolledBackToSavepointException;
    private boolean timedOutOrCancelled = false;
    private final List<RetriableStatement> statements = new ArrayList<RetriableStatement>();
    private final List<Mutation> mutations = new ArrayList<Mutation>();
    private Timestamp transactionStarted;
    private ScheduledFuture<?> keepAliveFuture;
    private final Callable<Void> commitCallable = new Callable<Void>(){

        @Override
        public Void call() {
            ReadWriteTransaction.this.checkAborted();
            ((TransactionContext)SpannerApiFutures.get(ReadWriteTransaction.this.txContextFuture)).buffer(ReadWriteTransaction.this.mutations);
            ReadWriteTransaction.this.txManager.commit();
            ReadWriteTransaction.this.commitResponseFuture.set((Object)ReadWriteTransaction.this.txManager.getCommitResponse());
            ReadWriteTransaction.this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
            return null;
        }
    };
    private final Callable<Void> rollbackCallable = new Callable<Void>(){

        @Override
        public Void call() {
            try {
                if (ReadWriteTransaction.this.state != UnitOfWork.UnitOfWorkState.ABORTED && ReadWriteTransaction.this.rolledBackToSavepointException == null) {
                    SpannerApiFutures.get(ReadWriteTransaction.this.txContextFuture);
                    ReadWriteTransaction.this.txManager.rollback();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                ReadWriteTransaction.this.txManager.close();
            }
        }
    };

    static Builder newBuilder() {
        return new Builder();
    }

    private ReadWriteTransaction(Builder builder) {
        super(builder);
        this.transactionId = ID_GENERATOR.incrementAndGet();
        this.useAutoSavepointsForEmulator = builder.useAutoSavepointsForEmulator && builder.retryAbortsInternally != false;
        this.maxInternalRetries = this.useAutoSavepointsForEmulator ? 500 : 50;
        this.dbClient = builder.dbClient;
        this.delayTransactionStartUntilFirstWrite = builder.delayTransactionStartUntilFirstWrite;
        this.keepTransactionAlive = builder.keepTransactionAlive;
        this.keepAliveIntervalMillis = this.keepTransactionAlive ? ConnectionOptions.tryParseLong(System.getProperty("spanner.connection.keep_alive_interval_millis", String.valueOf(8000L)), 8000L) : 0L;
        this.keepAliveLock = this.keepTransactionAlive ? new ReentrantLock() : null;
        this.retryAbortsInternally = builder.retryAbortsInternally;
        this.savepointSupport = builder.savepointSupport;
        this.transactionRetryListeners = builder.transactionRetryListeners;
        this.transactionOptions = this.extractOptions(builder);
    }

    private Options.TransactionOption[] extractOptions(Builder builder) {
        int numOptions = 0;
        if (builder.returnCommitStats) {
            ++numOptions;
        }
        if (builder.maxCommitDelay != null) {
            ++numOptions;
        }
        if (this.transactionTag != null) {
            ++numOptions;
        }
        if (this.excludeTxnFromChangeStreams) {
            ++numOptions;
        }
        if (this.rpcPriority != null) {
            ++numOptions;
        }
        Options.TransactionOption[] options = new Options.TransactionOption[numOptions];
        int index = 0;
        if (builder.returnCommitStats) {
            options[index++] = Options.commitStats();
        }
        if (builder.maxCommitDelay != null) {
            options[index++] = Options.maxCommitDelay(builder.maxCommitDelay);
        }
        if (this.transactionTag != null) {
            options[index++] = Options.tag(this.transactionTag);
        }
        if (this.excludeTxnFromChangeStreams) {
            options[index++] = Options.excludeTxnFromChangeStreams();
        }
        if (this.rpcPriority != null) {
            options[index++] = Options.priority(this.rpcPriority);
        }
        return options;
    }

    public String toString() {
        return "ReadWriteTransaction - ID: " + this.transactionId + "; Delay tx start: " + this.delayTransactionStartUntilFirstWrite + "; Tag: " + Strings.nullToEmpty((String)this.transactionTag) + "; Status: " + this.internalGetStateName() + "; Started: " + this.internalGetTimeStarted() + "; Retry attempts: " + this.transactionRetryAttempts + "; Successful retries: " + this.successfulRetries;
    }

    private String internalGetStateName() {
        return this.transactionStarted == null ? "Not yet started" : this.getState().toString();
    }

    private String internalGetTimeStarted() {
        return this.transactionStarted == null ? "Not yet started" : this.transactionStarted.toString();
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    void checkOrCreateValidTransaction(AbstractStatementParser.ParsedStatement statement, UnitOfWork.CallType callType) {
        this.checkValidStateAndMarkStarted();
        if (this.txContextFuture == null && (!this.delayTransactionStartUntilFirstWrite || statement != null && statement.isUpdate() || statement == AbstractStatementParser.COMMIT_STATEMENT && !this.mutations.isEmpty())) {
            this.txManager = this.dbClient.transactionManager(this.transactionOptions);
            this.canUseSingleUseRead = false;
            this.txContextFuture = this.executeStatementAsync(callType, AbstractStatementParser.BEGIN_STATEMENT, this.txManager::begin, SpannerGrpc.getBeginTransactionMethod());
        } else if (this.txContextFuture == null && this.delayTransactionStartUntilFirstWrite) {
            this.canUseSingleUseRead = true;
        }
        this.maybeUpdateActiveTransaction();
    }

    private void checkValidStateAndMarkStarted() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED || this.state == UnitOfWork.UnitOfWorkState.ABORTED, "This transaction has status " + this.state.name() + ", only " + (Object)((Object)UnitOfWork.UnitOfWorkState.STARTED) + "or " + (Object)((Object)UnitOfWork.UnitOfWorkState.ABORTED) + " is allowed.");
        ConnectionPreconditions.checkState(this.retryAbortsInternally || this.rolledBackToSavepointException == null, "Cannot resume execution after rolling back to a savepoint if internal retries have been disabled. Call Connection#setRetryAbortsInternally(true) or execute `SET RETRY_ABORTS_INTERNALLY=TRUE` to enable resuming execution after rolling back to a savepoint.");
        this.checkTimedOut();
        if (this.transactionStarted == null) {
            this.transactionStarted = Timestamp.now();
        }
    }

    private boolean shouldPing() {
        return this.isActive() && this.keepAliveLock != null && this.keepTransactionAlive && !this.timedOutOrCancelled && this.rolledBackToSavepointException == null;
    }

    private void maybeScheduleKeepAlivePing() {
        if (this.shouldPing()) {
            this.keepAliveLock.lock();
            try {
                if (this.keepAliveFuture == null || this.keepAliveFuture.isDone()) {
                    this.keepAliveFuture = KEEP_ALIVE_SERVICE.schedule(new KeepAliveRunnable(), this.keepAliveIntervalMillis > 0L ? this.keepAliveIntervalMillis : 8000L, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                this.keepAliveLock.unlock();
            }
        }
    }

    private void cancelScheduledKeepAlivePing() {
        if (this.keepAliveLock != null) {
            this.keepAliveLock.lock();
            try {
                if (this.keepAliveFuture != null) {
                    this.keepAliveFuture.cancel(false);
                }
            }
            finally {
                this.keepAliveLock.unlock();
            }
        }
    }

    private void checkTimedOut() {
        ConnectionPreconditions.checkState(!this.timedOutOrCancelled, "The last statement of this transaction timed out or was cancelled. The transaction is no longer usable. Rollback the transaction and start a new one.");
    }

    @Override
    public boolean isActive() {
        return this.getState().isActive() || this.state == UnitOfWork.UnitOfWorkState.ABORTED;
    }

    @Override
    void checkAborted() {
        if (this.state == UnitOfWork.UnitOfWorkState.ABORTED && this.abortedException != null) {
            if (this.abortedException instanceof AbortedDueToConcurrentModificationException) {
                throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException((AbortedDueToConcurrentModificationException)this.abortedException);
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "This transaction has already been aborted. Rollback this transaction to start a new one.", (Throwable)((Object)this.abortedException));
        }
    }

    void checkRolledBackToSavepoint() {
        if (this.rolledBackToSavepointException != null) {
            if (this.savepointSupport == SavepointSupport.FAIL_AFTER_ROLLBACK && !((RollbackToSavepointException)this.rolledBackToSavepointException.getCause()).getSavepoint().isAutoSavepoint()) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Using a read/write transaction after rolling back to a savepoint is not supported with SavepointSupport=" + (Object)((Object)this.savepointSupport));
            }
            AbortedException exception = this.rolledBackToSavepointException;
            this.rolledBackToSavepointException = null;
            throw exception;
        }
    }

    @Override
    ReadContext getReadContext() {
        if (this.txContextFuture == null && this.canUseSingleUseRead) {
            return this.dbClient.singleUse();
        }
        ConnectionPreconditions.checkState(this.txContextFuture != null, "Missing transaction context");
        return SpannerApiFutures.get(this.txContextFuture);
    }

    TransactionContext getTransactionContext() {
        ConnectionPreconditions.checkState(this.txContextFuture != null, "Missing transaction context");
        return (TransactionContext)this.getReadContext();
    }

    @Override
    public Timestamp getReadTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no read timestamp available for read/write transactions.");
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return null;
    }

    private boolean hasCommitResponse() {
        return this.commitResponseFuture != null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        ConnectionPreconditions.checkState(this.hasCommitResponse(), "This transaction has not been committed.");
        return SpannerApiFutures.get(this.commitResponseFuture).getCommitTimestamp();
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return this.hasCommitResponse() ? SpannerApiFutures.get(this.commitResponseFuture).getCommitTimestamp() : null;
    }

    @Override
    public CommitResponse getCommitResponse() {
        ConnectionPreconditions.checkState(this.hasCommitResponse(), "This transaction has not been committed.");
        return SpannerApiFutures.get(this.commitResponseFuture);
    }

    @Override
    public CommitResponse getCommitResponseOrNull() {
        return this.hasCommitResponse() ? SpannerApiFutures.get(this.commitResponseFuture) : null;
    }

    @Override
    public ApiFuture<Void> executeDdlAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement ddl) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DDL-statements are not allowed inside a read/write transaction.");
    }

    private void handlePossibleInvalidatingException(SpannerException e) {
        if (e.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED || e.getErrorCode() == ErrorCode.CANCELLED) {
            this.timedOutOrCancelled = true;
        }
    }

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((statement.getType() == AbstractStatementParser.StatementType.QUERY || statement.getType() == AbstractStatementParser.StatementType.UPDATE && statement.hasReturningClause() ? 1 : 0) != 0, (Object)"Statement must be a query or DML with returning clause");
        try (Scope ignore = this.span.makeCurrent();){
            this.checkOrCreateValidTransaction(statement, callType);
            ApiFuture<ResultSet> res = this.retryAbortsInternally && this.txContextFuture != null ? this.executeStatementAsync(callType, statement, () -> {
                this.checkTimedOut();
                return this.runWithRetry(() -> {
                    try {
                        this.getStatementExecutor().invokeInterceptors(statement, StatementExecutionStep.EXECUTE_STATEMENT, this);
                        DirectExecuteResultSet delegate = DirectExecuteResultSet.ofResultSet(this.internalExecuteQuery(statement, analyzeMode, options));
                        return this.createAndAddRetryResultSet(delegate, statement, analyzeMode, options);
                    }
                    catch (AbortedException e) {
                        throw e;
                    }
                    catch (SpannerException e) {
                        this.createAndAddFailedQuery(e, statement, analyzeMode, options);
                        throw e;
                    }
                });
            }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteStreamingSqlMethod())) : super.executeQueryAsync(callType, statement, analyzeMode, options);
            ApiFutures.addCallback(res, new StatementResultCallback(), (Executor)MoreExecutors.directExecutor());
            ApiFuture<ResultSet> apiFuture = res;
            return apiFuture;
        }
    }

    @Override
    public ApiFuture<ResultSet> analyzeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        try (Scope ignore = this.span.makeCurrent();){
            ApiFuture apiFuture = ApiFutures.transform(this.internalExecuteUpdateAsync(callType, update, analyzeMode, options), Tuple::y, (Executor)MoreExecutors.directExecutor());
            return apiFuture;
        }
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        try (Scope ignore = this.span.makeCurrent();){
            ApiFuture apiFuture = ApiFutures.transform(this.internalExecuteUpdateAsync(callType, update, AnalyzeMode.NONE, options), Tuple::x, (Executor)MoreExecutors.directExecutor());
            return apiFuture;
        }
    }

    private ApiFuture<Tuple<Long, ResultSet>> internalExecuteUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        Preconditions.checkNotNull((Object)update);
        Preconditions.checkArgument((boolean)update.isUpdate(), (Object)"The statement is not an update statement");
        this.checkOrCreateValidTransaction(update, callType);
        ApiFuture<Tuple> res = this.retryAbortsInternally && this.txContextFuture != null ? this.executeStatementAsync(callType, update, () -> {
            this.checkTimedOut();
            return this.runWithRetry(() -> {
                try {
                    Tuple result;
                    long updateCount;
                    this.getStatementExecutor().invokeInterceptors(update, StatementExecutionStep.EXECUTE_STATEMENT, this);
                    if (analyzeMode == AnalyzeMode.NONE) {
                        updateCount = SpannerApiFutures.get(this.txContextFuture).executeUpdate(update.getStatement(), options);
                        result = Tuple.of((Object)updateCount, null);
                    } else {
                        ResultSet resultSet = SpannerApiFutures.get(this.txContextFuture).analyzeUpdateStatement(update.getStatement(), analyzeMode.getQueryAnalyzeMode(), options);
                        updateCount = Objects.requireNonNull(resultSet.getStats()).getRowCountExact();
                        result = Tuple.of(null, (Object)resultSet);
                    }
                    this.createAndAddRetriableUpdate(update, analyzeMode, updateCount, options);
                    return result;
                }
                catch (AbortedException e) {
                    throw e;
                }
                catch (SpannerException e) {
                    this.createAndAddFailedUpdate(e, update);
                    throw e;
                }
            });
        }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteSqlMethod())) : this.executeStatementAsync(callType, update, () -> {
            this.checkTimedOut();
            this.checkAborted();
            if (analyzeMode == AnalyzeMode.NONE) {
                return Tuple.of((Object)SpannerApiFutures.get(this.txContextFuture).executeUpdate(update.getStatement(), options), null);
            }
            ResultSet resultSet = SpannerApiFutures.get(this.txContextFuture).analyzeUpdateStatement(update.getStatement(), analyzeMode.getQueryAnalyzeMode(), options);
            return Tuple.of(null, (Object)resultSet);
        }, SpannerGrpc.getExecuteSqlMethod());
        ApiFutures.addCallback(res, new StatementResultCallback(), (Executor)MoreExecutors.directExecutor());
        return res;
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(UnitOfWork.CallType callType, Iterable<AbstractStatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        Preconditions.checkNotNull(updates);
        try (Scope ignore = this.span.makeCurrent();){
            LinkedList<Statement> updateStatements = new LinkedList<Statement>();
            for (AbstractStatementParser.ParsedStatement update : updates) {
                Preconditions.checkArgument((boolean)update.isUpdate(), (Object)("Statement is not an update statement: " + update.getSqlWithoutComments()));
                updateStatements.add(update.getStatement());
            }
            this.checkOrCreateValidTransaction((AbstractStatementParser.ParsedStatement)Iterables.getFirst(updates, null), callType);
            ApiFuture<long[]> res = this.retryAbortsInternally ? this.executeStatementAsync(callType, AbstractStatementParser.RUN_BATCH_STATEMENT, () -> {
                this.checkTimedOut();
                return this.runWithRetry(() -> {
                    try {
                        this.getStatementExecutor().invokeInterceptors(AbstractStatementParser.RUN_BATCH_STATEMENT, StatementExecutionStep.EXECUTE_STATEMENT, this);
                        long[] updateCounts = SpannerApiFutures.get(this.txContextFuture).batchUpdate(updateStatements, options);
                        this.createAndAddRetriableBatchUpdate(updateStatements, updateCounts, options);
                        return updateCounts;
                    }
                    catch (AbortedException e) {
                        throw e;
                    }
                    catch (SpannerException e) {
                        this.createAndAddFailedBatchUpdate(e, updateStatements);
                        throw e;
                    }
                });
            }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getExecuteBatchDmlMethod())) : this.executeStatementAsync(callType, AbstractStatementParser.RUN_BATCH_STATEMENT, () -> {
                this.checkTimedOut();
                this.checkAborted();
                return SpannerApiFutures.get(this.txContextFuture).batchUpdate(updateStatements, new Options.UpdateOption[0]);
            }, SpannerGrpc.getExecuteBatchDmlMethod());
            ApiFutures.addCallback(res, new StatementResultCallback(), (Executor)MoreExecutors.directExecutor());
            ApiFuture<long[]> apiFuture = res;
            return apiFuture;
        }
    }

    @Override
    public ApiFuture<Void> writeAsync(UnitOfWork.CallType callType, Iterable<Mutation> mutations) {
        try (Scope ignore = this.span.makeCurrent();){
            Preconditions.checkNotNull(mutations);
            this.checkValidStateAndMarkStarted();
            for (Mutation mutation : mutations) {
                this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
            }
            ApiFuture apiFuture = ApiFutures.immediateFuture(null);
            return apiFuture;
        }
    }

    @Override
    public ApiFuture<Void> commitAsync(UnitOfWork.CallType callType) {
        try (Scope ignore = this.span.makeCurrent();){
            Object res;
            this.checkOrCreateValidTransaction(AbstractStatementParser.COMMIT_STATEMENT, callType);
            this.cancelScheduledKeepAlivePing();
            this.state = UnitOfWork.UnitOfWorkState.COMMITTING;
            this.commitResponseFuture = SettableApiFuture.create();
            if (this.txContextFuture == null) {
                this.commitResponseFuture.set((Object)new CommitResponse(Timestamp.fromProto((com.google.protobuf.Timestamp)com.google.protobuf.Timestamp.getDefaultInstance())));
                this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
                res = SettableApiFuture.create();
                res.set(null);
            } else {
                res = this.retryAbortsInternally ? this.executeStatementAsync(callType, AbstractStatementParser.COMMIT_STATEMENT, () -> {
                    this.checkTimedOut();
                    try {
                        return this.runWithRetry(() -> {
                            this.getStatementExecutor().invokeInterceptors(AbstractStatementParser.COMMIT_STATEMENT, StatementExecutionStep.EXECUTE_STATEMENT, this);
                            return this.commitCallable.call();
                        });
                    }
                    catch (Throwable t) {
                        this.commitResponseFuture.setException(t);
                        this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                        try {
                            this.txManager.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw t;
                    }
                }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)ImmutableList.of((Object)SpannerGrpc.getCommitMethod())) : this.executeStatementAsync(callType, AbstractStatementParser.COMMIT_STATEMENT, () -> {
                    this.checkTimedOut();
                    try {
                        return this.commitCallable.call();
                    }
                    catch (Throwable t) {
                        this.commitResponseFuture.setException(t);
                        this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
                        try {
                            this.txManager.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw t;
                    }
                }, SpannerGrpc.getCommitMethod());
            }
            this.asyncEndUnitOfWorkSpan();
            SettableApiFuture settableApiFuture = res;
            return settableApiFuture;
        }
    }

    /*
     * Exception decompiling
     */
    <T> T runWithRetry(Callable<T> callable) throws SpannerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void maybeUpdateActiveTransaction() {
        if (this.useAutoSavepointsForEmulator) {
            if (CURRENT_ACTIVE_TRANSACTION.get() != null && CURRENT_ACTIVE_TRANSACTION.get() != this) {
                ReadWriteTransaction activeTransaction = CURRENT_ACTIVE_TRANSACTION.get();
                if (activeTransaction.isActive() && activeTransaction.autoSavepoint != null) {
                    activeTransaction.rollbackToSavepoint(activeTransaction.autoSavepoint);
                    activeTransaction.autoSavepoint = null;
                }
                CURRENT_ACTIVE_TRANSACTION.remove();
            }
            CURRENT_ACTIVE_TRANSACTION.set(this);
        }
    }

    private ResultSet createAndAddRetryResultSet(ProtobufResultSet resultSet, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (this.retryAbortsInternally) {
            ChecksumResultSet checksumResultSet = this.createChecksumResultSet(resultSet, statement, analyzeMode, options);
            this.addRetryStatement(checksumResultSet);
            return checksumResultSet;
        }
        return resultSet;
    }

    private void createAndAddFailedQuery(SpannerException e, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new FailedQuery(this, e, statement, analyzeMode, options));
        }
    }

    private void createAndAddRetriableUpdate(AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, long updateCount, Options.UpdateOption ... options) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new RetriableUpdate(this, update, analyzeMode, updateCount, options));
        }
    }

    private void createAndAddRetriableBatchUpdate(Iterable<Statement> updates, long[] updateCounts, Options.UpdateOption ... options) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new RetriableBatchUpdate(this, updates, updateCounts, options));
        }
    }

    private void createAndAddFailedUpdate(SpannerException e, AbstractStatementParser.ParsedStatement update) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new FailedUpdate(this, e, update));
        }
    }

    private void createAndAddFailedBatchUpdate(SpannerException e, Iterable<Statement> updates) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new FailedBatchUpdate(this, e, updates));
        }
    }

    private void addRetryStatement(RetriableStatement statement) {
        Preconditions.checkState((boolean)this.retryAbortsInternally, (Object)"retryAbortsInternally is not enabled for this transaction");
        this.statements.add(statement);
    }

    private void handleAborted(AbortedException aborted) {
        block23: {
            if (this.transactionRetryAttempts >= this.maxInternalRetries) {
                this.span.addEvent("Internal retry attempts exceeded");
                this.throwAbortWithRetryAttemptsExceeded();
            } else {
                if (this.retryAbortsInternally) {
                    logger.fine(this.toString() + ": Starting internal transaction retry");
                    while (true) {
                        long delay = aborted.getRetryDelayInMillis();
                        this.span.addEvent("Transaction aborted. Backing off for " + delay + " milliseconds and retrying.");
                        this.span.setAttribute(TRANSACTION_RETRIED, (Object)true);
                        try {
                            if (delay > 0L) {
                                Thread.sleep(delay);
                            } else if (aborted.isEmulatorOnlySupportsOneTransactionException()) {
                                Thread.sleep(ThreadLocalRandom.current().nextInt(50));
                            }
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "The statement was cancelled");
                        }
                        try {
                            if (aborted.getCause() instanceof RollbackToSavepointException) {
                                this.txManager = this.dbClient.transactionManager(this.transactionOptions);
                                this.txContextFuture = ApiFutures.immediateFuture((Object)this.txManager.begin());
                            } else {
                                this.txContextFuture = ApiFutures.immediateFuture((Object)this.txManager.resetForRetry());
                            }
                            this.invokeTransactionRetryListenersOnStart();
                            ++this.transactionRetryAttempts;
                            for (RetriableStatement statement : this.statements) {
                                statement.retry(aborted);
                            }
                            ++this.successfulRetries;
                            this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_SUCCESSFUL);
                            logger.fine(this.toString() + ": Internal transaction retry succeeded. Starting retry of original statement.");
                            break block23;
                        }
                        catch (AbortedDueToConcurrentModificationException e) {
                            this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_ABORTED_DUE_TO_CONCURRENT_MODIFICATION);
                            logger.fine(this.toString() + ": Internal transaction retry aborted due to a concurrent modification");
                            try {
                                this.txManager.rollback();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.state = UnitOfWork.UnitOfWorkState.ABORTED;
                            this.abortedException = e;
                            throw e;
                        }
                        catch (AbortedException abortedExceptionDuringRetry) {
                            if (this.transactionRetryAttempts >= this.maxInternalRetries) {
                                this.throwAbortWithRetryAttemptsExceeded();
                            }
                            this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_ABORTED_AND_RESTARTING);
                            logger.fine(this.toString() + ": Internal transaction retry aborted, trying again");
                            aborted = abortedExceptionDuringRetry;
                            continue;
                        }
                        catch (SpannerException e) {
                            logger.log(Level.FINE, this.toString() + ": Internal transaction retry failed due to an unexpected exception", (Throwable)((Object)e));
                            try {
                                this.txManager.rollback();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.state = UnitOfWork.UnitOfWorkState.ABORTED;
                            this.abortedException = aborted;
                            throw e;
                        }
                        break;
                    }
                }
                try {
                    this.txManager.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.state = UnitOfWork.UnitOfWorkState.ABORTED;
                this.abortedException = aborted;
                throw aborted;
            }
        }
    }

    private void throwAbortWithRetryAttemptsExceeded() throws SpannerException {
        this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_ABORTED_AND_MAX_ATTEMPTS_EXCEEDED);
        logger.fine(this.toString() + ": Internal transaction retry aborted and max number of retry attempts has been exceeded");
        try {
            this.txManager.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.state = UnitOfWork.UnitOfWorkState.ABORTED;
        this.abortedException = (AbortedException)SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, MAX_INTERNAL_RETRIES_EXCEEDED);
        throw this.abortedException;
    }

    private void invokeTransactionRetryListenersOnStart() {
        for (TransactionRetryListener listener : this.transactionRetryListeners) {
            listener.retryStarting(this.transactionStarted, this.transactionId, this.transactionRetryAttempts);
        }
    }

    private void invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult result) {
        for (TransactionRetryListener listener : this.transactionRetryListeners) {
            listener.retryFinished(this.transactionStarted, this.transactionId, this.transactionRetryAttempts, result);
        }
    }

    @Override
    public ApiFuture<Void> rollbackAsync(UnitOfWork.CallType callType) {
        try (Scope ignore = this.span.makeCurrent();){
            ApiFuture<Void> apiFuture = this.rollbackAsync(callType, true);
            return apiFuture;
        }
    }

    private ApiFuture<Void> rollbackAsync(UnitOfWork.CallType callType, boolean updateStatusAndEndSpan) {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED || this.state == UnitOfWork.UnitOfWorkState.ABORTED, "This transaction has status " + this.state.name());
        this.cancelScheduledKeepAlivePing();
        if (updateStatusAndEndSpan) {
            this.state = UnitOfWork.UnitOfWorkState.ROLLED_BACK;
        }
        if (this.txContextFuture != null && this.state != UnitOfWork.UnitOfWorkState.ABORTED) {
            ApiFuture<Void> result = this.executeStatementAsync(callType, AbstractStatementParser.ROLLBACK_STATEMENT, this.rollbackCallable, SpannerGrpc.getRollbackMethod());
            if (updateStatusAndEndSpan) {
                this.asyncEndUnitOfWorkSpan();
            }
            return result;
        }
        if (updateStatusAndEndSpan) {
            return this.asyncEndUnitOfWorkSpan();
        }
        return ApiFutures.immediateFuture(null);
    }

    @Override
    String getUnitOfWorkName() {
        return "read/write transaction";
    }

    @Override
    AbstractMultiUseTransaction.Savepoint savepoint(String name) {
        return new ReadWriteSavepoint(name, this.statements.size(), this.mutations.size());
    }

    private AbstractMultiUseTransaction.Savepoint createAutoSavepoint() {
        return new ReadWriteSavepoint(AUTO_SAVEPOINT_NAME, this.statements.size(), this.mutations.size(), true);
    }

    @Override
    void rollbackToSavepoint(AbstractMultiUseTransaction.Savepoint savepoint) {
        try (Scope ignore = this.span.makeCurrent();){
            SpannerApiFutures.get(this.rollbackAsync(UnitOfWork.CallType.SYNC, false));
            this.rolledBackToSavepointException = (AbortedException)SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "Transaction has been rolled back to a savepoint", new RollbackToSavepointException(savepoint));
            this.statements.subList(savepoint.getStatementPosition(), this.statements.size()).clear();
            this.mutations.subList(savepoint.getMutationPosition(), this.mutations.size()).clear();
        }
    }

    @VisibleForTesting
    ChecksumResultSet createChecksumResultSet(ProtobufResultSet delegate, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        return new ChecksumResultSet(this, delegate, statement, analyzeMode, options);
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, ReadWriteTransaction> {
        private boolean useAutoSavepointsForEmulator;
        private DatabaseClient dbClient;
        private Boolean retryAbortsInternally;
        private boolean delayTransactionStartUntilFirstWrite;
        private boolean keepTransactionAlive;
        private boolean returnCommitStats;
        private Duration maxCommitDelay;
        private SavepointSupport savepointSupport;
        private List<TransactionRetryListener> transactionRetryListeners;

        private Builder() {
        }

        Builder setUseAutoSavepointsForEmulator(boolean useAutoSavepoints) {
            this.useAutoSavepointsForEmulator = useAutoSavepoints;
            return this;
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        Builder setDelayTransactionStartUntilFirstWrite(boolean delayTransactionStartUntilFirstWrite) {
            this.delayTransactionStartUntilFirstWrite = delayTransactionStartUntilFirstWrite;
            return this;
        }

        Builder setKeepTransactionAlive(boolean keepTransactionAlive) {
            this.keepTransactionAlive = keepTransactionAlive;
            return this;
        }

        Builder setRetryAbortsInternally(boolean retryAbortsInternally) {
            this.retryAbortsInternally = retryAbortsInternally;
            return this;
        }

        Builder setReturnCommitStats(boolean returnCommitStats) {
            this.returnCommitStats = returnCommitStats;
            return this;
        }

        Builder setMaxCommitDelay(Duration maxCommitDelay) {
            this.maxCommitDelay = maxCommitDelay;
            return this;
        }

        Builder setSavepointSupport(SavepointSupport savepointSupport) {
            this.savepointSupport = savepointSupport;
            return this;
        }

        Builder setTransactionRetryListeners(List<TransactionRetryListener> listeners) {
            Preconditions.checkNotNull(listeners);
            this.transactionRetryListeners = listeners;
            return this;
        }

        @Override
        ReadWriteTransaction build() {
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DatabaseClient client specified");
            Preconditions.checkState((this.retryAbortsInternally != null ? 1 : 0) != 0, (Object)"RetryAbortsInternally is not specified");
            Preconditions.checkState((this.transactionRetryListeners != null ? 1 : 0) != 0, (Object)"TransactionRetryListeners are not specified");
            Preconditions.checkState((this.savepointSupport != null ? 1 : 0) != 0, (Object)"SavepointSupport is not specified");
            return new ReadWriteTransaction(this);
        }
    }

    private class KeepAliveRunnable
    implements Runnable {
        private KeepAliveRunnable() {
        }

        @Override
        public void run() {
            if (ReadWriteTransaction.this.shouldPing()) {
                ApiFuture<ResultSet> future = ReadWriteTransaction.this.executeQueryAsync(UnitOfWork.CallType.SYNC, SELECT1_STATEMENT, AnalyzeMode.NONE, Options.tag(System.getProperty("spanner.connection.keep_alive_query_tag", "connection.transaction-keep-alive")));
                future.addListener(() -> ReadWriteTransaction.this.maybeScheduleKeepAlivePing(), MoreExecutors.directExecutor());
            }
        }
    }

    private static final class RollbackToSavepointException
    extends Exception {
        private final AbstractMultiUseTransaction.Savepoint savepoint;

        RollbackToSavepointException(AbstractMultiUseTransaction.Savepoint savepoint) {
            this.savepoint = (AbstractMultiUseTransaction.Savepoint)Preconditions.checkNotNull((Object)savepoint);
        }

        AbstractMultiUseTransaction.Savepoint getSavepoint() {
            return this.savepoint;
        }
    }

    private final class StatementResultCallback<V>
    implements ApiFutureCallback<V> {
        private StatementResultCallback() {
        }

        public void onFailure(Throwable t) {
            if (t instanceof SpannerException) {
                ReadWriteTransaction.this.handlePossibleInvalidatingException((SpannerException)((Object)t));
            }
            ReadWriteTransaction.this.maybeScheduleKeepAlivePing();
        }

        public void onSuccess(V result) {
            ReadWriteTransaction.this.maybeScheduleKeepAlivePing();
        }
    }

    static interface RetriableStatement {
        public void retry(AbortedException var1) throws AbortedException;
    }

    static class ReadWriteSavepoint
    extends AbstractMultiUseTransaction.Savepoint {
        private final int statementPosition;
        private final int mutationPosition;

        ReadWriteSavepoint(String name, int statementPosition, int mutationPosition) {
            this(name, statementPosition, mutationPosition, false);
        }

        ReadWriteSavepoint(String name, int statementPosition, int mutationPosition, boolean autoSavepoint) {
            super(name, autoSavepoint);
            this.statementPosition = statementPosition;
            this.mutationPosition = mutationPosition;
        }

        @Override
        int getStatementPosition() {
            return this.statementPosition;
        }

        @Override
        int getMutationPosition() {
            return this.mutationPosition;
        }
    }
}

