/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractLatencyBenchmark {
    static final String SELECT_QUERY = "SELECT ID FROM FOO WHERE ID = @id";
    static final String UPDATE_QUERY = "UPDATE FOO SET BAR=1 WHERE ID = @id";
    static final String ID_COLUMN_NAME = "id";
    static final int PARALLEL_THREADS = Integer.valueOf((String)MoreObjects.firstNonNull((Object)System.getenv("SPANNER_TEST_JMH_NUM_PARALLEL_THREADS"), (Object)"30"));
    static final int NUM_GRPC_CHANNELS = Integer.valueOf((String)MoreObjects.firstNonNull((Object)System.getenv("SPANNER_TEST_JMH_NUM_GRPC_CHANNELS"), (Object)"4"));
    static final int TOTAL_READS_PER_RUN = Integer.valueOf((String)MoreObjects.firstNonNull((Object)System.getenv("SPANNER_TEST_JMH_NUM_READS_PER_THREAD"), (Object)"48000"));
    static final int TOTAL_WRITES_PER_RUN = Integer.valueOf((String)MoreObjects.firstNonNull((Object)System.getenv("SPANNER_TEST_JMH_NUM_WRITES_PER_THREAD"), (Object)"4000"));
    static final int WARMUP_REQUEST_COUNT = 1;
    static final int TOTAL_RECORDS = 1000000;

    public void printResults(List<Duration> results) {
        if (results == null) {
            return;
        }
        ArrayList<Duration> orderedResults = new ArrayList<Duration>(results);
        Collections.sort(orderedResults);
        System.out.println();
        System.out.printf("Total number of queries: %d\n", orderedResults.size());
        System.out.printf("Avg: %fms\n", this.avg(results));
        System.out.printf("P50: %fms\n", this.percentile(50, orderedResults));
        System.out.printf("P95: %fms\n", this.percentile(95, orderedResults));
        System.out.printf("P99: %fms\n", this.percentile(99, orderedResults));
    }

    private double percentile(int percentile, List<Duration> orderedResults) {
        int index = percentile * orderedResults.size() / 100;
        Duration value = orderedResults.get(index);
        Double convertedValue = this.convertDurationToFractionInMilliSeconds(value);
        return convertedValue;
    }

    private double avg(List<Duration> results) {
        return results.stream().collect(Collectors.averagingDouble(this::convertDurationToFractionInMilliSeconds));
    }

    private double convertDurationToFractionInSeconds(Duration duration) {
        long seconds = duration.getSeconds();
        long nanos = duration.getNano();
        double fraction = (double)nanos / 1.0E9;
        double value = (double)seconds + fraction;
        return value;
    }

    private double convertDurationToFractionInMilliSeconds(Duration duration) {
        long nanoseconds = duration.toNanos();
        return (double)nanoseconds / 1000000.0;
    }
}

