/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.Identity;
import com.google.cloud.NoCredentials;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.MockInstanceAdminServiceImpl;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.truth.Truth;
import java.util.Collections;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InstanceAdminClientTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static MockInstanceAdminServiceImpl mockInstanceAdmin;
    private static MockServiceHelper serviceHelper;
    private LocalChannelProvider channelProvider;
    private Spanner spanner;
    private InstanceAdminClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockInstanceAdmin = new MockInstanceAdminServiceImpl();
        serviceHelper = new MockServiceHelper("in-process-1", Collections.singletonList(mockInstanceAdmin));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setChannelProvider((TransportChannelProvider)this.channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setProjectId(PROJECT_ID)).build().getService();
        this.client = this.spanner.getInstanceAdminClient();
    }

    @After
    public void tearDown() {
        this.spanner.close();
    }

    @Test
    public void getAndSetIAMPolicy() {
        Policy policy = this.client.getInstanceIAMPolicy(INSTANCE_ID);
        Truth.assertThat((Object)policy).isEqualTo((Object)Policy.newBuilder().build());
        Policy newPolicy = Policy.newBuilder().addIdentity(Role.viewer(), Identity.user((String)"joe@example.com"), new Identity[0]).build();
        Policy returnedPolicy = this.client.setInstanceIAMPolicy(INSTANCE_ID, newPolicy);
        Truth.assertThat((Object)returnedPolicy).isEqualTo((Object)newPolicy);
        Truth.assertThat((Object)this.client.getInstanceIAMPolicy(INSTANCE_ID)).isEqualTo((Object)newPolicy);
    }

    @Test
    public void testIAMPermissions() {
        Iterable permissions = this.client.testInstanceIAMPermissions(INSTANCE_ID, Collections.singletonList("spanner.instances.list"));
        Truth.assertThat((Iterable)permissions).containsExactly(new Object[]{"spanner.instances.list"});
    }
}

