/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.CancelledException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.spanner.MockDatabaseAdminServiceImpl;
import com.google.cloud.spanner.MockOperationsServiceImpl;
import com.google.cloud.spanner.OperationFutureUtil;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminClient;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminSettings;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import com.google.iam.v1.Binding;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.CreateBackupRequest;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.RestoreDatabaseRequest;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class MockDatabaseAdminServiceImplTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final String TEST_PARENT = "projects/my-project/instances/my-instance";
    private static final String TEST_DB_NAME = String.format("%s/databases/test-db", "projects/my-project/instances/my-instance");
    private static final String TEST_BCK_NAME = String.format("%s/backups/test-bck", "projects/my-project/instances/my-instance");
    private static MockOperationsServiceImpl mockOperations;
    private static MockDatabaseAdminServiceImpl mockDatabaseAdmin;
    private static MockServiceHelper serviceHelper;
    private DatabaseAdminClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockOperations = new MockOperationsServiceImpl();
        mockDatabaseAdmin = new MockDatabaseAdminServiceImpl(mockOperations);
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(new MockGrpcService[]{mockOperations, mockDatabaseAdmin}));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        DatabaseAdminSettings.Builder settingsBuilder = (DatabaseAdminSettings.Builder)((DatabaseAdminSettings.Builder)DatabaseAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
        settingsBuilder.createBackupOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)20L)).setInitialRetryDelay(Duration.ofMillis((long)10L)).setMaxRetryDelay(Duration.ofMillis((long)150L)).setMaxRpcTimeout(Duration.ofMillis((long)150L)).setMaxAttempts(10).setTotalTimeout(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setRpcTimeoutMultiplier(1.3).build()));
        settingsBuilder.createDatabaseOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)20L)).setInitialRetryDelay(Duration.ofMillis((long)10L)).setMaxRetryDelay(Duration.ofMillis((long)150L)).setMaxRpcTimeout(Duration.ofMillis((long)150L)).setMaxAttempts(10).setTotalTimeout(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setRpcTimeoutMultiplier(1.3).build()));
        settingsBuilder.restoreDatabaseOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)20L)).setInitialRetryDelay(Duration.ofMillis((long)10L)).setMaxRetryDelay(Duration.ofMillis((long)150L)).setMaxRpcTimeout(Duration.ofMillis((long)150L)).setMaxAttempts(10).setTotalTimeout(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setRpcTimeoutMultiplier(1.3).build()));
        this.client = DatabaseAdminClient.create((DatabaseAdminSettings)settingsBuilder.build());
    }

    @After
    public void tearDown() {
        this.client.close();
    }

    private Database createTestDb() {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setCreateStatement("CREATE DATABASE `test-db`").addAllExtraStatements(Arrays.asList("CREATE TABLE FOO", "CREATE TABLE BAR")).setParent(TEST_PARENT).build();
        OperationFuture op = this.client.createDatabaseOperationCallable().futureCall((Object)request);
        try {
            return (Database)op.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new CancelledException((Throwable)e, (StatusCode)OperationFutureUtil.FakeStatusCode.of(StatusCode.Code.CANCELLED), false);
        }
    }

    @Test
    public void createDatabase() {
        Database db = this.createTestDb();
        Truth.assertThat((String)db.getName()).isEqualTo((Object)TEST_DB_NAME);
    }

    @Test
    public void createDatabaseAlreadyExists() {
        this.createTestDb();
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.ALREADY_EXISTS));
        this.createTestDb();
    }

    @Test
    public void dropDatabase() {
        this.createTestDb();
        Database db = this.client.getDatabase(TEST_DB_NAME);
        Truth.assertThat((String)db.getName()).isEqualTo((Object)TEST_DB_NAME);
        this.client.dropDatabase(TEST_DB_NAME);
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.NOT_FOUND));
        this.client.getDatabase(TEST_DB_NAME);
    }

    @Test
    public void dropDatabaseNotFound() {
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.NOT_FOUND));
        this.client.dropDatabase(TEST_DB_NAME);
    }

    @Test
    public void getDatabase() {
        this.createTestDb();
        Database db = this.client.getDatabase(TEST_DB_NAME);
        Truth.assertThat((String)db.getName()).isEqualTo((Object)TEST_DB_NAME);
    }

    @Test
    public void getDatabaseNotFound() {
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.NOT_FOUND));
        this.client.getDatabase(TEST_DB_NAME);
    }

    @Test
    public void getDatabaseDdl() {
        this.createTestDb();
        GetDatabaseDdlResponse ddl = this.client.getDatabaseDdl(TEST_DB_NAME);
        Truth.assertThat((Iterable)ddl.getStatementsList()).containsExactly(new Object[]{"CREATE TABLE FOO", "CREATE TABLE BAR"});
    }

    @Test
    public void getDatabaseDdlNotFound() {
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.NOT_FOUND));
        this.client.getDatabaseDdl(TEST_DB_NAME);
    }

    @Test
    public void listDatabases() {
        this.createTestDb();
        DatabaseAdminClient.ListDatabasesPagedResponse response = this.client.listDatabases(TEST_PARENT);
        ArrayList<String> databases = new ArrayList<String>();
        for (Database db : response.iterateAll()) {
            databases.add(db.getName());
        }
        Truth.assertThat(databases).containsExactly(new Object[]{TEST_DB_NAME});
    }

    @Test
    public void listDatabaseOperations() {
        this.createTestDb();
        DatabaseAdminClient.ListDatabaseOperationsPagedResponse response = this.client.listDatabaseOperations(TEST_DB_NAME);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (Operation op : response.iterateAll()) {
            operations.add(op);
        }
        Truth.assertThat(operations).hasSize(1);
    }

    @Test
    public void updateDatabaseDdl() throws InterruptedException, ExecutionException {
        this.createTestDb();
        UpdateDatabaseDdlRequest request = UpdateDatabaseDdlRequest.newBuilder().setDatabase(TEST_DB_NAME).addAllStatements(Arrays.asList("CREATE TABLE BAZ", "DROP TABLE FOO")).build();
        OperationFuture op = this.client.updateDatabaseDdlOperationCallable().futureCall((Object)request);
        op.get();
        GetDatabaseDdlResponse response = this.client.getDatabaseDdl(TEST_DB_NAME);
        Truth.assertThat((Iterable)response.getStatementsList()).containsExactly(new Object[]{"CREATE TABLE FOO", "CREATE TABLE BAR", "CREATE TABLE BAZ", "DROP TABLE FOO"});
    }

    private Backup createTestBackup() {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setBackupId("test-bck").setBackup(Backup.newBuilder().setDatabase(TEST_DB_NAME).setExpireTime(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L + TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS))).build()).setParent(TEST_PARENT).build();
        OperationFuture op = this.client.createBackupOperationCallable().futureCall((Object)request);
        try {
            return (Backup)op.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new CancelledException((Throwable)e, (StatusCode)OperationFutureUtil.FakeStatusCode.of(StatusCode.Code.CANCELLED), false);
        }
    }

    @Test
    public void createBackup() {
        this.createTestDb();
        Backup bck = this.createTestBackup();
        Truth.assertThat((String)bck.getName()).isEqualTo((Object)TEST_BCK_NAME);
    }

    @Test
    public void createBackupAlreadyExists() {
        this.createTestDb();
        this.createTestBackup();
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.ALREADY_EXISTS));
        this.createTestBackup();
    }

    @Test
    public void createBackupDatabaseDoesNotExist() {
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.NOT_FOUND));
        this.createTestBackup();
    }

    @Test
    public void deleteBackup() {
        this.createTestDb();
        this.createTestBackup();
        Backup bck = this.client.getBackup(TEST_BCK_NAME);
        Truth.assertThat((String)bck.getName()).isEqualTo((Object)TEST_BCK_NAME);
        this.client.deleteBackup(TEST_BCK_NAME);
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.NOT_FOUND));
        this.client.getBackup(TEST_BCK_NAME);
    }

    @Test
    public void deleteBackupNotFound() {
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.NOT_FOUND));
        this.client.deleteBackup(TEST_BCK_NAME);
    }

    @Test
    public void getBackup() {
        this.createTestDb();
        this.createTestBackup();
        Backup bck = this.client.getBackup(TEST_BCK_NAME);
        Truth.assertThat((String)bck.getName()).isEqualTo((Object)TEST_BCK_NAME);
    }

    @Test
    public void getBackupNotFound() {
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.NOT_FOUND));
        this.client.getBackup(TEST_BCK_NAME);
    }

    @Test
    public void listBackups() {
        this.createTestDb();
        this.createTestBackup();
        DatabaseAdminClient.ListBackupsPagedResponse response = this.client.listBackups(TEST_PARENT);
        ArrayList<String> backups = new ArrayList<String>();
        for (Backup bck : response.iterateAll()) {
            backups.add(bck.getName());
        }
        Truth.assertThat(backups).containsExactly(new Object[]{TEST_BCK_NAME});
    }

    @Test
    public void listBackupOperations() {
        this.createTestDb();
        this.createTestBackup();
        DatabaseAdminClient.ListBackupOperationsPagedResponse response = this.client.listBackupOperations(TEST_BCK_NAME);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (Operation op : response.iterateAll()) {
            operations.add(op);
        }
        Truth.assertThat(operations).hasSize(1);
    }

    @Test
    public void updateBackup() {
        this.createTestDb();
        Backup backup = this.createTestBackup();
        Backup toBeUpdated = backup.toBuilder().setExpireTime(Timestamp.newBuilder().setSeconds(1000L).build()).build();
        Backup updated = this.client.updateBackup(toBeUpdated, FieldMask.newBuilder().addPaths("expire_time").build());
        Truth.assertThat((Object)updated.getExpireTime()).isEqualTo((Object)toBeUpdated.getExpireTime());
        Truth.assertThat((Object)backup.getExpireTime()).isNotEqualTo((Object)updated.getExpireTime());
    }

    @Test
    public void restoreDatabase() throws InterruptedException, ExecutionException {
        this.createTestDb();
        this.createTestBackup();
        RestoreDatabaseRequest request = RestoreDatabaseRequest.newBuilder().setBackup(TEST_BCK_NAME).setDatabaseId("restored-db").setParent(TEST_PARENT).build();
        OperationFuture op = this.client.restoreDatabaseOperationCallable().futureCall((Object)request);
        Database restoredDb = (Database)op.get();
        Truth.assertThat((String)restoredDb.getName()).isEqualTo((Object)String.format("%s/databases/%s", TEST_PARENT, "restored-db"));
        Truth.assertThat((String)restoredDb.getRestoreInfo().getBackupInfo().getBackup()).isEqualTo((Object)TEST_BCK_NAME);
        Truth.assertThat((String)restoredDb.getRestoreInfo().getBackupInfo().getSourceDatabase()).isEqualTo((Object)TEST_DB_NAME);
    }

    @Test
    public void restoreDatabaseNotFound() throws InterruptedException, ExecutionException {
        this.createTestDb();
        RestoreDatabaseRequest request = RestoreDatabaseRequest.newBuilder().setBackup(TEST_BCK_NAME).setDatabaseId("restored-db").setParent(TEST_PARENT).build();
        OperationFuture op = this.client.restoreDatabaseOperationCallable().futureCall((Object)request);
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.NOT_FOUND));
        op.get();
    }

    @Test
    public void restoreDatabaseAlreadyExists() throws InterruptedException, ExecutionException {
        this.createTestDb();
        this.createTestBackup();
        RestoreDatabaseRequest request = RestoreDatabaseRequest.newBuilder().setBackup(TEST_BCK_NAME).setDatabaseId("test-db").setParent(TEST_PARENT).build();
        OperationFuture op = this.client.restoreDatabaseOperationCallable().futureCall((Object)request);
        this.exception.expect((Matcher)ApiExceptionMatcher.forCode(StatusCode.Code.ALREADY_EXISTS));
        op.get();
    }

    @Test
    public void testIAMPolicy() {
        TestIamPermissionsResponse response = this.client.testIamPermissions(TestIamPermissionsRequest.newBuilder().setResource(TEST_PARENT).addPermissions("spanner.databases.select").addPermissions("spanner.databases.write").build());
        Truth.assertThat((Iterable)response.getPermissionsList()).containsExactly(new Object[]{"spanner.databases.select", "spanner.databases.write"});
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(TEST_PARENT).build();
        Policy policy = this.client.getIamPolicy(request);
        Truth.assertThat((Object)policy).isNotNull();
        Policy newPolicy = Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/admin").addMembers("user:joe@example.com")).setEtag(policy.getEtag()).build();
        this.client.setIamPolicy(SetIamPolicyRequest.newBuilder().setResource(TEST_PARENT).setPolicy(newPolicy).build());
        policy = this.client.getIamPolicy(TEST_PARENT);
        Truth.assertThat((Object)policy).isEqualTo((Object)newPolicy);
        response = this.client.testIamPermissions(TestIamPermissionsRequest.newBuilder().setResource(TEST_PARENT).addPermissions("spanner.databases.select").addPermissions("spanner.databases.update").build());
        Truth.assertThat((Iterable)response.getPermissionsList()).containsExactly(new Object[]{"spanner.databases.select", "spanner.databases.update"});
    }

    private static class ApiExceptionMatcher
    extends BaseMatcher<Throwable> {
        private final StatusCode.Code expectedStatus;

        private static ApiExceptionMatcher forCode(StatusCode.Code status) {
            return new ApiExceptionMatcher(status);
        }

        private ApiExceptionMatcher(StatusCode.Code expectedStatus) {
            this.expectedStatus = (StatusCode.Code)Preconditions.checkNotNull((Object)expectedStatus);
        }

        public boolean matches(Object item) {
            ApiException ae = null;
            if (item instanceof ExecutionException) {
                ExecutionException e = (ExecutionException)item;
                if (e.getCause() instanceof ApiException) {
                    ae = (ApiException)e.getCause();
                }
            } else if (item instanceof ApiException) {
                ae = (ApiException)item;
            }
            if (ae != null) {
                return ae.getStatusCode().getCode() == this.expectedStatus;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("ApiException[" + this.expectedStatus + "]");
        }
    }
}

