/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsGrpc;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import com.google.rpc.Status;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public class MockOperationsServiceImpl
extends OperationsGrpc.OperationsImplBase
implements MockGrpcService {
    private final AtomicLong operationCounter = new AtomicLong();
    private final ConcurrentMap<String, Operation> operations = new ConcurrentHashMap<String, Operation>();
    private final ConcurrentMap<String, Future<?>> futures = new ConcurrentHashMap();
    private final ExecutorService executor = Executors.newScheduledThreadPool(8, new ThreadFactoryBuilder().setThreadFactory(MoreExecutors.platformThreadFactory()).setNameFormat("mock-operations-%d").setDaemon(true).build());

    String generateOperationName(String parent) {
        return String.format("%s/operations/%d", parent, this.operationCounter.incrementAndGet());
    }

    <T> Future<T> addOperation(Operation operation, Callable<T> task) {
        this.operations.put(operation.getName(), operation);
        Future<T> future = this.executor.submit(task);
        this.futures.put(operation.getName(), future);
        return future;
    }

    Operation get(String name) {
        return (Operation)this.operations.get(name);
    }

    void update(Operation operation) {
        Operation existing = (Operation)this.operations.get(operation.getName());
        if (!existing.getDone()) {
            this.operations.put(operation.getName(), operation);
        }
    }

    Iterable<Operation> iterable() {
        return this.operations.values();
    }

    public void listOperations(ListOperationsRequest request, StreamObserver<ListOperationsResponse> responseObserver) {
        ListOperationsResponse.Builder builder = ListOperationsResponse.newBuilder();
        for (Operation op : this.iterable()) {
            if (!op.getName().startsWith(request.getName())) continue;
            builder.addOperations(op);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void getOperation(GetOperationRequest request, StreamObserver<Operation> responseObserver) {
        Operation op = (Operation)this.operations.get(request.getName());
        if (op != null) {
            responseObserver.onNext((Object)op);
            responseObserver.onCompleted();
        } else {
            responseObserver.onError((Throwable)io.grpc.Status.NOT_FOUND.asRuntimeException());
        }
    }

    public void deleteOperation(DeleteOperationRequest request, StreamObserver<Empty> responseObserver) {
        Operation op = (Operation)this.operations.get(request.getName());
        if (op != null) {
            if (op.getDone()) {
                if (this.operations.remove(request.getName(), op)) {
                    this.futures.remove(request.getName());
                    responseObserver.onNext((Object)Empty.getDefaultInstance());
                    responseObserver.onCompleted();
                } else {
                    responseObserver.onError((Throwable)io.grpc.Status.NOT_FOUND.asRuntimeException());
                }
            } else {
                responseObserver.onError((Throwable)io.grpc.Status.FAILED_PRECONDITION.withDescription("Operation is not done").asRuntimeException());
            }
        } else {
            responseObserver.onError((Throwable)io.grpc.Status.NOT_FOUND.asRuntimeException());
        }
    }

    public void cancelOperation(CancelOperationRequest request, StreamObserver<Empty> responseObserver) {
        Operation op = (Operation)this.operations.get(request.getName());
        Future fut = (Future)this.futures.get(request.getName());
        if (op != null && fut != null) {
            if (!op.getDone()) {
                this.operations.put(request.getName(), op.toBuilder().clearResponse().setDone(true).setError(Status.newBuilder().setCode(io.grpc.Status.CANCELLED.getCode().value()).setMessage("Operation was cancelled").build()).build());
                fut.cancel(true);
            }
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
        } else {
            responseObserver.onError((Throwable)io.grpc.Status.NOT_FOUND.asRuntimeException());
        }
    }

    public List<AbstractMessage> getRequests() {
        return Collections.emptyList();
    }

    public void addResponse(AbstractMessage response) {
        throw new UnsupportedOperationException();
    }

    public void addException(Exception exception) {
        throw new UnsupportedOperationException();
    }

    public ServerServiceDefinition getServiceDefinition() {
        return this.bindService();
    }

    public void reset() {
        for (Future fut : this.futures.values()) {
            fut.cancel(true);
        }
        this.operations.clear();
        this.futures.clear();
    }
}

