/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbstractMockServerTest;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.common.collect.ImmutableList;
import io.grpc.Status;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class OpenTelemetryApiTracerTest
extends AbstractMockServerTest {
    private static final Statement SELECT_RANDOM = Statement.of((String)"SELECT * FROM random");
    private static final Statement UPDATE_RANDOM = Statement.of((String)"UPDATE random SET foo=1 WHERE id=1");
    private static InMemorySpanExporter spanExporter;
    private static OpenTelemetrySdk openTelemetry;
    private DatabaseClient client;

    @BeforeClass
    public static void setupOpenTelemetry() {
        SpannerOptions.resetActiveTracingFramework();
        SpannerOptions.enableOpenTelemetryTraces();
        GlobalOpenTelemetry.resetForTest();
        spanExporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)).build();
        openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(tracerProvider).buildAndRegisterGlobal();
    }

    @BeforeClass
    public static void setupResults() {
        RandomResultSetGenerator generator = new RandomResultSetGenerator(1);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_RANDOM, generator.generate()));
        mockSpanner.putStatementResults(MockSpannerServiceImpl.StatementResult.update(UPDATE_RANDOM, 1L));
    }

    @AfterClass
    public static void closeOpenTelemetry() {
        if (openTelemetry != null) {
            openTelemetry.close();
        }
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
        spanExporter.reset();
    }

    @Override
    public void createSpannerInstance() {
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        builder.getDatabaseAdminStubSettingsBuilder().updateDatabaseDdlOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofNanos((long)1L)).setMaxRetryDelay(Duration.ofNanos((long)1L)).setRetryDelayMultiplier(1.0).setTotalTimeout(Duration.ofMinutes((long)10L)).build()));
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)builder.setProjectId("test-project")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).setFailOnSessionLeak().build()).setEnableApiTracing(true).build().getService();
        this.client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
    }

    @Test
    public void testSingleUseQuery() {
        try (ResultSet resultSet = this.client.singleUse().executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpanner.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertContains("Spanner.ExecuteStreamingSql", spans);
        this.assertParent("CloudSpanner.ReadOnlyTransaction", "CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertParent("CloudSpannerOperation.ExecuteStreamingQuery", "Spanner.ExecuteStreamingSql", spans);
    }

    @Test
    public void testExecuteUpdate() {
        Assert.assertNotNull((Object)this.client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_RANDOM, new Options.UpdateOption[0])));
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteUpdate", spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertContains("Spanner.ExecuteSql", spans);
        this.assertContains("Spanner.Commit", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.ExecuteUpdate", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.Commit", spans);
        this.assertParent("CloudSpannerOperation.ExecuteUpdate", "Spanner.ExecuteSql", spans);
    }

    @Test
    public void testBatchUpdate() {
        Assert.assertNotNull((Object)this.client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.batchUpdate((Iterable)ImmutableList.of((Object)UPDATE_RANDOM, (Object)UPDATE_RANDOM), new Options.UpdateOption[0])));
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.BatchUpdate", spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertContains("Spanner.ExecuteBatchDml", spans);
        this.assertContains("Spanner.Commit", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.BatchUpdate", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.Commit", spans);
        this.assertParent("CloudSpannerOperation.BatchUpdate", "Spanner.ExecuteBatchDml", spans);
        this.assertParent("CloudSpannerOperation.Commit", "Spanner.Commit", spans);
    }

    @Test
    public void testMultiUseReadOnlyQuery() {
        try (ReadOnlyTransaction readOnlyTransaction = this.client.readOnlyTransaction();
             ResultSet resultSet = readOnlyTransaction.executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpanner.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertContains("Spanner.ExecuteStreamingSql", spans);
        this.assertParent("CloudSpanner.ReadOnlyTransaction", "CloudSpannerOperation.ExecuteStreamingQuery", Attributes.empty(), spans);
        this.assertParent("CloudSpannerOperation.ExecuteStreamingQuery", "Spanner.ExecuteStreamingSql", Attributes.empty(), spans);
    }

    @Test
    public void testReadWriteTransactionQuery() {
        this.client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            try (ResultSet resultSet = transaction.executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.next());
            }
            return null;
        });
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertParent("CloudSpanner.ReadWriteTransaction", "CloudSpannerOperation.Commit", spans);
        this.assertParent("CloudSpannerOperation.ExecuteStreamingQuery", "Spanner.ExecuteStreamingSql", spans);
    }

    @Test
    public void testRetryUnaryRpc() {
        mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.UNAVAILABLE.asRuntimeException())));
        this.client.write((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("bar").to(1L)).build()));
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        SpanData span = this.getSpan("Spanner.BeginTransaction", spans);
        Assert.assertEquals((Object)StatusCode.OK, (Object)span.getStatus().getStatusCode());
        Assert.assertEquals((long)3L, (long)span.getTotalRecordedEvents());
        List events = span.getEvents();
        Assert.assertEquals((Object)"Attempt failed, scheduling next attempt", (Object)((EventData)events.get(0)).getName());
        Assert.assertEquals((Object)"Starting RPC retry 1", (Object)((EventData)events.get(1)).getName());
        Assert.assertEquals((Object)"Attempt succeeded", (Object)((EventData)events.get(2)).getName());
    }

    @Test
    public void testRetryQuery() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.UNAVAILABLE.asRuntimeException())));
        try (ResultSet resultSet = this.client.singleUse().executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        List<SpanData> executeStreamingSqlSpans = this.getSpans("Spanner.ExecuteStreamingSql", Attributes.empty(), spans);
        Assert.assertEquals((long)2L, (long)executeStreamingSqlSpans.size());
        SpanData span1 = executeStreamingSqlSpans.get(0);
        Assert.assertEquals((Object)StatusCode.ERROR, (Object)span1.getStatus().getStatusCode());
        SpanData span2 = executeStreamingSqlSpans.get(1);
        Assert.assertEquals((Object)StatusCode.OK, (Object)span2.getStatus().getStatusCode());
    }

    @Test
    public void testLroSucceeded() throws Exception {
        this.addUpdateDdlResponse();
        OperationFuture operationFuture = this.spanner.getDatabaseAdminClient().updateDatabaseDdl("i", "d", (Iterable)ImmutableList.of((Object)"create table foo (id int64) primary key (id)"), null);
        Assert.assertNull((Object)operationFuture.get());
        do {
            Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        } while (this.getSpans("DatabaseAdmin.UpdateDatabaseDdlOperation", Attributes.empty(), spanExporter.getFinishedSpanItems()).isEmpty() || this.getSpans("Operations.GetOperation", Attributes.empty(), spanExporter.getFinishedSpanItems()).size() < 2);
        List spans = spanExporter.getFinishedSpanItems();
        SpanData updateDatabaseDdl = this.getSpan("DatabaseAdmin.UpdateDatabaseDdl", spans);
        Assert.assertEquals((long)1L, (long)updateDatabaseDdl.getTotalRecordedEvents());
        Assert.assertEquals((Object)"Attempt succeeded", (Object)((EventData)updateDatabaseDdl.getEvents().get(0)).getName());
        SpanData updateDatabaseDdlOperation = this.getSpan("DatabaseAdmin.UpdateDatabaseDdlOperation", spans);
        Assert.assertTrue((updateDatabaseDdlOperation.getTotalRecordedEvents() >= 5 ? 1 : 0) != 0);
        this.assertContainsEvent("Operation started", updateDatabaseDdlOperation.getEvents());
        this.assertContainsEvent("Starting poll attempt 0", updateDatabaseDdlOperation.getEvents());
        this.assertContainsEvent("Scheduling next poll", updateDatabaseDdlOperation.getEvents());
        this.assertContainsEvent("Starting poll attempt 1", updateDatabaseDdlOperation.getEvents());
        this.assertContainsEvent("Polling completed", updateDatabaseDdlOperation.getEvents());
        List<SpanData> polls = this.getSpans("Operations.GetOperation", Attributes.empty(), spans);
        Assert.assertEquals((long)2L, (long)polls.size());
    }

    @Test
    public void testLroCreationFailed() {
        mockDatabaseAdmin.addException((Exception)((Object)Status.INVALID_ARGUMENT.asRuntimeException()));
        OperationFuture operationFuture = this.spanner.getDatabaseAdminClient().updateDatabaseDdl("i", "d", (Iterable)ImmutableList.of((Object)"create table foo (id int64) primary key (id)"), null);
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> operationFuture.get());
        Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)SpannerExceptionFactory.asSpannerException((Throwable)executionException.getCause()).getErrorCode());
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        SpanData updateDatabaseDdl = this.getSpan("DatabaseAdmin.UpdateDatabaseDdl", spans);
        Assert.assertEquals((long)1L, (long)updateDatabaseDdl.getTotalRecordedEvents());
        Assert.assertEquals((Object)"Attempt failed, error not retryable", (Object)((EventData)updateDatabaseDdl.getEvents().get(0)).getName());
        Assert.assertEquals((Object)StatusCode.ERROR, (Object)updateDatabaseDdl.getStatus().getStatusCode());
    }

    @Test
    public void testLroOperationFailed() {
        this.addUpdateDdlError();
        OperationFuture operationFuture = this.spanner.getDatabaseAdminClient().updateDatabaseDdl("i", "d", (Iterable)ImmutableList.of((Object)"create table foo (id int64) primary key (id)"), null);
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> operationFuture.get());
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)SpannerExceptionFactory.asSpannerException((Throwable)executionException.getCause()).getErrorCode());
        do {
            Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        } while (this.getSpans("DatabaseAdmin.UpdateDatabaseDdlOperation", Attributes.empty(), spanExporter.getFinishedSpanItems()).isEmpty());
        List spans = spanExporter.getFinishedSpanItems();
        SpanData updateDatabaseDdl = this.getSpan("DatabaseAdmin.UpdateDatabaseDdl", spans);
        Assert.assertEquals((long)1L, (long)updateDatabaseDdl.getTotalRecordedEvents());
        Assert.assertEquals((Object)"Attempt succeeded", (Object)((EventData)updateDatabaseDdl.getEvents().get(0)).getName());
        Assert.assertEquals((Object)StatusCode.OK, (Object)updateDatabaseDdl.getStatus().getStatusCode());
        SpanData updateDatabaseDdlOperation = this.getSpan("DatabaseAdmin.UpdateDatabaseDdlOperation", spans);
        Assert.assertEquals((long)3L, (long)updateDatabaseDdlOperation.getTotalRecordedEvents());
        this.assertContainsEvent("Operation started", updateDatabaseDdlOperation.getEvents());
        this.assertContainsEvent("Starting poll attempt 0", updateDatabaseDdlOperation.getEvents());
        this.assertContainsEvent("Polling completed", updateDatabaseDdlOperation.getEvents());
        Assert.assertEquals((Object)StatusCode.ERROR, (Object)updateDatabaseDdlOperation.getStatus().getStatusCode());
    }

    @Test
    public void testEnableWithEnvVar() {
        SpannerOptions.useEnvironment((SpannerOptions.SpannerEnvironment)new SpannerOptions.SpannerEnvironment(){

            public boolean isEnableApiTracing() {
                return true;
            }
        });
        Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).setFailOnSessionLeak().build()).build().getService();
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ResultSet resultSet = client.singleUse().executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        Assert.assertEquals((Object)CompletableResultCode.ofSuccess(), (Object)spanExporter.flush());
        List spans = spanExporter.getFinishedSpanItems();
        this.assertContains("CloudSpanner.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertContains("Spanner.ExecuteStreamingSql", spans);
        this.assertParent("CloudSpanner.ReadOnlyTransaction", "CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertParent("CloudSpannerOperation.ExecuteStreamingQuery", "Spanner.ExecuteStreamingSql", spans);
    }

    void assertContains(String expected, List<SpanData> spans) {
        Assert.assertTrue((String)("Expected " + this.spansToString(spans) + " to contain " + expected), (boolean)spans.stream().anyMatch(span -> span.getName().equals(expected)));
    }

    void assertContainsEvent(String expected, List<EventData> events) {
        Assert.assertTrue((String)("Expected " + this.eventsToString(events) + " to contain " + expected), (boolean)events.stream().anyMatch(event -> event.getName().equals(expected)));
    }

    boolean equalsSpan(SpanData span, String name, Attributes attributes) {
        if (!span.getName().equals(name)) {
            return false;
        }
        for (Map.Entry entry : attributes.asMap().entrySet()) {
            if (!span.getAttributes().asMap().containsKey(entry.getKey())) {
                return false;
            }
            if (Objects.equals(entry.getValue(), span.getAttributes().get((AttributeKey)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    void assertParent(String expectedParent, String child, List<SpanData> spans) {
        SpanData parentSpan = this.getSpan(expectedParent, spans);
        SpanData childSpan = this.getSpan(child, spans);
        Assert.assertEquals((Object)parentSpan.getSpanId(), (Object)childSpan.getParentSpanId());
    }

    void assertParent(String expectedParent, String child, Attributes attributes, List<SpanData> spans) {
        SpanData parentSpan = this.getSpan(expectedParent, spans);
        List<SpanData> childSpans = this.getSpans(child, attributes, spans);
        for (SpanData childSpan : childSpans) {
            Assert.assertEquals((Object)parentSpan.getSpanId(), (Object)childSpan.getParentSpanId());
        }
    }

    SpanData getSpan(String name, List<SpanData> spans) {
        return spans.stream().filter(span -> span.getName().equals(name)).findAny().orElseThrow(() -> new IllegalArgumentException("Span " + name + " not found"));
    }

    List<SpanData> getSpans(String name, Attributes attributes, List<SpanData> spans) {
        return spans.stream().filter(span -> this.equalsSpan((SpanData)span, name, attributes)).collect(Collectors.toList());
    }

    private String spansToString(List<SpanData> spans) {
        return spans.stream().map(SpanData::getName).collect(Collectors.joining("\n", "\n", "\n"));
    }

    private String eventsToString(List<EventData> events) {
        return events.stream().map(EventData::getName).collect(Collectors.joining("\n", "\n", "\n"));
    }
}

