/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.MetricsRecorder;
import com.google.api.gax.tracing.MetricsTracerFactory;
import com.google.api.gax.tracing.OpenTelemetryMetricsRecorder;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbstractMockServerTest;
import com.google.cloud.spanner.BuiltInMetricsConstant;
import com.google.cloud.spanner.BuiltInOpenTelemetryMetricsProvider;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import io.grpc.Status;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class OpenTelemetryBuiltInMetricsTracerTest
extends AbstractMockServerTest {
    private static final Statement SELECT_RANDOM = Statement.of((String)"SELECT * FROM random");
    private static final Statement UPDATE_RANDOM = Statement.of((String)"UPDATE random SET foo=1 WHERE id=1");
    private static InMemoryMetricReader metricReader;
    private static OpenTelemetry openTelemetry;
    private static Map<String, String> attributes;
    private static Attributes expectedBaseAttributes;
    private static final long MIN_LATENCY = 0L;
    private DatabaseClient client;

    @BeforeClass
    public static void setup() {
        metricReader = InMemoryMetricReader.create();
        BuiltInOpenTelemetryMetricsProvider provider = BuiltInOpenTelemetryMetricsProvider.INSTANCE;
        SdkMeterProviderBuilder meterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)metricReader);
        BuiltInMetricsConstant.getAllViews().forEach((arg_0, arg_1) -> ((SdkMeterProviderBuilder)meterProvider).registerView(arg_0, arg_1));
        String client_name = "spanner-java/";
        openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(meterProvider.build()).build();
        attributes = provider.createClientAttributes("test-project", client_name);
        expectedBaseAttributes = Attributes.builder().put(BuiltInMetricsConstant.PROJECT_ID_KEY, (Object)"test-project").put(BuiltInMetricsConstant.INSTANCE_CONFIG_ID_KEY, (Object)"unknown").put(BuiltInMetricsConstant.LOCATION_ID_KEY, (Object)BuiltInOpenTelemetryMetricsProvider.detectClientLocation()).put(BuiltInMetricsConstant.CLIENT_NAME_KEY, (Object)client_name).put(BuiltInMetricsConstant.CLIENT_UID_KEY, (Object)attributes.get("client_uid")).put(BuiltInMetricsConstant.CLIENT_HASH_KEY, (Object)"cloud_spanner_client_raw_metrics").build();
    }

    @BeforeClass
    public static void setupResults() {
        RandomResultSetGenerator generator = new RandomResultSetGenerator(1);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_RANDOM, generator.generate()));
        mockSpanner.putStatementResults(MockSpannerServiceImpl.StatementResult.update(UPDATE_RANDOM, 1L));
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Override
    public void createSpannerInstance() {
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        MetricsTracerFactory metricsTracerFactory = new MetricsTracerFactory((MetricsRecorder)new OpenTelemetryMetricsRecorder(openTelemetry, "spanner.googleapis.com/internal/client"), attributes);
        builder.getDatabaseAdminStubSettingsBuilder().updateDatabaseDdlOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofNanos((long)1L)).setMaxRetryDelay(Duration.ofNanos((long)1L)).setRetryDelayMultiplier(1.0).setTotalTimeout(Duration.ofMinutes((long)10L)).build()));
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)((SpannerOptions.Builder)builder.setProjectId("test-project")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).setFailOnSessionLeak().build()).setEnableBuiltInMetrics(false).setApiTracerFactory((ApiTracerFactory)metricsTracerFactory)).build().getService();
        this.client = this.spanner.getDatabaseClient(DatabaseId.of((String)"test-project", (String)"i", (String)"d"));
    }

    @Test
    public void testMetricsSingleUseQuery() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (ResultSet resultSet = this.client.singleUse().executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Attributes expectedAttributes = expectedBaseAttributes.toBuilder().put(BuiltInMetricsConstant.STATUS_KEY, (Object)"OK").put(BuiltInMetricsConstant.METHOD_KEY, (Object)"Spanner.ExecuteStreamingSql").build();
        MetricData operationLatencyMetricData = this.getMetricData(metricReader, "operation_latencies");
        long operationLatencyValue = this.getAggregatedValue(operationLatencyMetricData, expectedAttributes);
        Truth.assertThat((Long)operationLatencyValue).isIn(Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(elapsed)));
        MetricData attemptLatencyMetricData = this.getMetricData(metricReader, "attempt_latencies");
        long attemptLatencyValue = this.getAggregatedValue(attemptLatencyMetricData, expectedAttributes);
        Truth.assertThat((Long)attemptLatencyValue).isIn(Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(elapsed)));
        MetricData operationCountMetricData = this.getMetricData(metricReader, "operation_count");
        Truth.assertThat((Long)this.getAggregatedValue(operationCountMetricData, expectedAttributes)).isEqualTo((Object)1);
        MetricData attemptCountMetricData = this.getMetricData(metricReader, "attempt_count");
        Truth.assertThat((Long)this.getAggregatedValue(attemptCountMetricData, expectedAttributes)).isEqualTo((Object)1);
    }

    @Test
    public void testMetricsWithGaxRetryUnaryRpc() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.UNAVAILABLE.asRuntimeException()));
        this.client.write((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("bar").to(1L)).build()));
        stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Attributes expectedAttributesBeginTransactionOK = expectedBaseAttributes.toBuilder().put(BuiltInMetricsConstant.STATUS_KEY, (Object)"OK").put(BuiltInMetricsConstant.METHOD_KEY, (Object)"Spanner.BeginTransaction").build();
        Attributes expectedAttributesBeginTransactionFailed = expectedBaseAttributes.toBuilder().put(BuiltInMetricsConstant.STATUS_KEY, (Object)"UNAVAILABLE").put(BuiltInMetricsConstant.METHOD_KEY, (Object)"Spanner.BeginTransaction").build();
        MetricData attemptCountMetricData = this.getMetricData(metricReader, "attempt_count");
        Truth.assertThat((Long)this.getAggregatedValue(attemptCountMetricData, expectedAttributesBeginTransactionOK)).isEqualTo((Object)1);
        Truth.assertThat((Long)this.getAggregatedValue(attemptCountMetricData, expectedAttributesBeginTransactionFailed)).isEqualTo((Object)1);
        MetricData operationCountMetricData = this.getMetricData(metricReader, "operation_count");
        Truth.assertThat((Long)this.getAggregatedValue(operationCountMetricData, expectedAttributesBeginTransactionOK)).isEqualTo((Object)1);
        Truth.assertThat((Long)this.getAggregatedValue(operationCountMetricData, expectedAttributesBeginTransactionFailed)).isEqualTo((Object)0);
    }

    private MetricData getMetricData(InMemoryMetricReader reader, String metricName) {
        String fullMetricName = "spanner.googleapis.com/internal/client/" + metricName;
        Collection<Object> allMetricData = Collections.emptyList();
        for (int attemptsLeft = 1000; attemptsLeft > 0; --attemptsLeft) {
            allMetricData = reader.collectAllMetrics();
            List matchingMetadata = allMetricData.stream().filter(md -> md.getName().equals(fullMetricName)).collect(Collectors.toList());
            Truth.assertWithMessage((String)"Found multiple MetricData with the same name: %s, in: %s", (Object[])new Object[]{fullMetricName, matchingMetadata}).that(Integer.valueOf(matchingMetadata.size())).isAtMost((Comparable)Integer.valueOf(1));
            if (!matchingMetadata.isEmpty()) {
                return (MetricData)matchingMetadata.get(0);
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptedException);
            }
        }
        Assert.assertTrue((String)String.format("MetricData is missing for metric {0}", fullMetricName), (boolean)false);
        return null;
    }

    private long getAggregatedValue(MetricData metricData, Attributes attributes) {
        switch (metricData.getType()) {
            case HISTOGRAM: {
                Optional hd = metricData.getHistogramData().getPoints().stream().filter(pd -> pd.getAttributes().equals(attributes)).collect(Collectors.toList()).stream().findFirst();
                return hd.isPresent() ? (long)((HistogramPointData)hd.get()).getSum() / ((HistogramPointData)hd.get()).getCount() : 0L;
            }
            case LONG_SUM: {
                Optional ld = metricData.getLongSumData().getPoints().stream().filter(pd -> pd.getAttributes().equals(attributes)).collect(Collectors.toList()).stream().findFirst();
                return ld.isPresent() ? ((LongPointData)ld.get()).getValue() : 0L;
            }
        }
        return 0L;
    }
}

