/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.FailOnOverkillTraceComponentImpl;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TracerTest;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServerBuilder;
import io.opencensus.trace.Tracing;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@Category(value={TracerTest.class})
@RunWith(value=JUnit4.class)
public class OpenTelemetrySpanTest {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_INSTANCE = "my-instance";
    private static final String TEST_DATABASE = "my-database";
    private static LocalChannelProvider channelProvider;
    private static MockSpannerServiceImpl mockSpanner;
    private Spanner spanner;
    private Spanner spannerWithApiTracing;
    private static Server server;
    private static InMemorySpanExporter spanExporter;
    private static FailOnOverkillTraceComponentImpl failOnOverkillTraceComponent;
    private static final Statement SELECT1;
    private static final ResultSetMetadata SELECT1_METADATA;
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET;
    private static final Statement UPDATE_STATEMENT;
    private static final long UPDATE_COUNT = 1L;
    private static final Statement INVALID_UPDATE_STATEMENT;
    private List<String> expectedCreateMultiplexedSessionsRequestEvents = ImmutableList.of((Object)"Request for 1 multiplexed session returned 1 session");
    private int expectedCreateMultiplexedSessionsRequestEventsCount = 1;
    private List<String> expectedBatchCreateSessionsRequestEvents = ImmutableList.of((Object)"Requesting 2 sessions", (Object)"Request for 2 sessions returned 2 sessions");
    private int expectedBatchCreateSessionsRequestEventsCount = 2;
    private List<String> expectedBatchCreateSessionsEvents = ImmutableList.of((Object)"Creating 2 sessions");
    private int expectedBatchCreateSessionsEventsCount = 1;
    private List<String> expectedExecuteStreamingQueryEvents = ImmutableList.of((Object)"Starting/Resuming stream");
    private int expectedExecuteStreamingQueryEventsCount = 1;
    private List<String> expectedReadWriteTransactionErrorEvents = ImmutableList.of((Object)"Acquiring session", (Object)"Acquired session", (Object)"Using Session", (Object)"Starting Transaction Attempt", (Object)"Transaction Attempt Failed in user operation", (Object)"exception");
    private int expectedReadWriteTransactionErrorEventsCount = 6;
    private List<String> expectedReadWriteTransactionEvents = ImmutableList.of((Object)"Acquiring session", (Object)"Acquired session", (Object)"Using Session", (Object)"Starting Transaction Attempt", (Object)"Starting Commit", (Object)"Commit Done", (Object)"Transaction Attempt Succeeded");
    private int expectedReadWriteTransactionCount = 7;
    private List<String> expectedReadWriteTransactionErrorWithBeginTransactionEvents = ImmutableList.of((Object)"Acquiring session", (Object)"Acquired session", (Object)"Using Session", (Object)"Starting Transaction Attempt", (Object)"Transaction Attempt Aborted in user operation. Retrying", (Object)"Creating Transaction", (Object)"Transaction Creation Done", (Object)"Starting Commit", (Object)"Commit Done", (Object)"Transaction Attempt Succeeded");
    private int expectedReadWriteTransactionErrorWithBeginTransactionEventsCount = 11;

    @BeforeClass
    public static void setupOpenTelemetry() {
        SpannerOptions.resetActiveTracingFramework();
        SpannerOptions.enableOpenTelemetryTraces();
    }

    @BeforeClass
    public static void startStaticServer() throws Exception {
        Field field = Tracing.class.getDeclaredField("traceComponent");
        field.setAccessible(true);
        Field modifiersField = null;
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            Assume.assumeTrue((String)"Skipping test as reflection is not allowed on reflection class in this JDK build", (boolean)false);
        }
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, (Object)failOnOverkillTraceComponent);
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
        failOnOverkillTraceComponent.clearSpans();
        failOnOverkillTraceComponent.clearAnnotations();
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        if (server != null) {
            server.shutdown();
            server.awaitTermination();
        }
    }

    @Before
    public void setUp() throws Exception {
        spanExporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(tracerProvider).build();
        SpannerOptions.Builder builder = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setOpenTelemetry((OpenTelemetry)openTelemetry).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(2).setWaitForMinSessions(Duration.ofSeconds((long)10L)).build());
        this.spanner = (Spanner)builder.build().getService();
        this.spannerWithApiTracing = (Spanner)builder.setEnableApiTracing(true).build().getService();
    }

    DatabaseClient getClient() {
        return this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
    }

    DatabaseClient getClientWithApiTracing() {
        return this.spannerWithApiTracing.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
    }

    @After
    public void tearDown() {
        this.spanner.close();
        this.spannerWithApiTracing.close();
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        spanExporter.reset();
    }

    @Test
    public void singleUse() {
        List<String> expectedReadOnlyTransactionSingleUseEvents = this.getExpectedReadOnlyTransactionSingleUseEvents();
        ImmutableList expectedReadOnlyTransactionSpans = this.isMultiplexedSessionsEnabled() ? ImmutableList.of((Object)"CloudSpannerOperation.CreateMultiplexedSession", (Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)"CloudSpannerOperation.ExecuteStreamingQuery", (Object)"CloudSpannerOperation.BatchCreateSessions", (Object)"CloudSpanner.ReadOnlyTransaction") : ImmutableList.of((Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)"CloudSpannerOperation.ExecuteStreamingQuery", (Object)"CloudSpannerOperation.BatchCreateSessions", (Object)"CloudSpanner.ReadOnlyTransaction");
        int expectedReadOnlyTransactionSingleUseEventsCount = expectedReadOnlyTransactionSingleUseEvents.size();
        DatabaseClient client = this.getClient();
        try (ResultSet rs = client.singleUse().executeQuery(SELECT1, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
        Assert.assertEquals((long)failOnOverkillTraceComponent.getSpans().size(), (long)0L);
        ArrayList<String> actualSpanItems = new ArrayList<String>();
        spanExporter.getFinishedSpanItems().forEach(spanItem -> {
            actualSpanItems.add(spanItem.getName());
            switch (spanItem.getName()) {
                case "CloudSpannerOperation.CreateMultiplexedSession": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedCreateMultiplexedSessionsRequestEvents, this.expectedCreateMultiplexedSessionsRequestEventsCount);
                    break;
                }
                case "CloudSpannerOperation.BatchCreateSessionsRequest": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedBatchCreateSessionsRequestEvents, this.expectedBatchCreateSessionsRequestEventsCount);
                    break;
                }
                case "CloudSpannerOperation.BatchCreateSessions": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedBatchCreateSessionsEvents, this.expectedBatchCreateSessionsEventsCount);
                    break;
                }
                case "CloudSpannerOperation.ExecuteStreamingQuery": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedExecuteStreamingQueryEvents, this.expectedExecuteStreamingQueryEventsCount);
                    break;
                }
                case "CloudSpanner.ReadOnlyTransaction": {
                    this.verifyRequestEvents((SpanData)spanItem, expectedReadOnlyTransactionSingleUseEvents, expectedReadOnlyTransactionSingleUseEventsCount);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        });
        OpenTelemetrySpanTest.verifySpans(actualSpanItems, (List<String>)expectedReadOnlyTransactionSpans);
    }

    private List<String> getExpectedReadOnlyTransactionSingleUseEvents() {
        ImmutableList expectedReadOnlyTransactionSingleUseEvents = this.isMultiplexedSessionsEnabled() ? ImmutableList.of() : ImmutableList.of((Object)"Acquiring session", (Object)"Acquired session", (Object)"Using Session");
        return expectedReadOnlyTransactionSingleUseEvents;
    }

    @Test
    public void multiUse() {
        ImmutableList expectedReadOnlyTransactionSpans = this.isMultiplexedSessionsEnabled() ? ImmutableList.of((Object)"CloudSpannerOperation.CreateMultiplexedSession", (Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)"CloudSpannerOperation.ExecuteStreamingQuery", (Object)"CloudSpannerOperation.BatchCreateSessions", (Object)"CloudSpanner.ReadOnlyTransaction") : ImmutableList.of((Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)"CloudSpannerOperation.ExecuteStreamingQuery", (Object)"CloudSpannerOperation.BatchCreateSessions", (Object)"CloudSpanner.ReadOnlyTransaction");
        ImmutableList expectedReadOnlyTransactionMultiUseEvents = this.isMultiplexedSessionsEnabled() ? ImmutableList.of((Object)"Creating Transaction", (Object)"Transaction Creation Done") : ImmutableList.of((Object)"Acquiring session", (Object)"Acquired session", (Object)"Using Session", (Object)"Creating Transaction", (Object)"Transaction Creation Done");
        int expectedReadOnlyTransactionMultiUseEventsCount = expectedReadOnlyTransactionMultiUseEvents.size();
        DatabaseClient client = this.getClient();
        try (ReadOnlyTransaction tx = client.readOnlyTransaction();
             ResultSet rs = tx.executeQuery(SELECT1, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
        ArrayList<String> actualSpanItems = new ArrayList<String>();
        spanExporter.getFinishedSpanItems().forEach(arg_0 -> this.lambda$multiUse$1(actualSpanItems, (List)expectedReadOnlyTransactionMultiUseEvents, expectedReadOnlyTransactionMultiUseEventsCount, arg_0));
        OpenTelemetrySpanTest.verifySpans(actualSpanItems, (List<String>)expectedReadOnlyTransactionSpans);
    }

    @Test
    public void transactionRunner() {
        ImmutableList expectedReadWriteTransactionWithCommitSpans = this.isMultiplexedSessionsEnabled() ? ImmutableList.of((Object)"CloudSpannerOperation.CreateMultiplexedSession", (Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)"CloudSpannerOperation.ExecuteUpdate", (Object)"CloudSpannerOperation.Commit", (Object)"CloudSpannerOperation.BatchCreateSessions", (Object)"CloudSpanner.ReadWriteTransaction") : ImmutableList.of((Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)"CloudSpannerOperation.ExecuteUpdate", (Object)"CloudSpannerOperation.Commit", (Object)"CloudSpannerOperation.BatchCreateSessions", (Object)"CloudSpanner.ReadWriteTransaction");
        DatabaseClient client = this.getClient();
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (spanExporter.getFinishedSpanItems().stream().noneMatch(span -> span.getName().equals("CloudSpannerOperation.BatchCreateSessions")) && stopwatch.elapsed(TimeUnit.MILLISECONDS) < 100L) {
            Thread.yield();
        }
        ArrayList<String> actualSpanItems = new ArrayList<String>();
        spanExporter.getFinishedSpanItems().forEach(spanItem -> {
            actualSpanItems.add(spanItem.getName());
            switch (spanItem.getName()) {
                case "CloudSpannerOperation.CreateMultiplexedSession": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedCreateMultiplexedSessionsRequestEvents, this.expectedCreateMultiplexedSessionsRequestEventsCount);
                    break;
                }
                case "CloudSpannerOperation.BatchCreateSessionsRequest": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedBatchCreateSessionsRequestEvents, this.expectedBatchCreateSessionsRequestEventsCount);
                    break;
                }
                case "CloudSpannerOperation.BatchCreateSessions": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedBatchCreateSessionsEvents, this.expectedBatchCreateSessionsEventsCount);
                    break;
                }
                case "CloudSpannerOperation.Commit": 
                case "CloudSpannerOperation.ExecuteUpdate": {
                    Assert.assertEquals((long)0L, (long)spanItem.getEvents().size());
                    break;
                }
                case "CloudSpanner.ReadWriteTransaction": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedReadWriteTransactionEvents, this.expectedReadWriteTransactionCount);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        });
        OpenTelemetrySpanTest.verifySpans(actualSpanItems, (List<String>)expectedReadWriteTransactionWithCommitSpans);
    }

    @Test
    public void transactionRunnerWithError() {
        ImmutableList expectedReadWriteTransactionSpans = this.isMultiplexedSessionsEnabled() ? ImmutableList.of((Object)"CloudSpannerOperation.CreateMultiplexedSession", (Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)"CloudSpannerOperation.BatchCreateSessions", (Object)"CloudSpannerOperation.ExecuteUpdate", (Object)"CloudSpanner.ReadWriteTransaction") : ImmutableList.of((Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)"CloudSpannerOperation.BatchCreateSessions", (Object)"CloudSpannerOperation.ExecuteUpdate", (Object)"CloudSpanner.ReadWriteTransaction");
        DatabaseClient client = this.getClient();
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> runner.run(transaction -> transaction.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0])));
        Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
        ArrayList<String> actualSpanItems = new ArrayList<String>();
        spanExporter.getFinishedSpanItems().forEach(spanItem -> {
            actualSpanItems.add(spanItem.getName());
            switch (spanItem.getName()) {
                case "CloudSpannerOperation.CreateMultiplexedSession": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedCreateMultiplexedSessionsRequestEvents, this.expectedCreateMultiplexedSessionsRequestEventsCount);
                    break;
                }
                case "CloudSpannerOperation.BatchCreateSessionsRequest": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedBatchCreateSessionsRequestEvents, this.expectedBatchCreateSessionsRequestEventsCount);
                    break;
                }
                case "CloudSpannerOperation.BatchCreateSessions": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedBatchCreateSessionsEvents, this.expectedBatchCreateSessionsEventsCount);
                    break;
                }
                case "CloudSpanner.ReadWriteTransaction": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedReadWriteTransactionErrorEvents, this.expectedReadWriteTransactionErrorEventsCount);
                    break;
                }
                case "CloudSpannerOperation.ExecuteUpdate": {
                    Assert.assertEquals((long)0L, (long)spanItem.getEvents().size());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        });
        OpenTelemetrySpanTest.verifySpans(actualSpanItems, (List<String>)expectedReadWriteTransactionSpans);
    }

    @Test
    public void transactionRunnerWithFailedAndBeginTransaction() {
        ImmutableList expectedReadWriteTransactionWithCommitAndBeginTransactionSpans = ImmutableList.of((Object)"CloudSpannerOperation.BeginTransaction", (Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)"CloudSpannerOperation.ExecuteUpdate", (Object)"CloudSpannerOperation.Commit", (Object)"CloudSpannerOperation.BatchCreateSessions", (Object)"CloudSpanner.ReadWriteTransaction");
        DatabaseClient client = this.getClient();
        Assert.assertEquals((Object)1L, (Object)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> transaction.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
        }));
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (spanExporter.getFinishedSpanItems().size() < expectedReadWriteTransactionWithCommitAndBeginTransactionSpans.size() && stopwatch.elapsed(TimeUnit.MILLISECONDS) < 2000L) {
            Thread.yield();
        }
        ArrayList<String> actualSpanItems = new ArrayList<String>();
        spanExporter.getFinishedSpanItems().forEach(spanItem -> {
            if (!"CloudSpannerOperation.CreateMultiplexedSession".equals(spanItem.getName())) {
                actualSpanItems.add(spanItem.getName());
            }
            switch (spanItem.getName()) {
                case "CloudSpannerOperation.CreateMultiplexedSession": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedCreateMultiplexedSessionsRequestEvents, this.expectedCreateMultiplexedSessionsRequestEventsCount);
                    break;
                }
                case "CloudSpannerOperation.BatchCreateSessionsRequest": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedBatchCreateSessionsRequestEvents, this.expectedBatchCreateSessionsRequestEventsCount);
                    break;
                }
                case "CloudSpannerOperation.BatchCreateSessions": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedBatchCreateSessionsEvents, this.expectedBatchCreateSessionsEventsCount);
                    break;
                }
                case "CloudSpannerOperation.Commit": 
                case "CloudSpannerOperation.BeginTransaction": 
                case "CloudSpannerOperation.ExecuteUpdate": {
                    Assert.assertEquals((long)0L, (long)spanItem.getEvents().size());
                    break;
                }
                case "CloudSpanner.ReadWriteTransaction": {
                    this.verifyRequestEvents((SpanData)spanItem, this.expectedReadWriteTransactionErrorWithBeginTransactionEvents, this.expectedReadWriteTransactionErrorWithBeginTransactionEventsCount);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        });
        OpenTelemetrySpanTest.verifySpans(actualSpanItems, (List<String>)expectedReadWriteTransactionWithCommitAndBeginTransactionSpans);
    }

    @Test
    public void testTransactionRunnerWithRetryOnBeginTransaction() {
        DatabaseClient clientWithApiTracing = this.getClientWithApiTracing();
        mockSpanner.addException((Exception)Status.UNAVAILABLE.asRuntimeException());
        clientWithApiTracing.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).build());
            return null;
        });
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        int numExpectedSpans = this.isMultiplexedSessionsEnabled() ? 10 : 8;
        this.waitForFinishedSpans(numExpectedSpans);
        List finishedSpans = spanExporter.getFinishedSpanItems();
        List finishedSpanNames = finishedSpans.stream().map(SpanData::getName).collect(Collectors.toList());
        String actualSpanNames = finishedSpans.stream().map(SpanData::getName).collect(Collectors.joining("\n", "\n", "\n"));
        Assert.assertEquals((String)actualSpanNames, (long)numExpectedSpans, (long)finishedSpans.size());
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpanner.ReadWriteTransaction"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.BeginTransaction"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.Commit"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.BatchCreateSessions"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.BatchCreateSessionsRequest"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("Spanner.BatchCreateSessions"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("Spanner.BeginTransaction"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("Spanner.Commit"));
        SpanData beginTransactionSpan = finishedSpans.stream().filter(span -> span.getName().equals("Spanner.BeginTransaction")).findAny().orElseThrow(IllegalStateException::new);
        Assert.assertTrue((String)beginTransactionSpan.toString(), (boolean)beginTransactionSpan.getEvents().stream().anyMatch(event -> event.getName().equals("Starting RPC retry 1")));
    }

    @Test
    public void testSingleUseRetryOnExecuteStreamingSql() {
        DatabaseClient clientWithApiTracing = this.getClientWithApiTracing();
        mockSpanner.addException((Exception)Status.UNAVAILABLE.asRuntimeException());
        try (ResultSet resultSet = clientWithApiTracing.singleUse().executeQuery(SELECT1, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        int numExpectedSpans = this.isMultiplexedSessionsEnabled() ? 9 : 7;
        this.waitForFinishedSpans(numExpectedSpans);
        List finishedSpans = spanExporter.getFinishedSpanItems();
        List finishedSpanNames = finishedSpans.stream().map(SpanData::getName).collect(Collectors.toList());
        String actualSpanNames = finishedSpans.stream().map(SpanData::getName).collect(Collectors.joining("\n", "\n", "\n"));
        Assert.assertEquals((String)actualSpanNames, (long)numExpectedSpans, (long)finishedSpans.size());
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpanner.ReadOnlyTransaction"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.ExecuteStreamingQuery"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.BatchCreateSessions"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.BatchCreateSessionsRequest"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("Spanner.BatchCreateSessions"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("Spanner.ExecuteStreamingSql"));
        SpanData executeStreamingQuery = finishedSpans.stream().filter(span -> span.getName().equals("CloudSpannerOperation.ExecuteStreamingQuery")).findAny().orElseThrow(IllegalStateException::new);
        Assert.assertTrue((String)executeStreamingQuery.toString(), (boolean)executeStreamingQuery.getEvents().stream().anyMatch(event -> event.getName().contains("Stream broken. Safe to retry")));
    }

    @Test
    public void testRetryOnExecuteSql() {
        DatabaseClient clientWithApiTracing = this.getClientWithApiTracing();
        mockSpanner.addException((Exception)Status.UNAVAILABLE.asRuntimeException());
        clientWithApiTracing.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        int numExpectedSpans = this.isMultiplexedSessionsEnabled() ? 10 : 8;
        this.waitForFinishedSpans(numExpectedSpans);
        List finishedSpans = spanExporter.getFinishedSpanItems();
        List finishedSpanNames = finishedSpans.stream().map(SpanData::getName).collect(Collectors.toList());
        String actualSpanNames = finishedSpans.stream().map(SpanData::getName).collect(Collectors.joining("\n", "\n", "\n"));
        Assert.assertEquals((String)actualSpanNames, (long)numExpectedSpans, (long)finishedSpans.size());
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpanner.ReadWriteTransaction"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.Commit"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.BatchCreateSessions"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("CloudSpannerOperation.BatchCreateSessionsRequest"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("Spanner.BatchCreateSessions"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("Spanner.ExecuteSql"));
        Assert.assertTrue((String)actualSpanNames, (boolean)finishedSpanNames.contains("Spanner.Commit"));
        SpanData executeSqlSpan = finishedSpans.stream().filter(span -> span.getName().equals("Spanner.ExecuteSql")).findAny().orElseThrow(IllegalStateException::new);
        Assert.assertTrue((String)executeSqlSpan.toString(), (boolean)executeSqlSpan.getEvents().stream().anyMatch(event -> event.getName().equals("Starting RPC retry 1")));
    }

    private void waitForFinishedSpans(int numExpectedSpans) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (spanExporter.getFinishedSpanItems().size() < numExpectedSpans && stopwatch.elapsed().compareTo(java.time.Duration.ofMillis(1000L)) < 0) {
            Thread.yield();
        }
    }

    private void verifyRequestEvents(SpanData spanItem, List<String> expectedEvents, int eventCount) {
        List eventNames = spanItem.getEvents().stream().map(EventData::getName).collect(Collectors.toList());
        Assert.assertEquals((long)eventCount, (long)spanItem.getEvents().size());
        Assert.assertEquals(expectedEvents.stream().sorted().collect(Collectors.toList()), eventNames.stream().distinct().sorted().collect(Collectors.toList()));
    }

    private static void verifySpans(List<String> actualSpanItems, List<String> expectedSpansItems) {
        Assert.assertEquals(expectedSpansItems.stream().sorted().collect(Collectors.toList()), actualSpanItems.stream().distinct().sorted().collect(Collectors.toList()));
    }

    private boolean isMultiplexedSessionsEnabled() {
        if (this.spanner.getOptions() == null || ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions() == null) {
            return false;
        }
        return ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession();
    }

    private /* synthetic */ void lambda$multiUse$1(List actualSpanItems, List expectedReadOnlyTransactionMultiUseEvents, int expectedReadOnlyTransactionMultiUseEventsCount, SpanData spanItem) {
        actualSpanItems.add(spanItem.getName());
        switch (spanItem.getName()) {
            case "CloudSpannerOperation.CreateMultiplexedSession": {
                this.verifyRequestEvents(spanItem, this.expectedCreateMultiplexedSessionsRequestEvents, this.expectedCreateMultiplexedSessionsRequestEventsCount);
                break;
            }
            case "CloudSpannerOperation.BatchCreateSessionsRequest": {
                this.verifyRequestEvents(spanItem, this.expectedBatchCreateSessionsRequestEvents, this.expectedBatchCreateSessionsRequestEventsCount);
                break;
            }
            case "CloudSpannerOperation.BatchCreateSessions": {
                this.verifyRequestEvents(spanItem, this.expectedBatchCreateSessionsEvents, this.expectedBatchCreateSessionsEventsCount);
                break;
            }
            case "CloudSpannerOperation.ExecuteStreamingQuery": {
                this.verifyRequestEvents(spanItem, this.expectedExecuteStreamingQueryEvents, this.expectedExecuteStreamingQueryEventsCount);
                break;
            }
            case "CloudSpanner.ReadOnlyTransaction": {
                this.verifyRequestEvents(spanItem, expectedReadOnlyTransactionMultiUseEvents, expectedReadOnlyTransactionMultiUseEventsCount);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    static {
        failOnOverkillTraceComponent = new FailOnOverkillTraceComponentImpl();
        SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
        SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
        SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
        UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
        INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
    }
}

