/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Options;
import com.google.common.truth.Truth;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.RequestOptions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OptionsTest {
    private static final DirectedReadOptions DIRECTED_READ_OPTIONS = DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setLocation("us-west1").build())).build();

    @Test
    public void negativeLimitsNotAllowed() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Options.limit((long)-1L));
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void zeroLimitNotAllowed() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Options.limit((long)0L));
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void negativePrefetchChunksNotAllowed() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Options.prefetchChunks((int)-1));
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void zeroPrefetchChunksNotAllowed() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Options.prefetchChunks((int)0));
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void allOptionsPresent() {
        Options options = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)10L), Options.prefetchChunks((int)1), Options.dataBoostEnabled((Boolean)true), Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS), Options.orderBy((Options.RpcOrderBy)Options.RpcOrderBy.NO_ORDER)});
        Truth.assertThat((Boolean)options.hasLimit()).isTrue();
        Truth.assertThat((Long)options.limit()).isEqualTo((Object)10);
        Truth.assertThat((Boolean)options.hasPrefetchChunks()).isTrue();
        Truth.assertThat((Integer)options.prefetchChunks()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)options.hasDataBoostEnabled()).isTrue();
        Assert.assertTrue((boolean)options.dataBoostEnabled());
        Assert.assertTrue((boolean)options.hasDirectedReadOptions());
        Assert.assertTrue((boolean)options.hasOrderBy());
        Assert.assertEquals((Object)DIRECTED_READ_OPTIONS, (Object)options.directedReadOptions());
    }

    @Test
    public void allOptionsAbsent() {
        Options options = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Truth.assertThat((Boolean)options.hasLimit()).isFalse();
        Truth.assertThat((Boolean)options.hasPrefetchChunks()).isFalse();
        Truth.assertThat((Boolean)options.hasFilter()).isFalse();
        Truth.assertThat((Boolean)options.hasPageToken()).isFalse();
        Truth.assertThat((Boolean)options.hasPriority()).isFalse();
        Truth.assertThat((Boolean)options.hasTag()).isFalse();
        Truth.assertThat((Boolean)options.hasDataBoostEnabled()).isFalse();
        Truth.assertThat((Boolean)options.hasDirectedReadOptions()).isFalse();
        Truth.assertThat((Boolean)options.hasOrderBy()).isFalse();
        Assert.assertNull((Object)options.withExcludeTxnFromChangeStreams());
        Truth.assertThat((String)options.toString()).isEqualTo((Object)"");
        Truth.assertThat((Boolean)options.equals((Object)options)).isTrue();
        Truth.assertThat((Boolean)options.equals(null)).isFalse();
        Truth.assertThat((Boolean)options.equals((Object)this)).isFalse();
        Truth.assertThat((Integer)options.hashCode()).isEqualTo((Object)31);
    }

    @Test
    public void listOptionsTest() {
        int pageSize = 3;
        String pageToken = "ptok";
        String filter = "env";
        Options options = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageSize((int)pageSize), Options.pageToken((String)pageToken), Options.filter((String)filter)});
        Truth.assertThat((String)options.toString()).isEqualTo((Object)("pageSize: " + pageSize + " pageToken: " + pageToken + " filter: " + filter + " "));
        Truth.assertThat((Boolean)options.hasPageSize()).isTrue();
        Truth.assertThat((Boolean)options.hasPageToken()).isTrue();
        Truth.assertThat((Boolean)options.hasFilter()).isTrue();
        Truth.assertThat((Integer)options.pageSize()).isEqualTo((Object)pageSize);
        Truth.assertThat((String)options.pageToken()).isEqualTo((Object)pageToken);
        Truth.assertThat((String)options.filter()).isEqualTo((Object)filter);
        Truth.assertThat((Integer)options.hashCode()).isEqualTo((Object)108027089);
    }

    @Test
    public void listEquality() {
        Options o1 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[0]);
        Options o2 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[0]);
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isTrue();
        o2 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageSize((int)1)});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        Truth.assertThat((Boolean)o2.equals((Object)o1)).isFalse();
        Options o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageSize((int)1)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageSize((int)2)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
        o2 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageToken((String)"t1")});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageToken((String)"t1")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageToken((String)"t2")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
        o2 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.filter((String)"f1")});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.filter((String)"f1")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.filter((String)"f2")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
    }

    @Test
    public void readOptionsTest() {
        int limit = 3;
        String tag = "app=spanner,env=test,action=read";
        boolean dataBoost = true;
        Options options = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)limit), Options.tag((String)tag), Options.dataBoostEnabled((Boolean)true), Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS), Options.orderBy((Options.RpcOrderBy)Options.RpcOrderBy.NO_ORDER)});
        Truth.assertThat((String)options.toString()).isEqualTo((Object)("limit: " + limit + " tag: " + tag + " dataBoostEnabled: " + dataBoost + " directedReadOptions: " + DIRECTED_READ_OPTIONS + " orderBy: " + Options.RpcOrderBy.NO_ORDER + " "));
        Truth.assertThat((String)options.tag()).isEqualTo((Object)tag);
        Assert.assertEquals((Object)dataBoost, (Object)options.dataBoostEnabled());
        Assert.assertEquals((Object)DIRECTED_READ_OPTIONS, (Object)options.directedReadOptions());
        Assert.assertEquals((Object)ReadRequest.OrderBy.ORDER_BY_NO_ORDER, (Object)options.orderBy());
    }

    @Test
    public void readEquality() {
        Options o1 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Options o2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isTrue();
        o2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)1L)});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        Truth.assertThat((Boolean)o2.equals((Object)o1)).isFalse();
        Options o3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)1L)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)2L)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
    }

    @Test
    public void queryOptionsTest() {
        int chunks = 3;
        String tag = "app=spanner,env=test,action=query";
        boolean dataBoost = true;
        Options options = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.prefetchChunks((int)chunks), Options.tag((String)tag), Options.dataBoostEnabled((Boolean)true), Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS)});
        Truth.assertThat((String)options.toString()).isEqualTo((Object)("prefetchChunks: " + chunks + " tag: " + tag + " dataBoostEnabled: " + dataBoost + " directedReadOptions: " + DIRECTED_READ_OPTIONS + " "));
        Truth.assertThat((Integer)options.prefetchChunks()).isEqualTo((Object)chunks);
        Truth.assertThat((String)options.tag()).isEqualTo((Object)tag);
        Assert.assertEquals((Object)dataBoost, (Object)options.dataBoostEnabled());
        Assert.assertEquals((Object)DIRECTED_READ_OPTIONS, (Object)options.directedReadOptions());
    }

    @Test
    public void testReadOptionsDataBoost() {
        boolean dataBoost = true;
        Options options = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.dataBoostEnabled((Boolean)true)});
        Assert.assertTrue((boolean)options.hasDataBoostEnabled());
        Assert.assertEquals((Object)("dataBoostEnabled: " + dataBoost + " "), (Object)options.toString());
    }

    @Test
    public void testQueryOptionsDataBoost() {
        boolean dataBoost = true;
        Options options = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.dataBoostEnabled((Boolean)true)});
        Assert.assertTrue((boolean)options.hasDataBoostEnabled());
        Assert.assertEquals((Object)("dataBoostEnabled: " + dataBoost + " "), (Object)options.toString());
    }

    @Test
    public void queryEquality() {
        Options o1 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]);
        Options o2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]);
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isTrue();
        o2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.prefetchChunks((int)1)});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        Truth.assertThat((Boolean)o2.equals((Object)o1)).isFalse();
        Options o3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.prefetchChunks((int)1)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.prefetchChunks((int)2)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
    }

    @Test
    public void testFromTransactionOptions_toStringNoOptions() {
        Options options = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Truth.assertThat((String)options.toString()).isEqualTo((Object)"");
    }

    @Test
    public void testFromTransactionOptions_toStringWithCommitStats() {
        Options options = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Truth.assertThat((String)options.toString()).contains((CharSequence)"withCommitStats: true");
    }

    @Test
    public void testTransactionOptions_noOptionsAreEqual() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Assert.assertEquals((Object)option1, (Object)option2);
    }

    @Test
    public void testTransactionOptions_withCommitStatsAreEqual() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertEquals((Object)option1, (Object)option2);
    }

    @Test
    public void testTransactionOptions_withCommitStatsAndOtherOptionAreNotEqual() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Options option2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.prefetchChunks((int)10)});
        Assert.assertNotEquals((Object)option1, (Object)option2);
    }

    @Test
    public void testTransactionOptions_noOptionsHashCode() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Assert.assertEquals((long)option2.hashCode(), (long)option1.hashCode());
    }

    @Test
    public void testTransactionOptions_withCommitStatsHashCode() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertEquals((long)option2.hashCode(), (long)option1.hashCode());
    }

    @Test
    public void testTransactionOptions_withCommitStatsAndOtherOptionHashCode() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Options option2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.prefetchChunks((int)10)});
        Assert.assertNotEquals((long)option2.hashCode(), (long)option1.hashCode());
    }

    @Test
    public void testTransactionOptionsPriority() {
        Options.RpcPriority priority = Options.RpcPriority.HIGH;
        Options options = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)priority)});
        Assert.assertTrue((boolean)options.hasPriority());
        Assert.assertEquals((Object)("priority: " + priority + " "), (Object)options.toString());
    }

    @Test
    public void testReadOptionsOrderBy() {
        Options.RpcOrderBy orderBy = Options.RpcOrderBy.NO_ORDER;
        Options options = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.orderBy((Options.RpcOrderBy)orderBy)});
        Assert.assertTrue((boolean)options.hasOrderBy());
        Assert.assertEquals((Object)("orderBy: " + orderBy + " "), (Object)options.toString());
    }

    @Test
    public void testReadOptionsWithOrderByEquality() {
        Options optionsWithNoOrderBy1 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.orderBy((Options.RpcOrderBy)Options.RpcOrderBy.NO_ORDER)});
        Options optionsWithNoOrderBy2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.orderBy((Options.RpcOrderBy)Options.RpcOrderBy.NO_ORDER)});
        Assert.assertTrue((boolean)optionsWithNoOrderBy1.equals((Object)optionsWithNoOrderBy2));
        Options optionsWithPkOrder = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.orderBy((Options.RpcOrderBy)Options.RpcOrderBy.PRIMARY_KEY)});
        Assert.assertFalse((boolean)optionsWithNoOrderBy1.equals((Object)optionsWithPkOrder));
    }

    @Test
    public void testQueryOptionsPriority() {
        Options.RpcPriority priority = Options.RpcPriority.MEDIUM;
        Options options = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)priority)});
        Assert.assertTrue((boolean)options.hasPriority());
        Assert.assertEquals((Object)("priority: " + priority + " "), (Object)options.toString());
    }

    @Test
    public void testReadOptionsPriority() {
        Options.RpcPriority priority = Options.RpcPriority.LOW;
        Options options = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.priority((Options.RpcPriority)priority)});
        Assert.assertTrue((boolean)options.hasPriority());
        Assert.assertEquals((Object)("priority: " + priority + " "), (Object)options.toString());
    }

    @Test
    public void testUpdateOptionsPriority() {
        Options.RpcPriority priority = Options.RpcPriority.LOW;
        Options options = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.priority((Options.RpcPriority)priority)});
        Assert.assertTrue((boolean)options.hasPriority());
        Assert.assertEquals((Object)("priority: " + priority + " "), (Object)options.toString());
    }

    @Test
    public void testRpcPriorityEnumFromProto() {
        Assert.assertEquals((Object)Options.RpcPriority.fromProto((RequestOptions.Priority)RequestOptions.Priority.PRIORITY_LOW), (Object)Options.RpcPriority.LOW);
        Assert.assertEquals((Object)Options.RpcPriority.fromProto((RequestOptions.Priority)RequestOptions.Priority.PRIORITY_MEDIUM), (Object)Options.RpcPriority.MEDIUM);
        Assert.assertEquals((Object)Options.RpcPriority.fromProto((RequestOptions.Priority)RequestOptions.Priority.PRIORITY_HIGH), (Object)Options.RpcPriority.HIGH);
        Assert.assertEquals((Object)Options.RpcPriority.fromProto((RequestOptions.Priority)RequestOptions.Priority.PRIORITY_UNSPECIFIED), (Object)Options.RpcPriority.UNSPECIFIED);
        Assert.assertEquals((Object)Options.RpcPriority.fromProto(null), (Object)Options.RpcPriority.UNSPECIFIED);
    }

    @Test
    public void testTransactionOptionsHashCode() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Assert.assertEquals((long)option1.hashCode(), (long)option2.hashCode());
    }

    @Test
    public void testTransactionOptionsWithPriorityEquality() {
        Options optionsWithHighPriority1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options optionsWithHighPriority2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Assert.assertEquals((Object)optionsWithHighPriority1, (Object)optionsWithHighPriority2);
        Options optionsWithMediumPriority = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)});
        Assert.assertNotEquals((Object)optionsWithHighPriority1, (Object)optionsWithMediumPriority);
    }

    @Test
    public void testTransactionOptionsWithPriorityHashCode() {
        Options optionsWithHighPriority1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options optionsWithHighPriority2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Assert.assertEquals((long)optionsWithHighPriority1.hashCode(), (long)optionsWithHighPriority2.hashCode());
        Options optionsWithMediumPriority = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)});
        Assert.assertNotEquals((long)optionsWithHighPriority1.hashCode(), (long)optionsWithMediumPriority.hashCode());
    }

    @Test
    public void testUpdateOptionsEquality() {
        Options option1 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Options option2 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Assert.assertEquals((Object)option1, (Object)option2);
    }

    @Test
    public void testUpdateOptionsHashCode() {
        Options option1 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Options option2 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Assert.assertEquals((long)option1.hashCode(), (long)option2.hashCode());
    }

    @Test
    public void testUpdateOptionsWithPriorityEquality() {
        Options optionsWithHighPriority1 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options optionsWithHighPriority2 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Assert.assertEquals((Object)optionsWithHighPriority1, (Object)optionsWithHighPriority2);
        Options optionsWithMediumPriority = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)});
        Assert.assertNotEquals((Object)optionsWithHighPriority1, (Object)optionsWithMediumPriority);
    }

    @Test
    public void testUpdateOptionsWithPriorityHashCode() {
        Options optionsWithHighPriority1 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options optionsWithHighPriority2 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Assert.assertEquals((long)optionsWithHighPriority1.hashCode(), (long)optionsWithHighPriority2.hashCode());
        Options optionsWithMediumPriority = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)});
        Assert.assertNotEquals((long)optionsWithHighPriority1.hashCode(), (long)optionsWithMediumPriority.hashCode());
    }

    @Test
    public void testQueryOptionsEquality() {
        Options option1 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]);
        Options option2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]);
        Assert.assertEquals((Object)option1, (Object)option2);
    }

    @Test
    public void testQueryOptionsHashCode() {
        Options option1 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]);
        Options option2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]);
        Assert.assertEquals((long)option1.hashCode(), (long)option2.hashCode());
    }

    @Test
    public void testQueryOptionsWithPriorityEquality() {
        Options optionsWithHighPriority1 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options optionsWithHighPriority2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Assert.assertEquals((Object)optionsWithHighPriority1, (Object)optionsWithHighPriority2);
        Options optionsWithMediumPriority = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)});
        Assert.assertNotEquals((Object)optionsWithHighPriority1, (Object)optionsWithMediumPriority);
        Options optionsWithHighPriorityAndBufferRows = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH), Options.bufferRows((int)10)});
        Assert.assertNotEquals((Object)optionsWithHighPriorityAndBufferRows, (Object)optionsWithHighPriority1);
    }

    @Test
    public void testQueryOptionsWithPriorityHashCode() {
        Options optionsWithHighPriority1 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options optionsWithHighPriority2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Assert.assertEquals((long)optionsWithHighPriority1.hashCode(), (long)optionsWithHighPriority2.hashCode());
        Options optionsWithMediumPriority = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)});
        Assert.assertNotEquals((long)optionsWithHighPriority1.hashCode(), (long)optionsWithMediumPriority.hashCode());
        Options optionsWithHighPriorityAndBufferRows = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH), Options.bufferRows((int)10)});
        Assert.assertNotEquals((long)optionsWithHighPriorityAndBufferRows.hashCode(), (long)optionsWithHighPriority1.hashCode());
    }

    @Test
    public void testReadOptionsEquality() {
        Options option1 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Options option2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Assert.assertEquals((Object)option1, (Object)option2);
    }

    @Test
    public void testReadOptionsHashCode() {
        Options option1 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Options option2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Assert.assertEquals((long)option1.hashCode(), (long)option2.hashCode());
    }

    @Test
    public void testReadOptionsWithPriorityEquality() {
        Options optionsWithHighPriority1 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options optionsWithHighPriority2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Assert.assertEquals((Object)optionsWithHighPriority1, (Object)optionsWithHighPriority2);
        Options optionsWithMediumPriority = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)});
        Assert.assertNotEquals((Object)optionsWithHighPriority1, (Object)optionsWithMediumPriority);
        Options optionsWithHighPriorityAndBufferRows = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH), Options.bufferRows((int)10)});
        Assert.assertNotEquals((Object)optionsWithHighPriorityAndBufferRows, (Object)optionsWithHighPriority1);
    }

    @Test
    public void testReadOptionsWithPriorityHashCode() {
        Options optionsWithHighPriority1 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options optionsWithHighPriority2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Assert.assertEquals((long)optionsWithHighPriority1.hashCode(), (long)optionsWithHighPriority2.hashCode());
        Options optionsWithMediumPriority = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)});
        Assert.assertNotEquals((long)optionsWithHighPriority1.hashCode(), (long)optionsWithMediumPriority.hashCode());
        Options optionsWithHighPriorityAndBufferRows = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH), Options.bufferRows((int)10)});
        Assert.assertNotEquals((long)optionsWithHighPriorityAndBufferRows.hashCode(), (long)optionsWithHighPriority1.hashCode());
    }

    @Test
    public void testFromUpdateOptions() {
        Options options = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Truth.assertThat((String)options.toString()).isEqualTo((Object)"");
    }

    @Test
    public void testTransactionOptions() {
        Options.RpcPriority prio = Options.RpcPriority.HIGH;
        Options options = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)prio)});
        Truth.assertThat((String)options.toString()).isEqualTo((Object)("priority: " + prio + " "));
        Truth.assertThat((Comparable)options.priority()).isEqualTo((Object)RequestOptions.Priority.PRIORITY_HIGH);
    }

    @Test
    public void testTransactionOptionsDefaultEqual() {
        Options options1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Options options2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Assert.assertEquals((Object)options1, (Object)options2);
    }

    @Test
    public void testTransactionOptionsPriorityEquality() {
        Options options1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options options2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        Options options3 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Options options4 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.LOW)});
        Assert.assertEquals((Object)options1, (Object)options2);
        Assert.assertNotEquals((Object)options1, (Object)options3);
        Assert.assertNotEquals((Object)options1, (Object)options4);
        Assert.assertNotEquals((Object)options2, (Object)options3);
        Assert.assertNotEquals((Object)options2, (Object)options4);
    }

    @Test
    public void updateOptionsTest() {
        String tag = "app=spanner,env=test";
        Options options = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.tag((String)tag)});
        Assert.assertEquals((Object)("tag: " + tag + " "), (Object)options.toString());
        Assert.assertTrue((boolean)options.hasTag());
        Truth.assertThat((String)options.tag()).isEqualTo((Object)tag);
        Truth.assertThat((Integer)options.hashCode()).isEqualTo((Object)-2118248262);
    }

    @Test
    public void updateEquality() {
        Options o1 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Options o2 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isTrue();
        o2 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test")});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        Truth.assertThat((Boolean)o2.equals((Object)o1)).isFalse();
        Options o3 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=stage")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
    }

    @Test
    public void transactionOptionsTest() {
        String tag = "app=spanner,env=test";
        Options options = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.tag((String)tag)});
        Assert.assertEquals((Object)("tag: " + tag + " "), (Object)options.toString());
        Assert.assertTrue((boolean)options.hasTag());
        Truth.assertThat((String)options.tag()).isEqualTo((Object)tag);
        Truth.assertThat((Integer)options.hashCode()).isEqualTo((Object)-2118248262);
    }

    @Test
    public void transactionEquality() {
        Options o1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Options o2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isTrue();
        o2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test")});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        Truth.assertThat((Boolean)o2.equals((Object)o1)).isFalse();
        Options o3 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=stage")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
    }

    @Test
    public void optimisticLockEquality() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.optimisticLock()});
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.optimisticLock()});
        Options option3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Assert.assertEquals((Object)option1, (Object)option2);
        Assert.assertNotEquals((Object)option1, (Object)option3);
    }

    @Test
    public void optimisticLockHashCode() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.optimisticLock()});
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.optimisticLock()});
        Options option3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Assert.assertEquals((long)option1.hashCode(), (long)option2.hashCode());
        Assert.assertNotEquals((long)option1.hashCode(), (long)option3.hashCode());
    }

    @Test
    public void directedReadEquality() {
        Options option1 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS)});
        Options option2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS)});
        Options option3 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Assert.assertEquals((Object)option1, (Object)option2);
        Assert.assertNotEquals((Object)option1, (Object)option3);
    }

    @Test
    public void directedReadHashCode() {
        Options option1 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS)});
        Options option2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS)});
        Options option3 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Assert.assertEquals((long)option1.hashCode(), (long)option2.hashCode());
        Assert.assertNotEquals((long)option1.hashCode(), (long)option3.hashCode());
    }

    @Test
    public void directedReadsNullNotAllowed() {
        Assert.assertThrows(NullPointerException.class, () -> Options.directedRead(null));
    }

    @Test
    public void transactionOptionsExcludeTxnFromChangeStreams() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});
        Options option3 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Assert.assertEquals((Object)option1, (Object)option2);
        Assert.assertEquals((long)option1.hashCode(), (long)option2.hashCode());
        Assert.assertNotEquals((Object)option1, (Object)option3);
        Assert.assertNotEquals((long)option1.hashCode(), (long)option3.hashCode());
        Assert.assertTrue((boolean)option1.withExcludeTxnFromChangeStreams());
        Truth.assertThat((String)option1.toString()).contains((CharSequence)"withExcludeTxnFromChangeStreams: true");
        Assert.assertNull((Object)option3.withExcludeTxnFromChangeStreams());
        Truth.assertThat((String)option3.toString()).doesNotContain((CharSequence)"withExcludeTxnFromChangeStreams: true");
    }

    @Test
    public void updateOptionsExcludeTxnFromChangeStreams() {
        Options option1 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()});
        Options option2 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()});
        Options option3 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Assert.assertEquals((Object)option1, (Object)option2);
        Assert.assertEquals((long)option1.hashCode(), (long)option2.hashCode());
        Assert.assertNotEquals((Object)option1, (Object)option3);
        Assert.assertNotEquals((long)option1.hashCode(), (long)option3.hashCode());
        Assert.assertTrue((boolean)option1.withExcludeTxnFromChangeStreams());
        Truth.assertThat((String)option1.toString()).contains((CharSequence)"withExcludeTxnFromChangeStreams: true");
        Assert.assertNull((Object)option3.withExcludeTxnFromChangeStreams());
        Truth.assertThat((String)option3.toString()).doesNotContain((CharSequence)"withExcludeTxnFromChangeStreams: true");
    }
}

