/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.Statement;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PartitionTest {
    ByteString partitionToken = ByteString.copyFromUtf8((String)"partitionToken");
    PartitionOptions partitionOptions = PartitionOptions.getDefaultInstance();
    String table = "table";
    String index = "index";
    KeySet keys = KeySet.singleKey((Key)Key.of((Object[])new Object[]{"a", "b", "c"}));
    Iterable<String> columns = Arrays.asList("c1", "c2");
    Options.ReadOption rOption = Options.limit((long)10L);
    Options readOptions = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{this.rOption});
    Statement stmt = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT Name FROM Users").append(" WHERE Id = @id").bind("id").to(1234L)).append(" AND Status = @status").bind("status").to("ACTIVE")).build();
    Options.QueryOption qOption = Options.prefetchChunks((int)10);
    Options queryOptions = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{this.qOption});

    @Test
    public void statementInstance() {
        Partition p = Partition.createQueryPartition((ByteString)this.partitionToken, (PartitionOptions)this.partitionOptions, (Statement)this.stmt, (Options)this.queryOptions);
        Truth.assertThat((Iterable)p.getPartitionToken()).isEqualTo((Object)this.partitionToken);
        Truth.assertThat((Object)p.getStatement()).isEqualTo((Object)this.stmt);
        Truth.assertThat((Boolean)p.getQueryOptions().hasPrefetchChunks()).isTrue();
        Truth.assertThat((Integer)p.getQueryOptions().prefetchChunks()).isEqualTo((Object)10);
        Assert.assertNull((Object)p.getTable());
        Assert.assertNull((Object)p.getColumns());
        Assert.assertNull((Object)p.getKeys());
        Assert.assertNull((Object)p.getIndex());
        Assert.assertNull((Object)p.getReadOptions());
        SerializableTester.reserializeAndAssert((Object)p);
    }

    @Test
    public void readInstance() {
        Partition p = Partition.createReadPartition((ByteString)this.partitionToken, (PartitionOptions)this.partitionOptions, (String)this.table, null, (KeySet)this.keys, this.columns, (Options)this.readOptions);
        Truth.assertThat((Iterable)p.getPartitionToken()).isEqualTo((Object)this.partitionToken);
        Truth.assertThat((String)p.getTable()).isEqualTo((Object)this.table);
        Truth.assertThat((Object)p.getKeys()).isEqualTo((Object)this.keys);
        Truth.assertThat((Iterable)p.getColumns()).isEqualTo(this.columns);
        Assert.assertTrue((boolean)p.getReadOptions().hasLimit());
        Truth.assertThat((Long)p.getReadOptions().limit()).isEqualTo((Object)10);
        Assert.assertNull((Object)p.getIndex());
        Assert.assertNull((Object)p.getStatement());
        Assert.assertNull((Object)p.getQueryOptions());
        SerializableTester.reserializeAndAssert((Object)p);
    }

    @Test
    public void readUsingIndexInstance() {
        Partition p = Partition.createReadPartition((ByteString)this.partitionToken, (PartitionOptions)this.partitionOptions, (String)this.table, (String)this.index, (KeySet)this.keys, this.columns, (Options)this.readOptions);
        Truth.assertThat((Iterable)p.getPartitionToken()).isEqualTo((Object)this.partitionToken);
        Truth.assertThat((String)p.getTable()).isEqualTo((Object)this.table);
        Truth.assertThat((String)p.getIndex()).isEqualTo((Object)this.index);
        Truth.assertThat((Object)p.getKeys()).isEqualTo((Object)this.keys);
        Truth.assertThat((Iterable)p.getColumns()).isEqualTo(this.columns);
        Assert.assertTrue((boolean)p.getReadOptions().hasLimit());
        Truth.assertThat((Long)p.getReadOptions().limit()).isEqualTo((Object)10);
        Assert.assertNull((Object)p.getStatement());
        Assert.assertNull((Object)p.getQueryOptions());
        SerializableTester.reserializeAndAssert((Object)p);
    }

    @Test
    public void equalAndHashCode() {
        new EqualsTester().addEqualityGroup(new Object[]{Partition.createQueryPartition((ByteString)this.partitionToken, (PartitionOptions)this.partitionOptions, (Statement)this.stmt, (Options)this.queryOptions), Partition.createQueryPartition((ByteString)this.partitionToken, (PartitionOptions)this.partitionOptions, (Statement)this.stmt, (Options)this.queryOptions)}).addEqualityGroup(new Object[]{Partition.createReadPartition((ByteString)this.partitionToken, (PartitionOptions)this.partitionOptions, (String)this.table, null, (KeySet)this.keys, this.columns, (Options)this.readOptions), Partition.createReadPartition((ByteString)this.partitionToken, (PartitionOptions)this.partitionOptions, (String)this.table, null, (KeySet)this.keys, this.columns, (Options)this.readOptions)}).addEqualityGroup(new Object[]{Partition.createReadPartition((ByteString)this.partitionToken, (PartitionOptions)this.partitionOptions, (String)this.table, (String)this.index, (KeySet)this.keys, this.columns, (Options)this.readOptions), Partition.createReadPartition((ByteString)this.partitionToken, (PartitionOptions)this.partitionOptions, (String)this.table, (String)this.index, (KeySet)this.keys, this.columns, (Options)this.readOptions)}).testEquals();
    }
}

