/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.FakeClock;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.common.collect.ImmutableSet;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.grpc.Attributes;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.Grpc;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class RetryOnDifferentGrpcChannelMockServerTest
extends AbstractMockServerTest {
    private static final Map<String, Set<InetSocketAddress>> SERVER_ADDRESSES = new HashMap<String, Set<InetSocketAddress>>();

    @BeforeClass
    public static void startStaticServer() throws IOException {
        System.setProperty("spanner.retry_deadline_exceeded_on_different_channel", "true");
        RetryOnDifferentGrpcChannelMockServerTest.startStaticServer(RetryOnDifferentGrpcChannelMockServerTest.createServerInterceptor());
    }

    @AfterClass
    public static void removeSystemProperty() {
        System.clearProperty("spanner.retry_deadline_exceeded_on_different_channel");
    }

    @After
    public void clearRequests() {
        SERVER_ADDRESSES.clear();
        mockSpanner.clearRequests();
        mockSpanner.removeAllExecutionTimes();
    }

    static ServerInterceptor createServerInterceptor() {
        return new ServerInterceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
                Attributes attributes = serverCall.getAttributes();
                Attributes.Key key = attributes.keys().stream().filter(k -> k.equals(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).findFirst().orElse(null);
                if (key != null) {
                    InetSocketAddress address = (InetSocketAddress)attributes.get(key);
                    Map map = SERVER_ADDRESSES;
                    synchronized (map) {
                        Set addresses = SERVER_ADDRESSES.getOrDefault(serverCall.getMethodDescriptor().getFullMethodName(), new HashSet());
                        addresses.add(address);
                        SERVER_ADDRESSES.putIfAbsent(serverCall.getMethodDescriptor().getFullMethodName(), addresses);
                    }
                }
                return serverCallHandler.startCall(serverCall, metadata);
            }
        };
    }

    SpannerOptions.Builder createSpannerOptionsBuilder() {
        return (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("my-project")).setHost(String.format("http://localhost:%d", this.getPort())).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).setCredentials((Credentials)NoCredentials.getInstance());
    }

    @Test
    public void testReadWriteTransaction_retriesOnNewChannel() {
        SpannerOptions.Builder builder = this.createSpannerOptionsBuilder();
        builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).build());
        mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        AtomicInteger attempts = new AtomicInteger();
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                if (attempts.incrementAndGet() > 1) {
                    mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.NO_EXECUTION_TIME);
                }
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).build());
                return null;
            });
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        List<BeginTransactionRequest> requests = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Assert.assertNotEquals((Object)requests.get(0).getSession(), (Object)requests.get(1).getSession());
        Assert.assertEquals((long)2L, (long)SERVER_ADDRESSES.getOrDefault("google.spanner.v1.Spanner/BeginTransaction", (Set<InetSocketAddress>)ImmutableSet.of()).size());
    }

    @Test
    public void testReadWriteTransaction_stopsRetrying() {
        SpannerOptions.Builder builder = this.createSpannerOptionsBuilder();
        builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).build());
        mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).build());
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)exception.getErrorCode());
            int numChannels = ((SpannerOptions)spanner.getOptions()).getNumChannels();
            Assert.assertEquals((long)numChannels, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
            List<BeginTransactionRequest> requests = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
            Set sessions = requests.stream().map(BeginTransactionRequest::getSession).collect(Collectors.toSet());
            Assert.assertEquals((long)numChannels, (long)sessions.size());
            Assert.assertEquals((long)numChannels, (long)SERVER_ADDRESSES.getOrDefault("google.spanner.v1.Spanner/BeginTransaction", (Set<InetSocketAddress>)ImmutableSet.of()).size());
        }
    }

    @Test
    public void testDenyListedChannelIsCleared() {
        FakeClock clock = new FakeClock();
        SpannerOptions.Builder builder = this.createSpannerOptionsBuilder();
        builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).setPoolMaintainerClock((Clock)clock).build());
        mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).build());
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)exception.getErrorCode());
            clock.currentTimeMillis.addAndGet(TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES));
            AtomicInteger attempts = new AtomicInteger();
            client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                if (attempts.incrementAndGet() > 1) {
                    mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.none());
                }
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).build());
                return null;
            });
            int numChannels = ((SpannerOptions)spanner.getOptions()).getNumChannels();
            Assert.assertEquals((long)(numChannels + 2), (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
            List<BeginTransactionRequest> requests = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
            Set sessions = requests.stream().map(BeginTransactionRequest::getSession).collect(Collectors.toSet());
            Assert.assertEquals((long)(numChannels + 1), (long)sessions.size());
            Assert.assertEquals((long)numChannels, (long)SERVER_ADDRESSES.getOrDefault("google.spanner.v1.Spanner/BeginTransaction", (Set<InetSocketAddress>)ImmutableSet.of()).size());
            Assert.assertEquals((long)numChannels, (long)mockSpanner.countRequestsOfType(BatchCreateSessionsRequest.class));
        }
    }

    @Test
    public void testSingleUseQuery_retriesOnNewChannel() {
        SpannerOptions.Builder builder = this.createSpannerOptionsBuilder();
        builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).build());
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (ResultSet resultSet = client.singleUse().executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((Object)requests.get(0).getSession(), (Object)requests.get(1).getSession());
        Assert.assertEquals((long)2L, (long)SERVER_ADDRESSES.getOrDefault("google.spanner.v1.Spanner/ExecuteStreamingSql", (Set<InetSocketAddress>)ImmutableSet.of()).size());
    }

    @Test
    public void testSingleUseQuery_stopsRetrying() {
        SpannerOptions.Builder builder = this.createSpannerOptionsBuilder();
        builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).build());
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)Status.DEADLINE_EXCEEDED.asRuntimeException())));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (ResultSet resultSet = client.singleUse().executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)resultSet).next());
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)exception.getErrorCode());
            }
            int numChannels = ((SpannerOptions)spanner.getOptions()).getNumChannels();
            Assert.assertEquals((long)numChannels, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
            String session = requests.get(0).getSession();
            for (ExecuteSqlRequest request : requests) {
                Assert.assertEquals((Object)session, (Object)request.getSession());
            }
            Assert.assertEquals((long)numChannels, (long)SERVER_ADDRESSES.getOrDefault("google.spanner.v1.Spanner/ExecuteStreamingSql", (Set<InetSocketAddress>)ImmutableSet.of()).size());
        }
    }

    @Test
    public void testReadWriteTransaction_withGrpcContextDeadline_doesNotRetry() {
        SpannerOptions.Builder builder = this.createSpannerOptionsBuilder();
        builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).build());
        mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(500, 500));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
            Context.CancellableContext context = Context.current().withDeadline(Deadline.after((long)50L, (TimeUnit)TimeUnit.MILLISECONDS), service);
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> RetryOnDifferentGrpcChannelMockServerTest.lambda$testReadWriteTransaction_withGrpcContextDeadline_doesNotRetry$8((Context)context, client));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)exception.getErrorCode());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
    }

    private static /* synthetic */ void lambda$testReadWriteTransaction_withGrpcContextDeadline_doesNotRetry$8(Context context, DatabaseClient client) throws Throwable {
        context.run(() -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).build());
            return null;
        }));
    }
}

