/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BaseSessionPoolTest;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.FakeClock;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TraceWrapper;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import io.opencensus.trace.Tracing;
import io.opentelemetry.api.OpenTelemetry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class SessionPoolMaintainerTest
extends BaseSessionPoolTest {
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    @Mock
    private SpannerImpl client;
    @Mock
    private SessionClient sessionClient;
    @Mock
    private SpannerOptions spannerOptions;
    private DatabaseId db = DatabaseId.of((String)"projects/p/instances/i/databases/unused");
    private SessionPoolOptions options;
    private FakeClock clock = new FakeClock();
    private List<SessionPool.PooledSession> idledSessions = new ArrayList<SessionPool.PooledSession>();
    private Map<String, Integer> pingedSessions = new HashMap<String, Integer>();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)((SpannerOptions)this.client.getOptions())).thenReturn((Object)this.spannerOptions);
        Mockito.when((Object)this.client.getSessionClient(this.db)).thenReturn((Object)this.sessionClient);
        Mockito.when((Object)this.sessionClient.getSpanner()).thenReturn((Object)this.client);
        Mockito.when((Object)this.spannerOptions.getNumChannels()).thenReturn((Object)4);
        Mockito.when((Object)this.spannerOptions.getDatabaseRole()).thenReturn((Object)"role");
        this.setupMockSessionCreation();
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxIdleSessions(1).setMaxSessions(5).setIncStep(1).setKeepAliveIntervalMinutes(2).setPoolMaintainerClock((Clock)this.clock).build();
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)this.options);
        this.idledSessions.clear();
        this.pingedSessions.clear();
    }

    private void setupMockSessionCreation() {
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                int sessionCount = (Integer)invocation.getArgument(0, Integer.class);
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                for (int i = 0; i < sessionCount; ++i) {
                    ReadContext mockContext = (ReadContext)Mockito.mock(ReadContext.class);
                    consumer.onSessionReady(this.setupMockSession(this.buildMockSession(this.client, mockContext), mockContext));
                }
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.anyInt(), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
    }

    private SessionImpl setupMockSession(SessionImpl session, ReadContext mockContext) {
        ResultSet mockResult = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockContext.executeQuery((Statement)Mockito.any(Statement.class), new Options.QueryOption[0])).thenAnswer(invocation -> {
            Integer currentValue = this.pingedSessions.get(session.getName());
            if (currentValue == null) {
                currentValue = 0;
            }
            currentValue = currentValue + 1;
            this.pingedSessions.put(session.getName(), currentValue);
            return mockResult;
        });
        Mockito.when((Object)mockResult.next()).thenReturn((Object)true);
        return session;
    }

    private SessionPool createPool() throws Exception {
        return this.createPool(this.options);
    }

    private SessionPool createPool(SessionPoolOptions options) throws Exception {
        SessionPool pool = SessionPool.createPool((SessionPoolOptions)options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(this), (SessionClient)this.client.getSessionClient(this.db), (Clock)this.clock, (SessionPool.Position)SessionPool.Position.FIRST, (TraceWrapper)new TraceWrapper(Tracing.getTracer(), OpenTelemetry.noop().getTracer(""), false), (OpenTelemetry)OpenTelemetry.noop());
        pool.idleSessionRemovedListener = input -> {
            this.idledSessions.add((SessionPool.PooledSession)input);
            return null;
        };
        while (pool.totalSessions() < options.getMinSessions()) {
            Thread.sleep(1L);
        }
        return pool;
    }

    @Test
    public void testKeepAlive() throws Exception {
        SessionPool pool = this.createPool();
        Truth.assertThat(this.pingedSessions).isEmpty();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).isEmpty();
        SessionPool.PooledSessionFuture session1 = pool.getSession();
        SessionPool.PooledSessionFuture session2 = pool.getSession();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).isEmpty();
        session2.close();
        session1.close();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).isEmpty();
        this.clock.currentTimeMillis.addAndGet(TimeUnit.MINUTES.toMillis(this.options.getKeepAliveIntervalMinutes()) + 1L);
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)1, new Object[0]);
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)1, new Object[]{session2.getName(), 1});
        SessionPool.PooledSessionFuture session3 = pool.getSession();
        SessionPool.PooledSessionFuture session4 = pool.getSession();
        SessionPool.PooledSessionFuture session5 = pool.getSession();
        Assert.assertEquals((Object)session1.getName(), (Object)session3.getName());
        Assert.assertEquals((Object)session2.getName(), (Object)session4.getName());
        session5.close();
        session4.close();
        session3.close();
        this.clock.currentTimeMillis.addAndGet(TimeUnit.MINUTES.toMillis(this.options.getKeepAliveIntervalMinutes()) + 1L);
        this.runMaintenanceLoop(this.clock, pool, 3L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)2, new Object[]{session2.getName(), 2});
        this.clock.currentTimeMillis.addAndGet(TimeUnit.MINUTES.toMillis(this.options.getKeepAliveIntervalMinutes()) + 1L);
        SessionPool.PooledSessionFuture session6 = pool.getSession();
        Truth.assertThat((String)session6.getName()).isEqualTo((Object)session1.getName());
        this.runMaintenanceLoop(this.clock, pool, 3L);
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)3);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)2, new Object[]{session2.getName(), 3});
        session6.get().markUsed();
        session6.close();
        this.runMaintenanceLoop(this.clock, pool, 3L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)2, new Object[]{session2.getName(), 3});
        SessionPool.PooledSessionFuture session7 = pool.getSession();
        SessionPool.PooledSessionFuture session8 = pool.getSession();
        SessionPool.PooledSessionFuture session9 = pool.getSession();
        Truth.assertThat((String)session7.getName()).isEqualTo((Object)session1.getName());
        Truth.assertThat((String)session8.getName()).isEqualTo((Object)session2.getName());
        Truth.assertThat((String)session9.getName()).isEqualTo((Object)session5.getName());
        session7.close();
        session8.close();
        session9.close();
        this.clock.currentTimeMillis.addAndGet(TimeUnit.MINUTES.toMillis(this.options.getKeepAliveIntervalMinutes()) + 1L);
        this.runMaintenanceLoop(this.clock, pool, 3L);
        Truth.assertThat(this.pingedSessions).containsExactly((Object)session1.getName(), (Object)2, new Object[]{session2.getName(), 4, session5.getName(), 1});
    }

    @Test
    public void testIdleSessions() throws Exception {
        SessionPool pool = this.createPool();
        long loopsToIdleSessions = Double.valueOf(Math.ceil((double)this.options.getRemoveInactiveSessionAfter().toMillis() / (double)pool.poolMaintainer.loopFrequency)).longValue() + 2L;
        Truth.assertThat(this.idledSessions).isEmpty();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.idledSessions).isEmpty();
        SessionPool.PooledSessionFuture session1 = pool.getSession();
        SessionPool.PooledSessionFuture session2 = pool.getSession();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.idledSessions).isEmpty();
        session2.close();
        session1.close();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.idledSessions).isEmpty();
        this.runMaintenanceLoop(this.clock, pool, loopsToIdleSessions);
        Truth.assertThat(this.idledSessions).isEmpty();
        SessionPool.PooledSession session3 = pool.getSession().get();
        SessionPool.PooledSession session4 = pool.getSession().get();
        SessionPool.PooledSession session5 = pool.getSession().get();
        Truth.assertThat((String)session3.getName()).isEqualTo((Object)session1.getName());
        Truth.assertThat((String)session4.getName()).isEqualTo((Object)session2.getName());
        session5.close();
        session4.close();
        session3.close();
        this.runMaintenanceLoop(this.clock, pool, loopsToIdleSessions);
        Truth.assertThat(this.idledSessions).containsExactly(new Object[]{session5});
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)2);
        SessionPool.PooledSession session6 = pool.getSession().get();
        SessionPool.PooledSession session7 = pool.getSession().get();
        SessionPool.PooledSession session8 = pool.getSession().get();
        session8.close();
        session7.close();
        this.runMaintenanceLoop(this.clock, pool, loopsToIdleSessions);
        Truth.assertThat(this.idledSessions).containsExactly(new Object[]{session5, session8});
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)2);
        session6.markUsed();
        session6.close();
        SessionPool.PooledSession session9 = pool.getSession().get();
        SessionPool.PooledSession session10 = pool.getSession().get();
        SessionPool.PooledSession session11 = pool.getSession().get();
        this.runMaintenanceLoop(this.clock, pool, loopsToIdleSessions);
        Truth.assertThat(this.idledSessions).containsExactly(new Object[]{session5, session8});
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)3);
        session9.close();
        session10.close();
        session11.close();
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Truth.assertThat(this.idledSessions).containsExactly(new Object[]{session5, session8, session9, session10, session11});
        while (pool.totalSessions() < this.options.getMinSessions()) {
            Thread.sleep(1L);
        }
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)this.options.getMinSessions());
    }

    @Test
    public void testRandomizeThreshold() throws Exception {
        SessionPool pool = this.createPool(this.options.toBuilder().setMaxSessions(400).setLoopFrequency(1000L).setRandomizePositionQPSThreshold(4L).build());
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Assert.assertFalse((boolean)pool.shouldRandomize());
        this.returnSessions(1, this.useSessions(1, pool));
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Assert.assertFalse((boolean)pool.shouldRandomize());
        this.returnSessions(4, this.useSessions(4, pool));
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Assert.assertFalse((boolean)pool.shouldRandomize());
        List<Session> sessions = this.useSessions(4, pool);
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Assert.assertTrue((boolean)pool.shouldRandomize());
        this.returnSessions(1, sessions);
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Assert.assertFalse((boolean)pool.shouldRandomize());
        sessions.addAll(this.useSessions(3, pool));
        this.runMaintenanceLoop(this.clock, pool, 1L);
        Assert.assertFalse((boolean)pool.shouldRandomize());
        this.returnSessions(sessions.size(), sessions);
    }

    private List<Session> useSessions(int numSessions, SessionPool pool) {
        ArrayList<Session> sessions = new ArrayList<Session>(numSessions);
        for (int i = 0; i < numSessions; ++i) {
            sessions.add((Session)pool.getSession());
            ((Session)sessions.get(sessions.size() - 1)).singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]).next();
        }
        return sessions;
    }

    private void returnSessions(int numSessions, List<Session> sessions) {
        Preconditions.checkArgument((numSessions <= sessions.size() ? 1 : 0) != 0);
        for (int i = 0; i < numSessions; ++i) {
            sessions.remove(0).close();
        }
    }
}

