/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.it.ITTransactionRetryTest;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AbortedTest
extends AbstractMockServerTest {
    @Test
    public void testCommitAborted() {
        for (int i = 0; i < 2; ++i) {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_BEFORE_INSERT));
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 1L));
            ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new ITTransactionRetryTest.CountTransactionRetryListener());){
                try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
                }
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                connection.commit();
                mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_AFTER_INSERT));
                rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
                try {
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
                    continue;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testCommitAbortedDuringUpdateWithReturning() {
        for (int i = 0; i < 2; ++i) {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_BEFORE_INSERT));
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.updateReturning(INSERT_RETURNING_STATEMENT, UPDATE_RETURNING_RESULTSET));
            ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new ITTransactionRetryTest.CountTransactionRetryListener());){
                try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
                }
                connection.executeQuery(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted') THEN RETURN *"), new Options.QueryOption[0]);
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                connection.commit();
                mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_AFTER_INSERT));
                rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
                try {
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
                    continue;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testAbortedDuringRetryOfFailedQuery() {
        Statement invalidStatement = Statement.of((String)"SELECT * FROM FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            connection.execute(INSERT_STATEMENT);
            try (ResultSet rs = connection.executeQuery(invalidStatement, new Options.QueryOption[0]);){
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)6);
    }

    @Test
    public void testAbortedDuringRetryOfFailedUpdate() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            connection.execute(INSERT_STATEMENT);
            try {
                connection.execute(invalidStatement);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)6);
    }

    @Test
    public void testAbortedDuringRetryOfFailedUpdateWithReturning() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO THEN RETURN *");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            connection.execute(INSERT_STATEMENT);
            try {
                connection.execute(invalidStatement);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)6);
    }

    @Test
    public void testAbortedDuringRetryOfFailedBatchUpdate() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            connection.execute(INSERT_STATEMENT);
            try {
                connection.executeBatchUpdate(Collections.singletonList(invalidStatement));
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class)).isEqualTo((Object)3);
    }

    @Test
    public void testAbortedDuringRetryOfFailedBatchUpdateWithReturning() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO THEN RETURN *");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            connection.execute(INSERT_STATEMENT);
            try {
                connection.executeBatchUpdate(Collections.singletonList(invalidStatement));
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class)).isEqualTo((Object)3);
    }

    @Test
    public void testAbortedDuringRetryOfFailedQueryAsFirstStatement() {
        Statement invalidStatement = Statement.of((String)"SELECT * FROM FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortRetryListener(2, invalidStatement, notFound));){
            try (ResultSet rs = connection.executeQuery(invalidStatement, new Options.QueryOption[0]);){
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            connection.executeUpdate(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)8);
    }

    @Test
    public void testAbortedDuringRetryOfFailedUpdateAsFirstStatement() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortRetryListener(2, invalidStatement, notFound));){
            try {
                connection.execute(invalidStatement);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            connection.execute(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)8);
    }

    @Test
    public void testAbortedDuringRetryOfFailedUpdateWithReturningAsFirstStatement() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO THEN RETURN *");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortRetryListener(2, invalidStatement, notFound));){
            try {
                connection.execute(invalidStatement);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            connection.execute(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)8);
    }

    @Test
    public void testAbortedDuringRetryOfFailedBatchUpdateAsFirstStatement() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            try {
                connection.executeBatchUpdate(Collections.singletonList(invalidStatement));
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            connection.execute(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class)).isEqualTo((Object)6);
    }

    @Test
    public void testAbortedDuringRetryOfFailedBatchUpdateWithReturningAsFirstStatement() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO THEN RETURN *");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            try {
                connection.executeBatchUpdate(Collections.singletonList(invalidStatement));
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            connection.execute(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class)).isEqualTo((Object)6);
    }

    @Test
    public void testRetryUsesTags() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_BEFORE_INSERT));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 1L));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("transaction-tag");
            connection.setStatementTag("statement-tag");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.setStatementTag("statement-tag");
            connection.executeBatchUpdate(Collections.singleton(INSERT_STATEMENT));
            connection.setStatementTag("statement-tag");
            connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        long executeSqlRequestCount = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().filter(request -> request.getRequestOptions().getRequestTag().equals("statement-tag") && request.getRequestOptions().getTransactionTag().equals("transaction-tag")).count();
        Assert.assertEquals((long)4L, (long)executeSqlRequestCount);
        long executeBatchSqlRequestCount = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).stream().filter(request -> request.getRequestOptions().getRequestTag().equals("statement-tag") && request.getRequestOptions().getTransactionTag().equals("transaction-tag")).count();
        Assert.assertEquals((long)2L, (long)executeBatchSqlRequestCount);
        long commitRequestCount = mockSpanner.getRequestsOfType(CommitRequest.class).stream().filter(request -> request.getRequestOptions().getRequestTag().equals("") && request.getRequestOptions().getTransactionTag().equals("transaction-tag")).count();
        Assert.assertEquals((long)2L, (long)commitRequestCount);
    }

    @Test
    public void testRetryUsesTagsWithUpdateReturning() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_BEFORE_INSERT));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.updateReturning(INSERT_RETURNING_STATEMENT, UPDATE_RETURNING_RESULTSET));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("transaction-tag");
            connection.setStatementTag("statement-tag");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.setStatementTag("statement-tag");
            connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_RETURNING_STATEMENT));
            connection.setStatementTag("statement-tag");
            connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
            connection.setStatementTag("statement-tag");
            connection.executeQuery(INSERT_RETURNING_STATEMENT, new Options.QueryOption[0]);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        long executeSqlRequestCount = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().filter(request -> request.getRequestOptions().getRequestTag().equals("statement-tag") && request.getRequestOptions().getTransactionTag().equals("transaction-tag")).count();
        Assert.assertEquals((long)6L, (long)executeSqlRequestCount);
        long executeBatchSqlRequestCount = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).stream().filter(request -> request.getRequestOptions().getRequestTag().equals("statement-tag") && request.getRequestOptions().getTransactionTag().equals("transaction-tag")).count();
        Assert.assertEquals((long)2L, (long)executeBatchSqlRequestCount);
        long commitRequestCount = mockSpanner.getRequestsOfType(CommitRequest.class).stream().filter(request -> request.getRequestOptions().getRequestTag().equals("") && request.getRequestOptions().getTransactionTag().equals("transaction-tag")).count();
        Assert.assertEquals((long)2L, (long)commitRequestCount);
    }

    @Test
    public void testRetryUsesAnalyzeModeForUpdate() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_BEFORE_INSERT));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 0L));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)0L, (long)connection.analyzeUpdate(INSERT_STATEMENT, ReadContext.QueryAnalyzeMode.PLAN).getRowCountExact());
            mockSpanner.abortNextStatement();
            connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 1L));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)5L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.PLAN, (Object)requests.get(0).getQueryMode());
        Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.NORMAL, (Object)requests.get(1).getQueryMode());
        Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.PLAN, (Object)requests.get(2).getQueryMode());
        Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.NORMAL, (Object)requests.get(3).getQueryMode());
        Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.NORMAL, (Object)requests.get(4).getQueryMode());
    }

    @Test
    public void testAbortedWithBitReversedSequence() {
        String getSequenceValuesSql = "WITH t AS (\n\tselect get_next_sequence_value(sequence enhanced_sequence) AS n\n\tUNION ALL\n\tselect get_next_sequence_value(sequence enhanced_sequence) AS n\n\tUNION ALL\n\tselect get_next_sequence_value(sequence enhanced_sequence) AS n\n\tUNION ALL\n\tselect get_next_sequence_value(sequence enhanced_sequence) AS n\n\tUNION ALL\n\tselect get_next_sequence_value(sequence enhanced_sequence) AS n\n)\nSELECT n FROM t";
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.queryAndThen(Statement.of((String)getSequenceValuesSql), AbortedTest.createBitReversedSequenceResultSet(1L, 5L), AbortedTest.createBitReversedSequenceResultSet(6L, 10L)));
        long currentValue = 0L;
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)getSequenceValuesSql), new Options.QueryOption[0]);){
                while (resultSet.next()) {
                    Assert.assertEquals((long)Long.reverse(++currentValue), (long)resultSet.getLong(0));
                }
            }
            mockSpanner.abortNextStatement();
            Assert.assertThrows(AbortedDueToConcurrentModificationException.class, () -> ((ITAbstractSpannerTest.ITConnection)connection).commit());
        }
    }

    static com.google.spanner.v1.ResultSet createBitReversedSequenceResultSet(long startValue, long endValue) {
        return com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("n").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build()).addAllRows((Iterable)LongStream.range(startValue, endValue).map(Long::reverse).mapToObj(id -> ListValue.newBuilder().addValues(Value.newBuilder().setStringValue(String.valueOf(id)).build()).build()).collect(Collectors.toList())).build();
    }

    ITAbstractSpannerTest.ITConnection createConnection(TransactionRetryListener listener) {
        ITAbstractSpannerTest.ITConnection connection = super.createConnection((List<StatementExecutionInterceptor>)ImmutableList.of(), (List<TransactionRetryListener>)ImmutableList.of((Object)listener));
        connection.setAutocommit(false);
        return connection;
    }

    TransactionRetryListener createAbortFirstRetryListener(Statement invalidStatement, StatusRuntimeException statementException) {
        return this.createAbortRetryListener(0, invalidStatement, statementException);
    }

    TransactionRetryListener createAbortRetryListener(final int onAttempt, final Statement invalidStatement, final StatusRuntimeException statementException) {
        return new TransactionRetryListener(){

            public void retryStarting(Timestamp transactionStarted, long transactionId, int retryAttempt) {
                if (retryAttempt == onAttempt) {
                    AbstractMockServerTest.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, AbstractMockServerTest.mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"some-transaction"))));
                } else {
                    AbstractMockServerTest.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, statementException));
                }
            }

            public void retryFinished(Timestamp transactionStarted, long transactionId, int retryAttempt, TransactionRetryListener.RetryResult result) {
            }
        };
    }
}

