/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PlanNode;
import com.google.spanner.v1.QueryPlan;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AnalyzeStatementsTest
extends AbstractMockServerTest {
    private static final Statement PLAN_QUERY = Statement.of((String)"SELECT * FROM SomeTable WHERE Key LIKE @param ORDER BY Value");
    private static final Statement PLAN_UPDATE = Statement.of((String)"UPDATE SomeTable SET Value=Value+1 WHERE Key LIKE @param");

    @BeforeClass
    public static void setupAnalyzeResults() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(PLAN_QUERY, com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setType(Type.newBuilder().setCode(TypeCode.INT64).build()).setName("Key").build()).addFields(StructType.Field.newBuilder().setType(Type.newBuilder().setCode(TypeCode.STRING).build()).setName("Value").build()).build()).setUndeclaredParameters(StructType.newBuilder().addFields(StructType.Field.newBuilder().setType(Type.newBuilder().setCode(TypeCode.STRING).build()).setName("param").build()).build()).build()).setStats(ResultSetStats.newBuilder().setQueryPlan(QueryPlan.newBuilder().addPlanNodes(PlanNode.newBuilder().setDisplayName("some-plan-node").build()).build()).build()).build()));
        mockSpanner.putStatementResults(MockSpannerServiceImpl.StatementResult.query(PLAN_UPDATE, com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setUndeclaredParameters(StructType.newBuilder().addFields(StructType.Field.newBuilder().setType(Type.newBuilder().setCode(TypeCode.STRING).build()).setName("param").build()).build()).build()).setStats(ResultSetStats.newBuilder().setQueryPlan(QueryPlan.newBuilder().addPlanNodes(PlanNode.newBuilder().setDisplayName("some-plan-node").build()).build()).build()).build()));
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testAnalyzeQuery() {
        for (boolean readOnly : new boolean[]{true, false}) {
            for (boolean autocommit : new boolean[]{true, false}) {
                mockSpanner.clearRequests();
                try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                    connection.setAutocommit(autocommit);
                    connection.setReadOnly(readOnly);
                    try (ResultSet resultSet = connection.analyzeQuery(PLAN_QUERY, ReadContext.QueryAnalyzeMode.PLAN);){
                        Assert.assertFalse((boolean)resultSet.next());
                        Assert.assertNotNull((Object)resultSet.getStats());
                        Assert.assertNotNull((Object)resultSet.getStats().getQueryPlan());
                        Assert.assertNotNull((Object)resultSet.getMetadata());
                        Assert.assertEquals((long)1L, (long)resultSet.getMetadata().getUndeclaredParameters().getFieldsCount());
                        Assert.assertEquals((Object)Type.newBuilder().setCode(TypeCode.STRING).build(), (Object)resultSet.getMetadata().getUndeclaredParameters().getFields(0).getType());
                        Assert.assertEquals((Object)"param", (Object)resultSet.getMetadata().getUndeclaredParameters().getFields(0).getName());
                    }
                }
                List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
                Assert.assertEquals((long)1L, (long)requests.size());
                ExecuteSqlRequest request = requests.get(0);
                Assert.assertEquals((Object)PLAN_QUERY.getSql(), (Object)request.getSql());
                Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.PLAN, (Object)request.getQueryMode());
                if (autocommit) {
                    Assert.assertTrue((boolean)request.getTransaction().hasSingleUse());
                    Assert.assertTrue((boolean)request.getTransaction().getSingleUse().hasReadOnly());
                    continue;
                }
                if (readOnly) {
                    BeginTransactionRequest beginTransactionRequest = mockSpanner.getRequestsOfType(BeginTransactionRequest.class).stream().findFirst().orElse(null);
                    Assert.assertNotNull((Object)beginTransactionRequest);
                    Assert.assertTrue((boolean)beginTransactionRequest.getOptions().hasReadOnly());
                    Assert.assertTrue((boolean)request.getTransaction().hasId());
                    continue;
                }
                Assert.assertTrue((boolean)request.getTransaction().hasBegin());
                Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
            }
        }
    }

    @Test
    public void testAnalyzeUpdate() {
        for (boolean autocommit : new boolean[]{true, false}) {
            mockSpanner.clearRequests();
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setAutocommit(autocommit);
                ResultSetStats stats = connection.analyzeUpdate(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN);
                Assert.assertNotNull((Object)stats);
                Assert.assertNotNull((Object)stats.getQueryPlan());
            }
            List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
            Assert.assertEquals((long)1L, (long)requests.size());
            ExecuteSqlRequest request = requests.get(0);
            Assert.assertEquals((Object)PLAN_UPDATE.getSql(), (Object)request.getSql());
            Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.PLAN, (Object)request.getQueryMode());
            Assert.assertTrue((boolean)request.getTransaction().hasBegin());
            Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
            if (autocommit) {
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
                continue;
            }
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testAnalyzeUpdateStatement() {
        for (boolean autocommit : new boolean[]{true, false}) {
            mockSpanner.clearRequests();
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setAutocommit(autocommit);
                try (ResultSet resultSet = connection.analyzeUpdateStatement(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN, new Options.UpdateOption[0]);){
                    Assert.assertFalse((boolean)resultSet.next());
                    ResultSetStats stats = resultSet.getStats();
                    Assert.assertNotNull((Object)stats);
                    Assert.assertNotNull((Object)stats.getQueryPlan());
                    Assert.assertNotNull((Object)resultSet.getMetadata());
                    Assert.assertEquals((long)1L, (long)resultSet.getMetadata().getUndeclaredParameters().getFieldsCount());
                    Assert.assertEquals((Object)Type.newBuilder().setCode(TypeCode.STRING).build(), (Object)resultSet.getMetadata().getUndeclaredParameters().getFields(0).getType());
                    Assert.assertEquals((Object)"param", (Object)resultSet.getMetadata().getUndeclaredParameters().getFields(0).getName());
                }
            }
            List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
            Assert.assertEquals((long)1L, (long)requests.size());
            ExecuteSqlRequest request = requests.get(0);
            Assert.assertEquals((Object)PLAN_UPDATE.getSql(), (Object)request.getSql());
            Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.PLAN, (Object)request.getQueryMode());
            Assert.assertTrue((boolean)request.getTransaction().hasBegin());
            Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
            if (autocommit) {
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
                continue;
            }
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testAnalyzeUpdateReadOnly() {
        for (boolean autocommit : new boolean[]{true, false}) {
            mockSpanner.clearRequests();
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setReadOnly(true);
                connection.setAutocommit(autocommit);
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.analyzeUpdate(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN));
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            }
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testAnalyzeUpdateStatementWithQuery() {
        for (boolean autocommit : new boolean[]{true, false}) {
            mockSpanner.clearRequests();
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setReadOnly(true);
                connection.setAutocommit(autocommit);
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.analyzeUpdateStatement(PLAN_QUERY, ReadContext.QueryAnalyzeMode.PLAN, new Options.UpdateOption[0]));
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)exception.getErrorCode());
            }
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testAnalyzeUpdateStatementReadOnly() {
        for (boolean autocommit : new boolean[]{true, false}) {
            mockSpanner.clearRequests();
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setReadOnly(true);
                connection.setAutocommit(autocommit);
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.analyzeUpdateStatement(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN, new Options.UpdateOption[0]));
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            }
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testAnalyzeUpdateDdlBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.startBatchDdl();
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.analyzeUpdate(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
        }
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testAnalyzeUpdateStatementDdlBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.startBatchDdl();
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.analyzeUpdateStatement(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN, new Options.UpdateOption[0]));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
        }
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testAnalyzeUpdateDmlBatch_AutoCommit() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.startBatchDml();
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.analyzeUpdate(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
        }
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testAnalyzeUpdateDmlBatch_Transactional() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.startBatchDml();
            Assert.assertNotNull((Object)connection.analyzeUpdate(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN));
            Assert.assertEquals((long)-1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.runBatch();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        }
    }

    @Test
    public void testAnalyzeUpdateStatementDmlBatch_AutoCommit() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.startBatchDml();
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.analyzeUpdateStatement(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN, new Options.UpdateOption[0]));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
        }
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testAnalyzeUpdateStatementDmlBatch_Transactional() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.startBatchDml();
            connection.analyzeUpdateStatement(PLAN_UPDATE, ReadContext.QueryAnalyzeMode.PLAN, new Options.UpdateOption[0]);
            Assert.assertEquals((long)-1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.runBatch();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        }
    }
}

