/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.CredentialsService;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import com.google.common.truth.Truth;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConnectionOptionsTest {
    private static final String FILE_TEST_PATH = Objects.requireNonNull(ConnectionOptionsTest.class.getResource("test-key.json")).getFile();
    private static final String DEFAULT_HOST = "https://spanner.googleapis.com";
    private static final String TEST_PROJECT = "test-project-123";
    private static final String TEST_INSTANCE = "test-instance-123";
    private static final String TEST_DATABASE = "test-database-123";

    @Test
    public void testBuildWithURIWithDots() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner:/projects/some-company.com:test-project-123/instances/test-instance-123/databases/test-database-123");
        builder.setCredentialsUrl(FILE_TEST_PATH);
        ConnectionOptions options = builder.build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)DEFAULT_HOST);
        Truth.assertThat((String)options.getProjectId()).isEqualTo((Object)"some-company.com:test-project-123");
        Truth.assertThat((String)options.getInstanceId()).isEqualTo((Object)TEST_INSTANCE);
        Truth.assertThat((String)options.getDatabaseName()).isEqualTo((Object)TEST_DATABASE);
        Truth.assertThat((Object)options.getCredentials()).isEqualTo((Object)new CredentialsService().createCredentials(FILE_TEST_PATH));
        Truth.assertThat((Boolean)options.isAutocommit()).isEqualTo((Object)true);
        Truth.assertThat((Boolean)options.isReadOnly()).isEqualTo((Object)false);
    }

    @Test
    public void testBuildWithValidURIAndCredentialsFileURL() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance-123/databases/test-database-123");
        builder.setCredentialsUrl(FILE_TEST_PATH);
        ConnectionOptions options = builder.build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)DEFAULT_HOST);
        Truth.assertThat((String)options.getProjectId()).isEqualTo((Object)TEST_PROJECT);
        Truth.assertThat((String)options.getInstanceId()).isEqualTo((Object)TEST_INSTANCE);
        Truth.assertThat((String)options.getDatabaseName()).isEqualTo((Object)TEST_DATABASE);
        Truth.assertThat((Object)options.getCredentials()).isEqualTo((Object)new CredentialsService().createCredentials(FILE_TEST_PATH));
        Truth.assertThat((Boolean)options.isAutocommit()).isEqualTo((Object)true);
        Truth.assertThat((Boolean)options.isReadOnly()).isEqualTo((Object)false);
    }

    @Test
    public void testBuildWithValidURIAndProperties() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance-123/databases/test-database-123?autocommit=false;readonly=true");
        builder.setCredentialsUrl(FILE_TEST_PATH);
        ConnectionOptions options = builder.build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)DEFAULT_HOST);
        Truth.assertThat((String)options.getProjectId()).isEqualTo((Object)TEST_PROJECT);
        Truth.assertThat((String)options.getInstanceId()).isEqualTo((Object)TEST_INSTANCE);
        Truth.assertThat((String)options.getDatabaseName()).isEqualTo((Object)TEST_DATABASE);
        Truth.assertThat((Object)options.getCredentials()).isEqualTo((Object)new CredentialsService().createCredentials(FILE_TEST_PATH));
        Truth.assertThat((Boolean)options.isAutocommit()).isEqualTo((Object)false);
        Truth.assertThat((Boolean)options.isReadOnly()).isEqualTo((Object)true);
    }

    @Test
    public void testBuildWithHostAndValidURI() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner://test-spanner.googleapis.com/projects/test-project-123/instances/test-instance-123/databases/test-database-123");
        builder.setCredentialsUrl(FILE_TEST_PATH);
        ConnectionOptions options = builder.build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)"https://test-spanner.googleapis.com");
        Truth.assertThat((String)options.getProjectId()).isEqualTo((Object)TEST_PROJECT);
        Truth.assertThat((String)options.getInstanceId()).isEqualTo((Object)TEST_INSTANCE);
        Truth.assertThat((String)options.getDatabaseName()).isEqualTo((Object)TEST_DATABASE);
        Truth.assertThat((Object)options.getCredentials()).isEqualTo((Object)new CredentialsService().createCredentials(FILE_TEST_PATH));
        Truth.assertThat((Boolean)options.isAutocommit()).isEqualTo((Object)true);
        Truth.assertThat((Boolean)options.isReadOnly()).isEqualTo((Object)false);
    }

    @Test
    public void testBuildWithLocalhostPortAndValidURI() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner://localhost:8443/projects/test-project-123/instances/test-instance-123/databases/test-database-123");
        builder.setCredentialsUrl(FILE_TEST_PATH);
        ConnectionOptions options = builder.build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)"https://localhost:8443");
        Truth.assertThat((String)options.getProjectId()).isEqualTo((Object)TEST_PROJECT);
        Truth.assertThat((String)options.getInstanceId()).isEqualTo((Object)TEST_INSTANCE);
        Truth.assertThat((String)options.getDatabaseName()).isEqualTo((Object)TEST_DATABASE);
        Truth.assertThat((Object)options.getCredentials()).isEqualTo((Object)new CredentialsService().createCredentials(FILE_TEST_PATH));
        Truth.assertThat((Boolean)options.isAutocommit()).isEqualTo((Object)true);
        Truth.assertThat((Boolean)options.isReadOnly()).isEqualTo((Object)false);
    }

    @Test
    public void testBuildWithAutoConfigEmulator() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance-123/databases/test-database-123?autoConfigEmulator=true");
        ConnectionOptions options = builder.build();
        Assert.assertEquals((Object)"http://localhost:9010", (Object)options.getHost());
        Assert.assertEquals((Object)TEST_PROJECT, (Object)options.getProjectId());
        Assert.assertEquals((Object)TEST_INSTANCE, (Object)options.getInstanceId());
        Assert.assertEquals((Object)TEST_DATABASE, (Object)options.getDatabaseName());
        Assert.assertEquals((Object)NoCredentials.getInstance(), (Object)options.getCredentials());
        Assert.assertTrue((boolean)options.isUsePlainText());
    }

    @Test
    public void testDetermineHost() {
        String uriWithoutHost = "cloudspanner:/projects/test-project-123/instances/test-instance-123/databases/test-database-123";
        Matcher matcherWithoutHost = ConnectionOptions.Builder.SPANNER_URI_PATTERN.matcher("cloudspanner:/projects/test-project-123/instances/test-instance-123/databases/test-database-123");
        Assert.assertTrue((boolean)matcherWithoutHost.find());
        String uriWithHost = "cloudspanner://custom.host.domain:1234/projects/test-project-123/instances/test-instance-123/databases/test-database-123";
        Matcher matcherWithHost = ConnectionOptions.Builder.SPANNER_URI_PATTERN.matcher("cloudspanner://custom.host.domain:1234/projects/test-project-123/instances/test-instance-123/databases/test-database-123");
        Assert.assertTrue((boolean)matcherWithHost.find());
        Assert.assertEquals((Object)DEFAULT_HOST, (Object)ConnectionOptions.determineHost((Matcher)matcherWithoutHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)false, (boolean)false, (Map)ImmutableMap.of()));
        Assert.assertEquals((Object)DEFAULT_HOST, (Object)ConnectionOptions.determineHost((Matcher)matcherWithoutHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)false, (boolean)false, (Map)ImmutableMap.of((Object)"FOO", (Object)"bar")));
        Assert.assertEquals((Object)"http://localhost:9010", (Object)ConnectionOptions.determineHost((Matcher)matcherWithoutHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)true, (boolean)false, (Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"http://localhost:9011", (Object)ConnectionOptions.determineHost((Matcher)matcherWithoutHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)true, (boolean)false, (Map)ImmutableMap.of((Object)"SPANNER_EMULATOR_HOST", (Object)"localhost:9011")));
        Assert.assertEquals((Object)"http://localhost:9010", (Object)ConnectionOptions.determineHost((Matcher)matcherWithoutHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)true, (boolean)true, (Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"http://localhost:9011", (Object)ConnectionOptions.determineHost((Matcher)matcherWithoutHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)true, (boolean)true, (Map)ImmutableMap.of((Object)"SPANNER_EMULATOR_HOST", (Object)"localhost:9011")));
        Assert.assertEquals((Object)"https://custom.host.domain:1234", (Object)ConnectionOptions.determineHost((Matcher)matcherWithHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)false, (boolean)false, (Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"http://custom.host.domain:1234", (Object)ConnectionOptions.determineHost((Matcher)matcherWithHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)false, (boolean)true, (Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"http://custom.host.domain:1234", (Object)ConnectionOptions.determineHost((Matcher)matcherWithHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)false, (boolean)true, (Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"https://custom.host.domain:1234", (Object)ConnectionOptions.determineHost((Matcher)matcherWithHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)true, (boolean)false, (Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"http://custom.host.domain:1234", (Object)ConnectionOptions.determineHost((Matcher)matcherWithHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)false, (boolean)true, (Map)ImmutableMap.of((Object)"SPANNER_EMULATOR_HOST", (Object)"localhost:9011")));
        Assert.assertEquals((Object)"https://custom.host.domain:1234", (Object)ConnectionOptions.determineHost((Matcher)matcherWithHost, (String)ConnectionOptions.DEFAULT_ENDPOINT, (boolean)true, (boolean)false, (Map)ImmutableMap.of((Object)"SPANNER_EMULATOR_HOST", (Object)"localhost:9011")));
        Assert.assertEquals((Object)"http://localhost:9010", (Object)ConnectionOptions.determineHost((Matcher)matcherWithoutHost, (String)"localhost:9010", (boolean)false, (boolean)true, (Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"https://my.endpoint:1234", (Object)ConnectionOptions.determineHost((Matcher)matcherWithHost, (String)"my.endpoint:1234", (boolean)false, (boolean)false, (Map)ImmutableMap.of((Object)"SPANNER_EMULATOR_HOST", (Object)"localhost:9011")));
        Assert.assertEquals((Object)"http://my.endpoint.local:1234", (Object)ConnectionOptions.determineHost((Matcher)matcherWithHost, (String)"my.endpoint.local:1234", (boolean)false, (boolean)true, (Map)ImmutableMap.of()));
    }

    @Test
    public void testBuildWithRouteToLeader() {
        String BASE_URI = "cloudspanner:/projects/test-project-123/instances/test-instance-123/databases/test-database-123";
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance-123/databases/test-database-123?routeToLeader=false");
        builder.setCredentialsUrl(FILE_TEST_PATH);
        ConnectionOptions options = builder.build();
        Assert.assertEquals((Object)options.getHost(), (Object)DEFAULT_HOST);
        Assert.assertEquals((Object)options.getProjectId(), (Object)TEST_PROJECT);
        Assert.assertEquals((Object)options.getInstanceId(), (Object)TEST_INSTANCE);
        Assert.assertEquals((Object)options.getDatabaseName(), (Object)TEST_DATABASE);
        Assert.assertFalse((boolean)options.isRouteToLeader());
        builder = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance-123/databases/test-database-123");
        builder.setCredentialsUrl(FILE_TEST_PATH);
        options = builder.build();
        Assert.assertTrue((boolean)options.isRouteToLeader());
    }

    @Test
    public void testBuildWithAutoConfigEmulatorAndHost() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner://central-emulator.local:8080/projects/test-project-123/instances/test-instance-123/databases/test-database-123?autoConfigEmulator=true");
        ConnectionOptions options = builder.build();
        Assert.assertEquals((Object)"http://central-emulator.local:8080", (Object)options.getHost());
        Assert.assertEquals((Object)TEST_PROJECT, (Object)options.getProjectId());
        Assert.assertEquals((Object)TEST_INSTANCE, (Object)options.getInstanceId());
        Assert.assertEquals((Object)TEST_DATABASE, (Object)options.getDatabaseName());
        Assert.assertEquals((Object)NoCredentials.getInstance(), (Object)options.getCredentials());
        Assert.assertTrue((boolean)options.isUsePlainText());
    }

    @Test
    public void testBuildWithAutoConfigEmulatorAndEndpoint() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance-123/databases/test-database-123?autoConfigEmulator=true;endpoint=central-emulator.local:8080");
        ConnectionOptions options = builder.build();
        Assert.assertEquals((Object)"http://central-emulator.local:8080", (Object)options.getHost());
        Assert.assertEquals((Object)TEST_PROJECT, (Object)options.getProjectId());
        Assert.assertEquals((Object)TEST_INSTANCE, (Object)options.getInstanceId());
        Assert.assertEquals((Object)TEST_DATABASE, (Object)options.getDatabaseName());
        Assert.assertEquals((Object)NoCredentials.getInstance(), (Object)options.getCredentials());
        Assert.assertTrue((boolean)options.isUsePlainText());
    }

    @Test
    public void testBuildWithDefaultProjectPlaceholder() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner:/projects/default_project_id/instances/test-instance-123/databases/test-database-123");
        builder.setCredentialsUrl(FILE_TEST_PATH);
        ConnectionOptions options = builder.build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)DEFAULT_HOST);
        String projectId = SpannerOptions.getDefaultProjectId();
        if (projectId == null) {
            projectId = ((ServiceAccountCredentials)new CredentialsService().createCredentials(FILE_TEST_PATH)).getProjectId();
        }
        Truth.assertThat((String)options.getProjectId()).isEqualTo((Object)projectId);
        Truth.assertThat((String)options.getInstanceId()).isEqualTo((Object)TEST_INSTANCE);
        Truth.assertThat((String)options.getDatabaseName()).isEqualTo((Object)TEST_DATABASE);
        Truth.assertThat((Object)options.getCredentials()).isEqualTo((Object)new CredentialsService().createCredentials(FILE_TEST_PATH));
        Truth.assertThat((Boolean)options.isAutocommit()).isEqualTo((Object)true);
        Truth.assertThat((Boolean)options.isReadOnly()).isEqualTo((Object)false);
    }

    @Test
    public void testBuilderSetUri() {
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder();
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database");
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance");
        builder.setUri("cloudspanner:/projects/test-project-123");
        builder.setUri("cloudspanner://spanner.googleapis.com/projects/test-project-123/instances/test-instance/databases/test-database");
        builder.setUri("cloudspanner://spanner.googleapis.com/projects/test-project-123/instances/test-instance");
        builder.setUri("cloudspanner://spanner.googleapis.com/projects/test-project-123");
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true");
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance?autocommit=true");
        builder.setUri("cloudspanner:/projects/test-project-123?autocommit=true");
        builder.setUri("cloudspanner://spanner.googleapis.com/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true");
        builder.setUri("cloudspanner://spanner.googleapis.com/projects/test-project-123/instances/test-instance?autocommit=true");
        builder.setUri("cloudspanner://spanner.googleapis.com/projects/test-project-123?autocommit=true");
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true;readonly=false");
        builder.setUri("cloudspanner:/projects/test-project-123/instances/test-instance?autocommit=true;readonly=false");
        builder.setUri("cloudspanner:/projects/test-project-123?autocommit=true;readonly=false");
        builder.setUri("cloudspanner://spanner.googleapis.com/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true;readonly=false");
        builder.setUri("cloudspanner://spanner.googleapis.com/projects/test-project-123/instances/test-instance?autocommit=true;readonly=false");
        builder.setUri("cloudspanner://spanner.googleapis.com/projects/test-project-123?autocommit=true;readonly=false");
        this.setInvalidUri(builder, "/projects/test-project-123/instances/test-instance/databases/test-database");
        this.setInvalidUri(builder, "cloudspanner:/test-project-123/test-instance/test-database");
        this.setInvalidUri(builder, "cloudspanner:spanner.googleapis.com/projects/test-project-123/instances/test-instance/databases/test-database");
        this.setInvalidUri(builder, "cloudspanner://spanner.googleapis.com/projects/test-project-$$$/instances/test-instance/databases/test-database");
        this.setInvalidUri(builder, "cloudspanner://spanner.googleapis.com/projects/test-project-123/databases/test-database");
        this.setInvalidUri(builder, "cloudspanner:/projects/test_project_123/instances/test-instance/databases/test-database");
        this.setInvalidProperty(builder, "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?read=false", "read");
        this.setInvalidProperty(builder, "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?read=false;autocommit=true", "read");
        this.setInvalidProperty(builder, "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?read=false;auto=true", "read, auto");
    }

    private void setInvalidUri(ConnectionOptions.Builder builder, String uri) {
        Assert.assertThrows(IllegalArgumentException.class, () -> builder.setUri(uri));
    }

    private void setInvalidProperty(ConnectionOptions.Builder builder, String uri, String expectedInvalidProperties) {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> builder.setUri(uri));
        Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains(expectedInvalidProperties));
    }

    @Test
    public void testParseUriProperty() {
        String baseUri = "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database";
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database", (String)"autocommit")).isNull();
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true", (String)"autocommit")).isEqualTo((Object)"true");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=false", (String)"autocommit")).isEqualTo((Object)"false");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true;", (String)"autocommit")).isEqualTo((Object)"true");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=false;", (String)"autocommit")).isEqualTo((Object)"false");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true;readOnly=false", (String)"autocommit")).isEqualTo((Object)"true");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=false;readOnly=false", (String)"autocommit")).isEqualTo((Object)"false");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?readOnly=false;autocommit=true", (String)"autocommit")).isEqualTo((Object)"true");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?readOnly=false;autocommit=false", (String)"autocommit")).isEqualTo((Object)"false");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?readOnly=false;autocommit=true;foo=bar", (String)"autocommit")).isEqualTo((Object)"true");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?readOnly=false;autocommit=false;foo=bar", (String)"autocommit")).isEqualTo((Object)"false");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?AutoCommit=true", (String)"autocommit")).isEqualTo((Object)"true");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?AutoCommit=false", (String)"autocommit")).isEqualTo((Object)"false");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=true", (String)"autocommit")).isEqualTo((Object)"true");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-databaseautocommit=true", (String)"autocommit")).isNull();
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?isautocommit=true", (String)"autocommit")).isNull();
    }

    @Test
    public void testParseProperties() {
        String baseUri = "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database";
        Truth.assertThat((Iterable)ConnectionOptions.parseProperties((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true")).isEqualTo(Collections.singletonList("autocommit"));
        Truth.assertThat((Iterable)ConnectionOptions.parseProperties((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true;readonly=false")).isEqualTo(Arrays.asList("autocommit", "readonly"));
        Truth.assertThat((Iterable)ConnectionOptions.parseProperties((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true;READONLY=false")).isEqualTo(Arrays.asList("autocommit", "READONLY"));
        Truth.assertThat((Iterable)ConnectionOptions.parseProperties((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=true;readonly=false")).isEqualTo(Arrays.asList("autocommit", "readonly"));
        Truth.assertThat((Iterable)ConnectionOptions.parseProperties((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=true;readonly=false;")).isEqualTo(Arrays.asList("autocommit", "readonly"));
    }

    @Test
    public void testParsePropertiesSpecifiedMultipleTimes() {
        String baseUri = "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database";
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=true;autocommit=false", (String)"autocommit")).isEqualTo((Object)"true");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autocommit=false;autocommit=true", (String)"autocommit")).isEqualTo((Object)"false");
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=false;readonly=false;autocommit=true", (String)"autocommit")).isEqualTo((Object)"false");
        ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=false;readonly=false;autocommit=true");
    }

    @Test
    public void testParseOAuthToken() {
        Truth.assertThat((String)ConnectionOptions.parseUriProperty((String)"cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?oauthtoken=RsT5OjbzRn430zqMLgV3Ia", (String)"OAuthToken")).isEqualTo((Object)"RsT5OjbzRn430zqMLgV3Ia");
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?OAuthToken=RsT5OjbzRn430zqMLgV3Ia;credentials=/path/to/credentials.json");
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ((ConnectionOptions.Builder)builder).build());
        Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Specify only one of credentialsUrl, encodedCredentials, credentialsProvider and OAuth token"));
        builder = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?OAuthToken=RsT5OjbzRn430zqMLgV3Ia");
        ConnectionOptions options = builder.build();
        Truth.assertThat((Object)options.getCredentials()).isInstanceOf(GoogleCredentials.class);
        GoogleCredentials credentials = (GoogleCredentials)options.getCredentials();
        Truth.assertThat((String)credentials.getAccessToken().getTokenValue()).isEqualTo((Object)"RsT5OjbzRn430zqMLgV3Ia");
    }

    @Test
    public void testSetOAuthToken() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setOAuthToken("RsT5OjbzRn430zqMLgV3Ia").build();
        Truth.assertThat((Object)options.getCredentials()).isInstanceOf(GoogleCredentials.class);
        GoogleCredentials credentials = (GoogleCredentials)options.getCredentials();
        Truth.assertThat((Object)credentials.getAccessToken()).isNotNull();
        Truth.assertThat((String)credentials.getAccessToken().getTokenValue()).isEqualTo((Object)"RsT5OjbzRn430zqMLgV3Ia");
    }

    @Test
    public void testSetOAuthTokenAndCredentials() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setOAuthToken("RsT5OjbzRn430zqMLgV3Ia").setCredentialsUrl(FILE_TEST_PATH).build());
        Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Specify only one of credentialsUrl, encodedCredentials, credentialsProvider and OAuth token"));
    }

    @Test
    public void testLenient() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?lenient=true;foo=bar").setCredentialsUrl(FILE_TEST_PATH).build();
        Truth.assertThat((String)options.getWarnings()).isNotNull();
        Truth.assertThat((String)options.getWarnings()).contains((CharSequence)"foo");
        Truth.assertThat((String)options.getWarnings()).doesNotContain((CharSequence)"lenient");
        options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?bar=foo;lenient=true").setCredentialsUrl(FILE_TEST_PATH).build();
        Truth.assertThat((String)options.getWarnings()).isNotNull();
        Truth.assertThat((String)options.getWarnings()).contains((CharSequence)"bar");
        Truth.assertThat((String)options.getWarnings()).doesNotContain((CharSequence)"lenient");
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?bar=foo").setCredentialsUrl(FILE_TEST_PATH).build());
        Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("bar"));
    }

    @Test
    public void testMinSessions() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?minSessions=400").setCredentialsUrl(FILE_TEST_PATH).build();
        Truth.assertThat((Integer)options.getMinSessions()).isEqualTo((Object)400);
        Truth.assertThat((Integer)options.getSessionPoolOptions().getMinSessions()).isEqualTo((Object)400);
    }

    @Test
    public void testMaxSessions() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?maxSessions=4000").setCredentialsUrl(FILE_TEST_PATH).build();
        Truth.assertThat((Integer)options.getMaxSessions()).isEqualTo((Object)4000);
        Truth.assertThat((Integer)options.getSessionPoolOptions().getMaxSessions()).isEqualTo((Object)4000);
    }

    @Test
    public void testTrackSessionLeaks() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?trackSessionLeaks=false").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertFalse((boolean)options.getSessionPoolOptions().isTrackStackTraceOfSessionCheckout());
    }

    @Test
    public void testTrackSessionLeaksDefault() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertTrue((boolean)options.getSessionPoolOptions().isTrackStackTraceOfSessionCheckout());
    }

    @Test
    public void testTrackConnectionLeaks() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?trackConnectionLeaks=false").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertFalse((boolean)options.isTrackConnectionLeaks());
    }

    @Test
    public void testTrackConnectionLeaksDefault() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertTrue((boolean)options.isTrackConnectionLeaks());
    }

    @Test
    public void testDataBoostEnabled() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?dataBoostEnabled=true").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertTrue((boolean)options.isDataBoostEnabled());
    }

    @Test
    public void testDataBoostEnabledDefault() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertFalse((boolean)options.isDataBoostEnabled());
    }

    @Test
    public void testAutoPartitionMode() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?autoPartitionMode=true").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertTrue((boolean)options.isAutoPartitionMode());
    }

    @Test
    public void testAutoPartitionModeDefault() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertFalse((boolean)options.isAutoPartitionMode());
    }

    @Test
    public void testMaxPartitions() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?maxPartitions=4").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertEquals((long)4L, (long)options.getMaxPartitions());
    }

    @Test
    public void testMaxPartitionsDefault() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertEquals((long)0L, (long)options.getMaxPartitions());
    }

    @Test
    public void testMaxPartitionsInvalidValue() {
        Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?maxPartitions=-1").setCredentialsUrl(FILE_TEST_PATH).build());
    }

    @Test
    public void testMaxPartitionsNonNumeric() {
        Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?maxPartitions=four").setCredentialsUrl(FILE_TEST_PATH).build());
    }

    @Test
    public void testMaxPartitionedParallelism() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?maxPartitionedParallelism=4").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertEquals((long)4L, (long)options.getMaxPartitionedParallelism());
    }

    @Test
    public void testMaxPartitionedParallelismDefault() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentialsUrl(FILE_TEST_PATH).build();
        Assert.assertEquals((long)1L, (long)options.getMaxPartitionedParallelism());
    }

    @Test
    public void testMaxPartitionedParallelismInvalidValue() {
        Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?maxPartitionedParallelism=-1").setCredentialsUrl(FILE_TEST_PATH).build());
    }

    @Test
    public void testMaxPartitionedParallelismNonNumeric() {
        Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?maxPartitionedParallelism=four").setCredentialsUrl(FILE_TEST_PATH).build());
    }

    @Test
    public void testLocalConnectionError() {
        String uri = "cloudspanner://localhost:1/projects/test-project/instances/test-instance/databases/test-database?usePlainText=true";
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri(uri).build();
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ConnectionOptions)options).getConnection());
        Assert.assertEquals((Object)ErrorCode.UNAVAILABLE, (Object)exception.getErrorCode());
        Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains(String.format("The connection string '%s' contains host 'localhost:1', but no running", uri)));
    }

    @Test
    public void testInvalidCredentials() {
        String uri = "cloudspanner:/projects/test-project/instances/test-instance/databases/test-database?credentials=/some/non/existing/path";
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri(uri).build());
        Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)exception.getErrorCode());
        Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Invalid credentials path specified: /some/non/existing/path"));
    }

    @Test
    public void testNonBase64EncodedCredentials() throws Throwable {
        ConnectionOptionsTest.runWithSystemPropertyEnabled("ENABLE_ENCODED_CREDENTIALS", () -> {
            String uri = "cloudspanner:/projects/test-project/instances/test-instance/databases/test-database?encodedCredentials=not-a-base64-string/";
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri(uri).build());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"The encoded credentials could not be decoded as a base64 string.");
        });
    }

    @Test
    public void testInvalidEncodedCredentials() throws Throwable {
        ConnectionOptionsTest.runWithSystemPropertyEnabled("ENABLE_ENCODED_CREDENTIALS", () -> {
            String uri = String.format("cloudspanner:/projects/test-project/instances/test-instance/databases/test-database?encodedCredentials=%s", BaseEncoding.base64Url().encode("not-a-credentials-JSON-string".getBytes(StandardCharsets.UTF_8)));
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri(uri).build());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"The encoded credentials do not contain a valid Google Cloud credentials JSON string.");
        });
    }

    @Test
    public void testValidEncodedCredentials() throws Throwable {
        ConnectionOptionsTest.runWithSystemPropertyEnabled("ENABLE_ENCODED_CREDENTIALS", () -> {
            String encoded = BaseEncoding.base64Url().encode(Files.asByteSource((File)new File(FILE_TEST_PATH)).read());
            String uri = String.format("cloudspanner:/projects/test-project/instances/test-instance/databases/test-database?encodedCredentials=%s", encoded);
            ConnectionOptions options = ConnectionOptions.newBuilder().setUri(uri).build();
            Assert.assertEquals((Object)new CredentialsService().createCredentials(FILE_TEST_PATH), (Object)options.getCredentials());
        });
    }

    @Test
    public void testValidEncodedCredentials_WithoutEnablingProperty() throws Throwable {
        String encoded = BaseEncoding.base64Url().encode(Files.asByteSource((File)new File(FILE_TEST_PATH)).read());
        String uri = String.format("cloudspanner:/projects/test-project/instances/test-instance/databases/test-database?encodedCredentials=%s", encoded);
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri(uri).build());
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
    }

    @Test
    public void testSetCredentialsAndEncodedCredentials() throws Throwable {
        ConnectionOptionsTest.runWithSystemPropertyEnabled("ENABLE_ENCODED_CREDENTIALS", () -> {
            String encoded = BaseEncoding.base64Url().encode(Files.asByteSource((File)new File(FILE_TEST_PATH)).read());
            String uri = String.format("cloudspanner:/projects/test-project/instances/test-instance/databases/test-database?credentials=%s;encodedCredentials=%s", FILE_TEST_PATH, encoded);
            IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ConnectionOptions.newBuilder().setUri(uri).build());
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Specify only one of credentialsUrl, encodedCredentials, credentialsProvider and OAuth token"));
        });
    }

    static void runWithSystemPropertyEnabled(String systemPropertyName, ThrowingRunnable runnable) throws Throwable {
        String originalValue = System.getProperty(systemPropertyName);
        System.setProperty(systemPropertyName, "true");
        try {
            runnable.run();
        }
        finally {
            if (originalValue == null) {
                System.clearProperty(systemPropertyName);
            } else {
                System.setProperty(systemPropertyName, originalValue);
            }
        }
    }

    @Test
    public void testValidCredentialsProvider() throws Throwable {
        ConnectionOptionsTest.runWithSystemPropertyEnabled("ENABLE_CREDENTIALS_PROVIDER", () -> {
            String uri = String.format("cloudspanner:/projects/test-project/instances/test-instance/databases/test-database?credentialsProvider=%s", TestCredentialsProvider.class.getName());
            ConnectionOptions options = ConnectionOptions.newBuilder().setUri(uri).build();
            Assert.assertEquals((Object)NoCredentials.getInstance(), (Object)options.getCredentials());
        });
    }

    @Test
    public void testValidCredentialsProvider_WithoutEnablingSystemProperty() {
        String uri = String.format("cloudspanner:/projects/test-project/instances/test-instance/databases/test-database?credentialsProvider=%s", TestCredentialsProvider.class.getName());
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri(uri).build());
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
        Assert.assertEquals((Object)"FAILED_PRECONDITION: credentialsProvider can only be used if the system property ENABLE_CREDENTIALS_PROVIDER has been set to true. Start the application with the JVM command line option -DENABLE_CREDENTIALS_PROVIDER=true", (Object)exception.getMessage());
    }

    @Test
    public void testSetCredentialsAndCredentialsProvider() throws Throwable {
        ConnectionOptionsTest.runWithSystemPropertyEnabled("ENABLE_CREDENTIALS_PROVIDER", () -> {
            String uri = String.format("cloudspanner:/projects/test-project/instances/test-instance/databases/test-database?credentials=%s;credentialsProvider=%s", FILE_TEST_PATH, NoCredentialsProvider.class.getName());
            IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ConnectionOptions.newBuilder().setUri(uri).build());
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Specify only one of credentialsUrl, encodedCredentials, credentialsProvider and OAuth token"));
        });
    }

    @Test
    public void testExternalChannelProvider() throws Throwable {
        ConnectionOptionsTest.runWithSystemPropertyEnabled("ENABLE_CHANNEL_PROVIDER", () -> {
            String baseUri = "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database";
            ConnectionOptions options = ConnectionOptions.newBuilder().setUri(baseUri + "?channelProvider=com.google.cloud.spanner.connection.TestChannelProvider").setCredentials((Credentials)NoCredentials.getInstance()).build();
            TransportChannelProvider provider = options.getChannelProvider();
            Assert.assertTrue((boolean)(provider instanceof InstantiatingGrpcChannelProvider));
        });
    }

    @Test
    public void testExternalChannelProvider_WithoutEnablingProperty() throws Throwable {
        String baseUri = "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database";
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ConnectionOptions.newBuilder().setUri(baseUri + "?channelProvider=com.google.cloud.spanner.connection.TestChannelProvider").setCredentials((Credentials)NoCredentials.getInstance()).build());
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
    }

    @Test
    public void testUseVirtualThreads() {
        Assert.assertTrue((boolean)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?useVirtualThreads=true").setCredentials((Credentials)NoCredentials.getInstance()).build().isUseVirtualThreads());
        Assert.assertFalse((boolean)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?useVirtualThreads=false").setCredentials((Credentials)NoCredentials.getInstance()).build().isUseVirtualThreads());
        Assert.assertEquals((Object)false, (Object)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentials((Credentials)NoCredentials.getInstance()).build().isUseVirtualThreads());
    }

    @Test
    public void testUseVirtualGrpcTransportThreads() {
        Assert.assertTrue((boolean)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?useVirtualGrpcTransportThreads=true").setCredentials((Credentials)NoCredentials.getInstance()).build().isUseVirtualGrpcTransportThreads());
        Assert.assertFalse((boolean)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?useVirtualGrpcTransportThreads=false").setCredentials((Credentials)NoCredentials.getInstance()).build().isUseVirtualGrpcTransportThreads());
        Assert.assertEquals((Object)false, (Object)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentials((Credentials)NoCredentials.getInstance()).build().isUseVirtualThreads());
    }

    @Test
    public void testMaxCommitDelay() {
        Assert.assertNull((Object)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentials((Credentials)NoCredentials.getInstance()).build().getMaxCommitDelay());
        Assert.assertEquals((Object)Duration.ofMillis(10L), (Object)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?maxCommitDelay=10").setCredentials((Credentials)NoCredentials.getInstance()).build().getMaxCommitDelay());
    }

    @Test
    public void testEnableApiTracing() {
        Assert.assertNull((Object)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").setCredentials((Credentials)NoCredentials.getInstance()).build().isEnableApiTracing());
        Assert.assertTrue((boolean)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?enableApiTracing=true").setCredentials((Credentials)NoCredentials.getInstance()).build().isEnableApiTracing());
        Assert.assertFalse((boolean)ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?enableApiTracing=false").setCredentials((Credentials)NoCredentials.getInstance()).build().isEnableApiTracing());
    }

    public static class TestCredentialsProvider
    implements CredentialsProvider {
        public Credentials getCredentials() {
            return NoCredentials.getInstance();
        }
    }
}

