/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.DdlInTransactionMode;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import com.google.spanner.v1.CommitRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DdlTest
extends AbstractMockServerTest {
    @After
    public void reset() {
        mockDatabaseAdmin.reset();
    }

    @Override
    protected String getBaseUrl() {
        return String.format("cloudspanner://localhost:%d/projects/proj/instances/inst/databases/db?usePlainText=true", this.getPort());
    }

    private void addUpdateDdlResponse() {
        mockDatabaseAdmin.addResponse((AbstractMessage)Operation.newBuilder().setMetadata(Any.pack((Message)UpdateDatabaseDdlMetadata.newBuilder().setDatabase("projects/proj/instances/inst/databases/db").build())).setName("projects/proj/instances/inst/databases/db/operations/1").setDone(true).setResponse(Any.pack((Message)Empty.getDefaultInstance())).build());
    }

    @Test
    public void testSingleAnalyzeStatement() {
        this.addUpdateDdlResponse();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            StatementResult result = connection.execute(Statement.of((String)"analyze"));
            Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)result.getResultType());
        }
        List requests = mockDatabaseAdmin.getRequests().stream().filter(request -> request instanceof UpdateDatabaseDdlRequest).map(request -> (UpdateDatabaseDdlRequest)request).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((long)1L, (long)((UpdateDatabaseDdlRequest)requests.get(0)).getStatementsCount());
        Assert.assertEquals((Object)"analyze", (Object)((UpdateDatabaseDdlRequest)requests.get(0)).getStatements(0));
    }

    @Test
    public void testBatchedAnalyzeStatement() {
        this.addUpdateDdlResponse();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.startBatchDdl();
            Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)connection.execute(Statement.of((String)"create table foo (id int64) primary key (id)")).getResultType());
            Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)connection.execute(Statement.of((String)"analyze")).getResultType());
            connection.runBatch();
        }
        List requests = mockDatabaseAdmin.getRequests().stream().filter(request -> request instanceof UpdateDatabaseDdlRequest).map(request -> (UpdateDatabaseDdlRequest)request).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((long)2L, (long)((UpdateDatabaseDdlRequest)requests.get(0)).getStatementsCount());
        Assert.assertEquals((Object)"create table foo (id int64) primary key (id)", (Object)((UpdateDatabaseDdlRequest)requests.get(0)).getStatements(0));
        Assert.assertEquals((Object)"analyze", (Object)((UpdateDatabaseDdlRequest)requests.get(0)).getStatements(1));
    }

    @Test
    public void testDdlAtStartOfTransaction() {
        Statement statement = Statement.of((String)"create table foo (id int64) primary key (id)");
        for (DdlInTransactionMode mode : DdlInTransactionMode.values()) {
            mockDatabaseAdmin.getRequests().clear();
            if (mode != DdlInTransactionMode.FAIL) {
                this.addUpdateDdlResponse();
            }
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setAutocommit(false);
                connection.setDdlInTransactionMode(mode);
                if (mode == DdlInTransactionMode.FAIL) {
                    SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(statement));
                    Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
                    continue;
                }
                Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)connection.execute(statement).getResultType());
                Assert.assertEquals((long)1L, (long)mockDatabaseAdmin.getRequests().size());
            }
        }
    }

    @Test
    public void testDdlBatchAtStartOfTransaction() {
        for (DdlInTransactionMode mode : DdlInTransactionMode.values()) {
            mockDatabaseAdmin.getRequests().clear();
            if (mode != DdlInTransactionMode.FAIL) {
                this.addUpdateDdlResponse();
            }
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setAutocommit(false);
                connection.setDdlInTransactionMode(mode);
                if (mode == DdlInTransactionMode.FAIL) {
                    SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)"start batch ddl")));
                    Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
                    continue;
                }
                connection.execute(Statement.of((String)"start batch ddl"));
                connection.execute(Statement.of((String)"create table foo"));
                connection.execute(Statement.of((String)"alter table bar"));
                connection.execute(Statement.of((String)"run batch"));
                Assert.assertEquals((long)1L, (long)mockDatabaseAdmin.getRequests().size());
                UpdateDatabaseDdlRequest request = (UpdateDatabaseDdlRequest)mockDatabaseAdmin.getRequests().get(0);
                Assert.assertEquals((long)2L, (long)request.getStatementsCount());
            }
        }
    }

    @Test
    public void testDdlInTransaction() {
        Statement statement = Statement.of((String)"create table foo (id int64) primary key (id)");
        for (DdlInTransactionMode mode : DdlInTransactionMode.values()) {
            mockDatabaseAdmin.getRequests().clear();
            if (mode == DdlInTransactionMode.AUTO_COMMIT_TRANSACTION) {
                this.addUpdateDdlResponse();
            }
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setAutocommit(false);
                connection.setDdlInTransactionMode(mode);
                connection.execute(INSERT_STATEMENT);
                if (mode != DdlInTransactionMode.AUTO_COMMIT_TRANSACTION) {
                    SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(statement));
                    Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
                    continue;
                }
                Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)connection.execute(statement).getResultType());
                Assert.assertEquals((long)1L, (long)mockDatabaseAdmin.getRequests().size());
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            }
        }
    }

    @Test
    public void testDdlBatchInTransaction() {
        for (DdlInTransactionMode mode : DdlInTransactionMode.values()) {
            mockDatabaseAdmin.getRequests().clear();
            if (mode == DdlInTransactionMode.AUTO_COMMIT_TRANSACTION) {
                this.addUpdateDdlResponse();
            }
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setAutocommit(false);
                connection.setDdlInTransactionMode(mode);
                connection.execute(INSERT_STATEMENT);
                if (mode != DdlInTransactionMode.AUTO_COMMIT_TRANSACTION) {
                    SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)"start batch ddl")));
                    Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
                    continue;
                }
                connection.execute(Statement.of((String)"start batch ddl"));
                connection.execute(Statement.of((String)"create table foo"));
                connection.execute(Statement.of((String)"alter table bar"));
                connection.execute(Statement.of((String)"run batch"));
                Assert.assertEquals((long)1L, (long)mockDatabaseAdmin.getRequests().size());
                UpdateDatabaseDdlRequest request = (UpdateDatabaseDdlRequest)mockDatabaseAdmin.getRequests().get(0);
                Assert.assertEquals((long)2L, (long)request.getStatementsCount());
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            }
        }
    }
}

